/*
 * Decompiled with CFR 0.152.
 */
package de.kippdata.cria.solrext;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.queryParser.ParseException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;

public class MultiFieldSearchModifier
extends SearchComponent {
    private final String DEF_OP = "def_op";
    private final String CQ = "cq";
    private final String DESCRIPTION = "Experimental SearchComponent that modifies a query";
    private final String REF = "$Revision: 1.2 $";
    private Map<String, String> fieldMappings = new HashMap<String, String>();
    private static final Logger log = Logger.getLogger(MultiFieldSearchModifier.class);

    public void init(NamedList args) {
        for (int i = 0; i < args.size(); ++i) {
            this.fieldMappings.put(args.getName(i), args.getVal(i).toString());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("[init]: Found argument " + args.getName(i) + " with value " + args.getVal(i)));
        }
    }

    public String getDescription() {
        return "Experimental SearchComponent that modifies a query";
    }

    public String getSource() {
        return null;
    }

    public String getSourceId() {
        return null;
    }

    public String getVersion() {
        return "$Revision: 1.2 $";
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        log.debug((Object)"[prepare]: nothing to be done");
    }

    public void process(ResponseBuilder rb) throws IOException {
        String queryString;
        log.debug((Object)"[process]: Start");
        log.debug((Object)("[process]: query before = " + rb.getQuery().toString()));
        SolrQueryRequest request = rb.req;
        SolrParams params = request.getParams();
        String defType = params.get("defType");
        defType = defType == null ? QParserPlugin.DEFAULT_QTYPE : defType;
        log.debug((Object)("[process]: defType = " + defType));
        if (params.get("cq") != null) {
            log.debug((Object)("[process]: Transforming formal fields for query " + params.get("cq")));
            queryString = this.queryTransformer(params.get("cq"));
            log.debug((Object)("[process]: Transformed query is '" + queryString + "'"));
        } else {
            log.debug((Object)("[process]: Default operator is: '" + params.get("def_op") + "'"));
            String op = params.get("def_op", "+");
            StringBuffer queryBuffer = new StringBuffer();
            for (String s : this.fieldMappings.keySet()) {
                if (params.get(s) != null) {
                    queryBuffer.append(op + this.fieldMappings.get(s) + ":\"" + params.get(s) + "\" ");
                    log.debug((Object)("[process]: Mapped " + s + " to '" + this.fieldMappings.get(s) + "' with value " + params.get(s)));
                    continue;
                }
                log.debug((Object)("[process]: " + this.fieldMappings.get(s) + " is Null - no mapping"));
            }
            queryString = queryBuffer.toString();
        }
        try {
            log.debug((Object)("[process]: query = " + queryString));
            QParser parser = QParser.getParser((String)queryString, (String)defType, (SolrQueryRequest)request);
            rb.setQuery(parser.getQuery());
            rb.setQparser(parser);
            log.debug((Object)("[process]: Processed query = " + parser.getQuery().toString()));
        }
        catch (Exception e) {
            log.warn((Object)"[process]: ERROR building query");
            try {
                QParser parser = QParser.getParser((String)"*:* AND NOT (*:*)", (String)defType, (SolrQueryRequest)request);
                rb.setQuery(parser.getQuery());
                rb.setQparser(parser);
            }
            catch (ParseException e1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
        }
        log.debug((Object)"[process]: Done.");
    }

    private String queryTransformer(String query) {
        for (String s : this.fieldMappings.keySet()) {
            log.debug((Object)("[queryTransformer]: " + s + " -> " + this.fieldMappings.get(s)));
            query.replaceAll("/" + s + "/", this.fieldMappings.get(s));
            query = query.replaceAll(s, this.fieldMappings.get(s));
            log.debug((Object)("[queryTransformer]: " + query));
        }
        return query;
    }
}

