/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Fixed1ArgFunction;
import org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import org.apache.poi.ss.formula.functions.Fixed3ArgFunction;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.Var1or2ArgFunction;
import org.apache.poi.ss.formula.functions.Var2or3ArgFunction;

public abstract class TextFunction
implements Function {
    protected static final String EMPTY_STRING = "";
    public static final Function CHAR = new Fixed1ArgFunction(){

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0) {
            int arg;
            try {
                arg = TextFunction.evaluateIntArg(arg0, srcRowIndex, srcColumnIndex);
                if (arg < 0 || arg >= 256) {
                    throw new EvaluationException(ErrorEval.VALUE_INVALID);
                }
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
            return new StringEval(String.valueOf((char)arg));
        }
    };
    public static final Function LEN = new SingleArgTextFunc(){

        protected ValueEval evaluate(String arg) {
            return new NumberEval(arg.length());
        }
    };
    public static final Function LOWER = new SingleArgTextFunc(){

        protected ValueEval evaluate(String arg) {
            return new StringEval(arg.toLowerCase());
        }
    };
    public static final Function UPPER = new SingleArgTextFunc(){

        protected ValueEval evaluate(String arg) {
            return new StringEval(arg.toUpperCase());
        }
    };
    public static final Function TRIM = new SingleArgTextFunc(){

        protected ValueEval evaluate(String arg) {
            return new StringEval(arg.trim());
        }
    };
    public static final Function CLEAN = new SingleArgTextFunc(){

        protected ValueEval evaluate(String arg) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < arg.length(); ++i) {
                char c = arg.charAt(i);
                if (!this.isPrintable(c)) continue;
                result.append(c);
            }
            return new StringEval(result.toString());
        }

        private boolean isPrintable(char c) {
            char charCode = c;
            return charCode >= ' ';
        }
    };
    public static final Function MID = new Fixed3ArgFunction(){

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2) {
            int numChars;
            int startCharNum;
            String text;
            try {
                text = TextFunction.evaluateStringArg(arg0, srcRowIndex, srcColumnIndex);
                startCharNum = TextFunction.evaluateIntArg(arg1, srcRowIndex, srcColumnIndex);
                numChars = TextFunction.evaluateIntArg(arg2, srcRowIndex, srcColumnIndex);
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
            int startIx = startCharNum - 1;
            if (startIx < 0) {
                return ErrorEval.VALUE_INVALID;
            }
            if (numChars < 0) {
                return ErrorEval.VALUE_INVALID;
            }
            int len = text.length();
            if (numChars < 0 || startIx > len) {
                return new StringEval(TextFunction.EMPTY_STRING);
            }
            int endIx = Math.min(startIx + numChars, len);
            String result = text.substring(startIx, endIx);
            return new StringEval(result);
        }
    };
    public static final Function LEFT = new LeftRight(true);
    public static final Function RIGHT = new LeftRight(false);
    public static final Function CONCATENATE = new Function(){

        public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
            StringBuilder sb = new StringBuilder();
            int iSize = args.length;
            for (int i = 0; i < iSize; ++i) {
                try {
                    sb.append(TextFunction.evaluateStringArg(args[i], srcRowIndex, srcColumnIndex));
                    continue;
                }
                catch (EvaluationException e) {
                    return e.getErrorEval();
                }
            }
            return new StringEval(sb.toString());
        }
    };
    public static final Function EXACT = new Fixed2ArgFunction(){

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
            String s1;
            String s0;
            try {
                s0 = TextFunction.evaluateStringArg(arg0, srcRowIndex, srcColumnIndex);
                s1 = TextFunction.evaluateStringArg(arg1, srcRowIndex, srcColumnIndex);
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
            return BoolEval.valueOf(s0.equals(s1));
        }
    };
    public static final Function TEXT = new Fixed2ArgFunction(){

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
            String s1;
            double s0;
            try {
                s0 = TextFunction.evaluateDoubleArg(arg0, srcRowIndex, srcColumnIndex);
                s1 = TextFunction.evaluateStringArg(arg1, srcRowIndex, srcColumnIndex);
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
            if (s1.matches("[\\d,\\#,\\.,\\$,\\,]+")) {
                DecimalFormat formatter = new DecimalFormat(s1);
                return new StringEval(formatter.format(s0));
            }
            if (s1.indexOf("/") == s1.lastIndexOf("/") && s1.indexOf("/") >= 0 && !s1.contains("-")) {
                double decPart;
                double wholePart = Math.floor(s0);
                if (wholePart * (decPart = s0 - wholePart) == 0.0) {
                    return new StringEval("0");
                }
                String[] parts = s1.split(" ");
                String[] fractParts = parts.length == 2 ? parts[1].split("/") : s1.split("/");
                if (fractParts.length == 2) {
                    double minVal = 1.0;
                    double currDenom = Math.pow(10.0, fractParts[1].length()) - 1.0;
                    double currNeum = 0.0;
                    for (int i = (int)(Math.pow(10.0, fractParts[1].length()) - 1.0); i > 0; --i) {
                        for (int i2 = (int)(Math.pow(10.0, fractParts[1].length()) - 1.0); i2 > 0; --i2) {
                            if (!(minVal >= Math.abs((double)i2 / (double)i - decPart))) continue;
                            currDenom = i;
                            currNeum = i2;
                            minVal = Math.abs((double)i2 / (double)i - decPart);
                        }
                    }
                    DecimalFormat neumFormatter = new DecimalFormat(fractParts[0]);
                    DecimalFormat denomFormatter = new DecimalFormat(fractParts[1]);
                    if (parts.length == 2) {
                        DecimalFormat wholeFormatter = new DecimalFormat(parts[0]);
                        String result = wholeFormatter.format(wholePart) + " " + neumFormatter.format(currNeum) + "/" + denomFormatter.format(currDenom);
                        return new StringEval(result);
                    }
                    String result = neumFormatter.format(currNeum + currDenom * wholePart) + "/" + denomFormatter.format(currDenom);
                    return new StringEval(result);
                }
                return ErrorEval.VALUE_INVALID;
            }
            try {
                SimpleDateFormat dateFormatter = new SimpleDateFormat(s1);
                GregorianCalendar cal = new GregorianCalendar(1899, 11, 30, 0, 0, 0);
                ((Calendar)cal).add(5, (int)Math.floor(s0));
                double dayFraction = s0 - Math.floor(s0);
                ((Calendar)cal).add(14, (int)Math.round(dayFraction * 24.0 * 60.0 * 60.0 * 1000.0));
                return new StringEval(dateFormatter.format(cal.getTime()));
            }
            catch (Exception e) {
                return ErrorEval.VALUE_INVALID;
            }
        }
    };
    public static final Function FIND = new SearchFind(true);
    public static final Function SEARCH = new SearchFind(false);

    protected static final String evaluateStringArg(ValueEval eval, int srcRow, int srcCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(eval, srcRow, srcCol);
        return OperandResolver.coerceValueToString(ve);
    }

    protected static final int evaluateIntArg(ValueEval arg, int srcCellRow, int srcCellCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        return OperandResolver.coerceValueToInt(ve);
    }

    protected static final double evaluateDoubleArg(ValueEval arg, int srcCellRow, int srcCellCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        return OperandResolver.coerceValueToDouble(ve);
    }

    public final ValueEval evaluate(ValueEval[] args, int srcCellRow, int srcCellCol) {
        try {
            return this.evaluateFunc(args, srcCellRow, srcCellCol);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    protected abstract ValueEval evaluateFunc(ValueEval[] var1, int var2, int var3) throws EvaluationException;

    private static final class SearchFind
    extends Var2or3ArgFunction {
        private final boolean _isCaseSensitive;

        public SearchFind(boolean isCaseSensitive) {
            this._isCaseSensitive = isCaseSensitive;
        }

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
            try {
                String needle = TextFunction.evaluateStringArg(arg0, srcRowIndex, srcColumnIndex);
                String haystack = TextFunction.evaluateStringArg(arg1, srcRowIndex, srcColumnIndex);
                return this.eval(haystack, needle, 0);
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
        }

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2) {
            try {
                String needle = TextFunction.evaluateStringArg(arg0, srcRowIndex, srcColumnIndex);
                String haystack = TextFunction.evaluateStringArg(arg1, srcRowIndex, srcColumnIndex);
                int startpos = TextFunction.evaluateIntArg(arg2, srcRowIndex, srcColumnIndex) - 1;
                if (startpos < 0) {
                    return ErrorEval.VALUE_INVALID;
                }
                return this.eval(haystack, needle, startpos);
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
        }

        private ValueEval eval(String haystack, String needle, int startIndex) {
            int result = this._isCaseSensitive ? haystack.indexOf(needle, startIndex) : haystack.toUpperCase().indexOf(needle.toUpperCase(), startIndex);
            if (result == -1) {
                return ErrorEval.VALUE_INVALID;
            }
            return new NumberEval(result + 1);
        }
    }

    private static final class LeftRight
    extends Var1or2ArgFunction {
        private static final ValueEval DEFAULT_ARG1 = new NumberEval(1.0);
        private final boolean _isLeft;

        protected LeftRight(boolean isLeft) {
            this._isLeft = isLeft;
        }

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0) {
            return this.evaluate(srcRowIndex, srcColumnIndex, arg0, DEFAULT_ARG1);
        }

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
            int index;
            String arg;
            try {
                arg = TextFunction.evaluateStringArg(arg0, srcRowIndex, srcColumnIndex);
                index = TextFunction.evaluateIntArg(arg1, srcRowIndex, srcColumnIndex);
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
            if (index < 0) {
                return ErrorEval.VALUE_INVALID;
            }
            String result = this._isLeft ? arg.substring(0, Math.min(arg.length(), index)) : arg.substring(Math.max(0, arg.length() - index));
            return new StringEval(result);
        }
    }

    private static abstract class SingleArgTextFunc
    extends Fixed1ArgFunction {
        protected SingleArgTextFunc() {
        }

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0) {
            String arg;
            try {
                arg = TextFunction.evaluateStringArg(arg0, srcRowIndex, srcColumnIndex);
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
            return this.evaluate(arg);
        }

        protected abstract ValueEval evaluate(String var1);
    }
}

