/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import javax.xml.bind.DatatypeConverter;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.wsdl.W3CConstants;
import org.omg.CORBA.TypeCode;

public class CorbaOctetSequenceHandler
extends CorbaObjectHandler {
    private byte[] value;
    private boolean isBase64Octets = this.getType().getType().equals(W3CConstants.NT_SCHEMA_BASE64);

    public CorbaOctetSequenceHandler(QName primName, QName primIdlType, TypeCode primTC, Object primType) {
        super(primName, primIdlType, primTC, primType);
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] obj) {
        this.value = obj;
    }

    public String getDataFromValue() {
        String result = this.isBase64Octets ? new String(DatatypeConverter.printBase64Binary((byte[])this.value)) : new String(DatatypeConverter.printHexBinary((byte[])this.value));
        return result;
    }

    public void setValueFromData(String data) {
        try {
            this.value = this.isBase64Octets ? DatatypeConverter.parseBase64Binary((String)data) : DatatypeConverter.parseHexBinary((String)data);
        }
        catch (Exception ex) {
            throw new CorbaBindingException("Not able to parse the octet sequence", ex);
        }
    }

    public void clear() {
        this.value = null;
    }
}

