/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.GroupAdjacentIterator;
import net.sf.saxon.sort.GroupByIterator;
import net.sf.saxon.sort.GroupEndingIterator;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.sort.GroupStartingIterator;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.SortedGroupIterator;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class ForEachGroup
extends Instruction
implements ContextMappingFunction {
    public static final int GROUP_BY = 0;
    public static final int GROUP_ADJACENT = 1;
    public static final int GROUP_STARTING = 2;
    public static final int GROUP_ENDING = 3;
    private Expression select;
    private Expression action;
    private byte algorithm;
    private Expression key;
    private Expression collationName;
    private String baseURI;
    private Comparator collator = null;
    private SortKeyDefinition[] sortKeys = null;

    public ForEachGroup(Expression expression, Expression expression2, byte by, Expression expression3, Comparator comparator, Expression expression4, String string, SortKeyDefinition[] sortKeyDefinitionArray) {
        this.select = expression;
        this.action = expression2;
        this.algorithm = by;
        this.key = expression3;
        this.collator = comparator;
        this.collationName = expression4;
        this.baseURI = string;
        this.sortKeys = sortKeyDefinitionArray;
        Iterator iterator = this.iterateSubExpressions();
        while (iterator.hasNext()) {
            Expression expression5 = (Expression)iterator.next();
            this.adoptChildExpression(expression5);
        }
    }

    public int getInstructionNameCode() {
        return 148;
    }

    public Expression getActionExpression() {
        return this.action;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.select = this.select.simplify(staticContext);
        this.action = this.action.simplify(staticContext);
        this.key = this.key.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        this.select = this.select.typeCheck(staticContext, itemType);
        this.action = this.action.typeCheck(staticContext, this.select.getItemType(typeHierarchy));
        this.key = this.key.typeCheck(staticContext, this.select.getItemType(typeHierarchy));
        if (this.select instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        if (this.action instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        TypeHierarchy typeHierarchy = staticContext.getConfiguration().getTypeHierarchy();
        this.select = this.select.optimize(optimizer, staticContext, itemType);
        this.action = this.action.optimize(optimizer, staticContext, this.select.getItemType(typeHierarchy));
        this.key = this.key.optimize(optimizer, staticContext, this.select.getItemType(typeHierarchy));
        this.adoptChildExpression(this.select);
        this.adoptChildExpression(this.action);
        this.adoptChildExpression(this.key);
        if (this.select instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        if (this.action instanceof EmptySequence) {
            return EmptySequence.getInstance();
        }
        if (this.collator == null && this.collationName instanceof StringValue) {
            String string = ((StringValue)this.collationName).getStringValue();
            try {
                URI uRI = new URI(string);
                if (!uRI.isAbsolute()) {
                    URI uRI2 = new URI(this.baseURI);
                    uRI = uRI2.resolve(uRI);
                    this.collationName = new StringValue(uRI.toString());
                    this.collator = staticContext.getCollation(uRI.toString());
                    if (this.collator == null) {
                        StaticError staticError = new StaticError("Unknown collation " + Err.wrap(uRI.toString(), 7));
                        staticError.setErrorCode("XTDE1110");
                        staticError.setLocator(this);
                        throw staticError;
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                StaticError staticError = new StaticError("Collation name '" + this.collationName + "' is not a valid URI");
                staticError.setErrorCode("XTDE1110");
                staticError.setLocator(this);
                throw staticError;
            }
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return this.action.getItemType(typeHierarchy);
    }

    public int computeDependencies() {
        int n = 0;
        n |= this.select.getDependencies();
        n |= this.key.getDependencies() & 0xFFFFFFE1;
        n |= this.action.getDependencies() & 0xFFFFFFC1;
        if (this.sortKeys != null) {
            for (int i = 0; i < this.sortKeys.length; ++i) {
                n |= this.sortKeys[i].getSortKey().getDependencies() & 0xFFFFFFE1;
                Expression expression = this.sortKeys[i].getCaseOrder();
                if (expression != null && !(expression instanceof Value)) {
                    n |= expression.getDependencies();
                }
                if ((expression = this.sortKeys[i].getDataTypeExpression()) != null && !(expression instanceof Value)) {
                    n |= expression.getDependencies();
                }
                if ((expression = this.sortKeys[i].getLanguage()) == null || expression instanceof Value) continue;
                n |= expression.getDependencies();
            }
        }
        if (this.collationName != null) {
            n |= this.collationName.getDependencies();
        }
        return n;
    }

    public final boolean createsNewNodes() {
        int n = this.action.getSpecialProperties();
        return (n & 0x400000) == 0;
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.select = this.doPromotion(this.select, promotionOffer);
        this.action = this.doPromotion(this.action, promotionOffer);
        this.key = this.doPromotion(this.key, promotionOffer);
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(3);
        arrayList.add(this.select);
        arrayList.add(this.action);
        arrayList.add(this.key);
        if (this.collationName != null) {
            arrayList.add(this.collationName);
        }
        if (this.sortKeys != null) {
            for (int i = 0; i < this.sortKeys.length; ++i) {
                arrayList.add(this.sortKeys[i].getSortKey());
                Expression expression = this.sortKeys[i].getOrder();
                if (expression != null && !(expression instanceof Value)) {
                    arrayList.add(expression);
                }
                if ((expression = this.sortKeys[i].getCaseOrder()) != null && !(expression instanceof Value)) {
                    arrayList.add(expression);
                }
                if ((expression = this.sortKeys[i].getDataTypeExpression()) != null && !(expression instanceof Value)) {
                    arrayList.add(expression);
                }
                if ((expression = this.sortKeys[i].getLanguage()) == null || expression instanceof Value) continue;
                arrayList.add(expression);
            }
        }
        return arrayList.iterator();
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
        this.action.checkPermittedContents(schemaType, staticContext, false);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        GroupIterator groupIterator = this.getGroupIterator(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentIterator(groupIterator);
        xPathContextMajor.setCurrentGroupIterator(groupIterator);
        xPathContextMajor.setCurrentTemplateRule(null);
        if (controller.isTracing()) {
            Item item;
            TraceListener traceListener = controller.getTraceListener();
            while ((item = groupIterator.next()) != null) {
                traceListener.startCurrentItem(item);
                this.action.process(xPathContextMajor);
                traceListener.endCurrentItem(item);
            }
        } else {
            Item item;
            while ((item = groupIterator.next()) != null) {
                this.action.process(xPathContextMajor);
            }
        }
        return null;
    }

    private Comparator getCollator(XPathContext xPathContext) throws XPathException {
        if (this.collationName != null) {
            StringValue stringValue = (StringValue)this.collationName.evaluateItem(xPathContext);
            String string = stringValue.getStringValue();
            try {
                URI uRI = new URI(string);
                if (!uRI.isAbsolute()) {
                    if (this.baseURI == null) {
                        DynamicError dynamicError = new DynamicError("Cannot resolve relative collation URI '" + string + "': unknown or invalid base URI");
                        dynamicError.setErrorCode("XTDE1110");
                        dynamicError.setXPathContext(xPathContext);
                        dynamicError.setLocator(this);
                        throw dynamicError;
                    }
                    uRI = new URI(this.baseURI).resolve(uRI);
                    string = uRI.toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                DynamicError dynamicError = new DynamicError("Collation name '" + string + "' is not a valid URI");
                dynamicError.setErrorCode("XTDE1110");
                dynamicError.setXPathContext(xPathContext);
                dynamicError.setLocator(this);
                throw dynamicError;
            }
            return xPathContext.getCollation(string);
        }
        Comparator comparator = xPathContext.getDefaultCollation();
        return comparator == null ? CodepointCollator.getInstance() : comparator;
    }

    private GroupIterator getGroupIterator(XPathContext xPathContext) throws XPathException {
        GroupIterator groupIterator;
        XPathContextMinor xPathContextMinor;
        FixedSortKeyDefinition[] fixedSortKeyDefinitionArray;
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        switch (this.algorithm) {
            case 0: {
                fixedSortKeyDefinitionArray = this.collator;
                if (fixedSortKeyDefinitionArray == null) {
                    fixedSortKeyDefinitionArray = this.getCollator(xPathContext);
                }
                xPathContextMinor = xPathContext.newMinorContext();
                xPathContextMinor.setOrigin(this);
                xPathContextMinor.setCurrentIterator(sequenceIterator);
                groupIterator = new GroupByIterator(sequenceIterator, this.key, xPathContextMinor, (Comparator)fixedSortKeyDefinitionArray);
                break;
            }
            case 1: {
                fixedSortKeyDefinitionArray = this.collator;
                if (fixedSortKeyDefinitionArray == null) {
                    fixedSortKeyDefinitionArray = this.getCollator(xPathContext);
                }
                groupIterator = new GroupAdjacentIterator(sequenceIterator, this.key, xPathContext, (Comparator)fixedSortKeyDefinitionArray);
                break;
            }
            case 2: {
                groupIterator = new GroupStartingIterator(sequenceIterator, ((PatternSponsor)this.key).getPattern(), xPathContext);
                break;
            }
            case 3: {
                groupIterator = new GroupEndingIterator(sequenceIterator, ((PatternSponsor)this.key).getPattern(), xPathContext);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown grouping algorithm");
            }
        }
        if (this.sortKeys != null) {
            fixedSortKeyDefinitionArray = new FixedSortKeyDefinition[this.sortKeys.length];
            xPathContextMinor = xPathContext.newMinorContext();
            for (int i = 0; i < this.sortKeys.length; ++i) {
                fixedSortKeyDefinitionArray[i] = this.sortKeys[i].reduce(xPathContextMinor);
            }
            groupIterator = new SortedGroupIterator(xPathContextMinor, groupIterator, fixedSortKeyDefinitionArray, this);
        }
        return groupIterator;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        GroupIterator groupIterator = this.getGroupIterator(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentIterator(groupIterator);
        xPathContextMajor.setCurrentGroupIterator(groupIterator);
        xPathContextMajor.setCurrentTemplateRule(null);
        return new ContextMappingIterator(this, xPathContextMajor);
    }

    public SequenceIterator map(XPathContext xPathContext) throws XPathException {
        return this.action.iterate(xPathContext);
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "for-each-group");
        printStream.println(ExpressionTool.indent(n) + "select");
        this.select.display(n + 1, printStream, configuration);
        printStream.println(ExpressionTool.indent(n) + "return");
        this.action.display(n + 1, printStream, configuration);
    }
}

