<?xml version="1.0" encoding="UTF-8"?>
<stylesheet version="2.0" xmlns="http://www.w3.org/1999/XSL/Transform">

    <param name="root"/>
    <output method="text" encoding="UTF-8"/>

    <template match="/">
        <!-- Just loop step tags -->
        <for-each select="//step">
            <!-- Get normalized text node -->
            <variable name="text" select="text()"/>
            <variable name="quoted" select="replace($text, '&quot;', '\\&quot;')"/>
            <variable name="a" select="replace($quoted, '(^\s+|\s+$)', '')"/>
            <variable name="b" select="replace($a, '\n\s+', '&#10;')"/>
            <variable name="c" select="replace($b, '\n', '\\n&quot;&#10;&quot;')"/>
            <!-- Add id -->
            <text>&#10;msgid ""&#10;"</text>
            <!-- Escape quotes -->
            <value-of select="$c"/>
            <text>"</text>
            <!-- Add empty string -->
            <text>&#10;msgstr ""&#10;&#10;</text>
        </for-each>
    </template>
    
</stylesheet>