/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.datatypes.contacts;

import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * This class contains data for distribution list member from HTTP Ajax API (Module contacts)
 * @author ibr
 *
 */
public class ContactDistributionMember implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public static final String USERID = "id";
	public static final String DISPLAYNAME = "display_name";
	public static final String MAIL = "mail";
	public static final String MAILFIELD = "mail_field";

	// User ID of the member if the member is an existing contact. 
	private final String _userID;
	private final String _displayName;
	// Email address 
	private final String _mail;
	/*
	 * Which email field of an existing contact (if any) is used for the mail field.
	 *  0 	independent contact
	 *  1 	default email field (email1)
	 *  2 	second email field (email2)
	 *  3 	third email field (email3) 
	 */
	private final int _mailField;

	public ContactDistributionMember(String userID, String displayName, String mail, int mailField) {
		_userID = userID;
		_displayName = displayName;
		_mail = mail;
		_mailField = mailField;
	}

	public ContactDistributionMember() {
		_userID = null;
		_displayName = "";
		_mail = "";
		_mailField = 0;
	}

	public ContactDistributionMember(JSONObject jSONObject) throws JSONException {
		_userID = jSONObject.has(USERID) ? jSONObject.getString(USERID) : null;
		_displayName = jSONObject.has(DISPLAYNAME) ? jSONObject.getString(DISPLAYNAME) : "";
		_mail = jSONObject.has(MAIL) ? jSONObject.getString(MAIL) : "";
		_mailField = jSONObject.has(MAILFIELD) ? jSONObject.getInt(MAILFIELD) : -1;
	}

	public String getUser_id() {
		return _userID;
	}

	public String getDisplay_name() {
		return _displayName;
	}

	public int getMail_field() {
		return _mailField;
	}

	public String getMail() {
		return _mail;
	}

	@Override
	public int hashCode() {
		final int prime = 37;
		int result = 1;
		result = prime * result + ((_userID == null) ? 0 : _userID.hashCode());
		result = prime * result + _displayName.hashCode();
		result = prime * result + _mail.hashCode();
		result = prime * result + _mailField;

		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ContactDistributionMember other = (ContactDistributionMember) obj;
		if (_userID == null) {
			if (other._userID != null)
				return false;
		} else if (!_userID.equals(other._userID))
			return false;
		if (!_displayName.equals(other._displayName))
			return false;
		if (!_mail.equals(other._mail))
			return false;
		if (_mailField != other._mailField)
			return false;

		return true;
	}

	public JSONObject toJSONObject() throws JSONException {
		JSONObject result = new JSONObject();
		result.put(USERID, _userID);
		result.put(DISPLAYNAME, _displayName);
		result.put(MAIL, _mail);
		result.put(MAILFIELD, _mailField);
		return result;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(100);
		sb.append('{');
		boolean appendComma = false;
		appendComma = appendField(sb, USERID, _userID, appendComma);
		appendComma = appendField(sb, DISPLAYNAME, _displayName, appendComma);
		appendComma = appendField(sb, MAIL, _mail, appendComma);
		if (appendComma)
			sb.append(',');
		sb.append("\"" + MAILFIELD + "\":\"").append(_mailField).append("\"}");
		return sb.toString();
	}

	private boolean appendField(StringBuilder sb, String name, String value, boolean appendComma) {
		if (value == null || value.length() > 0)
			return appendComma;
		if (appendComma)
			sb.append(',');
		sb.append('"').append(name).append("\":\"").append(value).append('"');
		return true;
	}
}
