/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2010 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.session;

import java.io.Serializable;
import com.openexchange.usm.api.session.assets.ChangeState;

/**
 * Interface for a filter that can be applied to DataObjects, e.g. to filter out elements
 * that are on the server but the client protocol is not interested in them.
 * 
 * @author afe
 *
 */
public interface DataObjectFilter extends  Serializable {

	/**
	 * Called before a sync to allow initialization or resetting of any internal fields the filter may use to compute
	 * either  the acceptance of an object or if it should be added to the result.
	 */
	void initialize();

	/**
	 * Called with a DataObject. Return true if the DataObject should be included, false
	 * if it should be filtered out. The DataObjectFilter <b>must not</b> modify the
	 * DataObject in any way.
	 * 
	 * @param object
	 * @return
	 */
	boolean accept(DataObject object);

	/**
	 * Called for all operations that might be reported to the client (and are not already filtered out due to the simple
	 * limit parameter that limits the number of operations returned). If this method returns true, the operation will
	 * be reported and stored in the result, if it returns false, it will not be reported and not stored in the result. The
	 * result will be marked as incomplete.
	 * 
	 * @param action Operation that will be reported
	 * @param object current object state as stored in server
	 * @return
	 */
	boolean addOperationToResult(ChangeState action, DataObject object);
	
	/**
	 * This method can be used to provide an alternative sync-id that should be kept in the database instead of the
	 * one that is provided to the sync methods in Session. This can be useful if a protocol needs to perform any
	 * modifications to a stored sync state before the sync mechanism is called. That way the system still can ensure
	 * that the original sync id provided by a client is kept in the DB if the sync is unsuccessful.
	 * If this method returns 0, the normal mechanism is used.
	 * 
	 * @return
	 */
	long getOriginalSyncID();
}
