/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.logging;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.apache.commons.logging.Log;

//=============================================================================
/** It help to spawn logging contexts where meta data will be add to every
 *  log statement additional to the also given usual logging messages.
 */
public class ContextAwareLogHelp
{
    //-------------------------------------------------------------------------
	public ContextAwareLogHelp (final Log aLog)
		throws Exception
	{
		m_aLog = aLog;
	}

	//-------------------------------------------------------------------------
	public ContextAwareLogHelp forLevel (final ELogLevel eLevel)
		throws Exception
	{
		m_eLogLevel = eLevel;
		return this;
	}
	
	//-------------------------------------------------------------------------
	public ContextAwareLogHelp enterContext (final String sContextID   ,
										     final String sContextValue)
	    throws Exception
	{
		final Map< String, LogContext > aContextSet = mem_ContextSet ();
		final LogContext                aContext    = LogContext.build(sContextID, sContextValue);
		aContextSet.put(sContextID, aContext);
		return this;
	}

	//-------------------------------------------------------------------------
	public ContextAwareLogHelp leaveContext (final String sContextID)
	    throws Exception
	{
		final Map< String, LogContext > aContextSet = mem_ContextSet ();
		aContextSet.remove(sContextID);
		return this;
	}

	//-------------------------------------------------------------------------
	public String toLog (final String... lMessages)
	    throws Exception
	{
		if ( ! impl_isLogLevelActive ())
			return "";
		
		final StringBuffer           sLog          = new StringBuffer (256);
		final Iterator< LogContext > aContextSet   = mem_ContextSet ().values().iterator();
		      boolean                bAddSeparator = false;

		sLog.append ("context[");
		while (aContextSet.hasNext())
		{
			if (bAddSeparator)
				sLog.append (",");
			else
				bAddSeparator = true;
			
			final LogContext aContext = aContextSet.next();
			sLog.append (aContext.getID   ());
			sLog.append (":"                );
			sLog.append (aContext.getValue());
		}
		sLog.append ("]");
		
		if (lMessages != null)
		{
			sLog.append (" ");
			
			bAddSeparator = false;
			for (final String sMessage : lMessages)
			{
				if (bAddSeparator)
					sLog.append (",");
				else
					bAddSeparator = true;

				sLog.append (sMessage);
			}				
		}
		
		return sLog.toString ();
	}

	//-------------------------------------------------------------------------
	private boolean impl_isLogLevelActive ()
	    throws Exception
	{
		if (m_eLogLevel == ELogLevel.E_TRACE)
			return m_aLog.isTraceEnabled();
		if (m_eLogLevel == ELogLevel.E_DEBUG)
			return m_aLog.isDebugEnabled();
		if (m_eLogLevel == ELogLevel.E_INFO)
			return m_aLog.isInfoEnabled();
		if (m_eLogLevel == ELogLevel.E_WARNING)
			return m_aLog.isWarnEnabled();
		if (m_eLogLevel == ELogLevel.E_ERROR)
			return m_aLog.isErrorEnabled();
		
		throw new UnsupportedOperationException ("No support for log level '"+m_eLogLevel+"' implemented yet.");
	}
	
	//-------------------------------------------------------------------------
	private Map< String, LogContext > mem_ContextSet ()
	    throws Exception
	{
		if (m_aContextSet == null)
			m_aContextSet = new HashMap< String, LogContext > ();
		return m_aContextSet;
	}
	
	//-------------------------------------------------------------------------
	private Log m_aLog = null;

	//-------------------------------------------------------------------------
	private ELogLevel m_eLogLevel = null;

	//-------------------------------------------------------------------------
	private Map< String, LogContext > m_aContextSet = null;
}
