/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools.jobpool;


//=============================================================================
public class JobPoolConfig extends MapImpl
{
	//-------------------------------------------------------------------------
	private static final long serialVersionUID = 1L;

	//-------------------------------------------------------------------------
	/** [Boolean]
	 *  TRUE  enable blocking on leaseJob() if no job is still free for using ...
	 *  FALSE enable throwing an exception at the same case.
	 */
	public static final String PROP_BLOCK_ON_LEASE = "block.on.lease";
	
	//-------------------------------------------------------------------------
	/** [Long]
	 *  Define a timeout in [ms] for cancel blocked request on {@link IJob#leaseJob}.
	 */
	public static final String PROP_LEASE_BLOCK_TIMEOUT = "lease.block.timeout";

	//-------------------------------------------------------------------------
	/** [Integer]
	 *  The max pool size.
	 *  Values need to be > 0 !
	 */
	public static final String PROP_POOL_SIZE = "pool.size";

	//-------------------------------------------------------------------------
	/** [Integer]
	 *  Timeout in [ms] to be used to detect 'hanging' job executions.
	 */
	public static final String PROP_JOB_EXECUTION_TIMEOUT = "job.execution.timeout";

	//-------------------------------------------------------------------------
	/** Define a default size for a default pool ...
	 *  which is not configured from outside.
	 */
	public static final int DEFAULT_POOL_SIZE = 5;

	//-------------------------------------------------------------------------
	/** default timeout to detect blocked calls of {@link IJob#leaseJob}
	 *  Defined in [ms].
	 *  Needs to be > 0.
	 *  Be aware ... 0 means FOREVER .-)
	 */
	public static final int DEFAULT_LEASE_BLOCK_TIMEOUT_IN_MS = 30000;

	//-------------------------------------------------------------------------
	/** default timeout to detect 'hanging' jobs defined in [ms]
	 *  Needs to be > 0.
	 *  Be aware ... 0 means FOREVER .-)
	 */
	public static final int DEFAULT_JOB_EXECUTION_TIMEOUT_IN_MS = 30000;

	//-------------------------------------------------------------------------
	public JobPoolConfig()
		throws Exception
	{
		super();
	}

	//-------------------------------------------------------------------------
	public static final synchronized JobPoolConfig EMPTY_CONFIG ()
		throws Exception
	{
		return new JobPoolConfig ();
	}

	//-------------------------------------------------------------------------
	public static final synchronized JobPoolConfig DEFAULT_CONFIG ()
		throws Exception
	{
		JobPoolConfig aConfig = new JobPoolConfig ();
		aConfig.set(PROP_POOL_SIZE            , DEFAULT_POOL_SIZE                  );
		aConfig.set(PROP_LEASE_BLOCK_TIMEOUT  , DEFAULT_LEASE_BLOCK_TIMEOUT_IN_MS  );
		aConfig.set(PROP_JOB_EXECUTION_TIMEOUT, DEFAULT_JOB_EXECUTION_TIMEOUT_IN_MS);
		return aConfig;
	}
}
