package com.openexchange.office.tools.htmldoc;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

public abstract class NodeHolder
		implements
		INode
{

	private final List<INode>	children	= new ArrayList<INode>();
	private JSONObject			attrs;

	@Override
	public final boolean setAttribute(
		JSONArray start,
		JSONArray end,
		JSONObject attrs)
		throws Exception
	{
		if (start.length() == 0)
		{
			this.attrs = attrs;
			return true;
		}
		else
		{
			final int childIndex = start.getInt(0);
			final INode child = children.get(childIndex);
			final JSONArray subStart = GenDocHelper.shiftedCopy(start);
			final JSONArray subEnd = GenDocHelper.shiftedCopy(end);
			return child.setAttribute(subStart, subEnd, attrs);
		}

	}

	public JSONObject getAttribute()
	{
		return attrs;
	}

	@Override
	public boolean appendContent(
		StringBuilder document)
		throws Exception
	{
		boolean appendedContent = false;
		for (final INode child : children)
		{
			appendedContent |= child.appendContent(document); 
		}
        return appendedContent;
	}

	@Override
	public void insert(
		JSONArray start,
		INode newChild)
		throws Exception
	{
		if (start.length() == 1 && !(newChild instanceof SubNode))
		{
			final int childIndex = start.getInt(0);
			children.add(childIndex, newChild);
		}
		else
		{
			final int childIndex = start.getInt(0);
			final INode child = children.get(childIndex);
			final JSONArray subStart = GenDocHelper.shiftedCopy(start);
			child.insert(subStart, newChild);
		}
	}

	protected int getChildrenCount()
	{
		return children.size();
	}

	protected List<INode> getChildren()
	{
		return children;
	}

	@Override
	public int getTextLength()
	{
		int res = 0;
		for (INode sn : children)
		{
			res += sn.getTextLength();
		}
		return res;
	}

	@Override
	public String toString()
	{
		return this.getClass().getSimpleName() + " " + children;
	}

}
