/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.tools.htmldoc;

import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.openexchange.office.tools.json.JSONValueComparator;

public class GenericHtmlDocumentBuilder
{
	private final static Logger					LOG			= LoggerFactory.getLogger(GenericHtmlDocumentBuilder.class);
	private final static Set<String>			IGNOREOPS	= new HashSet<String>();
	private final static String					DUMMYATTRS	= "attrs:{character:{italic:false,tab:true}}";
	private final static JSONValueComparator	STARTCOMP	= new JSONValueComparator();

	static
	{
		IGNOREOPS.add("setDocumentAttributes");
		IGNOREOPS.add("insertFontDescription");
		IGNOREOPS.add("insertStyleSheet");
		IGNOREOPS.add("insertTheme");
		IGNOREOPS.add("insertListStyle");
	}

	static public String buildHtmlDocument(
		JSONObject documentOperations,
		String fileId,
		String folderId,
		String fileVersion,
		TextTableLimits textTableLimits)
	{

		String result = null;

		final DocumentNode documentNode = new DocumentNode();

		try
		{
			final long time = System.currentTimeMillis();
			final JSONArray operations = documentOperations.getJSONArray("operations");
			final JSONArray reducedOperations = new JSONArray();

			// final Set<JSONArray> missingTabParas = new TreeSet<JSONArray>(STARTCOMP);

			for (int i = 0; i < operations.length(); i++)
			{
				JSONObject operation = operations.getJSONObject(i);
				try
				{
					final String opName = operation.getString("name");
					if (IGNOREOPS.contains(opName))
					{
						reducedOperations.put(operation);
						continue;
					}

					JSONArray start = operation.optJSONArray("start");
					JSONArray end = operation.optJSONArray("end");
					final JSONObject attrs = operation.optJSONObject("attrs");

					if (null == start)
					{
						throw new Exception("RT connection: no start Info found " + opName);
					}

					if (null == end)
					{
						end = start;
					}

					boolean deleteOp;

					if (opName.equalsIgnoreCase("setAttributes"))
					{
						deleteOp = documentNode.setAttribute(start, end, attrs);
						// if (!deleteOp)
						// {
						// missingTabParas.remove(start);
						// }
					}
					else
					{
						JSONArray setStart = start;

						deleteOp = true;
						final INode insert;
						if (opName.equalsIgnoreCase("insertText"))
						{
							final int textIndex = start.getInt(start.length() - 1);
							start = new JSONArray(start.asList());
							start.remove(start.length() - 1);
							final String text = operation.getString("text");
							insert = new Text(text, textIndex);
						}
						else if (opName.equalsIgnoreCase("insertHardbreak"))
						{
							final int textIndex = start.getInt(start.length() - 1);
							start = new JSONArray(start.asList());
							start.remove(start.length() - 1);
							final String type = operation.optString("type");
							insert = new HardBreak(textIndex, type);
						}
						else if (opName.equalsIgnoreCase("insertTab"))
						{
							final int textIndex = start.getInt(start.length() - 1);
							start = new JSONArray(start.asList());
							start.remove(start.length() - 1);
							insert = new Tab(textIndex);

							// missingTabParas.add(start);
						}
						else if (opName.equalsIgnoreCase("insertParagraph"))
						{
							insert = new Paragraph();
						}
						else if (opName.equalsIgnoreCase("insertTable"))
						{
							insert = new Table(textTableLimits, attrs, operation.optJSONObject("sizeExceeded"));
						}
						else if (opName.equalsIgnoreCase("insertDrawing"))
						{

							final int textIndex = start.getInt(start.length() - 1);
							start = new JSONArray(start.asList());
							start.remove(start.length() - 1);
							insert = new Drawing(textIndex, attrs, fileId, folderId, fileVersion);

							deleteOp = false;

							// // if (Drawing.needAttrsOp(attrs)) // TODO: complete support for image attributes
							// // {
							// deleteOp = false;
							//
							// operation = new JSONObject().parseJSONString(operation.toString());
							// operation.put("name", "setAttributes");
							// // }
						}
						else if (opName.equalsIgnoreCase("insertRows"))
						{
							insert = new Row(operation.optBoolean("insertDefaultCells", false));
						}
						else if (opName.equalsIgnoreCase("insertCells"))
						{
							insert = new Cell();
						}
						else if (opName.equalsIgnoreCase("insertField"))
						{
							final int textIndex = start.getInt(start.length() - 1);
							start = new JSONArray(start.asList());
							start.remove(start.length() - 1);
							insert = new Field(textIndex, operation.optString("representation", ""));
						}
						else
						{
							LOG.warn(opName + " not implemented yet");
							continue;
						}

						documentNode.insert(start, insert);

						if (attrs != null)
						{
							documentNode.setAttribute(setStart, end, attrs);
						}

					}
					if (!deleteOp)
					{
						reducedOperations.put(operation);
					}
				}
				catch (final Exception e)
				{
					throw new Exception("operation: " + operation, e);
				}

			}

			// for (final JSONArray misPara : missingTabParas)
			// {
			// final JSONObject newOp = new JSONObject();
			// newOp.put("name", "setAttributes");
			// newOp.put("start", misPara);
			// newOp.put("attrs", DUMMYATTRS);
			// reducedOperations.put(newOp);
			// }

			// now create the document html string
			final StringBuilder document = new StringBuilder();
			documentNode.appendContent(document);

			// set result
			result = document.toString();
			documentOperations.put("operations", reducedOperations);
			// result = result.replace("'", "\"");

			LOG.debug("RT connection: fastLoad optimizations used for loading document: " + ((null != folderId) ? folderId : "") + "." + ((null != fileId) ? fileId : ""));
			LOG.debug("RT connection: creating the generic html document took " + (System.currentTimeMillis() - time) + "ms");
		}
		catch (final Exception e)
		{
			LOG.warn("RT connection: Eexception while creating the generic html document string from operations.", e);
		}
		return result;
	}

}
