package com.openexchange.office.tools.htmldoc;

public class Cell
		extends NodeHolder
{

	private final static Paragraph	IMPLICITPARA	= new Paragraph();
	static
	{
		IMPLICITPARA.setInTable(true);
		IMPLICITPARA.setImplicit(true);
	}

	public Cell()
		throws Exception
	{
		super();
		// TODO Auto-generated constructor stub
	}

	@Override
	public boolean appendContent(
		StringBuilder document)
		throws Exception
	{

		document.append("<td");
		GenDocHelper.appendAttributes(getAttribute(), document);
		document.append("role='gridcell' colspan='1' style='border: 1px solid rgb(0, 0, 0); padding: 2px 7px; background-color: transparent;'>");
		document.append("<div class='cell' contenteditable='false'>");
		document.append("<div class='resize bottom'></div>");
		document.append("<div class='resize right'></div>");
		document.append("<div class='cellcontent' contenteditable='true' data-focus-role='cell'>");

		if (getChildrenCount() > 0)
		{
			super.appendContent(document);
		}
		else
		{
			IMPLICITPARA.appendContent(document);
		}

		document.append("</div>");
		document.append("</div>");
		document.append("</td>");
        return true;
	}

	@Override
	public boolean needsEmptySpan()
	{
		return false;
	}
}