/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.tools;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.tools.file.external.QuotaFileStorageExceptionCodes;

/**
 * A helper class to map certain exception codes to specific error codes
 * defined in the enumation ErrorCode.
 *
 * {@link ErrorCode}
 *
 * @author <a href="mailto:carsten.driesner@open-xchange.com">Carsten Driesner</a>
 */

public class ExceptionToErrorCode {

    static protected final org.apache.commons.logging.Log LOG = com.openexchange.log.LogFactory.getLog(ExceptionToErrorCode.class);

    /**
     * Maps certain OXExceptions to specific error codes.
     *
     * @param e
     *  An instance of a OXException.
     *
     * @param defErrorCode
     *  The default error code to be used if there is no mapping available.
     *
     * @param logEx
     *  Specifies if the exception should be logged or not.
     *
     * @return
     *  The specific error code or the default if no mapping is available.
     */
	static public ErrorCode map(OXException e, ErrorCode defErrorCode, boolean logEx) {
    	ErrorCode errorCode = defErrorCode;
    	String msg = "Exception catched";
    	
        // special handling for file storage exceptions
        if (e.getPrefix().equalsIgnoreCase("FLS")) {
            if (e.getCode() == QuotaFileStorageExceptionCodes.STORE_FULL.getNumber()) {
                // set specific error code if quota reached
                errorCode = ErrorCode.GENERAL_QUOTA_REACHED_ERROR;
                msg = "RT connection: Quota reached error detected!";
            }
        } else if (e.getPrefix().equalsIgnoreCase("FILE_STORAGE")) {
        	if (e.getCode() == FileStorageExceptionCodes.FILE_NOT_FOUND.getNumber()) {
        	    // file not found error
        		errorCode = ErrorCode.GENERAL_FILE_NOT_FOUND_ERROR;
                msg = "RT connection: File not found error detected!";
        	}
        } else if (e.getPrefix().equalsIgnoreCase("IFO")) {
            if (e.getCode() == InfostoreExceptionCodes.NO_READ_PERMISSION.getNumber()) {
                // read permissions missing
                errorCode = ErrorCode.GENERAL_PERMISSION_READ_MISSING_ERROR;
                msg = "RT connection: No read permissions detected!";
            } else if (e.getCode() == InfostoreExceptionCodes.NO_WRITE_PERMISSION.getNumber()) {
                // read permissions missing
                errorCode = ErrorCode.GENERAL_PERMISSION_WRITE_MISSING_ERROR;
                msg = "RT connection: No write permissions!";
            } else if (e.getCode() == InfostoreExceptionCodes.NOT_EXIST.getNumber()) {
                // file not found
                errorCode = ErrorCode.GENERAL_FILE_NOT_FOUND_ERROR;
                msg = "RT connection: Original document couldn't be found!";
            }
        }

        if (logEx) {
        	LOG.error(msg, e);
        }

        return errorCode;
    }
}
