/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.pptx;

import java.io.InputStream;
import org.docx4j.dml.Theme;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import com.openexchange.office.DocumentProperties;
import com.openexchange.office.FilterException;
import com.openexchange.office.FilterException.ErrorCode;
import com.openexchange.office.tools.ResourceManager;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;

public class OperationDocument extends com.openexchange.office.ooxml.OperationDocument {

    final private PresentationMLPackage opcPackage;

    public OperationDocument(Session session, ServiceLookup _services, InputStream _inputDocumentStream, ResourceManager _resourceManager, DocumentProperties _documentProperties)
        throws FilterException {

        super(session, _services, _inputDocumentStream, _resourceManager, _documentProperties);
        try {
            opcPackage = (PresentationMLPackage)PresentationMLPackage.load(_inputDocumentStream);
        }
        catch(Docx4JException e) {
            ErrorCode errorCode = ErrorCode.CRITICAL_ERROR;
            if(e.getCause() instanceof java.security.InvalidKeyException) {
                errorCode = ErrorCode.WRONG_PASSWORD;
            }
            else if(e.getCause() instanceof org.apache.poi.EncryptedDocumentException) {
                errorCode = ErrorCode.UNSUPPORTED_ENCRYPTION_USED;
            }
            throw new FilterException(e, errorCode);
        }
    }

    // the constructor without inputStream creates an empty document
    public OperationDocument(ServiceLookup _services, DocumentProperties _documentProperties)
        throws FilterException {

        super(null, _services, null, null, _documentProperties);
        try {
            opcPackage = PresentationMLPackage.createPackage();
        }
        catch(Docx4JException e) {
            throw new FilterException(e, ErrorCode.CRITICAL_ERROR);
        }
    }

    @Override
    public void applyOperations(String applyOperations) throws FilterException {

        if (applyOperations != null) {
            int i = 0;
            JSONObject op = null;
            try {
                final JSONArray aOperations = new JSONArray(new JSONTokener(applyOperations));
                for (i = 0; i < aOperations.length(); i++) {
                    op = (JSONObject) aOperations.get(i);
                    String opName = op.getString("name");
/*
                    if (opName.equals("insertParagraph"))
                        applyOperationHelper.insertParagraph(op.getJSONArray("start"), op.optJSONObject("attrs"));
                    else if (opName.equals("delete"))
                        applyOperationHelper.delete(op.getJSONArray("start"), op.optJSONArray("end"));
                    else if (opName.equals("move"))
                        applyOperationHelper.move(op.getJSONArray("start"), op.optJSONArray("end"), op.getJSONArray("to"));
                    else if (opName.equals("splitParagraph"))
                        applyOperationHelper.splitParagraph(op.getJSONArray("start"));
                    else if (opName.equals("mergeParagraph"))
                        applyOperationHelper.mergeParagraph(op.getJSONArray("start"));
                    else if (opName.equals("insertText"))
                        applyOperationHelper.insertText(op.getJSONArray("start"), op.getString("text").replaceAll("\\p{C}", " "), op.optJSONObject("attrs"));
                    else if (opName.equals("insertTab"))
                        applyOperationHelper.insertTab(op.getJSONArray("start"), op.optJSONObject("attrs"));
                    else if (opName.equals("insertHardBreak"))
                        applyOperationHelper.insertHardBreak(op.getJSONArray("start"), op.optJSONObject("attrs"));
                    else if (opName.equals("insertTable"))
                        applyOperationHelper.insertTable(op.getJSONArray("start"), op.optJSONObject("attrs"));
                    else if (opName.equals("insertRows"))
                        applyOperationHelper.insertRows(op.getJSONArray("start"), op.optInt("count", 1), op.optBoolean("insertDefaultCells", false), op.optInt("referenceRow", -1), op.optJSONObject("attrs"));
                    else if (opName.equals("insertCells"))
                        applyOperationHelper.insertCells(op.getJSONArray("start"), op.optInt("count", 1), op.optJSONObject("attrs"));
                    else if (opName.equals("insertColumn"))
                        applyOperationHelper.insertColumn(op.getJSONArray("start"), op.getJSONArray("tableGrid"), op.getInt("gridPosition"), op.optString("insertMode", "before"));
                    else if (opName.equals("deleteColumns"))
                        applyOperationHelper.deleteColumns(op.getJSONArray("start"), op.getInt("startGrid"), op.optInt("endGrid", op.getInt("startGrid")));
                    else if (opName.equals("setAttributes"))
                        applyOperationHelper.setAttributes(op.getJSONObject("attrs"), op.getJSONArray("start"), op.optJSONArray("end"));
                    else if (opName.equals("insertField"))
                        applyOperationHelper.insertField(op.getJSONArray("start"), op.getString("type"), op.getString("representation"), op.optJSONObject("attrs"));
                    else if (opName.equals("insertDrawing"))
                        applyOperationHelper.insertDrawing(op.getJSONArray("start"), op.getString("type").toUpperCase(), op.optJSONObject("attrs"));
                    else if (opName.equals("insertStyleSheet"))
                        applyOperationHelper.insertStyleSheet(op.getString("type"), op.getString("styleId"), op.getString("styleName"), op.getJSONObject("attrs"), op.optString("parent"), op.optBoolean("hidden"), op.getInt("uiPriority"), op.optBoolean("default"));
                    else if (opName.equals("deleteStylesheet"))
                        applyOperationHelper.deleteStylesheet(op.getString("type"), op.getString("styleId"));
                    else if (opName.equals("insertListStyle"))
                        applyOperationHelper.insertListStyle(op.getString("listStyleId"), op.getJSONObject("listDefinition"));
*/
                }
            }
            catch(Exception e) {
                String message = e.getMessage();
                if(op!=null) {
                    message += ", operation:" + Integer.toString(i) + " " + op.toString();
                }
                throw new FilterException(message, e, ErrorCode.CRITICAL_ERROR);
            }
        }
    }

    @Override
    public JSONObject getOperations()
        throws JSONException {

        final JSONObject aOperations = new JSONObject();
        final JSONArray operationsArray = new JSONArray();

            // .....

        aOperations.put("operations", operationsArray);

        return aOperations;
    }


    @Override
    public PresentationMLPackage getPackage() {
        return opcPackage;
    }

    @Override
    public Theme getTheme() {
        return null;
    }
}
