/*
 *  Copyright 2010-2013, Plutext Pty Ltd.
 *
 *  This file is part of xlsx4j, a component of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */
package org.xlsx4j.sml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

import org.jvnet.jaxb2_commons.ppp.Child;
import org.xlsx4j.jaxb.Context;


/**
 * <p>Java class for CT_Row complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CT_Row">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="c" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}CT_Cell" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="extLst" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}CT_ExtensionList" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="r" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" />
 *       &lt;attribute name="spans" type="{http://schemas.openxmlformats.org/spreadsheetml/2006/main}ST_CellSpans" />
 *       &lt;attribute name="s" type="{http://www.w3.org/2001/XMLSchema}unsignedInt" default="0" />
 *       &lt;attribute name="customFormat" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="ht" type="{http://www.w3.org/2001/XMLSchema}double" />
 *       &lt;attribute name="hidden" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="customHeight" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="outlineLevel" type="{http://www.w3.org/2001/XMLSchema}unsignedByte" default="0" />
 *       &lt;attribute name="collapsed" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="thickTop" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="thickBot" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="ph" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_Row", propOrder = {
    "c",
    "extLst",
    "r",
    "spans",
    "s",
    "customFormat",
    "ht",
    "hidden",
    "customHeight",
    "outlineLevel",
    "collapsed",
    "thickTop",
    "thickBot",
    "ph"
})
@XmlRootElement(name = "row")
public class Row implements Child
{
    protected List<Cell> c;
    @XmlTransient
    private TreeMap<Integer, Cell> cells_impl;
    protected CTExtensionList extLst;
    @XmlAttribute(name = "r")
    @XmlSchemaType(name = "unsignedInt")
    protected Long r;
    @XmlAttribute(name = "spans")
    protected List<String> spans;
    @XmlAttribute(name = "s")
    @XmlSchemaType(name = "unsignedInt")
    protected Long s;
//  @XmlAttribute(name = "customFormat")	// 0x0003
//  protected Boolean customFormat;
    @XmlAttribute(name = "ht")
    protected Double ht;
//  @XmlAttribute(name = "hidden")			// 0x000c
//  protected Boolean hidden;
//  @XmlAttribute(name = "customHeight")	// 0x0030
//  protected Boolean customHeight;
    @XmlAttribute(name = "outlineLevel")
    @XmlSchemaType(name = "unsignedByte")
    protected Short outlineLevel;
//  @XmlAttribute(name = "collapsed")		// 0x00c0
//  protected Boolean collapsed;
//  @XmlAttribute(name = "thickTop")		// 0x0300
//  protected Boolean thickTop;
//  @XmlAttribute(name = "thickBot")		// 0x0c00
//  protected Boolean thickBot;
//  @XmlAttribute(name = "ph")				// 0x3000
//  protected Boolean ph;
    @XmlTransient
    private Object parent;
    @XmlTransient
    private Long maxSi;
    @XmlTransient
    int flags;

    /**
     * Gets the value of the c property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the c property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getC().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Cell }
     *
     *
     */
    private List<Cell> getListArray() {
        if (c == null) {
        	if(cells_impl!=null) {
        		c = new ArrayList<Cell>(cells_impl.values());
        	}
        	else {
        		c = new ArrayList<Cell>();
        	}
        	cells_impl = null;
        }
        return c;
    }

    private Map<Integer, Cell> getTreeMap() {
        if(cells_impl==null) {
            cells_impl = new TreeMap<Integer, Cell>();
            if(c!=null) {
            	for(Cell cell:c) {
            		cells_impl.put(cell.getColumn(), cell);
            	}
            	c = null;
            }
        }
        return cells_impl;
    }

    public Cell getCell(int column, boolean forceCreate) {
        final Map<Integer, Cell> treeMap = getTreeMap();
        Cell cell = treeMap.get(column);
        if(forceCreate&&cell==null) {

            // creating a new cell...
        	org.docx4j.jaxb.Context.checkMemory();

            cell = Context.getsmlObjectFactory().createCell();
            cell.setParent(this);
            cell.setColumn(column);
            treeMap.put(column, cell);
        }
        return cell;
    }

    public void insertCells(CTStylesheet stylesheet, int start, int count) {

    	final List<Cell> cells = getListArray();

        int i, previousColumnNumber = -1234;
        int nextColumnNumber = -1234;
        int insertIndex;

        for(insertIndex=0; insertIndex<cells.size();insertIndex++) {
            Cell c = cells.get(insertIndex);
            nextColumnNumber = c.getColumn();
            if(nextColumnNumber>=start) {
                break;
            }
            previousColumnNumber = nextColumnNumber;
        }

        Cell previousCell = null;
        Cell nextCell = null;
        if(previousColumnNumber+1==start) {
            previousCell = cells.get(insertIndex-1);
        }
        if(nextColumnNumber==start) {
            nextCell = cells.get(insertIndex);
        }
        for(i=0;i<count;i++) {
            final Cell cellClone = Context.getsmlObjectFactory().createCell();
            cellClone.setParent(this);
            cellClone.setColumn(start+i);
            if(previousCell!=null) {
                cellClone.setS(previousCell.getS());
            }
            if(previousCell!=null&&i==0) {
                SheetData.ApplyBorderStyle(stylesheet, cellClone, nextCell);
            }
            if(cellClone.getS()==0L) {
            	// not inserting default cells
            	break;
            }
            cells.add(insertIndex+i, cellClone);
            previousCell = cellClone;
        }
        for(i=insertIndex+i;i<cells.size();i++) {
            // correcting cell refs
            final Cell cell = cells.get(i);
            cell.setColumn(cell.getColumn()+count);
        }
    }

    public void deleteCells(int start, int deleteCount) {

    	final List<Cell> cells = getListArray();
    	for(int i=0; i<cells.size(); i++) {
    		final Cell cell = cells.get(i);
    		final int column = cell.getColumn();
    		if(column>=start) {
	    		if(column<=start+deleteCount-1) {
	    			cells.remove(i--);
	    		}
	    		else {
	    			cell.setColumn(column - deleteCount);
	    		}
    		}
    	}
    }

    public int getCellCount() {
        return c!=null?c.size():cells_impl!=null?cells_impl.size():0;
    }

    public Iterator<Cell> createCellIterator() {
    	if(c!=null) {
    		return c.iterator();
    	}
    	else if (cells_impl!=null) {
    		return cells_impl.values().iterator();
    	}
    	return getListArray().iterator();
    }

    /**
     * Gets the value of the extLst property.
     *
     * @return
     *     possible object is
     *     {@link CTExtensionList }
     *
     */
    public CTExtensionList getExtLst() {
        return extLst;
    }

    /**
     * Sets the value of the extLst property.
     *
     * @param value
     *     allowed object is
     *     {@link CTExtensionList }
     *
     */
    public void setExtLst(CTExtensionList value) {
        this.extLst = value;
    }

    /**
     * Gets the value of the r property.
     *
     * @return
     *     possible object is
     *     {@link Long }
     *
     */
    public Long getR() {
        return r;
    }

    /**
     * Sets the value of the r property.
     *
     * @param value
     *     allowed object is
     *     {@link Long }
     *
     */
    public void setR(Long value) {
        this.r = value;
    }

    public int getRow() {
    	return getR()!=null?getR().intValue()-1:-1;
    }

    public void setRow(int row) {
    	r = new Long(row+1);
    }

    
    /**
     * Gets the value of the spans property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the spans property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpans().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     *
     *
     */
    public List<String> getSpans() {
        if (spans == null) {
            spans = new ArrayList<String>();
        }
        return this.spans;
    }

    /**
     * Gets the value of the s property.
     *
     * @return
     *     possible object is
     *     {@link Long }
     *
     */
    public long getS() {
        if (s == null) {
            return  0L;
        } else {
            return s;
        }
    }

    /**
     * Sets the value of the s property.
     *
     * @param value
     *     allowed object is
     *     {@link Long }
     *
     */
    public void setS(Long value) {
        this.s = value;
    }

    /**
     * Gets the value of the customFormat property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    @XmlAttribute
    public Boolean isCustomFormat() {
        if ((flags&0x1)==0) {
            return null;
        }
        return (flags&0x2)!=0;
    }

    /**
     * Sets the value of the customFormat property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    public void setCustomFormat(Boolean value) {
		flags&=~0x3;
    	if(value!=null) {
    		flags|=value.booleanValue()?0x3:0x1;
    	}
    }

    /**
     * Gets the value of the ht property.
     *
     * @return
     *     possible object is
     *     {@link Double }
     *
     */
    public Double getHt() {
        return ht;
    }

    /**
     * Sets the value of the ht property.
     *
     * @param value
     *     allowed object is
     *     {@link Double }
     *
     */
    public void setHt(Double value) {
        this.ht = value;
    }

    /**
     * Gets the value of the hidden property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    @XmlAttribute
    public Boolean isHidden() {
        if ((flags&0x4)==0) {
            return null;
        }
        return (flags&0x8)!=0;
    }

    /**
     * Sets the value of the hidden property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    public void setHidden(Boolean value) {
		flags&=~0xc;
    	if(value!=null) {
    		flags|=value.booleanValue()?0xc:0x4;
    	}
    }

    /**
     * Gets the value of the customHeight property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    @XmlAttribute
    public Boolean isCustomHeight() {
        if ((flags&0x10)==0) {
            return null;
        }
        return (flags&0x20)!=0;
    }

    /**
     * Sets the value of the customHeight property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    public void setCustomHeight(Boolean value) {
		flags&=~0x30;
    	if(value!=null) {
    		flags|=value.booleanValue()?0x30:0x10;
    	}
    }

    /**
     * Gets the value of the outlineLevel property.
     *
     * @return
     *     possible object is
     *     {@link Short }
     *
     */
    public short getOutlineLevel() {
        if (outlineLevel == null) {
            return ((short) 0);
        } else {
            return outlineLevel;
        }
    }

    /**
     * Sets the value of the outlineLevel property.
     *
     * @param value
     *     allowed object is
     *     {@link Short }
     *
     */
    public void setOutlineLevel(Short value) {
        this.outlineLevel = value;
    }

    /**
     * Gets the value of the collapsed property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    @XmlAttribute
    public Boolean isCollapsed() {
        if ((flags&0x40)==0) {
            return null;
        }
        return (flags&0x80)!=0;
    }

    /**
     * Sets the value of the collapsed property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    public void setCollapsed(Boolean value) {
		flags&=~0xc0;
		if(value!=null) {
			flags|=value.booleanValue()?0xc0:0x40;
		}
    }

    /**
     * Gets the value of the thickTop property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    @XmlAttribute
    public Boolean isThickTop() {
        if ((flags&0x100)==0) {
            return null;
        }
        return (flags&0x200)!=0;
    }

    /**
     * Sets the value of the thickTop property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    public void setThickTop(Boolean value) {
		flags&=~0x300;
    	if(value!=null) {
    		flags|=value.booleanValue()?0x300:0x100;
    	}
    }

    /**
     * Gets the value of the thickBot property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    @XmlAttribute
    public Boolean isThickBot() {
        if ((flags&0x400)==0) {
            return null;
        }
        return (flags&0x800)!=0;
    }

    /**
     * Sets the value of the thickBot property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    public void setThickBot(Boolean value) {
		flags&=~0xc00;
    	if(value!=null) {
    		flags|=value.booleanValue()?0xc00:0x400;
    	}
    }

    /**
     * Gets the value of the ph property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    @XmlAttribute
    public Boolean isPh() {
        if ((flags&0x1000)==0) {
            return null;
        }
        return (flags&0x2000)!=0;
    }

    /**
     * Sets the value of the ph property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    public void setPh(Boolean value) {
		flags&=~0x3000;
    	if(value!=null) {
    		flags|=value.booleanValue()?0x3000:0x1000;
    	}
    }

    /**
     * Gets the parent object in the object tree representing the unmarshalled xml document.
     *
     * @return
     *     The parent object.
     */
    @Override
    public Object getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Object parent) {
        this.parent = parent;
    }

    public void setSi(long si) {
        if(maxSi==null) {
            maxSi = si;
        }
        else if(si>maxSi) {
            maxSi = si;
        }
    }

    public int getLastColumnNumber() {
    	if(c!=null&&!c.isEmpty()) {
    		return c.get(c.size()-1).getColumn();
    	}
    	else if (cells_impl!=null&&!cells_impl.isEmpty()) {
    		return cells_impl.lastKey();
    	}
    	return -1;
    }

    @SuppressWarnings("unused")
    public void beforeMarshal(Marshaller marshaller) {
        getListArray();
    }
    
    /**
     * This method is invoked by the JAXB implementation on each instance when unmarshalling completes.
     *
     * @param parent
     *     The parent object in the object tree.
     * @param unmarshaller
     *     The unmarshaller that generated the instance.
     */
    public void afterUnmarshal(Unmarshaller unmarshaller, Object _parent) {
        setParent(_parent);
        if(maxSi!=null&&_parent instanceof SheetData) {
            ((SheetData)_parent).setSi(maxSi);
        }
        if(r==null) {
        	setRow(((SheetData)_parent).getLastRowNumber()+1);
        }
    	org.docx4j.jaxb.Context.checkMemory();
    }
}
