/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.tools.config.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.lang.Validate;

import com.openxchange.office_communication.tools.common.TypeConverter;
import com.openxchange.office_communication.tools.config.IComplexConfiguration;

//=============================================================================
public class ComplexConfiguration implements IComplexConfiguration
{
	//-------------------------------------------------------------------------
	public ComplexConfiguration ()
	    throws Exception
	{}

	//-------------------------------------------------------------------------
	public void bindStore4Reading (final Configuration aStore)
	    throws Exception
	{
		m_aStore4Reading = aStore;
	}
	
	//-------------------------------------------------------------------------
	@Override
	public < T > T get(final String     sKey ,
					   final Class< T > aType)
		throws Exception
	{
		final T aValue = (T) get (sKey, aType, (T)null);
		return  aValue;
	}

	//-------------------------------------------------------------------------
	@Override
	public < T > T get(final String     sKey    ,
			           final Class< T > aType   ,
					   final T          aDefault)
		throws Exception
	{
		Object aValue = m_aStore4Reading.getProperty(sKey);

		if (aValue == null)
			aValue = aDefault;
		
		final T aTypedValue = (T) impl_mapValueToType (aValue, aType);
		return  aTypedValue;
	}

	//-------------------------------------------------------------------------
	@Override
	public Set< Map< String, String > > gets (final String sKey ,
            							      final String sType)
        throws Exception
	{
		Validate.notEmpty(sKey , "Invalid argument 'key'." );
		Validate.notEmpty(sType, "Invalid argument 'type'.");
		
		final Set< Map< String, String > > lValues   = new HashSet< Map< String, String > > ();
		final String                       sSelector = sKey + "." +sType;
		
		final List< HierarchicalConfiguration > aSubSet = ((HierarchicalConfiguration) m_aStore4Reading).configurationsAt(sSelector);
		for (final HierarchicalConfiguration aSub : aSubSet)
		{
			final Map< String, String > lSubData = new HashMap< String, String > ();
			final Iterator< String >    rKeys    = aSub.getKeys();

			while (rKeys.hasNext())
			{
				final String sSubKey   = rKeys.next ();
				final String sSubValue = aSub.getString(sSubKey);
				lSubData.put(sSubKey, sSubValue);
				
				System.err.println ("#### dbg : "+sSubKey+"="+sSubValue);
			}

			lValues.add(lSubData);
		}
		
		return lValues;
	}
	
	//-------------------------------------------------------------------------
	@Override
	public List< String > getAllRecursive (final String sKeyValueSeparator)
			throws Exception
	{
		final List< String > lAll = new Vector< String > ();
		impl_collectAll (((HierarchicalConfiguration) m_aStore4Reading).getRootNode(), "", sKeyValueSeparator, lAll);
		return lAll;
	}

	//-------------------------------------------------------------------------
	private void impl_collectAll (final ConfigurationNode aConfig   ,
							      final String            sPath     ,
							      final String            sSeparator,
							      final List< String >    lData     )
		throws Exception
	{
		if (aConfig == null)
			return;
		
		final List< ConfigurationNode > lChilds = aConfig.getChildren();
		if (lChilds == null)
			return;

		for (final ConfigurationNode aChild : lChilds)
		{
			final String sName         = aChild.getName();
			final Object aValue        = aChild.getValue();
			final String sAbsolutePath = sPath+"."+sName;
			
			lData.add(sAbsolutePath+sSeparator+aValue);
			
			impl_collectAll (aChild, sAbsolutePath, sSeparator, lData);
		}
	}
	
	//-------------------------------------------------------------------------
	public < T > T impl_mapValueToType (final Object     aValue,
										final Class< T > aType )
	    throws Exception
	{
		return (T) TypeConverter.mapValue(aValue, aType);
	}

	//-------------------------------------------------------------------------
	private Configuration m_aStore4Reading = null;
}
