package com.openxchange.office_communication.configuration.configitems.cluster_management;

import org.apache.commons.lang3.StringUtils;

//=============================================================================
public enum EAppType
{
	//-------------------------------------------------------------------------
	E_SHELL,
	E_JAR,
	E_JAVA_MAIN;

	//-------------------------------------------------------------------------
	public static final String STR_SHELL     = "shell";
	public static final String STR_JAR       = "jar";
	public static final String STR_JAVA_MAIN = "java-main";

	//-------------------------------------------------------------------------
	public static String toString (final EAppType eType)
		throws Exception
	{
		if (eType == E_SHELL)
			return STR_SHELL;
		else
		if (eType == E_JAR)
			return STR_JAR;
		else
		if (eType == E_JAVA_MAIN)
			return STR_JAVA_MAIN;
		else
			throw new UnsupportedOperationException ("No support for type '"+eType+"' implemented yet.");
	}

	//-------------------------------------------------------------------------
	public static EAppType fromString (final String sType)
		throws Exception
	{
		if (StringUtils.equalsIgnoreCase(sType, STR_SHELL))
			return E_SHELL;
		else
		if (StringUtils.equalsIgnoreCase(sType, STR_JAR))
			return E_JAR;
		else
		if (StringUtils.equalsIgnoreCase(sType, STR_JAVA_MAIN))
			return E_JAVA_MAIN;
		else
			throw new UnsupportedOperationException ("No support for type '"+sType+"' implemented yet.");
	}
}
