/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.configuration.configitems.cluster_management;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;

import com.openxchange.office_communication.configuration.ConfigAccess;
import com.openxchange.office_communication.tools.config.IComplexConfiguration;

//=============================================================================
public class ClusterNodeConfig
{
	//-------------------------------------------------------------------------
	public static final String CONFIG_PACKAGE  = "/cluster";

	//-------------------------------------------------------------------------
	public static final String CFGKEY_APP         = ".node.apps.app";
	public static final String CFGKEY_APP_ID      = CFGKEY_APP+".id";
	public static final String CFGKEY_APP_MAXINST = CFGKEY_APP+".max-instances";
	public static final String CFGKEY_EXE_ROOT    = CFGKEY_APP+".executable";
	public static final String CFGKEY_EXE_TYPE    = CFGKEY_EXE_ROOT+".type";
	public static final String CFGKEY_EXE_BIN     = CFGKEY_EXE_ROOT+".exe";
	public static final String CFGKEY_ARGS_ROOT   = CFGKEY_EXE_ROOT+".arguments";
	public static final String CFGKEY_ARG         = CFGKEY_ARGS_ROOT+".argument";
	
	//-------------------------------------------------------------------------
	private ClusterNodeConfig ()
		throws Exception
	{}

	//-------------------------------------------------------------------------
	public static ClusterNodeConfig access ()
		throws Exception
	{
		final ClusterNodeConfig aConfig = new ClusterNodeConfig ();
		return aConfig;
	}

	//-------------------------------------------------------------------------
	public Set< AppDescriptor > getApps ()
		throws Exception
	{
		final Set< AppDescriptor >  lApps     = new HashSet< AppDescriptor > ();
		final IComplexConfiguration iConfig   = mem_Config ();
		final String                SEPARATOR = "=";
		final List< String >        lAll      = iConfig.getAllRecursive(SEPARATOR);
			  AppDescriptor         aApp      = null;
		
		for (final String sCfgNode : lAll)
		{
			if ( ! StringUtils.startsWith(sCfgNode, CFGKEY_APP))
				continue;
			
			final String sKey   = StringUtils.substringBefore(sCfgNode, SEPARATOR);
			final String sValue = StringUtils.substringAfter (sCfgNode, SEPARATOR);
		
			/* There is a trick in the following code ...
			 * 
			 * All key-value pairs are given in the right order as the come
			 * from the underlying XML configuration file.
			 * 
			 * So - we can 'start a new application' if we find the app-root key ..
			 * and add all further values afterwards.
			 */
			
			if (StringUtils.equalsIgnoreCase(sKey, CFGKEY_APP))
			{
				aApp = new AppDescriptor ();
				lApps.add(aApp);
			}
			else
			if (StringUtils.equalsIgnoreCase(sKey, CFGKEY_APP_ID))
			{
				aApp.setId (sValue);
			}
			else
			if (StringUtils.equalsIgnoreCase(sKey, CFGKEY_APP_MAXINST))
			{
				aApp.setMaxInstances(Integer.parseInt(sValue));
			}
			else
			if (StringUtils.equalsIgnoreCase(sKey, CFGKEY_EXE_TYPE))
			{
				aApp.setType(sValue);
			}
			else
			if (StringUtils.equalsIgnoreCase(sKey, CFGKEY_EXE_BIN))
			{
				aApp.setExecutable(sValue);
			}
			else
			if (StringUtils.equalsIgnoreCase(sKey, CFGKEY_ARG))
			{
				aApp.addArgument(sValue);
			}
		}
		
		return lApps;
	}

	//-------------------------------------------------------------------------
	private IComplexConfiguration mem_Config ()
		throws Exception
	{
		if (m_iConfig == null)
			m_iConfig = ConfigAccess.accessConfig(CONFIG_PACKAGE);
		return m_iConfig;
	}

	//-------------------------------------------------------------------------
	private IComplexConfiguration m_iConfig = null;
}
