/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.configuration.configitems.cluster_management;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

//=============================================================================
public class AppDescriptor
{
	//-------------------------------------------------------------------------
	public static final String CFGKEY_ID            = "id";
	public static final String CFGKEY_EXE           = "executable.exe";
	public static final String CFGKEY_EXE_TYPE      = "executable.type";
	public static final String CFGKEY_EXE_ARGS      = "executable.arguments";
	public static final String CFGKEY_MAX_INSTANCES = "max-instances";
	
	//-------------------------------------------------------------------------
	public AppDescriptor ()
	    throws Exception
	{}

	//-------------------------------------------------------------------------
	@Override
	public String toString ()
	{
		try
		{
			final StringBuffer sString = new StringBuffer (256);
			
			sString.append (super.toString () );
			sString.append (" {"              );
			sString.append ("id="             );
			sString.append (m_sId             );
			sString.append (", type="         );
			sString.append (m_eType           );
			sString.append (", executable="   );
			sString.append (m_sExecutable     );
			sString.append (", arguments="    );
			sString.append (mem_Arguments()   );
			sString.append (", max-instances=");
			sString.append (m_nMaxInstances   );
			sString.append ("}"               );
			
			return sString.toString ();
		}
		catch (Exception ex)
		{
			return super.toString ();
		}
	}
	
	//-------------------------------------------------------------------------
	public void setId (final String sId)
		throws Exception
	{
		m_sId = sId;
	}
	
	//-------------------------------------------------------------------------
	public void setType (final String sType)
		throws Exception
	{
		m_eType = EAppType.fromString(sType);
	}

	//-------------------------------------------------------------------------
	public void setExecutable (final String sExe)
		throws Exception
	{
		m_sExecutable = sExe;
	}

	//-------------------------------------------------------------------------
	public void addArgument (final String sArg)
		throws Exception
	{
		mem_Arguments ().add(sArg);
	}

	//-------------------------------------------------------------------------
	public void setMaxInstances (final int nInstances)
	    throws Exception
	{
		m_nMaxInstances = nInstances;
	}

	//-------------------------------------------------------------------------
	public String getId ()
	    throws Exception
	{
		return m_sId;
	}
	
	//-------------------------------------------------------------------------
	public EAppType getType ()
	    throws Exception
	{
		return m_eType;
	}

	//-------------------------------------------------------------------------
	public String getExecutable ()
	    throws Exception
	{
		return m_sExecutable;
	}

	//-------------------------------------------------------------------------
	public List< String > getArguments ()
	    throws Exception
	{
		return mem_Arguments ();
	}

	//-------------------------------------------------------------------------
	public int getMaxInstances ()
	    throws Exception
	{
		return m_nMaxInstances;
	}
	
	//-------------------------------------------------------------------------
	private List< String > mem_Arguments ()
	    throws Exception
	{
		if (m_lArguments == null)
			m_lArguments = new ArrayList< String > ();
		return m_lArguments;
	}
	
	//-------------------------------------------------------------------------
	private String m_sId = null;

	//-------------------------------------------------------------------------
	private EAppType m_eType = null;

	//-------------------------------------------------------------------------
	private String m_sExecutable = null;

	//-------------------------------------------------------------------------
	private List< String > m_lArguments = null;

	//-------------------------------------------------------------------------
	private int m_nMaxInstances = 0;
}
