/*
 * Decompiled with CFR 0.152.
 */
package org.json.hash;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.hash.HashKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashKeyEntrySet<V>
implements Set<Map.Entry<String, V>> {
    private final Set<Map.Entry<HashKey, V>> entrySet;
    private final int sz;

    public HashKeyEntrySet(Set<Map.Entry<HashKey, V>> entrySet) {
        this.entrySet = entrySet;
        this.sz = entrySet.size();
    }

    @Override
    public int size() {
        return this.entrySet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.entrySet.contains(o);
    }

    @Override
    public Iterator<Map.Entry<String, V>> iterator() {
        ArrayList<HashKeyEntry<V>> list = new ArrayList<HashKeyEntry<V>>(this.sz);
        for (Map.Entry<HashKey, V> entry : this.entrySet) {
            list.add(new HashKeyEntry<V>(entry));
        }
        return list.iterator();
    }

    @Override
    public Object[] toArray() {
        ArrayList<HashKeyEntry<V>> list = new ArrayList<HashKeyEntry<V>>(this.sz);
        for (Map.Entry<HashKey, V> entry : this.entrySet) {
            list.add(new HashKeyEntry<V>(entry));
        }
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<HashKeyEntry<V>> list = new ArrayList<HashKeyEntry<V>>(this.sz);
        for (Map.Entry<HashKey, V> entry : this.entrySet) {
            list.add(new HashKeyEntry<V>(entry));
        }
        return list.toArray(a);
    }

    @Override
    public boolean add(Map.Entry<String, V> e) {
        return this.entrySet.add(new EntryImplementation<V>(e));
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Map.Entry) {
            return this.entrySet.remove(new EntryImplementation((Map.Entry)o));
        }
        return this.entrySet.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        ArrayList list = new ArrayList(c.size());
        for (Object o : c) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            list.add(new EntryImplementation((Map.Entry)o));
        }
        return this.entrySet.containsAll(list);
    }

    @Override
    public boolean addAll(Collection<? extends Map.Entry<String, V>> c) {
        ArrayList<EntryImplementation<V>> list = new ArrayList<EntryImplementation<V>>(c.size());
        for (Map.Entry<String, V> entry : c) {
            list.add(new EntryImplementation<V>(entry));
        }
        return this.entrySet.addAll(list);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList list = new ArrayList(c.size());
        for (Object o : c) {
            if (!(o instanceof Map.Entry)) continue;
            list.add(new EntryImplementation((Map.Entry)o));
        }
        return this.entrySet.retainAll(list);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        ArrayList list = new ArrayList(c.size());
        for (Object o : c) {
            if (!(o instanceof Map.Entry)) continue;
            list.add(new EntryImplementation((Map.Entry)o));
        }
        return this.entrySet.removeAll(list);
    }

    @Override
    public void clear() {
        this.entrySet.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.entrySet.equals(o);
    }

    @Override
    public int hashCode() {
        return this.entrySet.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntryImplementation<V>
    implements Map.Entry<HashKey, V> {
        private final Map.Entry<String, V> e;

        protected EntryImplementation(Map.Entry<String, V> e) {
            this.e = e;
        }

        @Override
        public HashKey getKey() {
            return HashKey.valueOf(this.e.getKey());
        }

        @Override
        public V getValue() {
            return this.e.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.e.setValue(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HashKeyEntry<V>
    implements Map.Entry<String, V> {
        private final Map.Entry<HashKey, V> entry;

        protected HashKeyEntry(Map.Entry<HashKey, V> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey().toString();
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(value);
        }

        @Override
        public boolean equals(Object o) {
            return this.entry.equals(o);
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }
    }
}

