/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.tools.config;

import java.io.File;
import java.net.URI;
import java.net.URL;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openxchange.office_communication.tools.config.impl.ComplexConfiguration;
import com.openxchange.office_communication.tools.config.impl.SimpleConfiguration;

//=============================================================================
public class ConfigurationFactory
{
	//-------------------------------------------------------------------------
	private static final Logger LOG = LoggerFactory.getLogger(ConfigurationFactory.class);
	
	//-------------------------------------------------------------------------
	/// we provide a static API only ... ctor not needed real .-)
	private ConfigurationFactory ()
	    throws Exception
	{}

	//-------------------------------------------------------------------------
	@Deprecated
	public static synchronized ISimpleConfiguration getSimpleConfigurationOld (final String sConfigPath   ,
																			   final String sConfigPackage)
		throws Exception
	{
		final File aConfigFile = new File (sConfigPath, sConfigPackage+".properties");
		Validate.isTrue(aConfigFile.isFile(), "Miss configuration file '"+aConfigFile.getAbsolutePath()+"'.");

		final PropertiesConfiguration aConfig4Read = new PropertiesConfiguration();
		aConfig4Read.setFile(aConfigFile);
		aConfig4Read.load   ();
		
		final SimpleConfiguration aSimpleConfig = new SimpleConfiguration ();
		aSimpleConfig.bindStore4Reading(aConfig4Read);
		
		return aSimpleConfig;
	}

	//-------------------------------------------------------------------------
	public static synchronized ISimpleConfiguration getSimpleConfiguration (final String sConfigPath   ,
																			final String sConfigPackage)
		throws Exception
	{
		final URL                         aDescriptor = impl_getConfigDescriptor (sConfigPath, sConfigPackage);
   		final DefaultConfigurationBuilder aLoader     = new DefaultConfigurationBuilder ();

		aLoader.setListDelimiter             ((char) 0   );
		aLoader.setDelimiterParsingDisabled  ( true      );
		aLoader.setAttributeSplittingDisabled( true      );
		aLoader.setEncoding                  ("utf-8"    );
		aLoader.setURL                       (aDescriptor);
		aLoader.clearErrorListeners          (           );
		
		LOG.info("load configuration '"+aDescriptor+"' ...");
		
		final Configuration        aConfig4Read = aLoader.getConfiguration ();
		final SimpleConfiguration aSimpleConfig = new SimpleConfiguration ();
		aSimpleConfig.bindStore4Reading(aConfig4Read);
		
		return aSimpleConfig;
	}

	//-------------------------------------------------------------------------
	public static synchronized IComplexConfiguration getComplexConfiguration (final String sConfigPath   ,
																			  final String sConfigPackage)
		throws Exception
	{
		final URL                         aDescriptor = impl_getConfigDescriptor (sConfigPath, sConfigPackage);
   		final DefaultConfigurationBuilder aLoader     = new DefaultConfigurationBuilder ();

		aLoader.setListDelimiter             ((char) 0   );
		aLoader.setDelimiterParsingDisabled  ( true      );
		aLoader.setAttributeSplittingDisabled( true      );
		aLoader.setEncoding                  ("utf-8"    );
		aLoader.setURL                       (aDescriptor);
		aLoader.clearErrorListeners          (           );
	
		LOG.info("load configuration '"+aDescriptor+"' ...");

		final Configuration        aConfig4Read = aLoader.getConfiguration ();
		final ComplexConfiguration aConfig      = new ComplexConfiguration ();

		aConfig.bindStore4Reading(aConfig4Read);
		
		return aConfig;
	}

	//-------------------------------------------------------------------------
	private static URL impl_getConfigDescriptor (final String sConfigPath   ,
			  									 final String sConfigPackage)
	    throws Exception
	{
		String sDescriptor = StringUtils.join(new String[]{sConfigPath, sConfigPackage, "descriptor.xml"}, "/");
		URL    aDescriptor = null;

		sDescriptor = StringUtils.replace(sDescriptor, "//", "/");
		
		if (StringUtils.startsWithIgnoreCase(sDescriptor, "classpath:"))
		{
			aDescriptor = new URL (sDescriptor);
		}
		else
		if (StringUtils.startsWithIgnoreCase(sDescriptor, "file:"))
		{
			final String sRealDescriptor = StringUtils.removeStartIgnoreCase(sDescriptor, "file:");
			final File   aDescriptorFile = new File (sRealDescriptor);
			             aDescriptor     = aDescriptorFile.toURI().toURL();
		}
		else
			throw new UnsupportedOperationException ("No support for config protocol '"+sDescriptor+"' yet.");
		
		return aDescriptor;
	}
}
