/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.jms.core.plain.beans;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;

import com.openxchange.office_communication.jms.core.plain.EErrorCode;

//=============================================================================
public class JMSMessageBean
{
	//-------------------------------------------------------------------------
	public static final String HEADER_NAMESPACE = "ox"+JMSHeader.SEPARATOR+"msg";

	//-------------------------------------------------------------------------
	public static final String HEADER_MSGTYPE   = HEADER_NAMESPACE+JMSHeader.SEPARATOR+"type";
	public static final String HEADER_ERRORCODE = HEADER_NAMESPACE+JMSHeader.SEPARATOR+"error"+JMSHeader.SEPARATOR+"code";

    //-------------------------------------------------------------------------
	public JMSMessageBean ()
		throws Exception
	{
		setType(getClass());
	}

    //-------------------------------------------------------------------------
	public void validate ()
		throws Exception
	{
		// DON'T validate JMSXXX values here ... they are generated/defined within the
		// queue context on demand .. and might not initialized always !!!
		
		if (StringUtils.isEmpty (m_sType))
			throw new IllegalStateException ("No 'type' defined.");
	}
	
	//-------------------------------------------------------------------------
	public String getJMSID ()
		throws Exception
	{
		return m_sJMSID;
	}
	
	//-------------------------------------------------------------------------
	public String getJMSCorrelationID ()
		throws Exception
	{
		return m_sJMSCorrelationID;
	}
	
	//-------------------------------------------------------------------------
	public void setJMSCorrelationID (final String sID)
		throws Exception
	{
		m_sJMSCorrelationID = sID;
	}

	//-------------------------------------------------------------------------
	public void setOK ()
	    throws Exception
	{
		m_eErrorCode = EErrorCode.E_OK;
	}
	
	//-------------------------------------------------------------------------
	public boolean isOK ()
	    throws Exception
	{
		if (m_eErrorCode == null)
			return true;
		if (m_eErrorCode == EErrorCode.E_OK)
			return true;
		return false;
	}

	//-------------------------------------------------------------------------
	public void setError (final EErrorCode eError  ,
						  final String     sMessage)
	    throws Exception
	{
		m_eErrorCode = eError;
		setBody(sMessage);
	}
	
	//-------------------------------------------------------------------------
	public EErrorCode getErrorCode ()
	    throws Exception
	{
		return m_eErrorCode;
	}

	//-------------------------------------------------------------------------
	public String getErrorMessage ()
	    throws Exception
	{
		return getBody ();
	}

	//-------------------------------------------------------------------------
	protected void setType (final Class< ? extends JMSMessageBean > aType)
		throws Exception
	{
		m_sType = aType.getName();
	}

	//-------------------------------------------------------------------------
	public String getType ()
		throws Exception
	{
		return m_sType;
	}

	//-------------------------------------------------------------------------
	public <T extends Serializable> void setBody (final T aBody)
		throws Exception
	{
		m_aBody = aBody;
	}

	//-------------------------------------------------------------------------
	@SuppressWarnings("unchecked")
	public <T extends Serializable> T getBody ()
		throws Exception
	{
		return (T) m_aBody;
	}

	//-------------------------------------------------------------------------
	@Override
	public String toString ()
	{
		final StringBuffer sStr = new StringBuffer (256);
		sStr.append (super.toString ()    );
		sStr.append ("[type="             );
		sStr.append (m_sType              );
		sStr.append (" ,error-code="      );
		sStr.append (m_eErrorCode         );
		sStr.append (" ,body="            );
		sStr.append (m_aBody              );
		sStr.append ("]"                  );
		return sStr.toString ();
	}
	
	//-------------------------------------------------------------------------
	@JMSHeader(name=JMSHeader.JMSHEADER_MESSAGEID)
	private String m_sJMSID = null;

	//-------------------------------------------------------------------------
	@JMSHeader(name=JMSHeader.JMSHEADER_CORRELATIONID)
	private String m_sJMSCorrelationID = null;
	
	//-------------------------------------------------------------------------
	@JMSProperty(name=HEADER_MSGTYPE)
	private String m_sType = null;

	//-------------------------------------------------------------------------
	@JMSProperty(name=HEADER_ERRORCODE)
	private EErrorCode m_eErrorCode = EErrorCode.E_OK;

	//-------------------------------------------------------------------------
	@JMSBody
	private Object m_aBody = null;
}
