/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.jms.core.plain;

import org.apache.commons.lang3.StringUtils;

//=============================================================================
public enum EErrorCode
{
    //-------------------------------------------------------------------------
	E_OK,
	E_GENERAL,
	E_TIMEOUT;
	
    //-------------------------------------------------------------------------
	public static final String STR_OK      = E_OK     .name();
	public static final String STR_GENERAL = E_GENERAL.name();
	public static final String STR_TIMEOUT = E_TIMEOUT.name();

    //-------------------------------------------------------------------------
	public static EErrorCode fromString (final String sResult)
	    throws Exception
	{
		EErrorCode eResult = null;

		if (StringUtils.equalsIgnoreCase(sResult, STR_OK))
			eResult = E_OK;
		else
		if (StringUtils.equalsIgnoreCase(sResult, STR_GENERAL))
			eResult = E_GENERAL;
		else
		if (StringUtils.equalsIgnoreCase(sResult, STR_TIMEOUT))
			eResult = E_TIMEOUT;
		else
			throw new UnsupportedOperationException ("no support for '"+sResult+"' implemented yet");

		return eResult;
	}

    //-------------------------------------------------------------------------
	public static String toString (final EErrorCode eResult)
	    throws Exception
	{
		String sResult = null;
		
		if (eResult == E_OK)
			sResult = STR_OK;
		else
		if (eResult == E_GENERAL)
			sResult = STR_GENERAL;
		else
		if (eResult == E_TIMEOUT)
			sResult = STR_TIMEOUT;
		else
			throw new UnsupportedOperationException ("no support for '"+eResult+"' implemented yet");
		
		return sResult;
	}
}
