/**
 * OPEN-XCHANGE legal information
 *
 * All intellectual property rights in the Software are protected by
 * international copyright laws.
 *
 *
 * In some countries OX, OX Open-Xchange, open xchange and OXtender
 * as well as the corresponding Logos OX Open-Xchange and OX are registered
 * trademarks of the Open-Xchange, Inc. group of companies.
 * The use of the Logos is not covered by the GNU General Public License.
 * Instead, you are allowed to use these Logos according to the terms and
 * conditions of the Creative Commons License, Version 2.5, Attribution,
 * Non-commercial, ShareAlike, and the interpretation of the term
 * Non-commercial applicable to the aforementioned license is published
 * on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 * Please make sure that third-party modules and libraries are used
 * according to their respective licenses.
 *
 * Any modifications to this package must retain all copyright notices
 * of the original copyright holder(s) for the original code used.
 *
 * After any such modifications, the original and derivative code shall remain
 * under the copyright of the copyright holder(s) and/or original author(s)per
 * the Attribution and Assignment Agreement that can be located at
 * http://www.open-xchange.com/EN/developer/. The contributing author shall be
 * given Attribution for the derivative code and a license granting use.
 *
 *  Copyright (C) 2004-2014 Open-Xchange, Inc.
 *  Mail: info@open-xchange.com
 *
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, Version 2 as published
 *  by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc., 59
 *  Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package com.openxchange.office_communication.cluster_management;

import com.openxchange.office_communication.configuration.configitems.cluster_management.AppDescriptor;
import com.openxchange.office_communication.configuration.configitems.cluster_management.EAppType;
import com.openxchange.office_communication.tools.exec.Executable;

//=============================================================================
public class App
{
	//-------------------------------------------------------------------------
	public App ()
		throws Exception
	{}

	//-------------------------------------------------------------------------
	public void setDescriptor (final AppDescriptor aDescriptor)
	    throws Exception
	{
		m_aDescriptor = aDescriptor;
	}
	
	//-------------------------------------------------------------------------
	public boolean isRunning ()
		throws Exception
	{
		if (m_aProzess != null)
			return true;
		
		return false;
	}
	
	//-------------------------------------------------------------------------
	public void start ()
		throws Exception
	{
		if (m_aProzess != null)
			return;
		
		Executable aExe = impl_defineExe ();
		aExe.runAsync (null);
		
		m_aProzess = aExe;
	}
	
	//-------------------------------------------------------------------------
	public void stop ()
		throws Exception
	{
		if (m_aProzess == null)
			return;
		
		m_aProzess.kill();
		m_aProzess = null;
	}

	//-------------------------------------------------------------------------
	private Executable impl_defineExe ()
		throws Exception
	{
		      Executable aExe  = null;
		final EAppType   eType = m_aDescriptor.getType();

		if (eType.equals(EAppType.E_SHELL))
			aExe = impl_defineExe4Shell ();
		else
		if (eType.equals(EAppType.E_JAR))
			aExe = impl_defineExe4Jar ();
		else
		if (eType.equals(EAppType.E_JAVA_MAIN))
			aExe = impl_defineExe4JavaMain ();
		else
			throw new UnsupportedOperationException ("No support for app type '"+eType+"' implemented yet.");
		
		return aExe;
	}

	//-------------------------------------------------------------------------
	private Executable impl_defineExe4Shell ()
		throws Exception
	{
		final Executable aExe = new Executable ();
		aExe.setExecutable (m_aDescriptor.getExecutable());
		return aExe;
	}

	//-------------------------------------------------------------------------
	private Executable impl_defineExe4Jar ()
		throws Exception
	{
		final Executable aExe = new Executable ();
		
		aExe.setExecutable("java"                       );
		aExe.addArgument  ("-jar"                       );
		aExe.addArgument  (m_aDescriptor.getExecutable());
		
		return aExe;
	}

	//-------------------------------------------------------------------------
	private Executable impl_defineExe4JavaMain ()
		throws Exception
	{
		final Executable aExe       = new Executable ();
		final String     sClasspath = System.getProperty("java.class.path");
		
//		System.err.println
//		(
//				CollectionUtils.toString(
//						StringUtils.splitByWholeSeparatorPreserveAllTokens(sClasspath, ":"),
//						'\n')
//		);

		aExe.setExecutable("java"                       );
		aExe.addArgument  ("-classpath"                 );
		aExe.addArgument  (sClasspath                   );
		aExe.addArgument  (m_aDescriptor.getExecutable());
		
		return aExe;
	}

	//-------------------------------------------------------------------------
	public AppDescriptor m_aDescriptor = null;

	//-------------------------------------------------------------------------
	private Executable m_aProzess = null;
}
