package com.openexchange.office.tools.htmldoc;

import org.apache.commons.lang.StringEscapeUtils;

public class Text
		extends SubNode
{
	private static final String	SPANBEFORE	= "<span ";
	private static final String	SPANMIDDLE	= "style=\"font-family: Arial, Helvetica, sans-serif; font-weight: normal; font-style: normal; text-decoration: none; color: rgb(0, 0, 0); font-size: 11pt; vertical-align: baseline; line-height: 20px; background-color: transparent;\">";
	private static final String	SPANEND		= "</span>";

	// ////////////////////////////////////////////////////

	private final String		text;

	public Text(
			String text, int position)
	{
		super(position, text.length());
		this.text = text;
	}

	public String getText()
	{
		return text;
	}

	@Override
	public boolean appendContent(
		StringBuilder document)
		throws Exception
	{
		document.append(SPANBEFORE);
		GenDocHelper.appendAttributes(getAttribute(), document);
		document.append(SPANMIDDLE);
		document.append(StringEscapeUtils.escapeHtml(text));
		document.append(SPANEND);
        return true;
	}

	@Override
	public String toString()
	{
		return super.toString() + " text: " + getText();
	}

	@Override
	public boolean needsEmptySpan()
	{
		return false;
	}
}
