package com.openexchange.office.tools.htmldoc;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GenDocHelper
{
	private final static String	EMPTYSPAN	= "<span nonjquerydata=\"{&quot;isempty&quot;:true}\" \"style=\"font-family: Arial, Helvetica, sans-serif; font-weight: normal; font-style: normal; text-decoration: none; color: rgb(0, 0, 0); font-size: 11pt; vertical-align: baseline; line-height: 20px; background-color: transparent;\"></span>";

	static JSONArray shiftedCopy(
		JSONArray input)
	{
		final List<Object> list = input.asList();
		list.remove(0);
		return new JSONArray(list);
	}

	public static void appendAttributes(
		JSONObject attrs,
		StringBuilder document)
		throws JSONException
	{

		appendAttributes(attrs, document, false);

	}

	public static void appendAttributes(
		JSONObject attrs,
		StringBuilder document,
		boolean implicit)
		throws JSONException
	{
		if (attrs != null)
		{
			final JSONObject adapter = new JSONObject();
			if (implicit)
			{
				adapter.put("implicit", "true");
			}
			adapter.put("attributes", attrs);
			document.append(" jquerydata='");
			document.append(adapter.toString());
			document.append("' ");
		}
		else
		{
			document.append(" ");
		}
	}

	public static boolean addEmptySpanForNecessaryNode(
		StringBuilder doc,
		SubNode node,
		boolean emptySpanNeeded)
	{
		boolean nodeTypeNeedsEmptySpan = node.needsEmptySpan();

		if (nodeTypeNeedsEmptySpan && emptySpanNeeded)
		{
			doc.append(EMPTYSPAN);
		}

		return nodeTypeNeedsEmptySpan;
	}

	public static void addEmptySpan(
		StringBuilder doc)
	{
		doc.append(EMPTYSPAN);
	}

}
