package com.openexchange.office.tools.htmldoc;

public class Field extends SubNode {
	private static final String	BEFOREATTRS	= "<div contenteditable=\"false\" class=\"inline field\"><span ";
	private static final String	AFTERATTRS	= " >";
	private static final String CLOSEFIELD  = "</span></div>";
	
	private final String fieldText;

	// ///////////////////////////////////////////////////////////

	public Field(
			int position, String representation)
	{
		super(position, 1);
		
		this.fieldText = representation;
	}

	@Override
	public boolean appendContent(
		StringBuilder document)
		throws Exception
	{
		document.append(BEFOREATTRS);
		
		GenDocHelper.appendAttributes(getAttribute(), document);
		
		document.append(AFTERATTRS);
		
		document.append(fieldText);
		
		document.append(CLOSEFIELD);
		return true;
	}

	@Override
	public boolean needsEmptySpan()
	{
		return true;
	}
}
