/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.realtime.tools;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

/**
 * Helper class to access system specific information of the JVM.
 *
 * @author Carsten Driesner
 */
public class SystemInfoHelper {

    public final static long KBYTES = 1024;
    public final static long MBYTES = 1024 * 1024;
    public final static long TYPICAL_BACKEND_HEAPSPACE = 250 * MBYTES;
    public final static long MINIMAL_FREE_BACKEND_HEAPSPACE = 100 * MBYTES;

    public static class MemoryInfo {
        public long usedHeapSize = 0;
        public long maxHeapSize = 0;
        public long committedHeapSize = 0;
    }

    /**
     * Provides information about the current free heap size, the total memory
     * used by the JVM and the maximal heap size.
     *
     * @return
     *  A MemoryInfo object which contains the heap memory details or all
     *  values are zero in case the information could not be retrieved.
     */
    static public MemoryInfo getMemoryInfo() {
        MemoryInfo memInfo = new MemoryInfo();

        final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        final MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();

        if (null != heapMemoryUsage) {
            memInfo.maxHeapSize = heapMemoryUsage.getMax();
            memInfo.usedHeapSize = heapMemoryUsage.getUsed();
            memInfo.committedHeapSize = heapMemoryUsage.getCommitted();
        }
        return memInfo;
    }

    /**
     * Calculates the minimal JVM heap size we need to load a specific
     * document.
     *
     * @param filterHeapSpaceNeeded
     *  The memory needed by the filter to process the document.
     *
     * @return
     *  The minimal setting of the JVM heap size to load the document.
     */
    static public long calculateNeededHeapSize(long filterHeapSpaceNeeded) {
        return (filterHeapSpaceNeeded * 2) + TYPICAL_BACKEND_HEAPSPACE;
    }
}
