/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.realtime.impl.calc;

import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONObject;
import com.openexchange.realtime.packet.ID;

public class Request {
	private Type type = Type.REQUEST_LOAD;
	private ID fromId = null;
	private IRequestProcessor processor = null;
	private JSONObject requestOps = null;
	private int documentOSN = 0;
	private String folderId = null;
	private String fileId = null;
	private final AtomicBoolean finished = new AtomicBoolean(false);

	public enum Type {
		REQUEST_LOAD,
		REQUEST_LOAD_SYNC
	}

	public Request(String folderId, String fileId, ID fromId, IRequestProcessor processor, int documentOSN) {
		this.type = Type.REQUEST_LOAD_SYNC;
		this.folderId = folderId;
		this.fileId = fileId;
		this.fromId = fromId;
		this.processor = processor;
		this.documentOSN = documentOSN;
	}

	public Request(String folderId, String fileId, ID fromId, final JSONArray operations, IRequestProcessor processor, int documentOSN) throws Exception {
		this.type = Type.REQUEST_LOAD;
		this.folderId = folderId;
		this.fileId = fileId;
		this.fromId = fromId;
		this.processor = processor;
		this.documentOSN = documentOSN;
	    requestOps = new JSONObject();
	    requestOps.put("operations", operations);
	}

	public Type getType() {
		return type;
	}

	public JSONObject getOperations() {
		return requestOps;
	}

	public ID getId() {
		return fromId;
	}

	public IRequestProcessor getProcessor() {
		return processor;
	}

	public int getDocumentOSN() {
		return documentOSN;
	}

	public String getDocumentId() {
		return new StringBuilder(folderId).append(".").append(fileId).toString();
	}

	public boolean isFinished() {
		return finished.get();
	}

	public void finished() {
		finished.set(true);
	}

	static public String buildDocumentId(final String folderId, final String fileId) {
        return new StringBuilder(folderId).append(".").append(fileId).toString();
	}
}
