package com.openexchange.office.realtime.impl.calc;

import com.openexchange.office.calcengine.client.ECalcEngineError;

public class CalcEngineException extends Exception {
    /**
    *
    */
   private static final long serialVersionUID = 1L;

   final private ECalcEngineError errorCode;

   public CalcEngineException(String message, ECalcEngineError eCode) {
       super(message);
       errorCode = eCode;
   }

   public CalcEngineException(String message, Throwable e, ECalcEngineError eCode) {
       super(message, e);
       setStackTrace(e.getStackTrace());
       errorCode = eCode;
   }

   public CalcEngineException(Throwable e, ECalcEngineError eCode) {
       super(e);
       setStackTrace(e.getStackTrace());
       errorCode = eCode;
   }

   public ECalcEngineError getErrorcode() {
       return errorCode;
   }

}
