/*
 * Copyright 2012 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.odftoolkit.odfdom.component;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import static org.odftoolkit.odfdom.component.RoundtripTestTemplate.OUTPUT_DIRECTORY;
import org.odftoolkit.odfdom.utils.ResourceUtilities;

/**
 * Loads a document with tables and gathers its operations. Gathered operations
 * will be applied to an empty text document. The changed text document will be
 * saved and reloaded. New gathered operations will be compared with the
 * original ones, expected to be identical!
 *
 * @author svanteschubert
 */
public class LatestOngoingTest extends RoundtripTestTemplate {

    private static final Logger LOG = Logger.getLogger(LatestOngoingTest.class.getName());

    public LatestOngoingTest() {
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        // Creating the output directory for the tests
        File outputDir = ResourceUtilities.newTestOutputFile(OUTPUT_DIRECTORY);
        outputDir.mkdir();
    }



    @Test
    @Ignore
    /**
     * Insert row column within colored spreadsheet in the beginning and within.
     */
    public void insertRowColumn2Test() {
        final String SOURCE_FILE_NAME_TRUNC = "coloredRowColumn";
        String firstEditOperations = "["
            + "{\"start\":0,\"name\":\"insertColumns\",\"sheet\":0},"
            + "{\"start\":0,\"name\":\"insertRows\",\"sheet\":0},"
            + "]";
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);

//        List<String> editOperations = new ArrayList();
//        editOperations.add(firstEditOperations);
//        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);    
    }

    @Test
    @Ignore
    /**
     * Add a background to the complete sheet. We should NOT repeat the color in
     * rows endlessly, but use only default cell color within columns.
     */
    public void setSheetBackgroundTest() {
        final String SOURCE_FILE_NAME_TRUNC = "formulaSheetReferenz";
        String firstEditOperations = "["
            + "{\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"C00000\"}}},\"end\":1023,\"name\":\"setColumnAttributes\",\"opl\":1,\"osn\":20,\"parse\":\"en_US\",\"rangeBorders\":null,\"sheet\":0,\"start\":0,\"visibleBorders\":null},"
            + "{\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"C00000\"}}},\"end\":[2,0],\"name\":\"fillCellRange\",\"sheet\":0,\"start\":[2,0]},"
            + "{\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"C00000\"}}},\"end\":[0,0],\"name\":\"fillCellRange\",\"sheet\":0,\"start\":[0,0]},"
            + "{\"attrs\":{\"sheet\":{\"activeCell\":[0,0],\"selectedRanges\":[{\"end\":[1023,1048575],\"start\":[0,0]}]}},\"name\":\"setSheetAttributes\",\"opl\":1,\"osn\":21,\"parse\":\"en_US\",\"sheet\":0}"
            + "]";
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);

//        List<String> editOperations = new ArrayList();
//        editOperations.add(firstEditOperations);
//        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);    
    }

    @Test
    @Ignore
    /**
     * Add a background to the complete sheet. We should NOT repeat the color in
     * rows endlessly, but use only default cell color within columns.
     */
    public void setAndUnsetSheetBackgroundTest() {
        final String SOURCE_FILE_NAME_TRUNC = "formulaSheetReferenz";
        String firstEditOperations = "["
            + "{\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"FFC000\"}}},\"end\":[3,9],\"name\":\"fillCellRange\",\"parse\":\"en_US\",\"sheet\":0,\"start\":[3,9]},"
            + "{\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"FFC000\"}}},\"end\":[3,9],\"name\":\"fillCellRange\",\"parse\":\"en_US\",\"sheet\":0,\"start\":[3,9]},"
            + "{\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"FF0000\"}}},\"end\":1023,\"name\":\"setColumnAttributes\",\"opl\":1,\"osn\":18,\"parse\":\"en_US\",\"rangeBorders\":null,\"sheet\":0,\"start\":0,\"visibleBorders\":null},"
            + "{\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"FF0000\"}}},\"end\":[3,9],\"name\":\"fillCellRange\",\"sheet\":0,\"start\":[3,9]},"
            + "{\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"FF0000\"}}},\"end\":[0,0],\"name\":\"fillCellRange\",\"sheet\":0,\"start\":[0,0]},"
            + "{\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"FF0000\"}}},\"end\":[1,0],\"name\":\"fillCellRange\",\"sheet\":0,\"start\":[1,0]},"
            + "{\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"FF0000\"}}},\"end\":1023,\"name\":\"setColumnAttributes\",\"opl\":1,\"osn\":19,\"parse\":\"en_US\",\"rangeBorders\":null,\"sheet\":0,\"start\":0,\"visibleBorders\":null},"
            + "{\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"FF0000\"}}},\"end\":[0,0],\"name\":\"fillCellRange\",\"sheet\":0,\"start\":[0,0]},"
            + "{\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"FF0000\"}}},\"end\":[1,0],\"name\":\"fillCellRange\",\"sheet\":0,\"start\":[1,0]},"
            + "{\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"FF0000\"}}},\"end\":[3,9],\"name\":\"fillCellRange\",\"sheet\":0,\"start\":[3,9]},"
            + "{\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"92D050\"}}},\"end\":[1,1],\"name\":\"fillCellRange\",\"parse\":\"en_US\",\"sheet\":0,\"start\":[1,1]},"
            + "{\"attrs\":{},\"name\":\"insertStyleSheet\",\"opl\":1,\"osn\":21,\"parse\":\"en_US\",\"styleId\":\"Standard\",\"styleName\":\"Standard\",\"type\":\"cell\",\"uiPriority\":1},"
            + "{\"attrs\":{\"cell\":{\"alignHor\":null,\"alignVert\":null,\"borderBottom\":null,\"borderInsideHor\":null,\"borderInsideVert\":null,\"borderLeft\":null,\"borderRight\":null,\"borderTop\":null,\"fillColor\":null,\"hidden\":null,\"numberFormat\":null,\"unlocked\":null,\"wrapText\":null},\"character\":{\"bold\":null,\"color\":null,\"fontName\":null,\"fontSize\":null,\"italic\":null,\"strike\":null,\"underline\":null},\"styleId\":\"Standard\"},\"end\":1023,\"name\":\"setColumnAttributes\",\"opl\":1,\"osn\":22,\"rangeBorders\":null,\"sheet\":0,\"start\":0,\"visibleBorders\":null},"
            + "{\"attrs\":{\"sheet\":{\"selectedRanges\":[{\"end\":[1023,1048575],\"start\":[0,0]}]}},\"name\":\"setSheetAttributes\",\"opl\":1,\"osn\":23,\"parse\":\"en_US\",\"sheet\":0}"
            + "]";
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);

//        List<String> editOperations = new ArrayList();
//        editOperations.add(firstEditOperations);
//        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);    
    }

    @Test
    @Ignore
    /**
     * Add a repeated "*" formula
     *
     * "value":"=REPT(\"*\";32767)"
     *
     * table:formula="of:=REPT(&quot;*&quot;; 1234)"
     */
    public void formulaRepeatedTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";
        String firstEditOperations = "["
            + "{\"contents\":[[{\"result\":\"*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************\",\"value\":\"=REPT(\\\"*\\\";32767)\"}]],\"name\":\"setCellContents\",\"opl\":1,\"osn\":12,\"parse\":\"en_US\",\"sheet\":0,\"start\":[0,0]}"
            + "]";
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);

//        List<String> editOperations = new ArrayList();
//        editOperations.add(firstEditOperations);
//        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);    
    }

    @Test
    @Ignore
    /**
     * Inserting columns
     */
    public void importOnly() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";
        String firstEditOperations = "["
            + "{\"name\":\"setDocumentAttributes\",\"attrs\":{\"document\":{\"defaultTabStop\":1250}}},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"default_cell_style\",\"attrs\":{\"character\":{\"fontName\":\"Liberation Sans\",\"fontNameAsian\":\"Segoe UI\",\"fontNameComplex\":\"Tahoma\",\"language\":\"de-DE\"}},\"default\":true,\"hidden\":true,\"styleName\":\"Default Cell Style\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Default\",\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11}},\"parent\":\"default_cell_style\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Ok\",\"attrs\":{\"cell\":{\"borderBottom\":{\"style\":\"none\"},\"borderLeft\":{\"style\":\"none\"},\"borderRight\":{\"style\":\"none\"},\"borderTop\":{\"style\":\"none\"},\"fillColor\":{\"type\":\"auto\"}},\"character\":{\"bold\":false,\"boldAsian\":false,\"boldComplex\":false,\"color\":{\"type\":\"rgb\",\"value\":\"008000\"},\"fontName\":\"Calibri\",\"fontSize\":11,\"fontSizeAsian\":11,\"italic\":false,\"italicAsian\":false,\"italicComplex\":false,\"strike\":\"none\",\"underline\":false},\"paragraph\":{\"alignment\":\"center\",\"indentLeft\":0,\"marginLeft\":0}},\"parent\":\"Default\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Heading_5f_3\",\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"d9d9d9\"}},\"character\":{\"bold\":false,\"boldAsian\":false,\"boldComplex\":false,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontSize\":11,\"fontSizeAsian\":11,\"italic\":false,\"italicAsian\":false,\"italicComplex\":false,\"strike\":\"none\",\"underline\":false}},\"parent\":\"Default\",\"styleName\":\"Heading_3\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Excel_20_Built-in_20_Followed_20_Hyperlink\",\"attrs\":{\"character\":{\"bold\":false,\"boldAsian\":false,\"boldComplex\":false,\"color\":{\"type\":\"rgb\",\"value\":\"800080\"},\"fontName\":\"Calibri\",\"fontSize\":11,\"fontSizeAsian\":11,\"italic\":false,\"italicAsian\":false,\"italicComplex\":false,\"strike\":\"none\",\"underline\":true}},\"parent\":\"Default\",\"styleName\":\"Excel Built-in Followed Hyperlink\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Heading\",\"attrs\":{\"character\":{\"bold\":true,\"fontSize\":16,\"italic\":true},\"paragraph\":{\"alignment\":\"center\"}},\"parent\":\"Default\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Heading1\",\"attrs\":{},\"parent\":\"Heading\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Result\",\"attrs\":{\"character\":{\"bold\":true,\"italic\":true,\"underline\":true}},\"parent\":\"Default\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Heading_5f_1\",\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"ffc080\"}},\"character\":{\"bold\":true,\"boldAsian\":true,\"boldComplex\":true,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Cambria\",\"fontSize\":14,\"fontSizeAsian\":14,\"italic\":true,\"italicAsian\":true,\"italicComplex\":true,\"strike\":\"none\",\"underline\":false}},\"parent\":\"Default\",\"styleName\":\"Heading_1\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Heading_5f_2\",\"attrs\":{\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"ffffc0\"}},\"character\":{\"bold\":false,\"boldAsian\":false,\"boldComplex\":false,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Cambria\",\"fontSize\":12,\"fontSizeAsian\":12,\"italic\":true,\"italicAsian\":true,\"italicComplex\":true,\"strike\":\"none\",\"underline\":false}},\"parent\":\"Default\",\"styleName\":\"Heading_2\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Result2\",\"attrs\":{},\"parent\":\"Result\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Excel_20_Built-in_20_Hyperlink\",\"attrs\":{\"character\":{\"bold\":false,\"boldAsian\":false,\"boldComplex\":false,\"color\":{\"type\":\"rgb\",\"value\":\"0000ff\"},\"fontName\":\"Calibri\",\"fontSize\":11,\"fontSizeAsian\":11,\"italic\":false,\"italicAsian\":false,\"italicComplex\":false,\"strike\":\"none\",\"underline\":true}},\"parent\":\"Default\",\"styleName\":\"Excel Built-in Hyperlink\"},\n"
            + "{\"name\":\"setDocumentAttributes\",\"attrs\":{\"document\":{\"fileFormat\":\"odf\"}}},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"Cambria\",\"familyGeneric\":\"roman\"},\"fontName\":\"Cambria\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"Calibri\",\"familyGeneric\":\"swiss\"},\"fontName\":\"Calibri\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"'Liberation Sans'\",\"familyGeneric\":\"swiss\",\"pitch\":\"variable\"},\"fontName\":\"Liberation Sans\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"Mangal\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"fontName\":\"Mangal\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"'Microsoft YaHei'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"fontName\":\"Microsoft YaHei\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"'Segoe UI'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"fontName\":\"Segoe UI\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"Tahoma\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"fontName\":\"Tahoma\"},\n"
            + "{\"name\":\"setDocumentAttributes\",\"attrs\":{\"document\":{\"fileFormat\":\"odf\"},\"page\":{\"height\":29700,\"indentLeft\":1778,\"indentRight\":1778,\"marginBottom\":1905,\"marginLeft\":1778,\"marginRight\":1778,\"marginTop\":1905,\"numberFormat\":\"1\",\"printOrientation\":\"portrait\",\"width\":21001}}},\n"
            + "{\"name\":\"insertSheet\",\"attrs\":{\"sheet\":{\"visible\":true}},\"sheet\":0,\"sheetName\":\"Cell\"},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":0,\"end\":1,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":2099}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":2,\"end\":3,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":1707}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":4,\"end\":5,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":1118}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":6,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":3080}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":7,\"end\":8,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":2099}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":9,\"end\":10,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":1118}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":11,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":2099}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":12,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":6018}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":13,\"end\":17,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":1118}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":18,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":4059}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":19,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":6018}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":20,\"end\":21,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":1707}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":22,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":1118}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":23,\"end\":1023,\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\",\"fontSize\":11,\"fontSizeAsian\":11},\"column\":{\"width\":1700}},\"sheet\":0},\n"
            + "{\"name\":\"setRowAttributes\",\"start\":0,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":778}},\"sheet\":0},\n"
            + "{\"name\":\"setCellContents\",\"start\":[0,0],\"contents\":[[{\"attrs\":{\"styleId\":\"Default\",\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"8eb4e3\"}},\"character\":{\"bold\":true,\"boldAsian\":true,\"boldComplex\":true,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Cambria\",\"fontSize\":18,\"fontSizeAsian\":18,\"italic\":true,\"italicAsian\":true,\"italicComplex\":true,\"strike\":\"none\",\"underline\":false}},\"value\":\"FORMULA TEST DOCUMENT\"}]],\"sheet\":0},\n"
            + "{\"name\":\"fillCellRange\",\"start\":[1,0],\"end\":[22,0],\"attrs\":{\"styleId\":\"Default\",\"cell\":{\"fillColor\":{\"type\":\"rgb\",\"value\":\"8eb4e3\"}},\"character\":{\"bold\":true,\"boldAsian\":true,\"boldComplex\":true,\"color\":{\"type\":\"rgb\",\"value\":\"000000\"},\"fontName\":\"Cambria\",\"fontSize\":18,\"fontSizeAsian\":18,\"italic\":true,\"italicAsian\":true,\"italicComplex\":true,\"strike\":\"none\",\"underline\":false}},\"sheet\":0}"
            + "]";
        List<String> editOperations = new ArrayList();
        editOperations.add(firstEditOperations);
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Deleting, editing & format a spreadsheet with existing hyperlinks
     */
    public void styleSheetFormatTest() {
        final String SOURCE_FILE_NAME_TRUNC = "Calc_Excel_Funktionen_Pootle";
        String firstEditOperations = "["
            + "{\"start\":[1,3],\"opl\":1,\"name\":\"fillCellRange\",\"value\":null,\"sheet\":0,\"osn\":477},"
            + "{\"start\":[1,2],\"attrs\":{\"character\":{\"underline\":true}},\"opl\":1,\"name\":\"fillCellRange\",\"sheet\":0,\"osn\":478},"
            + "{\"start\":[1,2],\"attrs\":{\"character\":{\"italic\":true}},\"opl\":1,\"name\":\"fillCellRange\",\"sheet\":0,\"osn\":479},"
            + "{\"start\":[1,1],\"contents\":[[{\"value\":\"A0BC\"}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":480},"
            + "{\"start\":[1,4],\"attrs\":{\"character\":{\"fontSize\":24}},\"opl\":1,\"name\":\"fillCellRange\",\"sheet\":0,\"osn\":481},"
            + "{\"start\":[1,4],\"attrs\":{\"character\":{\"fontName\":\"Andale Mono\"}},\"opl\":1,\"name\":\"fillCellRange\",\"sheet\":0,\"osn\":482},"
            + "{\"start\":[1,5],\"opl\":1,\"name\":\"fillCellRange\",\"value\":null,\"attrs\":{\"character\":{\"url\":\"http://www.heise.de\"}},\"sheet\":0,\"osn\":37},"
            + "{\"start\":[1,5],\"contents\":[[{\"value\":\"HEISE\"}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":36}"
            + "]";
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    /**
     * Format column/row width & color on a complex spreadsheet.
     */
    public void complexFormatTest() {
        final String SOURCE_FILE_NAME_TRUNC = "formula_import_xml_12_LO42";
        String firstEditOperations = "["
            //                + "{\"visibleBorders\":null,\"start\":22,\"attrs\":{\"cell\":{\"fillColor\":{\"value\":\"CCCCCC\",\"type\":\"rgb\"}},\"column\":null,\"character\":null},\"opl\":1,\"name\":\"setColumnAttributes\",\"rangeBorders\":null,\"sheet\":0,\"end\":null,\"osn\":467},"
            + "{\"start\":0,\"attrs\":{\"cell\":{\"fillColor\":{\"value\":\"FFEE00\",\"type\":\"rgb\"}},\"row\":{\"customFormat\":true},\"character\":null},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":466},"
            //				+ "{\"visibleBorders\":null,\"start\":2,\"attrs\":{\"cell\":{\"fillColor\":{\"value\":\"FF0000\",\"type\":\"rgb\"}},\"column\":null,\"character\":null},\"opl\":1,\"name\":\"setColumnAttributes\",\"rangeBorders\":null,\"sheet\":0,\"end\":null,\"osn\":467},"
            //				+ "{\"visibleBorders\":null,\"start\":4,\"attrs\":{\"cell\":{\"fillColor\":{\"value\":\"FFFF00\",\"type\":\"rgb\"}},\"column\":null,\"character\":null},\"opl\":1,\"name\":\"setColumnAttributes\",\"rangeBorders\":null,\"sheet\":0,\"end\":null,\"osn\":468},"
            //				+ "{\"visibleBorders\":null,\"start\":4,\"attrs\":{\"cell\":null,\"column\":{\"customWidth\":true,\"visible\":true,\"width\":2117},\"character\":null},\"opl\":1,\"name\":\"setColumnAttributes\",\"rangeBorders\":null,\"sheet\":0,\"end\":null,\"osn\":469},"
            //				+ "{\"start\":0,\"attrs\":{\"cell\":null,\"row\":{\"customHeight\":true,\"height\":1460,\"visible\":true},\"character\":null},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":470},"
            //				+ "{\"start\":5,\"attrs\":{\"row\":{\"visible\":false}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":470},"
            //				+ "{\"start\":5,\"attrs\":{\"column\":{\"visible\":false}},\"opl\":1,\"name\":\"setColumnAttributes\",\"sheet\":0,\"osn\":470},"
            + "]";
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore

    /**
     * Inserting and Deleting rows and columns
     */
    public void rowInsertionATest() {
        final String SOURCE_FILE_NAME_TRUNC = "Insert and Delete Rows2";
        String firstEditOperations = "["
            + "{\"start\":12,\"name\":\"insertRows\",\"opl\":1,\"end\":14,\"sheet\":0,\"osn\":135},"
            + "]";
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }
//
//    @Test
//	/**
//	 * Inserting and Deleting rows and columns
//	 */
//	public void rowInsertionATest2() {
//		final String SOURCE_FILE_NAME_TRUNC = "empty"; //"Insert and Delete Rows2";
//		String firstEditOperations = "["
//                + "{\"name\":\"setCellContents\",\"start\":[31,9],\"contents\":[[{\"value\":\"Merged ranges\"},null,null,null,null,{\"value\":\"Drawing objects\"}]],\"sheet\":0}"
////				+ "{\"start\":12,\"name\":\"insertRows\",\"opl\":1,\"end\":14,\"sheet\":0,\"osn\":135},"
//				+ "]";
//		super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
//	}

//
//    @Test
//    /**
//     * Deleting content range.
//     */
//    public void deleteRangeTest() {
//        final String SOURCE_FILE_NAME_TRUNC = "30694";
//
//        String firstEditOperations = "["
//                + "{\"start\":[1,4],\"opl\":1,\"name\":\"fillCellRange\",\"value\":null,\"sheet\":0,\"end\":[2,6],\"osn\":47},"
//                + "{\"start\":4,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":508,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":48},"
//                + "{\"start\":5,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":508,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":49},"
//                + "{\"start\":6,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":508,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":50},"
//                + "{\"start\":4,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":508,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":51},"
//                + "{\"start\":5,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":508,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":52},"
//                + "{\"start\":6,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":508,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":53}"
//                + "]";
//        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
//    }
    @Test
    @Ignore
    /**
     * ODF space XML element that contains more than two spaces and was not
     * completely deleted, returned the removed spaces as remaining element
     * https://bugs.open-xchange.com/show_bug.cgi?id=28869
     */
    public void hyperlinkUnderscoreRemovalTest() {
        final String SOURCE_FILE_NAME_TRUNC = "hyperlinkSpaces";
        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"start\":[5,7],\"attrs\":{\"character\":{\"underline\":false}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[5,34],\"osn\":48}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

//    @Test
//    /**
//     * Create content within a spreadsheet
//     */
//    public void newSpreadsheetContentTest() {
//        final String SOURCE_FILE_NAME_TRUNC = "empty_as_can_be";
//
//        String firstEditOperations = "["
//                + "{\"name\":\"setDocumentAttributes\",\"attrs\":{\"document\":{\"defaultTabStop\":1270}}},\n"
//                + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"default_cell_style\",\"attrs\":{\"character\":{\"fontName\":\"Liberation Sans\",\"fontNameAsian\":\"DejaVu Sans\",\"fontNameComplex\":\"DejaVu Sans\",\"language\":\"en-US\"}},\"default\":true,\"hidden\":true,\"styleName\":\"Default Cell Style\"},\n"
//                + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Default\",\"attrs\":{\"character\":{\"fontNameComplex\":\"FreeSans\"}},\"parent\":\"default_cell_style\"},\n"
//                + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Heading\",\"attrs\":{\"character\":{\"bold\":true,\"fontSize\":16,\"italic\":true},\"paragraph\":{\"alignment\":\"center\"}},\"parent\":\"Default\"},\n"
//                + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Heading1\",\"attrs\":{},\"parent\":\"Heading\"},\n"
//                + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Result\",\"attrs\":{\"character\":{\"bold\":true,\"italic\":true,\"underline\":true}},\"parent\":\"Default\"},\n"
//                + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Result2\",\"attrs\":{},\"parent\":\"Result\"},\n"
//                + "{\"name\":\"setDocumentAttributes\",\"attrs\":{\"document\":{\"fileFormat\":\"odf\"}}},\n"
//                + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"'Liberation Sans'\",\"familyGeneric\":\"swiss\",\"pitch\":\"variable\"},\"fontName\":\"Liberation Sans\"},\n"
//                + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"'DejaVu Sans'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"fontName\":\"DejaVu Sans\"},\n"
//                + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"FreeSans\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"fontName\":\"FreeSans\"},\n"
//                + "{\"name\":\"setDocumentAttributes\",\"attrs\":{\"document\":{\"fileFormat\":\"odf\"}}},\n"
//                + "{\"name\":\"insertSheet\",\"attrs\":{\"sheet\":{\"visible\":true}},\"sheet\":0,\"sheetName\":\"Sheet5-svante\"},\n"
//                + "{\"name\":\"setColumnAttributes\",\"start\":2,\"end\":5,\"attrs\":{\"character\":{\"fontNameComplex\":\"FreeSans\"},\"column\":{\"width\":98765}},\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":0,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":123}},\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":1,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":321}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,1],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"1\"}},\"value\":\"1\"},{\"attrs\":{\"cell\":{\"value\":\"2\"}},\"value\":\"2\"},{\"attrs\":{\"cell\":{\"value\":\"3\"}},\"value\":\"3\"}]],\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":2,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":427}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,2],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"2\"}},\"value\":\"2\"},{\"attrs\":{\"cell\":{\"value\":\"3\"}},\"value\":\"3\"},{\"attrs\":{\"cell\":{\"value\":\"4\"}},\"value\":\"4\"}]],\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":3,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":427}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,3],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"3\"}},\"value\":\"3\"},{\"attrs\":{\"cell\":{\"value\":\"4\"}},\"value\":\"4\"},{\"attrs\":{\"cell\":{\"value\":\"5\"}},\"value\":\"5\"}]],\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":4,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":427}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,4],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"4\"}},\"value\":\"4\"},{\"attrs\":{\"cell\":{\"value\":\"5\"}},\"value\":\"5\"},{\"attrs\":{\"cell\":{\"value\":\"6\"}},\"value\":\"6\"}]],\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":5,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":427}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,5],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"5\"}},\"value\":\"5\"},{\"attrs\":{\"cell\":{\"value\":\"6\"}},\"value\":\"6\"},{\"attrs\":{\"cell\":{\"value\":\"7\"}},\"value\":\"7\"}]],\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":6,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":427}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,6],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"6\"}},\"value\":\"6\"},{\"attrs\":{\"cell\":{\"value\":\"7\"}},\"value\":\"7\"},{\"attrs\":{\"cell\":{\"value\":\"8\"}},\"value\":\"8\"}]],\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":7,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":427}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,7],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"7\"}},\"value\":\"7\"},{\"attrs\":{\"cell\":{\"value\":\"8\"}},\"value\":\"8\"},{\"attrs\":{\"cell\":{\"value\":\"9\"}},\"value\":\"9\"}]],\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":8,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":427}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,8],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"8\"}},\"value\":\"8\"},{\"attrs\":{\"cell\":{\"value\":\"9\"}},\"value\":\"9\"},{\"attrs\":{\"cell\":{\"value\":\"10\"}},\"value\":\"10\"}]],\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":9,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":427}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,9],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"9\"}},\"value\":\"9\"},{\"attrs\":{\"cell\":{\"value\":\"10\"}},\"value\":\"10\"},{\"attrs\":{\"cell\":{\"value\":\"11\"}},\"value\":\"11\"}]],\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":10,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":427}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,10],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"10\"}},\"value\":\"10\"},{\"attrs\":{\"cell\":{\"value\":\"11\"}},\"value\":\"11\"},{\"attrs\":{\"cell\":{\"value\":\"12\"}},\"value\":\"12\"}]],\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":11,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":427}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,11],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"11\"}},\"value\":\"11\"},{\"attrs\":{\"cell\":{\"value\":\"12\"}},\"value\":\"12\"},{\"attrs\":{\"cell\":{\"value\":\"13\"}},\"value\":\"13\"}]],\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":12,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":427}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,12],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"12\"}},\"value\":\"12\"},{\"attrs\":{\"cell\":{\"value\":\"13\"}},\"value\":\"13\"},{\"attrs\":{\"cell\":{\"value\":\"14\"}},\"value\":\"14\"}]],\"sheet\":0},\n"
//                + "{\"name\":\"setRowAttributes\",\"start\":13,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":427}},\"sheet\":0},\n"
//                + "{\"name\":\"setCellContents\",\"start\":[1,13],\"contents\":[[{\"attrs\":{\"cell\":{\"value\":\"13\"}},\"value\":\"13\"},{\"attrs\":{\"cell\":{\"value\":\"14\"}},\"value\":\"14\"},{\"attrs\":{\"cell\":{\"value\":\"15\"}},\"value\":\"15\"}]],\"sheet\":0}"
//                + "]";
//        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
//    }
//
    @Test
    @Ignore
    /**
     * Inserting and Deleting rows and columns
     */
    public void rowInsertionA2Test() {
        final String SOURCE_FILE_NAME_TRUNC = "columnStyle"; // "Insert and Delete Rows2";
        String firstEditOperations = "["
            //		+ "{\"start\":12,\"name\":\"insertRows\",\"opl\":1,\"end\":14,\"sheet\":0,\"osn\":135},"
            + "]";
        List<String> editOperations = new ArrayList();
        editOperations.add(firstEditOperations);
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);
    }
//
//	@Test
//	/**
//	 * Inserting and Deleting rows and columns
//	 */
//	public void rowInsertionBTest() {
//		final String SOURCE_FILE_NAME_TRUNC = "Insert and Delete Rows3";
//		String firstEditOperations = "["
//				+ "{\"start\":12,\"name\":\"insertRows\",\"opl\":1,\"end\":14,\"sheet\":0,\"osn\":135},"
//				+ "{\"start\":12,\"name\":\"insertRows\",\"opl\":1,\"end\":14,\"sheet\":1,\"osn\":135},"
//				+ "{\"start\":12,\"name\":\"insertRows\",\"opl\":1,\"end\":14,\"sheet\":2,\"osn\":135},"
//				+ "]";
//		List<String> editOperations = new ArrayList();
//		editOperations.add(firstEditOperations);
//		super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);
//	}
//
//
//	@Test
//	/**
//	 * Inserting columns
//	 */
//	public void columnInsertionTest() {
//		final String SOURCE_FILE_NAME_TRUNC = "Insert and Delete Columns_MSO15";
//		String firstEditOperations = "["
//				+ "{\"start\":3,\"name\":\"insertColumns\",\"end\":5,\"sheet\":0,\"osn\":135},"
//				+ "]";
//		List<String> editOperations = new ArrayList();
//		editOperations.add(firstEditOperations);
//		super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);
//	}

    @Test
    @Ignore
    /**
     * A paragraph style may contain text and paragraph properties. The text
     * properties are similar to default style.
     */
    public void splitDefaultTextParagraphStyleProperties() {

        final String SOURCE_FILE_NAME_TRUNC = "CharacterParagraphFormat";
        String firstEditOperations = "["
            + "{\"start\":[0,1],\"attrs\":{\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"name\":\"setAttributes\",\"end\":[0,1]}"
            + "]";
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);

    }

    @Test
    @Ignore
    /**
     *
     * https://bugs.open-xchange.com/show_bug.cgi?id=31350 A table within a text
     * box within a frame is not being loaded.
     */
    public void loadTableWithinTextBoxWithinFrame() {
        final String SOURCE_FILE_NAME_TRUNC = "table-within-textBox-within-frame";
        String firstEditOperations = "[]";
        List<String> editOperations = new ArrayList();
        editOperations.add(firstEditOperations);
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Inserting and Deleting rows and columns
     */
    public void deleteColumnsTest() {
        final String SOURCE_FILE_NAME_TRUNC = "30694-special";

        String firstEditOperations = "["
            //				+ "{\"start\":[5,15],\"contents\":[[{\"value\":\"test\"}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":46},"
            //				+ "{\"start\":15,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":166,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":47},"
            //				+ "{\"start\":[1,4],\"opl\":1,\"name\":\"fillCellRange\",\"value\":null,\"sheet\":0,\"end\":[2,6],\"osn\":48},"
            //				+ "{\"start\":4,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":1508,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":49},"
            //				+ "{\"start\":5,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":2508,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":50},"
            //				+ "{\"start\":6,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":3508,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":51},"
            //				+ "{\"start\":4,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":4508,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":52},"
            //				+ "{\"start\":5,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":5508,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":53},"
            //				+ "{\"start\":6,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":6508,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":54},"
            //				+ "{\"start\":9,\"end\":13,\"opl\":1,\"name\":\"insertRows\",\"sheet\":0,\"osn\":55},"
            //				+ "{\"start\":2,\"end\":3,\"opl\":1,\"name\":\"deleteRows\",\"sheet\":0,\"osn\":56},"
            //				+ "{\"start\":2,\"end\":5,\"opl\":1,\"name\":\"insertColumns\",\"sheet\":0,\"osn\":57},"
            //				+ "{\"start\":0,\"end\":5,\"opl\":1,\"name\":\"insertColumns\",\"sheet\":0,\"osn\":57},"
            //				+ "{\"start\":13,\"opl\":1,\"name\":\"insertColumns\",\"sheet\":0,\"osn\":57},"
            //				+ "{\"start\":0,\"end\":4,\"name\":\"deleteColumns\",\"sheet\":0,\"osn\":58},"
            + "{\"start\":7,\"name\":\"deleteColumns\",\"sheet\":0,\"osn\":58}"
            + "]";
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    /**
     * Coloring text with and without existing format properties.
     */
    public void listColoringTest() {
        final String SOURCE_FILE_NAME_TRUNC = "coloredParagraph";
        String firstEditOperations = "["
            + "{\"start\":[0,0],\"attrs\":{\"character\":{\"color\":{\"value\":\"7030A0\",\"type\":\"rgb\"}}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,2],\"osn\":36},"
            + "]";
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

//	@Test
//	public void colorParagraphTest() {
//		final String SOURCE_FILE_NAME_TRUNC = "empty";
//		String firstEditOperations = "["
//				+ "{\"name\":\"insertText\",\"start\":[0,0],\"text\":\"abc\"},"
//				+ "{\"name\":\"setAttributes\",\"start\":[0,0],\"end\":[0,0],\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"7030A0\"},\"fillColor\":{\"type\":\"rgb\",\"value\":\"92D050\"}}}},"
//				+ "{\"name\":\"setAttributes\",\"start\":[0,1],\"end\":[0,2],\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"7030A0\"}}}}"
//				+ "]";
//		super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
//	}
    @Test
    @Ignore
    /**
     * Coloring list content.
     */
    public void loadTest() {
        //final String SOURCE_FILE_NAME_TRUNC = "datavalidation_import_xml_12_MSO15"; // hangs during roundtrip
        //final String SOURCE_FILE_NAME_TRUNC = "31383 - viewsettings_import_xml_12";
        //final String SOURCE_FILE_NAME_TRUNC = "30694-styled";
        //final String SOURCE_FILE_NAME_TRUNC = "Calc_Excel_Funktionen_Pootle_REPEATED";
        // final String SOURCE_FILE_NAME_TRUNC = "simple-list";
        //final String SOURCE_FILE_NAME_TRUNC = "simple-list_MSO14_MSO15";
        // final String SOURCE_FILE_NAME_TRUNC = "OpenDocument-v1.2-os-part1";
        final String SOURCE_FILE_NAME_TRUNC = "OpenDocument-v1.2-os-part1";
        String firstEditOperations = "["
            //					+ "{\"text\":\"a\",\"start\":[0,0],\"opl\":1,\"name\":\"insertText\",\"osn\":17},"
            //				+ "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"right\"},\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"defaultlist\":\"numbering\",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"right\"},\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"right\"},\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"opl\":1,\"listStyleId\":\"L1\",\"osn\":18},"
            //				+ "{\"start\":[0],\"attrs\":{\"styleId\":\"ListParagraph\",\"paragraph\":{\"listStyleId\":\"L1\",\"listLevel\":0}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":19},"
            //					+ "{\"text\":\"bc\",\"start\":[0,1],\"opl\":2,\"name\":\"insertText\",\"osn\":20},"
            //				+ "{\"start\":[0,0],\"attrs\":{\"character\":{\"color\":{\"value\":\"FF0000\",\"type\":\"rgb\"}}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,2],\"osn\":22},"
            //				+ "{\"start\":[0,0],\"attrs\":{\"character\":{\"bold\":true}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,2],\"osn\":23},"
            //				+ "{\"start\":[0,3],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":24},"
            //				+ "{\"text\":\"def\",\"start\":[1,0],\"opl\":3,\"name\":\"insertText\",\"osn\":25},"
            //				+ "{\"start\":[1,3],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":28},"
            //				+ "{\"text\":\"ghi\",\"start\":[2,0],\"opl\":3,\"name\":\"insertText\",\"osn\":29},"
            //				+ "{\"start\":[2,0],\"attrs\":{\"character\":{\"color\":{\"value\":\"FFC000\",\"type\":\"rgb\"}}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[2,2],\"osn\":32},"
            //				+ "{\"start\":[2,0],\"attrs\":{\"character\":{\"color\":{\"value\":\"FFC000\",\"type\":\"rgb\"}}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[2,2],\"osn\":33},"
            //					+ "{\"start\":[0,0],\"attrs\":{\"character\":{\"fillColor\":{\"value\":\"92D050\",\"type\":\"rgb\"}}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,0],\"osn\":34},"
            //				+ "{\"start\":[1,0],\"attrs\":{\"character\":{\"color\":{\"value\":\"7030A0\",\"type\":\"rgb\"}}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[1,2],\"osn\":35},"
            //				+ "{\"start\":[0,0],\"attrs\":{\"character\":{\"color\":{\"value\":\"7030A0\",\"type\":\"rgb\"}}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,2],\"osn\":36},"
            //				+ "{\"start\":[2,3],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":37},"
            //				+ "{\"start\":[3],\"attrs\":{\"character\":{\"italic\":true}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":38},"
            //				+ "{\"start\":[3],\"attrs\":{\"character\":{\"underline\":true}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":39},"
            //				+ "{\"start\":[3],\"attrs\":{\"character\":{\"bold\":false}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":40},"
            //				+ "{\"start\":[3],\"attrs\":{\"character\":{\"strike\":\"single\"}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":41},"
            //				+ "{\"text\":\"d\",\"start\":[3,0],\"opl\":1,\"name\":\"insertText\",\"osn\":42}"
            + "]";
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    // {"start":[0,537],"attrs":{"drawing":{"anchorVertOffset":0,"anchorHorBase":"column","anchorHorOffset":0,"textWrapMode":"square","inline":false,"anchorHorAlign":"left","textWrapSide":"right","anchorVertBase":"paragraph"}},"name":"setAttributes","opl":1,"osn":21}
    @Test
    @Ignore
    /**
     * Adding red to first column and yellow to first row.
     */
    public void MergeTest() {
        final String SOURCE_FILE_NAME_TRUNC = "MergedRegionWithFormatedColumnRow_MSO15_LO";
        String firstEditOperations = "["
            //				+ "{\"start\":[1,1],\"opl\":1,\"name\":\"mergeCells\",\"type\":\"merge\",\"sheet\":0,\"end\":[4,4],\"osn\":18},"
            + "{\"start\":[0,1],\"contents\":[[{\"ref\":null,\"attrs\":{\"cell\":{\"numberFormat\":{\"id\":0,\"code\":\"\"}}},\"value\":1}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":19},"
            + "{\"start\":1,\"attrs\":{\"cell\":null,\"row\":{\"customHeight\":false,\"height\":466,\"visible\":true},\"character\":null},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":20},"
            + "{\"start\":[1,1],\"contents\":[[{\"ref\":null,\"attrs\":{\"cell\":{\"numberFormat\":{\"id\":0,\"code\":\"\"}}},\"value\":2}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":21},"
            + "{\"start\":1,\"attrs\":{\"cell\":null,\"row\":{\"customHeight\":false,\"height\":466,\"visible\":true},\"character\":null},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":22},"
            + "{\"start\":2,\"attrs\":{\"cell\":null,\"row\":{\"customHeight\":false,\"height\":508,\"visible\":true},\"character\":null},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":23},"
            + "{\"start\":3,\"attrs\":{\"cell\":null,\"row\":{\"customHeight\":false,\"height\":508,\"visible\":true},\"character\":null},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":24},"
            + "{\"start\":[5,1],\"contents\":[[{\"ref\":null,\"attrs\":{\"cell\":{\"numberFormat\":{\"id\":0,\"code\":\"\"}}},\"value\":3}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":25},"
            + "{\"start\":1,\"attrs\":{\"cell\":null,\"row\":{\"customHeight\":false,\"height\":466,\"visible\":true},\"character\":null},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":26}"
            + "]";
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    /**
     * Merging cells
     */
    public void mergeTest() {
        final String SOURCE_FILE_NAME_TRUNC = "MergedCells";

        String firstEditOperations = "["
            //				+ "{\"start\":[0,4],\"contents\":[[{\"value\":\"=TODAY()\"}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":38},"
            //				+ "{\"start\":4,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":550,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":39}"
            + "]";

        List<String> editOperations = new ArrayList();
        editOperations.add(firstEditOperations);
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);

//		// TODO: Performance Issues during loading!
//		super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    /**
     * Inserting a formula
     */
    public void insertFormulaTest() {
        final String SOURCE_FILE_NAME_TRUNC = "attributes";

        String firstEditOperations = "["
            + "{\"start\":[0,4],\"contents\":[[{\"value\":\"=TODAY()\"}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":38},"
            + "{\"start\":4,\"attrs\":{\"row\":{\"customHeight\":false,\"height\":550,\"visible\":true}},\"opl\":1,\"name\":\"setRowAttributes\",\"sheet\":0,\"osn\":39}"
            + "]";

//		List<String> editOperations = new ArrayList();
//		editOperations.add(firstEditOperations);
//		super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);
//		// TODO: Performance Issues during loading!
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    /**
     * Deleting, editing & format a spreadsheet with existing hyperlinks
     */
    public void multipleCellFormatTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";
        String firstEditOperations = "["
            + "{\"name\":\"setDocumentAttributes\",\"attrs\":{\"document\":{\"defaultTabStop\":1250}}},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"default_cell_style\",\"attrs\":{\"character\":{\"fontName\":\"Arial\",\"fontNameAsian\":\"Lucida Sans Unicode\",\"fontNameComplex\":\"Tahoma\",\"language\":\"de-DE\"}},\"default\":true,\"hidden\":true,\"styleName\":\"Default Cell Style\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Default\",\"attrs\":{\"character\":{\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\"}},\"parent\":\"default_cell_style\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Heading\",\"attrs\":{\"character\":{\"bold\":true,\"fontSize\":16,\"italic\":true},\"paragraph\":{\"alignment\":\"center\"}},\"parent\":\"Default\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Heading1\",\"attrs\":{},\"parent\":\"Heading\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Result\",\"attrs\":{\"character\":{\"bold\":true,\"italic\":true,\"underline\":true}},\"parent\":\"Default\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Result2\",\"attrs\":{},\"parent\":\"Result\"},\n"
            + "{\"name\":\"setDocumentAttributes\",\"attrs\":{\"document\":{\"fileFormat\":\"odf\"}}},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"'Times New Roman'\",\"familyGeneric\":\"roman\",\"pitch\":\"variable\"},\"fontName\":\"Times New Roman\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"Arial\",\"familyGeneric\":\"swiss\",\"pitch\":\"variable\"},\"fontName\":\"Arial\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"'Lucida Sans Unicode'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"fontName\":\"Lucida Sans Unicode\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"Mangal\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"fontName\":\"Mangal\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"'Microsoft YaHei'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"fontName\":\"Microsoft YaHei\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"'Segoe UI'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"fontName\":\"Segoe UI\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"Tahoma\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"fontName\":\"Tahoma\"},\n"
            + "{\"name\":\"setDocumentAttributes\",\"attrs\":{\"document\":{\"fileFormat\":\"odf\"}}},\n"
            + "{\"name\":\"insertSheet\",\"attrs\":{\"sheet\":{\"visible\":true}},\"sheet\":0,\"sheetName\":\"Tabelle1\"},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":0,\"end\":1,\"attrs\":{\"character\":{\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\"},\"column\":{\"width\":4791}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":2,\"attrs\":{\"column\":{\"width\":2258}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":3,\"attrs\":{\"column\":{\"width\":3286}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":4,\"attrs\":{\"column\":{\"width\":3071}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":5,\"attrs\":{\"column\":{\"width\":3348}},\"sheet\":0},\n"
            + "{\"name\":\"setColumnAttributes\",\"start\":6,\"end\":1022,\"attrs\":{\"character\":{\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\"},\"column\":{\"width\":2258}},\"sheet\":0},\n"
            + "{\"name\":\"setRowAttributes\",\"start\":0,\"attrs\":{\"row\":{\"customHeight\":true,\"height\":2223}},\"sheet\":0},\n"
            + "{\"name\":\"setCellContents\",\"start\":[0,0],\"contents\":[[{\"attrs\":{\"styleId\":\"Default\",\"character\":{\"bold\":true,\"boldAsian\":false,\"boldComplex\":false,\"color\":{\"type\":\"auto\"},\"fontName\":\"Times New Roman\",\"fontSize\":10,\"fontSizeAsian\":10,\"italic\":false,\"italicAsian\":false,\"italicComplex\":false,\"language\":\"de-DE\",\"strike\":\"none\",\"underline\":false},\"paragraph\":{\"alignment\":\"center\",\"indentLeft\":0,\"marginLeft\":0}},\"value\":\"englisch\"},{\"attrs\":{\"styleId\":\"Default\",\"character\":{\"bold\":true,\"boldAsian\":false,\"boldComplex\":false,\"color\":{\"type\":\"auto\"},\"fontName\":\"Times New Roman\",\"fontSize\":10,\"fontSizeAsian\":10,\"italic\":false,\"italicAsian\":false,\"italicComplex\":false,\"language\":\"de-DE\",\"strike\":\"none\",\"underline\":false},\"paragraph\":{\"alignment\":\"right\",\"indentLeft\":0,\"marginLeft\":0}},\"value\":\"deutschsprachig\"},{\"attrs\":{\"styleId\":\"Default\",\"character\":{\"bold\":true,\"boldAsian\":false,\"boldComplex\":false,\"color\":{\"type\":\"auto\"},\"fontName\":\"Times New Roman\",\"fontSize\":10,\"fontSizeAsian\":10,\"italic\":false,\"italicAsian\":false,\"italicComplex\":false,\"language\":\"de-DE\",\"strike\":\"none\",\"underline\":false},\"paragraph\":{\"alignment\":\"center\",\"indentLeft\":0,\"marginLeft\":0}},\"value\":\"in Excel vorhanden\"},{\"attrs\":{\"styleId\":\"Default\",\"character\":{\"bold\":true,\"boldAsian\":false,\"boldComplex\":false,\"color\":{\"type\":\"auto\"},\"fontName\":\"Times New Roman\",\"fontSize\":10,\"fontSizeAsian\":10,\"italic\":false,\"italicAsian\":false,\"italicComplex\":false,\"language\":\"de-DE\",\"strike\":\"none\",\"underline\":false},\"paragraph\":{\"alignment\":\"center\",\"indentLeft\":0,\"marginLeft\":0}},\"value\":\"f\\u00FCr LO konsentiert (ja/nein)\"},{\"attrs\":{\"styleId\":\"Default\",\"character\":{\"bold\":true,\"boldAsian\":false,\"boldComplex\":false,\"color\":{\"type\":\"auto\"},\"fontName\":\"Times New Roman\",\"fontSize\":10,\"fontSizeAsian\":10,\"italic\":false,\"italicAsian\":false,\"italicComplex\":false,\"language\":\"de-DE\",\"strike\":\"none\",\"underline\":false},\"paragraph\":{\"alignment\":\"center\",\"indentLeft\":0,\"marginLeft\":0}},\"value\":\"in Pootle \\u00FCberpr\\u00FCft und ggfs. ge\\u00E4ndert (ja/nein)\"},{\"attrs\":{\"styleId\":\"Default\",\"character\":{\"bold\":true,\"boldAsian\":false,\"boldComplex\":false,\"color\":{\"type\":\"auto\"},\"fontName\":\"Times New Roman\",\"fontSize\":10,\"fontSizeAsian\":10,\"italic\":false,\"italicAsian\":false,\"italicComplex\":false,\"language\":\"de-DE\",\"strike\":\"none\",\"underline\":false},\"paragraph\":{\"alignment\":\"center\",\"indentLeft\":0,\"marginLeft\":0}},\"value\":\"in terminology-Datei eingetragen (ja/nein\"}]],\"sheet\":0},\n"
            + "{\"name\":\"fillCellRange\",\"start\":[6,0],\"end\":[1022,0],\"attrs\":{\"styleId\":\"Default\",\"paragraph\":{\"alignment\":\"left\"}},\"sheet\":0}"
            + "]";
        List<String> editOperations = new ArrayList();
        editOperations.add(firstEditOperations);
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Deleting, editing
     */
    public void splitRepeatedRowsCells1Test() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        String firstEditOperations = "["
            + "{\"start\":[1,3],\"opl\":1,\"name\":\"fillCellRange\",\"value\":null,\"sheet\":0,\"osn\":477},"
            //				+ "{\"start\":[8,6],\"attrs\":{\"character\":{\"underline\":true}},\"opl\":1,\"name\":\"fillCellRange\",\"sheet\":0,\"osn\":478},"
            //				+ "{\"start\":[1,2],\"attrs\":{\"character\":{\"italic\":true}},\"opl\":1,\"name\":\"fillCellRange\",\"sheet\":0,\"osn\":479},"
            //				+ "{\"start\":[1,1],\"contents\":[[{\"value\":\"A0BC\"}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":480},"
            //				+ "{\"start\":[1,4],\"attrs\":{\"character\":{\"fontSize\":24}},\"opl\":1,\"name\":\"fillCellRange\",\"sheet\":0,\"osn\":481},"
            //				+ "{\"start\":[1,4],\"attrs\":{\"character\":{\"fontName\":\"Andale Mono\"}},\"opl\":1,\"name\":\"fillCellRange\",\"sheet\":0,\"osn\":482},"
            //				+ "{\"start\":[1,5],\"opl\":1,\"name\":\"fillCellRange\",\"value\":null,\"attrs\":{\"character\":{\"url\":\"http://www.heise.de\"}},\"sheet\":0,\"osn\":37},"
            //				+ "{\"start\":[1,5],\"contents\":[[{\"value\":\"HEISE\"}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":36}"
            + "]";
        List<String> editOperations = new ArrayList();
        editOperations.add(firstEditOperations);
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);
        //super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    /**
     *
     * Inserting, Delete Columns in Spreadsheets
     */
    public void insertDeleteColumnsTest() {
		//final String SOURCE_FILE_NAME_TRUNC = "Insert and Delete Rows_MSO15";

        //final String SOURCE_FILE_NAME_TRUNC = "Insert and Delete Columns_MSO15";
        final String SOURCE_FILE_NAME_TRUNC = "Unterlagen_Juli2013";

        String firstEditOperations = "["
            + "]";
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    /**
     * ToDo: Interesting are the style references from the four images. In
     * styles.xml <style:style style:family="graphic" style:name="Graphics"
     * style:parent-style-name="default_drawing_style"/>
     * 1) Referenced empty template styles should still be referenced 2) The
     * explicit reference to the default style have to be removed
     */
    public void imageStyleTestTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty_as_can_be";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            // Moving Charlie Brown from left alinged to right aligned
            + "{\"name\":\"setDocumentAttributes\",\"attrs\":{\"document\":{\"defaultTabStop\":1249}}},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"paragraph\",\"styleId\":\"default_paragraph_style\",\"attrs\":{\"character\":{\"bold\":false,\"boldAsian\":false,\"boldComplex\":false,\"color\":{\"type\":\"auto\"},\"fillColor\":{\"type\":\"auto\"},\"fontName\":\"Calibri\",\"fontNameAsian\":\"Calibri\",\"fontNameComplex\":\"Times New Roman\",\"fontSize\":11,\"fontSizeAsian\":11,\"italic\":false,\"italicAsian\":false,\"italicComplex\":false,\"language\":\"de-DE\",\"letterSpacing\":\"normal\",\"vertAlign\":\"baseline\"},\"paragraph\":{\"alignment\":\"left\",\"borderBottom\":{\"space\":0,\"style\":\"none\"},\"borderLeft\":{\"space\":0,\"style\":\"none\"},\"borderRight\":{\"space\":0,\"style\":\"none\"},\"borderTop\":{\"space\":0,\"style\":\"none\"},\"fillColor\":{\"type\":\"auto\"},\"lineHeight\":{\"type\":\"percent\",\"value\":115},\"marginBottom\":353,\"paddingBottom\":0,\"paddingLeft\":0,\"paddingRight\":0,\"paddingTop\":0}},\"default\":true,\"hidden\":true,\"styleName\":\"Default Paragraph Style\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"paragraph\",\"styleId\":\"Normal\",\"attrs\":{},\"parent\":\"default_paragraph_style\",\"styleName\":\"Normal\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"paragraph\",\"styleId\":\"BalloonText\",\"attrs\":{\"character\":{\"fontName\":\"Tahoma\",\"fontNameComplex\":\"Tahoma\",\"fontSize\":8,\"fontSizeAsian\":8},\"paragraph\":{\"lineHeight\":{\"type\":\"percent\",\"value\":100},\"marginBottom\":0}},\"parent\":\"Normal\",\"styleName\":\"Balloon Text\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"paragraph\",\"styleId\":\"Heading1\",\"attrs\":{\"character\":{\"bold\":true,\"boldAsian\":true,\"boldComplex\":true,\"color\":{\"type\":\"rgb\",\"value\":\"365F91\"},\"fontName\":\"Cambria\",\"fontNameAsian\":\"MS Gothic\",\"fontNameComplex\":\"Times New Roman\",\"fontSize\":14,\"fontSizeAsian\":14},\"paragraph\":{\"marginBottom\":0,\"marginTop\":847,\"nextStyleId\":\"Normal\",\"outlineLevel\":0}},\"parent\":\"Normal\",\"styleName\":\"Heading 1\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"paragraph\",\"styleId\":\"Heading2\",\"attrs\":{\"character\":{\"bold\":true,\"boldAsian\":true,\"boldComplex\":true,\"color\":{\"type\":\"rgb\",\"value\":\"4F81BD\"},\"fontName\":\"Cambria\",\"fontNameAsian\":\"MS Gothic\",\"fontNameComplex\":\"Times New Roman\",\"fontSize\":13,\"fontSizeAsian\":13},\"paragraph\":{\"marginBottom\":0,\"marginTop\":353,\"nextStyleId\":\"Normal\",\"outlineLevel\":1}},\"parent\":\"Normal\",\"styleName\":\"Heading 2\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"paragraph\",\"styleId\":\"Heading3\",\"attrs\":{\"character\":{\"bold\":true,\"boldAsian\":true,\"boldComplex\":true,\"color\":{\"type\":\"rgb\",\"value\":\"4F81BD\"},\"fontName\":\"Cambria\",\"fontNameAsian\":\"MS Gothic\",\"fontNameComplex\":\"Times New Roman\"},\"paragraph\":{\"marginBottom\":0,\"marginTop\":353,\"nextStyleId\":\"Normal\",\"outlineLevel\":2}},\"parent\":\"Normal\",\"styleName\":\"Heading 3\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"paragraph\",\"styleId\":\"Title\",\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"17365D\"},\"fontName\":\"Cambria\",\"fontNameAsian\":\"MS Gothic\",\"fontNameComplex\":\"Times New Roman\",\"fontSize\":26,\"fontSizeAsian\":26,\"letterSpacing\":9},\"paragraph\":{\"borderBottom\":{\"color\":{\"type\":\"rgb\",\"value\":\"4F81BD\"},\"space\":141,\"style\":\"single\",\"width\":35},\"borderLeft\":{\"space\":0,\"style\":\"none\"},\"borderRight\":{\"space\":0,\"style\":\"none\"},\"borderTop\":{\"space\":0,\"style\":\"none\"},\"lineHeight\":{\"type\":\"percent\",\"value\":100},\"marginBottom\":529,\"nextStyleId\":\"Normal\",\"paddingBottom\":141,\"paddingLeft\":0,\"paddingRight\":0,\"paddingTop\":0}},\"parent\":\"Normal\",\"styleName\":\"Title\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"character\",\"styleId\":\"DefaultParagraphFont\",\"attrs\":{},\"parent\":\"default_character_style\",\"styleName\":\"Default Paragraph Font\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"character\",\"styleId\":\"BalloonTextChar\",\"attrs\":{\"character\":{\"fontName\":\"Tahoma\",\"fontNameComplex\":\"Tahoma\",\"fontSize\":8,\"fontSizeAsian\":8}},\"parent\":\"DefaultParagraphFont\",\"styleName\":\"Balloon Text Char\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"character\",\"styleId\":\"Heading1Char\",\"attrs\":{\"character\":{\"bold\":true,\"boldAsian\":true,\"boldComplex\":true,\"color\":{\"type\":\"rgb\",\"value\":\"365F91\"},\"fontName\":\"Cambria\",\"fontNameAsian\":\"MS Gothic\",\"fontNameComplex\":\"Times New Roman\",\"fontSize\":14,\"fontSizeAsian\":14}},\"parent\":\"DefaultParagraphFont\",\"styleName\":\"Heading 1 Char\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"character\",\"styleId\":\"Heading2Char\",\"attrs\":{\"character\":{\"bold\":true,\"boldAsian\":true,\"boldComplex\":true,\"color\":{\"type\":\"rgb\",\"value\":\"4F81BD\"},\"fontName\":\"Cambria\",\"fontNameAsian\":\"MS Gothic\",\"fontNameComplex\":\"Times New Roman\",\"fontSize\":13,\"fontSizeAsian\":13}},\"parent\":\"DefaultParagraphFont\",\"styleName\":\"Heading 2 Char\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"character\",\"styleId\":\"Heading3Char\",\"attrs\":{\"character\":{\"bold\":true,\"boldAsian\":true,\"boldComplex\":true,\"color\":{\"type\":\"rgb\",\"value\":\"4F81BD\"},\"fontName\":\"Cambria\",\"fontNameAsian\":\"MS Gothic\",\"fontNameComplex\":\"Times New Roman\"}},\"parent\":\"DefaultParagraphFont\",\"styleName\":\"Heading 3 Char\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"character\",\"styleId\":\"IntenseEmphasis\",\"attrs\":{\"character\":{\"bold\":true,\"boldAsian\":true,\"boldComplex\":true,\"color\":{\"type\":\"rgb\",\"value\":\"4F81BD\"},\"italic\":true,\"italicAsian\":true,\"italicComplex\":true}},\"parent\":\"DefaultParagraphFont\",\"styleName\":\"Intense Emphasis\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"character\",\"styleId\":\"TitleChar\",\"attrs\":{\"character\":{\"color\":{\"type\":\"rgb\",\"value\":\"17365D\"},\"fontName\":\"Cambria\",\"fontNameAsian\":\"MS Gothic\",\"fontNameComplex\":\"Times New Roman\",\"fontSize\":26,\"fontSizeAsian\":26,\"letterSpacing\":9}},\"parent\":\"DefaultParagraphFont\",\"styleName\":\"Title Char\"},\n"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"drawing\",\"styleId\":\"Graphics\",\"attrs\":{},\"parent\":\"default_drawing_style\"},\n"
            + "{\"name\":\"setDocumentAttributes\",\"attrs\":{\"document\":{\"fileFormat\":\"odf\"}}},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"Calibri\",\"familyGeneric\":\"swiss\",\"panose1\":[2,15,5,2,2,2,4,3,2,4],\"pitch\":\"variable\"},\"fontName\":\"Calibri\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"Times New Roman\",\"familyGeneric\":\"roman\",\"panose1\":[2,2,6,3,5,4,5,2,3,4],\"pitch\":\"variable\"},\"fontName\":\"Times New Roman\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"Cambria\",\"familyGeneric\":\"roman\",\"panose1\":[2,4,5,3,5,4,6,3,2,4],\"pitch\":\"variable\"},\"fontName\":\"Cambria\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"MS Gothic\",\"familyGeneric\":\"modern\",\"panose1\":[2,11,6,9,7,2,5,8,2,4],\"pitch\":\"fixed\"},\"fontName\":\"MS Gothic\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"Tahoma\",\"familyGeneric\":\"swiss\",\"panose1\":[2,11,6,4,3,5,4,4,2,4],\"pitch\":\"variable\"},\"fontName\":\"Tahoma\"},\n"
            + "{\"name\":\"insertFontDescription\",\"attrs\":{\"family\":\"MS Mincho\",\"familyGeneric\":\"modern\",\"panose1\":[2,2,6,9,4,2,5,8,3,4],\"pitch\":\"fixed\"},\"fontName\":\"MS Mincho\"},\n"
            + "{\"name\":\"setDocumentAttributes\",\"attrs\":{\"document\":{\"fileFormat\":\"odf\"},\"page\":{\"height\":29700,\"indentLeft\":2499,\"indentRight\":2499,\"marginBottom\":2000,\"marginLeft\":2499,\"marginRight\":2499,\"marginTop\":2499,\"numberFormat\":\"1\",\"printOrientation\":\"portrait\",\"width\":21001}}},\n"
            + "{\"name\":\"insertParagraph\",\"start\":[0],\"attrs\":{\"styleId\":\"Title\",\"character\":{\"language\":\"en-US\"}}},\n"
            + "{\"name\":\"insertText\",\"start\":[0,0],\"text\":\"Images\"},\n"
            + "{\"name\":\"insertParagraph\",\"start\":[1],\"attrs\":{\"styleId\":\"Heading1\",\"character\":{\"language\":\"en-US\"},\"paragraph\":{\"outlineLevel\":0}}},\n"
            + "{\"name\":\"insertText\",\"start\":[1,0],\"text\":\"Inline Images\"},\n"
            + "{\"name\":\"insertParagraph\",\"start\":[2],\"attrs\":{\"styleId\":\"Heading2\",\"character\":{\"language\":\"en-US\"},\"paragraph\":{\"outlineLevel\":1}}},\n"
            + "{\"name\":\"insertText\",\"start\":[2,0],\"text\":\"Single Images Between Words\"},\n"
            + "{\"name\":\"insertParagraph\",\"start\":[3],\"attrs\":{\"styleId\":\"Normal\"}},\n"
            + "{\"name\":\"insertText\",\"start\":[3,0],\"text\":\"Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. Charlie Brown \"},\n"
            + "{\"name\":\"insertDrawing\",\"start\":[3,170],\"type\":\"image\",\"attrs\":{\"styleId\":\"Graphics\",\"drawing\":{\"name\":\"Picture 49\",\"borderBottom\":{\"style\":\"none\"},\"borderLeft\":{\"style\":\"none\"},\"borderRight\":{\"style\":\"none\"},\"borderTop\":{\"style\":\"none\"},\"description\":\"charlie.png\",\"fillColor\":{\"type\":\"auto\"},\"height\":889,\"imageUrl\":\"media/image1.png\",\"inline\":true,\"width\":889}}},\n"
            + "{\"name\":\"insertText\",\"start\":[3,171],\"text\":\" Snoopy \"},\n"
            + "{\"name\":\"insertDrawing\",\"start\":[3,179],\"type\":\"image\",\"attrs\":{\"styleId\":\"Graphics\",\"drawing\":{\"name\":\"Picture 50\",\"borderBottom\":{\"style\":\"none\"},\"borderLeft\":{\"style\":\"none\"},\"borderRight\":{\"style\":\"none\"},\"borderTop\":{\"style\":\"none\"},\"description\":\"snoopy.png\",\"fillColor\":{\"type\":\"auto\"},\"height\":889,\"imageUrl\":\"media/image2.png\",\"inline\":true,\"width\":889}}},\n"
            + "{\"name\":\"insertText\",\"start\":[3,180],\"text\":\" Lucy \"},\n"
            + "{\"name\":\"insertDrawing\",\"start\":[3,186],\"type\":\"image\",\"attrs\":{\"styleId\":\"Graphics\",\"drawing\":{\"name\":\"Picture 51\",\"borderBottom\":{\"style\":\"none\"},\"borderLeft\":{\"style\":\"none\"},\"borderRight\":{\"style\":\"none\"},\"borderTop\":{\"style\":\"none\"},\"description\":\"lucy.png\",\"fillColor\":{\"type\":\"auto\"},\"height\":889,\"imageUrl\":\"media/image3.png\",\"inline\":true,\"width\":889}}},\n"
            + "{\"name\":\"insertText\",\"start\":[3,187],\"text\":\" Woodstock \"},\n"
            + "{\"name\":\"insertDrawing\",\"start\":[3,198],\"type\":\"image\",\"attrs\":{\"styleId\":\"Graphics\",\"drawing\":{\"name\":\"Picture 52\",\"borderBottom\":{\"style\":\"none\"},\"borderLeft\":{\"style\":\"none\"},\"borderRight\":{\"style\":\"none\"},\"borderTop\":{\"style\":\"none\"},\"description\":\"woodstock.png\",\"fillColor\":{\"type\":\"auto\"},\"height\":889,\"imageUrl\":\"media/image4.png\",\"inline\":true,\"width\":889}}}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    public void splitInCellTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";
        String firstEditOperations = "["
            + "{\"start\":[0],\"attrs\":{\"styleId\":\"ListParagraph\",\"paragraph\":{\"listStyleId\":\"L1\",\"listStart\":true,\"listLevel\":0}},\"name\":\"insertParagraph\"},"
            + "{\"text\":\"1\",\"start\":[0,0],\"name\":\"insertText\"},"
            + "{\"start\":[0,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"2\",\"start\":[1,0],\"name\":\"insertText\"},"
            + "{\"start\":[1,1],\"name\":\"splitParagraph\"},"
            + "{\"start\":[1],\"attrs\":{\"styleId\":null,\"paragraph\":{\"alignment\":null,\"lineHeight\":null,\"fillColor\":null,\"marginTop\":null,\"outlineLevel\":null,\"nextStyleId\":null,\"listStyleId\":null,\"borderBottom\":null,\"listLevel\":null,\"contextualSpacing\":null,\"borderLeft\":null,\"tabStops\":null,\"marginBottom\":null,\"listLabelHidden\":null,\"listStartValue\":null,\"indentRight\":null,\"indentLeft\":null,\"borderTop\":null,\"borderInside\":null,\"indentFirstLine\":null,\"borderRight\":null},\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"name\":\"setAttributes\"},"
            + "{\"text\":\"a\",\"start\":[2,0],\"name\":\"insertText\"},"
            + "]";
        List<String> editOperations = new ArrayList();
        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 29792 - ODT - Embedding a table within the list of another table
     * https://bugs.open-xchange.com/show_bug.cgi?id=29792
     */
    public void deleteListPropertiesSimpleTest() {
        final String SOURCE_FILE_NAME_TRUNC = "listsInTable";
        String firstEditOperations = "["
            + "{\"text\":\"1\",\"start\":[0,0,2,0,0],\"opl\":1,\"name\":\"insertText\",\"osn\":70},"
            + "{\"start\":[0,0,2,0,1],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":71},"
            + "{\"text\":\"2\",\"start\":[0,0,2,1,0],\"opl\":1,\"name\":\"insertText\",\"osn\":72},"
            + "{\"start\":[0,0,2,1,1],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":73},"
            + "{\"text\":\"3\",\"start\":[0,0,2,2,0],\"opl\":1,\"name\":\"insertText\",\"osn\":74},"
            + "{\"start\":[0,0,2,2,1],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":75},"
            + "{\"start\":[0,0,2,1,1],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":76},"
            + "{\"start\":[0,0,2,1],\"attrs\":{\"styleId\":null,\"paragraph\":{\"alignment\":null,\"lineHeight\":null,\"fillColor\":null,\"marginTop\":null,\"outlineLevel\":null,\"nextStyleId\":null,\"listStyleId\":null,\"borderBottom\":null,\"listLevel\":null,\"contextualSpacing\":null,\"borderLeft\":null,\"tabStops\":null,\"marginBottom\":null,\"listLabelHidden\":null,\"listStartValue\":null,\"indentRight\":null,\"indentLeft\":null,\"borderTop\":null,\"borderInside\":null,\"indentFirstLine\":null,\"borderRight\":null},\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":77},"
            + "{\"text\":\"Notfallkontakt:\",\"start\":[0,0,2,1,1],\"attrs\":{\"styleId\":null,\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"opl\":1,\"name\":\"insertText\",\"osn\":78},"
            + "{\"start\":[0,0,2,2],\"attrs\":{\"paragraph\":{\"marginTop\":1270}},\"name\":\"insertParagraph\",\"opl\":1,\"osn\":93},"
            + "{\"text\":\"Mein Kind darf im Notfall medizinisch betreut werden.\",\"start\":[0,0,2,2,0],\"opl\":1,\"name\":\"insertText\",\"osn\":94},"
            + "{\"start\":[0,0,2,3],\"attrs\":{\"styleId\":\"Standard\"},\"name\":\"insertParagraph\",\"opl\":1,\"osn\":112},"
            + "{\"text\":\"a\",\"start\":[0,0,2,4,0],\"attrs\":{\"styleId\":null,\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"opl\":1,\"name\":\"insertText\",\"osn\":113},"
            + "]";
        List<String> editOperations = new ArrayList();
        editOperations.add(firstEditOperations);
        //super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

//
//	@Test
//	/**
//	 * Bug 29792 - ODT - Embedding a table within the list of another table
//	 * https://bugs.open-xchange.com/show_bug.cgi?id=29792
//	 */
//	public void deleteListPropertiesTest() {
//		final String SOURCE_FILE_NAME_TRUNC = "listsInTable";
//		String firstEditOperations = "["
//				+ "{\"text\":\"a1\",\"start\":[0,0,2,0,2],\"opl\":1,\"name\":\"insertText\",\"osn\":70},"
//				+ "{\"start\":[0,0,2,0,2],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":71},"
//				+ "{\"text\":\"a2\",\"start\":[0,0,2,1,2],\"opl\":1,\"name\":\"insertText\",\"osn\":72},"
//				+ "{\"start\":[0,0,2,1,2],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":73},"
//				+ "{\"text\":\"a3\",\"start\":[0,0,2,2,2],\"opl\":1,\"name\":\"insertText\",\"osn\":74},"
//				+ "{\"start\":[0,0,2,2,2],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":75},"
//				+ "{\"start\":[0,0,2,1,2],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":76},"
//				+ "{\"start\":[0,0,2,1],\"attrs\":{\"styleId\":null,\"paragraph\":{\"alignment\":null,\"lineHeight\":null,\"fillColor\":null,\"marginTop\":null,\"outlineLevel\":null,\"nextStyleId\":null,\"listStyleId\":null,\"borderBottom\":null,\"listLevel\":null,\"contextualSpacing\":null,\"borderLeft\":null,\"tabStops\":null,\"marginBottom\":null,\"listLabelHidden\":null,\"listStartValue\":null,\"indentRight\":null,\"indentLeft\":null,\"borderTop\":null,\"borderInside\":null,\"indentFirstLine\":null,\"borderRight\":null},\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":77},"
//				+ "{\"text\":\"HELPINGTEXT:\",\"start\":[0,0,2,1,2],\"attrs\":{\"styleId\":null,\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"opl\":1,\"name\":\"insertText\",\"osn\":78},"
//				+ "{\"styleId\":\"ListParagraph\",\"styleName\":\"List Paragraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"marginLeft\":1270,\"nextStyleId\":\"ListParagraph\"}},\"name\":\"insertStyleSheet\",\"opl\":1,\"parent\":\"Standard\",\"uiPriority\":0,\"type\":\"paragraph\",\"osn\":79},"
//				+ "{\"start\":[0,0,2,2],\"attrs\":{\"styleId\":\"FieldTripLetterTable\",\"table\":{\"tableGrid\":[1582,14418]}},\"name\":\"insertTable\",\"opl\":1,\"osn\":80},"
//				+ "{\"start\":[0,0,2,2,0],\"attrs\":{\"row\":{\"height\":793}},\"name\":\"insertRows\",\"opl\":1,\"osn\":81},"
//				+ "{\"count\":1,\"start\":[0,0,2,2,0,0],\"name\":\"insertCells\",\"opl\":1,\"osn\":82},"
//				+ "{\"start\":[0,0,2,2,0,0,0],\"name\":\"insertParagraph\",\"opl\":1,\"osn\":83},"
//				+ "{\"text\":\"SVANTE1:\",\"start\":[0,0,2,2,0,0,0,0],\"opl\":1,\"name\":\"insertText\",\"osn\":84},"
//				+ "{\"count\":1,\"start\":[0,0,2,2,0,1],\"name\":\"insertCells\",\"opl\":1,\"osn\":85},"
//				+ "{\"start\":[0,0,2,2,0,1,0],\"name\":\"insertParagraph\",\"opl\":1,\"osn\":86},"
//				+ "{\"text\":\"SVANTE2:\",\"start\":[0,0,2,2,0,1,0,0],\"opl\":1,\"name\":\"insertText\",\"osn\":84},"
//
////				+ "{\"start\":[0,0,2,2,1],\"attrs\":{\"row\":{\"height\":793}},\"name\":\"insertRows\",\"opl\":1,\"osn\":87},"
////				+ "{\"count\":1,\"start\":[0,0,2,2,1,0],\"name\":\"insertCells\",\"opl\":1,\"osn\":88},"
////				+ "{\"start\":[0,0,2,2,1,0,0],\"name\":\"insertParagraph\",\"opl\":1,\"osn\":89},"
////				+ "{\"text\":\"Telefon:\",\"start\":[0,0,2,2,1,0,0,0],\"opl\":1,\"name\":\"insertText\",\"osn\":90},"
////				+ "{\"count\":1,\"start\":[0,0,2,2,1,1],\"name\":\"insertCells\",\"opl\":1,\"osn\":91},"
////				+ "{\"start\":[0,0,2,2,1,1,0],\"name\":\"insertParagraph\",\"opl\":1,\"osn\":92},"
////				+ "{\"start\":[0,0,2,3],\"attrs\":{\"paragraph\":{\"marginTop\":1270}},\"name\":\"insertParagraph\",\"opl\":1,\"osn\":93},"
////				+ "{\"text\":\"Mein Kind darf im Notfall medizinisch betreut werden.\",\"start\":[0,0,2,3,0],\"opl\":1,\"name\":\"insertText\",\"osn\":94},"
////				+ "{\"start\":[0,0,2,4],\"attrs\":{\"table\":{\"tableGrid\":[7679,640,7679]}},\"name\":\"insertTable\",\"opl\":1,\"osn\":95},"
////				+ "{\"start\":[0,0,2,4,0],\"name\":\"insertRows\",\"opl\":1,\"osn\":96},"
////				+ "{\"count\":1,\"start\":[0,0,2,4,0,0],\"attrs\":{\"cell\":{\"borderBottom\":{\"style\":\"single\",\"width\":18}}},\"name\":\"insertCells\",\"opl\":1,\"osn\":97},"
////				+ "{\"start\":[0,0,2,4,0,0,0],\"name\":\"insertParagraph\",\"opl\":1,\"osn\":98},"
////				+ "{\"count\":1,\"start\":[0,0,2,4,0,1],\"name\":\"insertCells\",\"opl\":1,\"osn\":99},"
////				+ "{\"start\":[0,0,2,4,0,1,0],\"name\":\"insertParagraph\",\"opl\":1,\"osn\":100},"
////				+ "{\"count\":1,\"start\":[0,0,2,4,0,2],\"attrs\":{\"cell\":{\"borderBottom\":{\"style\":\"single\",\"width\":18}}},\"name\":\"insertCells\",\"opl\":1,\"osn\":101},"
////				+ "{\"start\":[0,0,2,4,0,2,0],\"name\":\"insertParagraph\",\"opl\":1,\"osn\":102},"
////				+ "{\"start\":[0,0,2,4,1],\"attrs\":{\"row\":{\"height\":0}},\"name\":\"insertRows\",\"opl\":1,\"osn\":103},"
////				+ "{\"count\":1,\"start\":[0,0,2,4,1,0],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"width\":18}}},\"name\":\"insertCells\",\"opl\":1,\"osn\":104},"
////				+ "{\"start\":[0,0,2,4,1,0,0],\"name\":\"insertParagraph\",\"opl\":1,\"osn\":105},"
////				+ "{\"text\":\"Unterschrift der Eltern/eines Erziehungsberechtigten\",\"start\":[0,0,2,4,1,0,0,0],\"opl\":1,\"name\":\"insertText\",\"osn\":106},"
////				+ "{\"count\":1,\"start\":[0,0,2,4,1,1],\"name\":\"insertCells\",\"opl\":1,\"osn\":107},"
////				+ "{\"start\":[0,0,2,4,1,1,0],\"name\":\"insertParagraph\",\"opl\":1,\"osn\":108},"
////				+ "{\"count\":1,\"start\":[0,0,2,4,1,2],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"width\":18}}},\"name\":\"insertCells\",\"opl\":1,\"osn\":109},"
////				+ "{\"start\":[0,0,2,4,1,2,0],\"name\":\"insertParagraph\",\"opl\":1,\"osn\":110},"
////				+ "{\"text\":\"Datum\",\"start\":[0,0,2,4,1,2,0,0],\"opl\":1,\"name\":\"insertText\",\"osn\":111},"
////				+ "{\"start\":[0,0,2,5],\"attrs\":{\"styleId\":\"Standard\"},\"name\":\"insertParagraph\",\"opl\":1,\"osn\":112},"
////				+ "{\"text\":\"XXXX\",\"start\":[0,0,2,6,0],\"attrs\":{\"styleId\":null,\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"opl\":1,\"name\":\"insertText\",\"osn\":113},"
////				+ "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":11430,\"numberFormat\":\"lowerRoman\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":8890,\"numberFormat\":\"lowerRoman\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":10160,\"numberFormat\":\"lowerRoman\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":7620,\"numberFormat\":\"lowerRoman\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":6350,\"numberFormat\":\"lowerRoman\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":5080,\"numberFormat\":\"lowerRoman\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":3810,\"numberFormat\":\"lowerRoman\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":2540,\"numberFormat\":\"lowerRoman\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":1270,\"numberFormat\":\"lowerRoman\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"opl\":1,\"listStyleId\":\"L30031\",\"osn\":114}"
//				+ "]";
//		List<String> editOperations = new ArrayList();
//		editOperations.add(firstEditOperations);
//		//super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
//		super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
//	}
//		@Test
//	/**
//	 * Foreign ODF elements could not be cloned. Throwable are now catched and
//	 * rethrown as filterexception to be found by Admin logging -- adding
//	 * regression test references
//	 * https://bugs.open-xchange.com/show_bug.cgi?id=28841
//	 */
//	public void foreignElementSplitTest() {
//		final String SOURCE_FILE_NAME_TRUNC = "foreignElementSplit";
//		List<String> editOperations = new ArrayList();
//		String firstEditOperations = "["
//				+ "{\"start\":[1,9,1,1,2],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":495}"
//				+ "]";
//
//		editOperations.add(firstEditOperations);
//		super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
//	}
//	@Test
//	/**
//	 * Inserting, Renaming and Moving Spreadsheets
//	 */
//	public void styleSheetAdoptionTest() {
//		final String SOURCE_FILE_NAME_TRUNC = "empty";
//		String firstEditOperations = "["
//				+ "{\"opl\":1,\"name\":\"setSheetName\",\"sheetName\":\"FORMER_FIRST\",\"sheet\":0,\"osn\":477},"
//				+ "{\"opl\":1,\"name\":\"insertSheet\",\"sheetName\":\"NEW\",\"sheet\":1,\"osn\":478},"
//				+ "{\"opl\":1,\"name\":\"setSheetName\",\"sheetName\":\"NEW_RENAMED\",\"sheet\":1,\"osn\":479},"
//				+ "{\"opl\":1,\"name\":\"setSheetName\",\"sheetName\":\"NEW_RENAMED_SECON\",\"sheet\":1,\"osn\":480},"
//				+ "{\"opl\":1,\"name\":\"insertSheet\",\"sheetName\":\"Sheet2\",\"sheet\":2,\"osn\":481},"
//				+ "{\"opl\":1,\"name\":\"setSheetName\",\"sheetName\":\"THIRD_NOW_FIRST\",\"sheet\":2,\"osn\":482},"
//				+ "{\"opl\":1,\"name\":\"moveSheet\",\"to\":\"0\",\"sheet\":2,\"osn\":483},"
//				+ "{\"opl\":1,\"name\":\"deleteSheet\",\"sheet\":1,\"osn\":484},"
//				+ "{\"opl\":1,\"name\":\"setSheetAttributes\",\"sheet\":1,\"osn\":479,\"attrs\":{\"sheet\":{\"visible\":false}}}"
//				+ "]";
//		super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
//	}
//
    @Test
    @Ignore
    /**
     * Spreadsheet text insertion/deletion and formatting
     */
    public void spreadSheetText3Editing() {
        final String SOURCE_FILE_NAME_TRUNC = "basic";
        String firstEditOperations = "["
            + "{\"start\":[0,0],\"name\":\"fillCellRange\",\"opl\":1,\"value\":null,\"sheet\":0,\"osn\":478}]},\"changed\":{\"sheets\":{\"0\":{\"cells\":[{\"start\":[1,7]}]}},\"type\":\"cells\"}"
            //				+ "{\"start\":[1,7],\"name\":\"fillCellRange\",\"opl\":1,\"value\":null,\"sheet\":0,\"osn\":478}]},\"changed\":{\"sheets\":{\"0\":{\"cells\":[{\"start\":[1,7]}]}},\"type\":\"cells\"}"
            //				+ "{\"start\":[0,0],\"contents\":[[{\"value\":\"x\"}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":35},"
            //				+ "{\"start\":[0,21],\"contents\":[[{\"value\":\"y\"}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":36},"
            // 				+ "{\"start\":[2,11],\"opl\":1,\"name\":\"fillCellRange\",\"value\":null,\"sheet\":0,\"osn\":37},"
            //				+ "{\"start\":[1,6],\"attrs\":{\"character\":{\"url\":\"http://www.heise.de\"}},\"name\":\"fillCellRange\",\"opl\":1,\"sheet\":0,\"osn\":477}]},\"changed\":{\"sheets\":{\"0\":{\"cells\":[{\"start\":[1,6]}]}},\"type\":\"cells\"}"
            //				+ "{\"start\":[1,0],\"opl\":1,\"name\":\"fillCellRange\",\"value\":null,\"attrs\":{\"character\":{\"url\":\"http://www.heise.de\"}},\"sheet\":0,\"osn\":37},"
            //				+ "{\"start\":[1,0],\"contents\":[[{\"value\":\"HEISE\"}]],\"opl\":1,\"name\":\"setCellContents\",\"sheet\":0,\"osn\":36},"
            ////				+ "{\"start\":[2,12],\"attrs\":{\"character\":{\"bold\":true}},\"opl\":1,\"name\":\"fillCellRange\",\"sheet\":0,\"osn\":38},"
            //				+ "{\"start\":[2,12],\"attrs\":{\"character\":{\"italic\":true}},\"opl\":1,\"name\":\"fillCellRange\",\"sheet\":0,\"osn\":39},"
            //				+ "{\"start\":[2,12],\"attrs\":{\"character\":{\"underline\":true}},\"opl\":1,\"name\":\"fillCellRange\",\"sheet\":0,\"osn\":40}"
            + "]";
        List<String> editOperations = new ArrayList();
        editOperations.add(firstEditOperations);
        //super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 29882 - ODT - Default Styles are not being round-tripped
     * https://bugs.open-xchange.com/show_bug.cgi?id=29882
     */
    public void styleSheetInsertionTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";
        String firstEditOperations = "["
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"default_cell_style\",\"attrs\":{\"character\":{\"fontName\":\"Arial\",\"fontNameAsian\":\"Arial Unicode MS\",\"fontNameComplex\":\"Tahoma\",\"language\":\"de-DE\"}},\"default\":true,\"hidden\":true,\"styleName\":\"Default Cell Style\"},"
            + "{\"name\":\"insertStyleSheet\",\"type\":\"cell\",\"styleId\":\"Default\",\"attrs\":{\"character\":{\"fontNameAsian\":\"Microsoft YaHei\",\"fontNameComplex\":\"Mangal\"}},\"parent\":\"default_cell_style\"}"
            + "]";
        super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    /**
     */
    public void styleSheetRoundtripTest() {
        //final String SOURCE_FILE_NAME_TRUNC = "scenarios_import_xml_12-with-hidden-sheet_MSO15";
        final String SOURCE_FILE_NAME_TRUNC = "basic";
        // final String SOURCE_FILE_NAME_TRUNC = "formula";
        //final String SOURCE_FILE_NAME_TRUNC = "Calc_Excel_Funktionen_Pootle";
        //final String SOURCE_FILE_NAME_TRUNC = "OpenDocument-v1.2-os-part1";
        // final String SOURCE_FILE_NAME_TRUNC = "datavalidation_import_xml_12_MSO15";
        String firstEditOperations = "["
            + "]";
        List<String> editOperations = new ArrayList();
        editOperations.add(firstEditOperations);
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".ods", getTestMethodName(), editOperations);
//		super.roundtripRegressionSpreadsheetTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    public void hyperlinkDeletionTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";
        String firstEditOperations = "["
            + "{\"attrs\":{\"document\":{\"defaultTabStop\":1251}},\"name\":\"setDocumentAttributes\"}"
            + ",{\"styleName\":\"Default Paragraph Style\",\"styleId\":\"default_paragraph_style\",\"default\":true,\"hidden\":true,\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontName\":\"Times New Roman\",\"fontNameComplex\":\"Mangal\",\"language\":\"de-DE\",\"fontSize\":12,\"fontNameAsian\":\"SimSun\"}},\"name\":\"insertStyleSheet\",\"type\":\"paragraph\"}"
            + ",{\"styleId\":\"Standard\",\"attrs\":{},\"name\":\"insertStyleSheet\",\"parent\":\"default_paragraph_style\",\"type\":\"paragraph\"}"
            + ",{\"styleId\":\"Caption\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":212},\"character\":{\"fontSizeAsian\":12,\"italicComplex\":true,\"fontNameComplex\":\"Mangal1\",\"italicAsian\":true,\"italic\":true,\"fontSize\":12}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"}"
            + ",{\"styleId\":\"Heading\",\"attrs\":{\"paragraph\":{\"nextStyleId\":\"Text_20_body\",\"marginTop\":423,\"marginBottom\":212},\"character\":{\"fontSizeAsian\":14,\"fontNameComplex\":\"Mangal\",\"fontName\":\"Arial\",\"fontSize\":14,\"fontNameAsian\":\"Microsoft YaHei\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"}"
            + ",{\"styleId\":\"Index\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"}"
            + ",{\"styleName\":\"List Paragraph\",\"styleId\":\"ListParagraph\",\"attrs\":{\"paragraph\":{\"nextStyleId\":\"ListParagraph\",\"indentLeft\":1270,\"marginLeft\":1270}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"}"
            + ",{\"styleName\":\"Text body\",\"styleId\":\"Text_20_body\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":0}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"}"
            + ",{\"styleId\":\"List\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Text_20_body\",\"type\":\"paragraph\"}"
            + ",{\"styleName\":\"Hyperlink\",\"styleId\":\"Hyperlink\",\"attrs\":{\"character\":{\"color\":{\"value\":\"0080C0\",\"type\":\"rgb\"},\"underline\":true}},\"name\":\"insertStyleSheet\",\"parent\":\"default_character_style\",\"type\":\"character\"}"
            + ",{\"attrs\":{\"page\":{\"printOrientation\":\"portrait\",\"marginBottom\":2000,\"indentRight\":2000,\"height\":29700,\"indentLeft\":2000,\"marginTop\":2000,\"marginLeft\":2000,\"numberFormat\":\"1\",\"width\":21001,\"marginRight\":2000}},\"name\":\"setDocumentAttributes\"}"
            + ",{\"fontName\":\"Mangal1\",\"attrs\":{\"family\":\"Mangal\"},\"name\":\"insertFontDescription\"}"
            + ",{\"fontName\":\"Times New Roman\",\"attrs\":{\"family\":\"'Times New Roman'\",\"familyGeneric\":\"roman\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"}"
            + ",{\"fontName\":\"Arial\",\"attrs\":{\"family\":\"Arial\",\"familyGeneric\":\"swiss\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"}"
            + ",{\"fontName\":\"Mangal\",\"attrs\":{\"family\":\"Mangal\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"}"
            + ",{\"fontName\":\"Microsoft YaHei\",\"attrs\":{\"family\":\"'Microsoft YaHei'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"}"
            + ",{\"fontName\":\"SimSun\",\"attrs\":{\"family\":\"SimSun\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"}"
            + ",{\"listDefinition\":{\"listLevel8\":{\"levelText\":\"■\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel6\":{\"levelText\":\"\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel7\":{\"levelText\":\"○\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel5\":{\"levelText\":\"■\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel4\":{\"levelText\":\"○\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"levelText\":\"\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"levelText\":\"■\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel1\":{\"levelText\":\"○\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"levelText\":\"\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L1\"}"
            + ",{\"start\":[0],\"attrs\":{\"styleId\":\"ListParagraph\",\"paragraph\":{\"listStyleId\":\"L1\",\"listStart\":true,\"listLevel\":0}},\"name\":\"insertParagraph\"}"
            + ",{\"text\":\"abc\",\"start\":[0,0],\"name\":\"insertText\"}"
            + ",{\"start\":[0,0],\"attrs\":{\"styleId\":\"Hyperlink\",\"character\":{\"url\":\"http://www.einlink.co.uk\"}},\"name\":\"setAttributes\",\"end\":[0,2]}"
            + ",{\"start\":[1],\"attrs\":{\"styleId\":\"Standard\"},\"name\":\"insertParagraph\"}"
            + ",{\"text\":\"Empty Document\",\"start\":[1,0],\"name\":\"insertText\"}"
            + ",{\"start\":[1,1],\"attrs\":{\"styleId\":\"Hyperlink\",\"character\":{\"url\":\"http://www.mopo.de\"}},\"name\":\"setAttributes\",\"end\":[1,9]}"
            + ",{\"start\":[1,2],\"attrs\":{\"styleId\":\"Hyperlink\",\"character\":{\"url\":\"http://www.heise.de\"}},\"name\":\"setAttributes\",\"end\":[1,8]},"
            + "{\"start\":[0,0],\"attrs\":{\"styleId\":null,\"character\":{\"url\":null}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,1],\"osn\":25}"
            + "]";
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    public void autoColorTest() {
        final String SOURCE_FILE_NAME_TRUNC = "tabellen_header_DOC_LO4-1-0";
        String firstEditOperations = "["
            + "]";
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    public void dropFixLineHeightTest() {
        final String SOURCE_FILE_NAME_TRUNC = "fields";
        String firstEditOperations = "["
            + "{\"start\":[0,0],\"attrs\":{\"character\":{\"fontSize\":72}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,8],\"osn\":273}"
            + "]";
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

//
//	@Test
//	public void hyperlinkTest() {
//		final String SOURCE_FILE_NAME_TRUNC = "hyperlink";
//		String firstEditOperations = "["
//				+ "{\"styleId\":\"Hyperlink\",\"styleName\":\"Hyperlink\",\"attrs\":{\"character\":{\"color\":{\"value\":\"hyperlink\",\"fallbackValue\":\"0080C0\",\"type\":\"scheme\"},\"underline\":true}},\"name\":\"insertStyleSheet\",\"parent\":null,\"uiPriority\":99,\"type\":\"character\"},"
//				+ "{\"start\":[0,4],\"attrs\":{\"character\":{\"style\":\"Hyperlink\",\"url\":\"http://www.alternate.de\"}},\"name\":\"setAttributes\",\"end\":[0,4]}"
//				+ "]";
//		super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
//	}
//
//	@Test
//	/**
//	 * Verified: https://bugs.open-xchange.com/show_bug.cgi?id=26055
//	 */
//	public void changeListAlignmentTest() {
//		final String SOURCE_FILE_NAME_TRUNC = "invalid_simple";
//		//final String SOURCE_FILE_NAME_TRUNC = "hyperlink";
////		final String SOURCE_FILE_NAME_TRUNC = "test3_simple";
////final String SOURCE_FILE_NAME_TRUNC = "images_reloaded";
//
//
//		List<String> editOperations = new ArrayList();
//		String firstEditOperations = "["
//				+ "]";
//
//		editOperations.add(firstEditOperations);
//				super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
//
////		super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
//	}
    @Test
    @Ignore
    /**
     * Bug 27061 - ODT - hyperlink - set clear formatting: after closing/reedit
     * the hyperlink is lost https://bugs.open-xchange.com/show_bug.cgi?id=27061
     */
    public void dummyStyle2Test() {
        final String SOURCE_FILE_NAME_TRUNC = "test3_simple";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "]";

        editOperations.add(firstEditOperations);
//      super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
    }

    @Ignore
    @Test
    /**
     * Bug 27061 - ODT - hyperlink - set clear formatting: after closing/reedit
     * the hyperlink is lost https://bugs.open-xchange.com/show_bug.cgi?id=27061
     */
    public void dummyStyleTest() {
        final String SOURCE_FILE_NAME_TRUNC = "feature_attributes_character_MSO15_simple";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "]";

        editOperations.add(firstEditOperations);
//      super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
    }

//	@Test
//	public void setFontName() {
//		final String SOURCE_FILE_NAME_TRUNC = "feature_attributes_character_MSO15";
//		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
//
//		List<String> editOperations = new ArrayList();
//		String firstEditOperations = "[{\"name\":\"setAttributes\",\"start\":[3,12],\"end\":[3,16],\"attrs\":{\"character\":{\"fontName\":\"Impact\"}}}]";
//		String secondEditOperations = "[{\"text\":\"Svante\",\"start\":[3,9],\"name\":\"insertText\"}]";
//
//		editOperations.add(firstEditOperations);
//		editOperations.add(secondEditOperations);
//		super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, SOURCE_FILE_NAME_SUFFIX, getTestMethodName(), editOperations);
//	}
    @Test
    @Ignore
    /**
     * Bug 26831 - ODT: insert hyperlink via clipboard not saved
     * https://bugs.open-xchange.com/show_bug.cgi?id=26831
     *
     *
     * The width of an image should be limited to its page width (page width -
     * left&rigth margin) QUESTION: Is the height adapted to keep the ratio?
     */
    public void markHyperlinkAllTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"text\":\"http://www.bild.de/\",\"start\":[0,0],\"name\":\"insertText\"},"
            + "{\"styleName\":\"Hyperlink\",\"styleId\":\"Hyperlink\",\"attrs\":{\"character\":{\"color\":{\"value\":\"hyperlink\",\"fallbackValue\":\"0080C0\",\"type\":\"scheme\"},\"underline\":true}},\"name\":\"insertStyleSheet\",\"parent\":null,\"uiPriority\":99,\"type\":\"character\"},"
            + "{\"start\":[0,0],\"attrs\":{\"styleId\":\"Hyperlink\",\"character\":{\"url\":\"http://www.bild.de/\"}},\"name\":\"setAttributes\",\"end\":[0,19]}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

//	@Test
//
//	/**
//	 * Bug 27061 - ODT - hyperlink - set clear formatting: after closing/reedit
//	 * the hyperlink is lost https://bugs.open-xchange.com/show_bug.cgi?id=27061
//	 */
//	public void hyperLinksNoStyleTest() {
//		final String SOURCE_FILE_NAME_TRUNC = "empty";
//
//		List<String> editOperations = new ArrayList();
//		String firstEditOperations = "["
//				+ "{\"text\":\"Empty Document\",\"start\":[0,0],\"opl\":1,\"name\":\"insertText\",\"osn\":21},{\"start\":[0,2],\"attrs\":{\"styleId\":\"Hyperlink\",\"character\":{\"url\":\"http://www.heise.de\"}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,8],\"osn\":22},{\"start\":[0,1],\"attrs\":{\"styleId\":\"Hyperlink\",\"character\":{\"url\":\"http://www.mopo.de\"}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,9],\"osn\":23}"
//				+ "]";
//
//		editOperations.add(firstEditOperations);
////      super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
//		super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
//	}
    @Test
    @Ignore
    /**
     * Bug 27061 - ODT - hyperlink - set clear formatting: after closing/reedit
     * the hyperlink is lost https://bugs.open-xchange.com/show_bug.cgi?id=27061
     */
    public void hyperLinksLostStyleTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"text\":\"abcdef\",\"start\":[0,0],\"opl\":6,\"name\":\"insertText\",\"osn\":16}"
            + ",{\"styleId\":\"Hyperlink\",\"styleName\":\"Hyperlink\",\"attrs\":{\"character\":{\"color\":{\"value\":\"hyperlink\",\"fallbackValue\":\"0080C0\",\"type\":\"scheme\"},\"underline\":true}},\"name\":\"insertStyleSheet\",\"opl\":1,\"parent\":null,\"uiPriority\":99,\"type\":\"character\",\"osn\":22}"
            + ",{\"start\":[0,1],\"attrs\":{\"styleId\":\"Hyperlink\",\"character\":{\"url\":\"http://www.heise.de\"}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,3],\"osn\":23}"
            + ",{\"start\":[0,1],\"attrs\":{\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,3],\"osn\":24}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
        //super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     */
    public void listHyperlink2Test() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"text\":\"link\",\"start\":[0,0],\"opl\":4,\"name\":\"insertText\",\"osn\":16}"
            + ",{\"styleId\":\"Hyperlink\",\"styleName\":\"Hyperlink\",\"attrs\":{\"character\":{\"color\":{\"value\":\"hyperlink\",\"fallbackValue\":\"0080C0\",\"type\":\"scheme\"},\"underline\":true}},\"name\":\"insertStyleSheet\",\"opl\":1,\"parent\":null,\"uiPriority\":99,\"type\":\"character\",\"osn\":20}"
            + ",{\"start\":[0,1],\"attrs\":{\"styleId\":\"Hyperlink\",\"character\":{\"url\":\"http://www.heise.de\"}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,2],\"osn\":21}"
            + ",{\"start\":[0,4],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":22}"
            + ",{\"text\":\"link2\",\"start\":[1,0],\"opl\":5,\"name\":\"insertText\",\"osn\":23}"
            //				+ ",{\"start\":[1,0],\"attrs\":{\"styleId\":\"Hyperlink\",\"character\":{\"url\":\"http://www.spiegel.de\"}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[1,4],\"osn\":28}"
            //				+ ",{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"right\"},\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"defaultlist\":\"numbering\",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"right\"},\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"right\"},\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"opl\":1,\"listStyleId\":\"L1\",\"osn\":29}"
            //				+ ",{\"styleId\":\"ListParagraph\",\"styleName\":\"List Paragraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"nextStyleId\":\"ListParagraph\",\"contextualSpacing\":true}},\"name\":\"insertStyleSheet\",\"opl\":1,\"parent\":\"Standard\",\"uiPriority\":34,\"type\":\"paragraph\",\"osn\":30}"
            //				+ ",{\"start\":[1],\"attrs\":{\"styleId\":\"ListParagraph\",\"paragraph\":{\"listStyleId\":\"L1\",\"listLevel\":0}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":31}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * To test if the outlineLevel null is appropriate
     */
    public void paragraphHeadingChangesTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";
        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"text\":\"abc\",\"start\":[0,0],\"opl\":3,\"name\":\"insertText\",\"osn\":16}"
            + ",{\"styleId\":\"heading3\",\"styleName\":\"heading 3\",\"attrs\":{\"paragraph\":{\"outlineLevel\":2,\"nextStyleId\":\"Standard\"},\"character\":{\"bold\":true,\"color\":{\"value\":\"accent1\",\"fallbackValue\":\"4F81BD\",\"type\":\"scheme\"}}},\"name\":\"insertStyleSheet\",\"opl\":1,\"parent\":\"Standard\",\"uiPriority\":9,\"type\":\"paragraph\",\"osn\":19}"
            + ",{\"start\":[0],\"attrs\":{\"paragraph\":{\"alignment\":null,\"lineHeight\":null,\"fillColor\":null,\"marginTop\":null,\"outlineLevel\":null,\"nextStyleId\":null,\"borderBottom\":null,\"contextualSpacing\":null,\"borderLeft\":null,\"marginBottom\":null,\"listLabelHidden\":null,\"tabStops\":null,\"listStartValue\":null,\"indentRight\":null,\"indentLeft\":null,\"style\":\"heading3\",\"borderTop\":null,\"borderInside\":null,\"indentFirstLine\":null,\"borderRight\":null},\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":20}"
            + ",{\"start\":[0,3],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":21}"
            + ",{\"start\":[1],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":22}"
            + ",{\"text\":\"abc2\",\"start\":[1,0],\"opl\":4,\"name\":\"insertText\",\"osn\":23}"
            + ",{\"start\":[1,4],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":27}"
            + ",{\"text\":\"def\",\"start\":[2,0],\"opl\":3,\"name\":\"insertText\",\"osn\":28}"
            + ",{\"styleId\":\"heading4\",\"styleName\":\"heading 4\",\"attrs\":{\"paragraph\":{\"outlineLevel\":3,\"nextStyleId\":\"Standard\"},\"character\":{\"bold\":true,\"color\":{\"value\":\"accent1\",\"fallbackValue\":\"4F81BD\",\"type\":\"scheme\"},\"italic\":true}},\"name\":\"insertStyleSheet\",\"opl\":1,\"parent\":\"Standard\",\"uiPriority\":9,\"type\":\"paragraph\",\"osn\":31}"
            + ",{\"start\":[2],\"attrs\":{\"paragraph\":{\"alignment\":null,\"lineHeight\":null,\"fillColor\":null,\"marginTop\":null,\"outlineLevel\":null,\"nextStyleId\":null,\"borderBottom\":null,\"contextualSpacing\":null,\"borderLeft\":null,\"marginBottom\":null,\"listLabelHidden\":null,\"tabStops\":null,\"listStartValue\":null,\"indentRight\":null,\"indentLeft\":null,\"style\":\"heading4\",\"borderTop\":null,\"borderInside\":null,\"indentFirstLine\":null,\"borderRight\":null},\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":32}"
            + ",{\"start\":[2,2],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":33}"
            + ",{\"start\":[3],\"attrs\":{\"paragraph\":{\"alignment\":null,\"lineHeight\":null,\"fillColor\":null,\"marginTop\":null,\"outlineLevel\":null,\"nextStyleId\":null,\"borderBottom\":null,\"contextualSpacing\":null,\"borderLeft\":null,\"marginBottom\":null,\"listLabelHidden\":null,\"tabStops\":null,\"listStartValue\":null,\"indentRight\":null,\"indentLeft\":null,\"style\":\"Standard\",\"borderTop\":null,\"borderInside\":null,\"indentFirstLine\":null,\"borderRight\":null},\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":34}"
            + "]";
        editOperations.add(firstEditOperations);
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
    }

//	@Test
//	@Ignore
//	/**
//	 * Bug 27821 - ODT - Numbered list: After saving the numbering list contains
//	 * wrong labels https://bugs.open-xchange.com/show_bug.cgi?id=27821
//	 */
//	public void editSubList2Test() {
//		final String SOURCE_FILE_NAME_TRUNC = "empty";
//
//		List<String> editOperations = new ArrayList();
//		String firstEditOperations = "["
//				+ "{\"text\":\"a\",\"start\":[0,0],\"opl\":1,\"name\":\"insertText\",\"osn\":16},"
//				+ "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"■\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Symbol\",\"levelText\":\"\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"○\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"defaultlist\":\"bullet\",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"■\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"○\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Symbol\",\"levelText\":\"\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"■\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"○\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Symbol\",\"levelText\":\"\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635}},\"name\":\"insertListStyle\",\"opl\":1,\"listStyleId\":\"L1\",\"osn\":17},"
//				+ "{\"styleId\":\"ListParagraph\",\"styleName\":\"List Paragraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"nextStyleId\":\"ListParagraph\",\"contextualSpacing\":true}},\"name\":\"insertStyleSheet\",\"opl\":1,\"parent\":\"Standard\",\"uiPriority\":34,\"type\":\"paragraph\",\"osn\":18},"
//				+ "{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L1\",\"listLevel\":0}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":19},"
//				+ "{\"start\":[0,1],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":20},"
//				+ "{\"text\":\"b1\",\"start\":[1,0],\"opl\":1,\"name\":\"insertText\",\"osn\":21},"
//				+ "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"right\"},\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"defaultlist\":\"numbering\",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"right\"},\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"right\"},\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"opl\":1,\"listStyleId\":\"L2\",\"osn\":22},"
//				+ "{\"start\":[1],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L2\",\"listLevel\":0}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":23},"
//				+ "{\"start\":[1],\"attrs\":{\"paragraph\":{\"listLevel\":1}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":24},"
//				+ "{\"start\":[1,2],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":25},"
//				+ "{\"text\":\"b2\",\"start\":[2,0],\"opl\":1,\"name\":\"insertText\",\"osn\":26},"
//				+ "{\"start\":[2,2],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":27},"
//				+ "{\"text\":\"c\",\"start\":[3,0],\"opl\":1,\"name\":\"insertText\",\"osn\":28},"
//				+ "{\"start\":[3,1],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":29},"
//				+ "{\"text\":\"d\",\"start\":[4,0],\"opl\":1,\"name\":\"insertText\",\"osn\":30},"
//
//				+ "{\"start\":[2],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L7\",\"listLevel\":0}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":31},"
////				+ "{\"start\":[2],\"attrs\":{\"paragraph\":{\"listLevel\":1}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":32}"
//				+ "]";
//
//		editOperations.add(firstEditOperations);
//		super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
//	}
    @Test
    @Ignore
    /**
     *
     */
    public void changeSubListTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"text\":\"1.\",\"start\":[0,0],\"opl\":2,\"name\":\"insertText\",\"osn\":16}"
            + ",{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"opl\":1,\"listStyleId\":\"L30001\",\"osn\":18}"
            + ",{\"styleId\":\"ListParagraph\",\"styleName\":\"List Paragraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"nextStyleId\":\"ListParagraph\",\"contextualSpacing\":true}},\"name\":\"insertStyleSheet\",\"opl\":1,\"parent\":\"Standard\",\"uiPriority\":34,\"type\":\"paragraph\",\"osn\":19}"
            + ",{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30001\",\"listLevel\":0}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":20}"
            + ",{\"start\":[0,2],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":21}"
            + ",{\"start\":[1],\"attrs\":{\"paragraph\":{\"listLevel\":1}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":22}"
            + ",{\"text\":\"a.\",\"start\":[1,0],\"opl\":2,\"name\":\"insertText\",\"osn\":23}"
            + ",{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listIdentifier\":\"L30001\",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevels\":[{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}],\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"opl\":1,\"listStyleId\":\"L2\",\"osn\":25}"
            + ",{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L2\"}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":26}"
            + ",{\"start\":[1],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L2\"}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":27}"
            + ",{\"start\":[1,2],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":28}"
            + ",{\"text\":\"b.\",\"start\":[2,0],\"opl\":2,\"name\":\"insertText\",\"osn\":29}"
            + ",{\"start\":[2,2],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":31}"
            + ",{\"text\":\"c.\",\"start\":[3,0],\"opl\":2,\"name\":\"insertText\",\"osn\":32}"
            + ",{\"start\":[3,2],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":34}"
            + ",{\"start\":[4],\"attrs\":{\"paragraph\":{\"listLevel\":0}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":35}"
            + ",{\"text\":\"a.\",\"start\":[4,0],\"opl\":2,\"name\":\"insertText\",\"osn\":36}"
            + ",{\"start\":[4],\"attrs\":{\"paragraph\":{\"style\":\"Standard\",\"listStyleId\":null,\"listLevel\":-1}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":38}"
            + ",{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"opl\":1,\"listStyleId\":\"L30011\",\"osn\":39}"
            + ",{\"start\":[4],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30011\",\"listLevel\":0}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":40}"
            + ",{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30011\",\"listLevel\":0}},\"name\":\"setAttributes\",\"opl\":1,\"osn\":41}"
            + ",{\"text\":\"->a.\",\"start\":[0,2],\"opl\":4,\"name\":\"insertText\",\"osn\":42}"
            + ",{\"text\":\"->b.\",\"start\":[4,2],\"opl\":4,\"name\":\"insertText\",\"osn\":54}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 28188 - ODT: No hyperlink after changing Text language
     * https://bugs.open-xchange.com/show_bug.cgi?id=28188
     *
     * BEFORE:
	 * <code>
     * <text:p text:style-name="Standard">
     * <text:a xlink:href="http://www.heise.de" xlink:type="simple">
     * <text:span text:style-name="a59fcaf">eins zwei</text:span>
     * </text:a>
     * </text:p>
     * </code> 	 <code>
     *
     * </code>
     *
     */
    public void hyperlinkWithSpaceTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"attrs\":{\"document\":{\"defaultTabStop\":1251}},\"name\":\"setDocumentAttributes\"},"
            + "{\"styleId\":\"default_paragraph_style\",\"default\":true,\"hidden\":true,\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontName\":\"Times New Roman\",\"fontNameComplex\":\"Mangal\",\"language\":\"de-DE\",\"fontSize\":12,\"fontNameAsian\":\"SimSun\"}},\"name\":\"insertStyleSheet\",\"type\":\"paragraph\"},"
            + "{\"styleId\":\"Standard\",\"attrs\":{},\"name\":\"insertStyleSheet\",\"parent\":\"default_paragraph_style\",\"type\":\"paragraph\"},"
            + "{\"styleId\":\"Caption\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":212},\"character\":{\"fontSizeAsian\":12,\"italicComplex\":true,\"fontNameComplex\":\"Mangal1\",\"italicAsian\":true,\"italic\":true,\"fontSize\":12}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},"
            + "{\"styleId\":\"Heading\",\"attrs\":{\"paragraph\":{\"nextStyleId\":\"Text_20_body\",\"marginTop\":423,\"marginBottom\":212},\"character\":{\"fontSizeAsian\":14,\"fontNameComplex\":\"Mangal\",\"fontName\":\"Arial\",\"fontSize\":14,\"fontNameAsian\":\"Microsoft YaHei\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},"
            + "{\"styleId\":\"Index\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},"
            + "{\"styleName\":\"Text body\",\"styleId\":\"Text_20_body\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":0}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},"
            + "{\"styleId\":\"List\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Text_20_body\",\"type\":\"paragraph\"},"
            + "{\"styleName\":\"Hyperlink\",\"styleId\":\"Hyperlink\",\"attrs\":{\"character\":{\"color\":{\"value\":\"0080C0\",\"type\":\"rgb\"},\"underline\":true}},\"name\":\"insertStyleSheet\",\"parent\":\"default_character_style\",\"type\":\"character\"},"
            + "{\"attrs\":{\"page\":{\"printOrientation\":\"portrait\",\"marginBottom\":2000,\"indentRight\":2000,\"height\":29700,\"indentLeft\":2000,\"marginTop\":2000,\"marginLeft\":2000,\"numberFormat\":\"1\",\"width\":21001,\"marginRight\":2000}},\"name\":\"setDocumentAttributes\"},"
            + "{\"fontName\":\"Mangal1\",\"attrs\":{\"family\":\"Mangal\"},\"name\":\"insertFontDescription\"},"
            + "{\"fontName\":\"Times New Roman\",\"attrs\":{\"family\":\"'Times New Roman'\",\"familyGeneric\":\"roman\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},"
            + "{\"fontName\":\"Arial\",\"attrs\":{\"family\":\"Arial\",\"familyGeneric\":\"swiss\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},"
            + "{\"fontName\":\"Mangal\",\"attrs\":{\"family\":\"Mangal\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},"
            + "{\"fontName\":\"Microsoft YaHei\",\"attrs\":{\"family\":\"'Microsoft YaHei'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},"
            + "{\"fontName\":\"SimSun\",\"attrs\":{\"family\":\"SimSun\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},"
            + "{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}},\"name\":\"insertParagraph\"},"
            + "{\"text\":\"eins zwei\",\"start\":[0,0],\"name\":\"insertText\"},"
            + "{\"start\":[0,0],\"attrs\":{\"character\":{\"style\":\"Hyperlink\",\"url\":\"http://www.heise.de\"}},\"name\":\"setAttributes\",\"end\":[0,8]}"
            // Here comes the problem..
            + ",{\"start\":[0,4],\"name\":\"delete\",\"opl\":1,\"end\":[0,4],\"osn\":19}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 28188 - ODT: No hyperlink after changing Text language
     * https://bugs.open-xchange.com/show_bug.cgi?id=28188
     */
    public void hyperlinkChangeLocaleTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"text\":\"hallo\",\"start\":[0,0],\"opl\":5,\"name\":\"insertText\",\"osn\":16},"
            + "{\"start\":[0,5],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":21},"
            + "{\"text\":\"www.hallo.de\",\"start\":[1,0],\"opl\":12,\"name\":\"insertText\",\"osn\":22},"
            + "{\"start\":[1,12],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":34},"
            + "{\"styleId\":\"Hyperlink\",\"styleName\":\"Hyperlink\",\"attrs\":{\"character\":{\"color\":{\"value\":\"hyperlink\",\"fallbackValue\":\"0080C0\",\"type\":\"scheme\"},\"underline\":true}},\"name\":\"insertStyleSheet\",\"opl\":1,\"parent\":null,\"uiPriority\":99,\"type\":\"character\",\"osn\":35},"
            + "{\"start\":[1,0],\"attrs\":{\"character\":{\"style\":\"Hyperlink\",\"url\":\"http://www.hallo.de\"}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[1,11],\"osn\":36},"
            + "{\"text\":\"hallo\",\"start\":[2,0],\"opl\":5,\"name\":\"insertText\",\"osn\":37},"
            + "{\"start\":[0,0],\"attrs\":{\"character\":{\"language\":\"en-US\"}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,4],\"osn\":42},"
            + "{\"start\":[1,0],\"attrs\":{\"character\":{\"language\":\"en-US\"}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[1,11],\"osn\":43},"
            + "{\"start\":[2,0],\"attrs\":{\"character\":{\"language\":\"en-US\"}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[2,4],\"osn\":44}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     *
     */
    public void hyperlinkBubbleTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"text\":\"link\",\"start\":[0,0],\"opl\":1,\"name\":\"insertText\",\"osn\":16},"
            + "{\"styleId\":\"Hyperlink\",\"styleName\":\"Hyperlink\",\"attrs\":{\"character\":{\"color\":{\"value\":\"hyperlink\",\"fallbackValue\":\"0080C0\",\"type\":\"scheme\"},\"underline\":true}},\"name\":\"insertStyleSheet\",\"opl\":1,\"parent\":null,\"uiPriority\":99,\"type\":\"character\",\"osn\":17},"
            + "{\"start\":[0,0],\"attrs\":{\"character\":{\"style\":\"Hyperlink\",\"url\":\"http://www.url.de\"}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,4],\"osn\":18},"
            + "{\"start\":[0,4],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":19},"
            //				+ "{\"text\":\"link\",\"start\":[1,0],\"attrs\":{\"character\":{\"style\":null,\"url\":null}},\"opl\":4,\"name\":\"insertText\",\"osn\":20}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     *
     */
    public void hyperlinkUndoRedoTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"attrs\":{\"document\":{\"defaultTabStop\":1251}},\"name\":\"setDocumentAttributes\"},{\"styleId\":\"default_paragraph_style\",\"default\":true,\"hidden\":true,\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontName\":\"Times New Roman\",\"fontNameComplex\":\"Mangal\",\"language\":\"de-DE\",\"fontSize\":12,\"fontNameAsian\":\"SimSun\"}},\"name\":\"insertStyleSheet\",\"type\":\"paragraph\"},{\"styleId\":\"Standard\",\"attrs\":{},\"name\":\"insertStyleSheet\",\"parent\":\"default_paragraph_style\",\"type\":\"paragraph\"},{\"styleId\":\"Caption\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":212},\"character\":{\"fontSizeAsian\":12,\"italicComplex\":true,\"fontNameComplex\":\"Mangal1\",\"italicAsian\":true,\"italic\":true,\"fontSize\":12}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"Heading\",\"attrs\":{\"paragraph\":{\"nextStyleId\":\"Text_20_body\",\"marginTop\":423,\"marginBottom\":212},\"character\":{\"fontSizeAsian\":14,\"fontNameComplex\":\"Mangal\",\"fontName\":\"Arial\",\"fontSize\":14,\"fontNameAsian\":\"Microsoft YaHei\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"Index\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleName\":\"Text body\",\"styleId\":\"Text_20_body\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":0}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"List\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Text_20_body\",\"type\":\"paragraph\"},{\"styleName\":\"Hyperlink\",\"styleId\":\"Hyperlink\",\"attrs\":{\"character\":{\"color\":{\"value\":\"0080C0\",\"type\":\"rgb\"},\"underline\":true}},\"name\":\"insertStyleSheet\",\"parent\":\"default_character_style\",\"type\":\"character\"},{\"attrs\":{\"page\":{\"printOrientation\":\"portrait\",\"marginBottom\":2000,\"indentRight\":2000,\"height\":29700,\"indentLeft\":2000,\"marginTop\":2000,\"marginLeft\":2000,\"numberFormat\":\"1\",\"width\":21001,\"marginRight\":2000}},\"name\":\"setDocumentAttributes\"},{\"fontName\":\"Mangal1\",\"attrs\":{\"family\":\"Mangal\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Times New Roman\",\"attrs\":{\"family\":\"'Times New Roman'\",\"familyGeneric\":\"roman\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Arial\",\"attrs\":{\"family\":\"Arial\",\"familyGeneric\":\"swiss\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Mangal\",\"attrs\":{\"family\":\"Mangal\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Microsoft YaHei\",\"attrs\":{\"family\":\"'Microsoft YaHei'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"SimSun\",\"attrs\":{\"family\":\"SimSun\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}},\"name\":\"insertParagraph\"},{\"text\":\"abc\",\"start\":[0,0],\"name\":\"insertText\"},"
            + "{\"start\":[0,0],\"attrs\":{\"character\":{\"style\":\"Hyperlink\",\"url\":\"http://www.heise.de\"}},\"name\":\"setAttributes\",\"end\":[0,2]},"
            // ** DELETE
            + "{\"start\":[0,0],\"attrs\":{\"character\":{\"style\":null,\"url\":null}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,2],\"osn\":19},"
            // ** UNDELETE
            //				+ "{\"start\":[0,0],\"attrs\":{\"character\":{\"style\":\"Hyperlink\",\"url\":\"http://www.heise.de\"}},\"name\":\"setAttributes\",\"opl\":1,\"end\":[0,2],\"osn\":20}"
            // ** RELOAD
            //+ "{\"attrs\":{\"document\":{\"defaultTabStop\":1251}},\"name\":\"setDocumentAttributes\"},{\"styleId\":\"default_paragraph_style\",\"default\":true,\"hidden\":true,\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontName\":\"Times New Roman\",\"fontNameComplex\":\"Mangal\",\"language\":\"de-DE\",\"fontSize\":12,\"fontNameAsian\":\"SimSun\"}},\"name\":\"insertStyleSheet\",\"type\":\"paragraph\"},{\"styleId\":\"Standard\",\"attrs\":{},\"name\":\"insertStyleSheet\",\"parent\":\"default_paragraph_style\",\"type\":\"paragraph\"},{\"styleId\":\"Caption\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":212},\"character\":{\"fontSizeAsian\":12,\"italicComplex\":true,\"fontNameComplex\":\"Mangal1\",\"italicAsian\":true,\"italic\":true,\"fontSize\":12}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"Heading\",\"attrs\":{\"paragraph\":{\"nextStyleId\":\"Text_20_body\",\"marginTop\":423,\"marginBottom\":212},\"character\":{\"fontSizeAsian\":14,\"fontNameComplex\":\"Mangal\",\"fontName\":\"Arial\",\"fontSize\":14,\"fontNameAsian\":\"Microsoft YaHei\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"Index\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleName\":\"Text body\",\"styleId\":\"Text_20_body\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":0}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"List\",\"attrs\":{\"character\":{\"fontNameComplex\":\"Mangal1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Text_20_body\",\"type\":\"paragraph\"},{\"styleName\":\"Hyperlink\",\"styleId\":\"Hyperlink\",\"attrs\":{\"character\":{\"color\":{\"value\":\"0080C0\",\"type\":\"rgb\"},\"underline\":true}},\"name\":\"insertStyleSheet\",\"parent\":\"default_character_style\",\"type\":\"character\"},{\"attrs\":{\"page\":{\"printOrientation\":\"portrait\",\"marginBottom\":2000,\"indentRight\":2000,\"height\":29700,\"indentLeft\":2000,\"marginTop\":2000,\"marginLeft\":2000,\"numberFormat\":\"1\",\"width\":21001,\"marginRight\":2000}},\"name\":\"setDocumentAttributes\"},{\"fontName\":\"Mangal1\",\"attrs\":{\"family\":\"Mangal\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Times New Roman\",\"attrs\":{\"family\":\"'Times New Roman'\",\"familyGeneric\":\"roman\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Arial\",\"attrs\":{\"family\":\"Arial\",\"familyGeneric\":\"swiss\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Mangal\",\"attrs\":{\"family\":\"Mangal\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Microsoft YaHei\",\"attrs\":{\"family\":\"'Microsoft YaHei'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"SimSun\",\"attrs\":{\"family\":\"SimSun\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}},\"name\":\"insertParagraph\"},{\"text\":\"abc\",\"start\":[0,0],\"name\":\"insertText\"},{\"start\":[0,0],\"attrs\":{\"character\":{\"url\":\"null\"}},\"name\":\"setAttributes\",\"end\":[0,2]}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * First make it impossible that "null" becomes a parent-style value, second
     * ignore empty setAttributes operations!
     *
     * https://bugs.open-xchange.com/show_bug.cgi?id=28066
     */
    public void errorTest() {
        final String SOURCE_FILE_NAME_TRUNC = "error-ox";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"start\":[10,5],\"name\":\"splitParagraph\",\"opl\":1,\"osn\":224},{\"text\":\"keine\",\"start\":[11,0],\"attrs\":{\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"style\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"opl\":1,\"name\":\"insertText\",\"osn\":225}"
            ////				+ "{\"start\":[10,0],\"name\":\"delete\",\"end\":[10,4]},{\"start\":[10,0],\"name\":\"splitParagraph\"},{\"text\":\"keine\",\"start\":[11,0],\"attrs\":{\"character\":{\"vertAlign\":null,\"fontName\":null,\"bold\":null,\"strike\":null,\"fillColor\":null,\"style\":null,\"color\":null,\"underline\":null,\"italic\":null,\"language\":null,\"fontSize\":null,\"url\":null}},\"name\":\"insertText\"}"
            ////				+ ",{\"start\":[11,0],\"start\":[11,4],\"attrs\":{},\"name\":\"setAttributes\"},"
            //setAttributes	start:[11,0],attrs:{},end:[11,4]
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 26872 - ODT - splitParagraph does only split the paragraph and not
     * create a new list item
     * https://bugs.open-xchange.com/show_bug.cgi?id=26872
     */
    public void severalListLevelTest() {
        final String SOURCE_FILE_NAME_TRUNC = "preparedList";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            //				+ "{\"text\":\"a\",\"start\":[0,0],\"osv\":false,\"opl\":1,\"name\":\"insertText\",\"osn\":80},"
            //				+ "{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L1\",\"listLevel\":0}},\"osv\":false,\"name\":\"setAttributes\",\"opl\":1,\"osn\":81},"
            //				+ "{\"start\":[0,1],\"osv\":false,\"name\":\"splitParagraph\",\"opl\":1,\"osn\":82},"
            //				+ "{\"text\":\"b\",\"start\":[1,0],\"osv\":false,\"opl\":1,\"name\":\"insertText\",\"osn\":83},"
            //				+ "{\"start\":[1],\"attrs\":{\"paragraph\":{\"listLevel\":1}},\"osv\":false,\"name\":\"setAttributes\",\"opl\":1,\"osn\":84},"
            //				+ "{\"start\":[1,1],\"osv\":false,\"name\":\"splitParagraph\",\"opl\":1,\"osn\":85},"
            //				+ "{\"text\":\"c\",\"start\":[2,0],\"osv\":false,\"opl\":1,\"name\":\"insertText\",\"osn\":86},"
            //				+ "{\"start\":[2,1],\"osv\":false,\"name\":\"splitParagraph\",\"opl\":1,\"osn\":87},"
            //				+ "{\"text\":\"d\",\"start\":[3,0],\"osv\":false,\"opl\":1,\"name\":\"insertText\",\"osn\":88},"
            //				+ "{\"start\":[3,1],\"osv\":false,\"name\":\"splitParagraph\",\"opl\":1,\"osn\":89},"
            //				+ "{\"text\":\"x\",\"start\":[4,0],\"osv\":false,\"opl\":1,\"name\":\"insertText\",\"osn\":91}"
            // does delete all previous lists
            //				+ "{\"start\":[4],\"attrs\":{\"paragraph\":{\"listLevel\":0}},\"osv\":false,\"name\":\"setAttributes\",\"opl\":1,\"osn\":90},"
            + "{\"start\":[4],\"attrs\":{\"paragraph\":{\"listLevel\":-1}},\"osv\":false,\"name\":\"setAttributes\",\"opl\":1,\"osn\":90},"
            + "]";

        editOperations.add(firstEditOperations);
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 27818 - ODT - Table with paragraphs borders: display error
     * https://bugs.open-xchange.com/show_bug.cgi?id=27818
     */
    public void paragraphBorderTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            //				+ "{\"styleId\":\"TableGrid\",\"styleName\":\"Table Grid\",\"attrs\":{\"wholeTable\":{\"paragraph\":{\"lineHeight\":{\"value\":100,\"type\":\"percent\"}},\"table\":{\"borderInsideVert\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"paddingTop\":0,\"borderTop\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderInsideHor\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderBottom\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderLeft\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderRight\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"paddingBottom\":0,\"paddingLeft\":190,\"paddingRight\":190}}},\"osv\":false,\"name\":\"insertStyleSheet\",\"opl\":1,\"uiPriority\":59,\"type\":\"table\",\"osn\":16},"
            //				+ "{\"start\":[1],\"attrs\":{\"table\":{\"style\":\"TableGrid\",\"tableGrid\":[1000,1000,1000],\"width\":\"auto\",\"exclude\":[\"lastRow\",\"lastCol\",\"bandsVert\"]}},\"osv\":false,\"name\":\"insertTable\",\"opl\":1,\"osn\":17},"				+ "{\"count\":2,\"start\":[1,0],\"osv\":false,\"name\":\"insertRows\",\"opl\":1,\"insertDefaultCells\":true,\"osn\":18},"
            //				+ "{\"start\":[1,0,0,0],\"osv\":false,\"name\":\"insertParagraph\",\"opl\":1,\"osn\":19},"
            //				+ "{\"text\":\"a1\",\"start\":[1,0,0,0,0],\"osv\":false,\"opl\":2,\"name\":\"insertText\",\"osn\":20},"
            //				+ "{\"start\":[1,0,1,0],\"osv\":false,\"name\":\"insertParagraph\",\"opl\":1,\"osn\":22},"
            //				+ "{\"text\":\"b1\",\"start\":[1,0,1,0,0],\"osv\":false,\"opl\":2,\"name\":\"insertText\",\"osn\":23},"
            //				+ "{\"start\":[1,0,2,0],\"osv\":false,\"name\":\"insertParagraph\",\"opl\":1,\"osn\":25},"
            //				+ "{\"text\":\"c1\",\"start\":[1,0,2,0,0],\"osv\":false,\"opl\":2,\"name\":\"insertText\",\"osn\":26},"
            //				+ "{\"start\":[1,1,0,0],\"osv\":false,\"name\":\"insertParagraph\",\"opl\":1,\"osn\":28},"
            //				+ "{\"text\":\"a2\",\"start\":[1,1,0,0,0],\"osv\":false,\"opl\":2,\"name\":\"insertText\",\"osn\":31},"
            //				+ "{\"start\":[1,1,1,0],\"osv\":false,\"name\":\"insertParagraph\",\"opl\":1,\"osn\":33},"
            //				+ "{\"text\":\"b2\",\"start\":[1,1,1,0,0],\"osv\":false,\"opl\":2,\"name\":\"insertText\",\"osn\":34},"
            //				+ "{\"start\":[1,1,2,0],\"osv\":false,\"name\":\"insertParagraph\",\"opl\":1,\"osn\":36},"
            //				+ "{\"text\":\"c2\",\"start\":[1,1,2,0,0],\"osv\":false,\"opl\":4,\"name\":\"insertText\",\"osn\":37},"
            //				+ "{\"start\":[1,0,0,0],\"attrs\":{\"paragraph\":{\"fillColor\":{\"value\":\"FF0000\",\"type\":\"rgb\"}}},\"osv\":false,\"name\":\"setAttributes\",\"opl\":1,\"osn\":41},"
            //				+ "{\"start\":[1,0,0,0],\"attrs\":{\"paragraph\":{\"borderTop\":{\"style\":\"none\"},\"undefined\":{\"style\":\"none\"},\"borderInside\":{\"style\":\"none\"},\"borderBottom\":{\"style\":\"none\"},\"borderLeft\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17,\"space\":140},\"borderRight\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17,\"space\":140}}},\"osv\":false,\"name\":\"setAttributes\",\"opl\":1,\"osn\":42}"
            + "{\"start\":[0],\"attrs\":{\"paragraph\":{\"borderTop\":{\"style\":\"none\"},\"undefined\":{\"style\":\"none\"},\"borderInside\":{\"style\":\"none\"},\"borderBottom\":{\"style\":\"none\"},\"borderLeft\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17,\"space\":140},\"borderRight\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17,\"space\":140}}},\"osv\":false,\"name\":\"setAttributes\",\"opl\":1,\"osn\":42}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 27727 - ODT - 2 independent bullet lists: data is lost
     * https://bugs.open-xchange.com/show_bug.cgi?id=27727
     */
    public void paddingTest() {
        final String SOURCE_FILE_NAME_TRUNC = "para-with-padding";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 27727 - ODT - 2 independent bullet lists: data is lost
     * https://bugs.open-xchange.com/show_bug.cgi?id=27727
     */
    public void splitParagraphTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"text\":\"a\",\"start\":[0,0],\"osv\":false,\"opl\":1,\"name\":\"insertText\",\"osn\":16},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"¦\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Symbol\",\"levelText\":\"?\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"?\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"defaultlist\":\"bullet\",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"¦\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"?\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Symbol\",\"levelText\":\"?\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"¦\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"?\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Symbol\",\"levelText\":\"?\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635}},\"osv\":false,\"name\":\"insertListStyle\",\"opl\":1,\"listStyleId\":\"L1\",\"osn\":17},"
            + "{\"styleId\":\"ListParagraph\",\"styleName\":\"List Paragraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"nextStyleId\":\"ListParagraph\",\"contextualSpacing\":true}},\"osv\":false,\"name\":\"insertStyleSheet\",\"opl\":1,\"parent\":\"Standard\",\"uiPriority\":34,\"type\":\"paragraph\",\"osn\":18},"
            + "{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L1\",\"listLevel\":0}},\"osv\":false,\"name\":\"setAttributes\",\"opl\":1,\"osn\":19},"
            + "{\"start\":[0,1],\"osv\":false,\"name\":\"splitParagraph\",\"opl\":1,\"osn\":20},"
            + "{\"start\":[1],\"attrs\":{\"paragraph\":{\"style\":\"Standard\",\"listStyleId\":null,\"listLevel\":-1}},\"osv\":false,\"name\":\"setAttributes\",\"opl\":1,\"osn\":21},"
            + "{\"start\":[1,0],\"osv\":false,\"name\":\"splitParagraph\",\"opl\":1,\"osn\":22},"
            + "{\"text\":\"b\",\"start\":[2,0],\"osv\":false,\"opl\":1,\"name\":\"insertText\",\"osn\":23},"
            + "{\"start\":[2],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L1\",\"listLevel\":0}},\"osv\":false,\"name\":\"setAttributes\",\"opl\":1,\"osn\":24}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Document created by wiki has invalid ZIP and content can not be loaded,
     * although it works with other ODF apps
     * https://bugs.open-xchange.com/show_bug.cgi?id=27982
     */
    public void loadBrokenZipTest() {
        final String SOURCE_FILE_NAME_TRUNC = "broken-zip";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    public void loadListStyleResolutionDocFullTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"listDefinition\":{\"listLevel8\":{\"styleId\":\"Numbering_20_Symbols\",\"tabStopPosition\":6350,\"levelText\":\"%9.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":6350,\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635},\"listLevel9\":{\"styleId\":\"Numbering_20_Symbols\",\"tabStopPosition\":6985,\"levelText\":\"%10.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":6985,\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635},\"listLevel6\":{\"styleId\":\"Numbering_20_Symbols\",\"tabStopPosition\":5080,\"levelText\":\"%7.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":5080,\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635},\"listLevel7\":{\"styleId\":\"Numbering_20_Symbols\",\"tabStopPosition\":5715,\"levelText\":\"%8.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":5715,\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635},\"listLevel5\":{\"styleId\":\"Numbering_20_Symbols\",\"tabStopPosition\":4445,\"levelText\":\"%6.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":4445,\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635},\"listLevel4\":{\"styleId\":\"Numbering_20_Symbols\",\"tabStopPosition\":3810,\"levelText\":\"%5.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":3810,\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635},\"listLevel3\":{\"styleId\":\"Numbering_20_Symbols\",\"tabStopPosition\":3175,\"levelText\":\"%4.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":3175,\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635},\"listLevel2\":{\"styleId\":\"Numbering_20_Symbols\",\"tabStopPosition\":2540,\"levelText\":\"%3.\",\"labelFollowedBy\":\"listtab\",\"indentLeft\":2540,\"numberFormat\":\"decimal\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635},\"listLevel1\":{\"verticalRel\":\"baseline\",\"verticalPos\":\"bottom\",\"tabStopPosition\":1905,\"height\":212,\"labelFollowedBy\":\"listtab\",\"indentLeft\":1905,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"width\":212,\"levelPicBulletUri\":\"Pictures/100002000000000A0000000A1F4FBE6C.gif\",\"indentFirstLine\":-635},\"listLevel0\":{\"verticalRel\":\"baseline\",\"verticalPos\":\"bottom\",\"tabStopPosition\":1270,\"height\":212,\"labelFollowedBy\":\"listtab\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"width\":212,\"levelPicBulletUri\":\"Pictures/100002000000000A0000000A1F4FBE6C.gif\",\"indentFirstLine\":-635}},\"name\":\"insertListStyle\",\"listStyleId\":\"ListStyle-ImageLabel\"},"
            + "{\"start\":[0],\"attrs\":{\"paragraph\":{\"listXmlId\":\"list6357203421921001764\",\"listId\":\"list6357203421921001764\",\"listStyleId\":\"ListStyle-ImageLabel\",\"listItemXmlId\":\"listItem1\",\"listStart\":true,\"listLevel\":0}},\"name\":\"insertParagraph\"},"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 26723 - ODT: Changing bullet for one list item changes whole bullet
     * list https://bugs.open-xchange.com/show_bug.cgi?id=26723
     */
    public void changeListStyle() {
        final String SOURCE_FILE_NAME_TRUNC = "simple bullet list 1_pre OX";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"right\"},\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"defaultlist\":\"numbering\",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"right\"},\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"right\"},\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L2\"},{\"styleId\":\"ListParagraph\",\"styleName\":\"List Paragraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"nextStyleId\":\"ListParagraph\",\"contextualSpacing\":true}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"uiPriority\":34,\"type\":\"paragraph\"},"
            + "{\"start\":[2],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L2\",\"listLevel\":0}},\"name\":\"setAttributes\"}"
            + "]";

        editOperations.add(firstEditOperations);
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * This test if the debug output does work: 1) Applies operations to a test
     * document 2) Checks if operation and original document exist 3) Applies
     * again operation to the test document 4) Checks if two operation files and
     * same original document as previously exists
     */
    public void debugOperationTest() {
        final String SOURCE_FILE_NAME_TRUNC = "feature_bullets_numbering";

        List<String> editOperations = new ArrayList();
        String firstEditOperations1 = "["
            + "{\"name\":\"insertText\",\"start\":[0,10],\"text\":\"Svante & \"},"
            + "]";

        editOperations.add(firstEditOperations1);
//		super.roundtripOnlyToEmptyDocRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt");
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
//.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     */
    public void insertWithSpace() {
        final String SOURCE_FILE_NAME_TRUNC = "feature_bullets_numbering";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 26872 - ODT - splitParagraph does only split the paragraph and not
     * create a new list item
     * https://bugs.open-xchange.com/show_bug.cgi?id=26872
     */
    public void splitListParagraphTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"attrs\":{\"document\":{\"defaultTabStop\":1251}},\"name\":\"setDocumentAttributes\"},"
            + "{\"styleId\":\"default_paragraph_style\",\"default\":true,\"hidden\":true,\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontName\":\"Times New Roman\",\"fontNameComplex\":\"Mangal\",\"language\":\"de-DE\",\"fontSize\":12,\"fontNameAsian\":\"SimSun\"}},\"name\":\"insertStyleSheet\",\"type\":\"paragraph\"},"
            + "{\"styleId\":\"Standard\",\"attrs\":{},\"name\":\"insertStyleSheet\",\"parent\":\"default_paragraph_style\",\"type\":\"paragraph\"},"
            + "{\"styleName\":\"Text body\",\"styleId\":\"Text_20_body\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":0}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},"
            + "{\"styleId\":\"Caption\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":212},\"character\":{\"fontSizeAsian\":12,\"italicComplex\":true,\"fontNameComplex\":\"Mangal1\",\"italicAsian\":true,\"italic\":true,\"fontSize\":12}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},"
            + "{\"styleId\":\"Index\",\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontNameComplex\":\"Mangal1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},"
            + "{\"styleId\":\"Heading\",\"attrs\":{\"paragraph\":{\"nextStyleId\":\"Text_20_body\",\"marginTop\":423,\"marginBottom\":212},\"character\":{\"fontSizeAsian\":14,\"fontNameComplex\":\"Mangal\",\"fontName\":\"Arial\",\"fontSize\":14,\"fontNameAsian\":\"Microsoft YaHei\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},"
            + "{\"styleId\":\"List\",\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontNameComplex\":\"Mangal1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Text_20_body\",\"type\":\"paragraph\"},"
            + "{\"attrs\":{\"page\":{\"printOrientation\":\"portrait\",\"marginBottom\":2000,\"indentRight\":2000,\"height\":29700,\"indentLeft\":2000,\"numberFormat\":\"1\",\"marginTop\":2000,\"marginLeft\":2000,\"width\":21001,\"marginRight\":2000}},\"name\":\"setDocumentAttributes\"},"
            + "{\"fontName\":\"Mangal1\",\"attrs\":{\"family\":\"Mangal\"},\"name\":\"insertFontDescription\"},"
            + "{\"fontName\":\"Times New Roman\",\"attrs\":{\"family\":\"'Times New Roman'\",\"familyGeneric\":\"roman\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},"
            + "{\"fontName\":\"Arial\",\"attrs\":{\"family\":\"Arial\",\"familyGeneric\":\"swiss\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},"
            + "{\"fontName\":\"Mangal\",\"attrs\":{\"family\":\"Mangal\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},"
            + "{\"fontName\":\"Microsoft YaHei\",\"attrs\":{\"family\":\"'Microsoft YaHei'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},"
            + "{\"fontName\":\"SimSun\",\"attrs\":{\"family\":\"SimSun\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},"
            + "{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}},\"name\":\"insertParagraph\"},"
            + "{\"text\":\"hello\",\"start\":[0,0],\"name\":\"insertText\"}"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9)\",\"indentLeft\":11430,\"numberFormat\":\"decimal\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7)\",\"indentLeft\":8890,\"numberFormat\":\"decimal\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8)\",\"indentLeft\":10160,\"numberFormat\":\"decimal\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6)\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5)\",\"indentLeft\":6350,\"numberFormat\":\"decimal\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4)\",\"indentLeft\":5080,\"numberFormat\":\"decimal\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3)\",\"indentLeft\":3810,\"numberFormat\":\"decimal\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2)\",\"indentLeft\":2540,\"numberFormat\":\"decimal\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1)\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"textAlign\":\"left\",\"indentFirstLine\":-635}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30002\"},"
            + "{\"styleName\":\"List Paragraph\",\"styleId\":\"ListParagraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"nextStyleId\":\"ListParagraph\",\"contextualSpacing\":true}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"uiPriority\":34,\"type\":\"paragraph\"},"
            + "{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30002\",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"start\":[0,5],\"name\":\"splitParagraph\"},"
            + "{\"start\":[1],\"attrs\":{\"paragraph\":{\"listLevel\":1}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"lowerLetter\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"lowerLetter\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"lowerLetter\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"lowerLetter\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"lowerLetter\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"lowerLetter\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"lowerLetter\",\"textAlign\":\"left\",\"indentFirstLine\":-635}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30011\"},"
            + "{\"start\":[1],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30011\",\"listLevel\":1}},\"name\":\"setAttributes\"},"
            + "{\"text\":\"a1\",\"start\":[1,0],\"name\":\"insertText\"},"
            + "{\"start\":[1,2],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"b1\",\"start\":[2,0],\"name\":\"insertText\"},"
            + "{\"start\":[2,2],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"c3\",\"start\":[3,0],\"name\":\"insertText\"},"
            + "{\"start\":[3,2],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"x\",\"start\":[4,0],\"name\":\"insertText\"},"
            + "{\"start\":[4],\"attrs\":{\"paragraph\":{\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"¦\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel6\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"?\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"defaultlist\":\"bullet\",\"listLevel7\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"?\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel5\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"¦\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel4\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"?\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"?\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"¦\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel1\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"?\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"?\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L3\"},"
            + "{\"start\":[4],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L3\",\"listLevel\":0}},\"name\":\"setAttributes\"}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 26872 - ODT - splitParagraph does only split the paragraph and not
     * create a new list item
     * https://bugs.open-xchange.com/show_bug.cgi?id=26872
     */
    public void savedListTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"attrs\":{\"document\":{\"defaultTabStop\":1251}},\"name\":\"setDocumentAttributes\"},{\"styleId\":\"default_paragraph_style\",\"default\":true,\"hidden\":true,\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontName\":\"Times New Roman\",\"fontNameComplex\":\"Mangal\",\"language\":\"de-DE\",\"fontSize\":12,\"fontNameAsian\":\"SimSun\"}},\"name\":\"insertStyleSheet\",\"type\":\"paragraph\"},{\"styleId\":\"Standard\",\"attrs\":{},\"name\":\"insertStyleSheet\",\"parent\":\"default_paragraph_style\",\"type\":\"paragraph\"},{\"styleName\":\"Text body\",\"styleId\":\"Text_20_body\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":0}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"Caption\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":212},\"character\":{\"fontSizeAsian\":12,\"italicComplex\":true,\"fontNameComplex\":\"Mangal1\",\"italicAsian\":true,\"italic\":true,\"fontSize\":12}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"Index\",\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontNameComplex\":\"Mangal1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"Heading\",\"attrs\":{\"paragraph\":{\"nextStyleId\":\"Text_20_body\",\"marginTop\":423,\"marginBottom\":212},\"character\":{\"fontSizeAsian\":14,\"fontNameComplex\":\"Mangal\",\"fontName\":\"Arial\",\"fontSize\":14,\"fontNameAsian\":\"Microsoft YaHei\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleName\":\"List Paragraph\",\"styleId\":\"ListParagraph\",\"attrs\":{\"paragraph\":{\"nextStyleId\":\"ListParagraph\",\"indentLeft\":1270,\"marginLeft\":1270}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"List\",\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontNameComplex\":\"Mangal1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Text_20_body\",\"type\":\"paragraph\"},{\"attrs\":{\"page\":{\"printOrientation\":\"portrait\",\"marginBottom\":2000,\"indentRight\":2000,\"height\":29700,\"indentLeft\":2000,\"numberFormat\":\"1\",\"marginTop\":2000,\"marginLeft\":2000,\"width\":21001,\"marginRight\":2000}},\"name\":\"setDocumentAttributes\"},{\"fontName\":\"Mangal1\",\"attrs\":{\"family\":\"Mangal\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Times New Roman\",\"attrs\":{\"family\":\"'Times New Roman'\",\"familyGeneric\":\"roman\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Arial\",\"attrs\":{\"family\":\"Arial\",\"familyGeneric\":\"swiss\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Mangal\",\"attrs\":{\"family\":\"Mangal\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Microsoft YaHei\",\"attrs\":{\"family\":\"'Microsoft YaHei'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"SimSun\",\"attrs\":{\"family\":\"SimSun\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":\"1\",\"levelText\":\"%1.\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":11430,\"numberFormat\":\"lowerLetter\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel6\":{\"listStartValue\":\"1\",\"levelText\":\"%1.\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel7\":{\"listStartValue\":\"1\",\"levelText\":\"%1.\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":10160,\"numberFormat\":\"lowerLetter\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel5\":{\"listStartValue\":\"1\",\"levelText\":\"%1.\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":7620,\"numberFormat\":\"lowerLetter\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel4\":{\"listStartValue\":\"1\",\"levelText\":\"%1.\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":6350,\"numberFormat\":\"lowerLetter\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"listStartValue\":\"1\",\"levelText\":\"%1.\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":5080,\"numberFormat\":\"lowerLetter\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"listStartValue\":\"1\",\"levelText\":\"%1.\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":3810,\"numberFormat\":\"lowerLetter\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel1\":{\"listStartValue\":\"1\",\"levelText\":\"%1.\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"listStartValue\":\"1\",\"levelText\":\"%1.\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":1270,\"numberFormat\":\"lowerLetter\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30011\"},{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30011\",\"listStart\":true,\"listLevel\":0}},\"name\":\"insertParagraph\"},{\"text\":\"hello\",\"start\":[0,0],\"name\":\"insertText\"},{\"start\":[1],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30011\",\"listLevel\":1}},\"name\":\"insertParagraph\"},{\"text\":\"a1\",\"start\":[1,0],\"name\":\"insertText\"},{\"start\":[2],\"attrs\":{\"paragraph\":{\"listLabelHidden\":true,\"style\":\"ListParagraph\",\"listStyleId\":\"L30011\",\"listLevel\":1}},\"name\":\"insertParagraph\"},{\"text\":\"b1\",\"start\":[2,0],\"name\":\"insertText\"},{\"start\":[3],\"attrs\":{\"paragraph\":{\"listLabelHidden\":true,\"style\":\"ListParagraph\",\"listStyleId\":\"L30011\",\"listLevel\":1}},\"name\":\"insertParagraph\"},{\"text\":\"c3\",\"start\":[3,0],\"name\":\"insertText\"},{\"listDefinition\":{\"listLevel8\":{\"levelText\":\"■\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel6\":{\"levelText\":\"●\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel7\":{\"levelText\":\"○\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel5\":{\"levelText\":\"■\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel4\":{\"levelText\":\"○\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel3\":{\"levelText\":\"●\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel2\":{\"levelText\":\"■\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel1\":{\"levelText\":\"○\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"listLevel0\":{\"levelText\":\"●\",\"labelFollowedBy\":\"nothing\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"listLevelPositionAndSpaceMode\":\"label-alignment\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L3\"},{\"start\":[4],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L3\",\"listStart\":true,\"listLevel\":0}},\"name\":\"insertParagraph\"},{\"text\":\"x\",\"start\":[4,0],\"name\":\"insertText\"}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 26831 - ODT: insert hyperlink via clipboard not saved
     * https://bugs.open-xchange.com/show_bug.cgi?id=26831
     *
     *
     * The width of an image should be limited to its page width (page width -
     * left&rigth margin) QUESTION: Is the height adapted to keep the ratio?
     */
    public void insertHyperlinkTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"text\":\"http://www.bild.de/\",\"start\":[0,0],\"name\":\"insertText\"},"
            + "{\"styleName\":\"Hyperlink\",\"styleId\":\"Hyperlink\",\"attrs\":{\"character\":{\"color\":{\"value\":\"hyperlink\",\"fallbackValue\":\"0080C0\",\"type\":\"scheme\"},\"underline\":true}},\"name\":\"insertStyleSheet\",\"parent\":null,\"uiPriority\":99,\"type\":\"character\"},"
            + "{\"start\":[0,0],\"attrs\":{\"character\":{\"style\":\"Hyperlink\",\"url\":\"http://www.bild.de/\"}},\"name\":\"setAttributes\",\"end\":[0,19]}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Bug 26818 - ODT: PaddingRoundtrip
     * https://bugs.open-xchange.com/show_bug.cgi?id=26818
     */
    public void paddingRoundtrip2Test() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"styleName\":\"Table Grid\",\"styleId\":\"TableGrid\",\"attrs\":{\"wholeTable\":{\"paragraph\":{\"lineHeight\":{\"value\":100,\"type\":\"percent\"}},\"table\":{\"paddingTop\":0,\"borderInsideVert\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderTop\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderInsideHor\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderBottom\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderRight\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderLeft\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"paddingLeft\":190,\"paddingBottom\":0,\"paddingRight\":190}}},\"name\":\"insertStyleSheet\",\"uiPriority\":59,\"type\":\"table\"},"
            + "{\"start\":[1],\"attrs\":{\"table\":{\"style\":\"TableGrid\",\"width\":\"auto\",\"tableGrid\":[1000,1000,1000],\"exclude\":[\"lastRow\",\"lastCol\",\"bandsVert\"]}},\"name\":\"insertTable\"},"
            + "{\"count\":1,\"start\":[1,0],\"name\":\"insertRows\",\"insertDefaultCells\":true},"
            + "{\"start\":[1,0,0,0],\"name\":\"insertParagraph\"},"
            + "{\"text\":\"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\",\"start\":[1,0,0,0,0],\"name\":\"insertText\"}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

//	"[{\"start\":[0,0],\"attrs\":{\"drawing\":{\"marginBottom\":317,\"height\":7890,\"marginLeft\":317,\"marginTop\":317,\"imageUrl\":\"Pictures/uid33ecce236deef.png\",\"marginRight\":317,\"width\":17013}},\"name\":\"insertDrawing\",\"type\":\"image\"},{\"start\":[0,1],\"name\":\"splitParagraph\"},{\"styleName\":\"Table Grid\",\"styleId\":\"TableGrid\",\"attrs\":{\"wholeTable\":{\"paragraph\":{\"lineHeight\":{\"value\":100,\"type\":\"percent\"}},\"table\":{\"borderInsideVert\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderTop\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderInsideHor\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderBottom\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderRight\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderLeft\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17}}}},\"name\":\"insertStyleSheet\",\"uiPriority\":59,\"type\":\"table\"},{\"start\":[2],\"attrs\":{\"table\":{\"style\":\"TableGrid\",\"width\":\"auto\",\"tableGrid\":[1000,1000,1000],\"exclude\":[\"lastRow\",\"lastCol\",\"bandsVert\"]}},\"name\":\"insertTable\"},{\"count\":3,\"start\":[2,0],\"name\":\"insertRows\",\"insertDefaultCells\":true}]"
    @Test
    @Ignore
    public void changeListStyleTest() {
        final String SOURCE_FILE_NAME_TRUNC = "simple bullet list 1_pre OX";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"listDefinition\":{\"listLevel8\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"○\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel6\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"○\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel7\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"○\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel5\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"○\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel4\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"○\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel3\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"○\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel2\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"○\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel1\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"○\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635},\"listLevel0\":{\"fontName\":\"Times New Roman\",\"listStartValue\":1,\"levelText\":\"○\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"textAlign\":\"left\",\"indentFirstLine\":-635}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20002\"},{\"styleName\":\"List Paragraph\",\"styleId\":\"ListParagraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"nextStyleId\":\"ListParagraph\",\"contextualSpacing\":true}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"uiPriority\":34,\"type\":\"paragraph\"},{\"start\":[2],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20002\",\"listLevel\":0}},\"name\":\"setAttributes\"}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    public void expandExistingListTest() {
        final String SOURCE_FILE_NAME_TRUNC = "simple bullet list 1_pre OX";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"start\":[2,8],\"name\":\"splitParagraph\"},{\"start\":[3],\"attrs\":{\"paragraph\":{\"style\":\"Standard\",\"listStyleId\":null,\"listLevel\":-1}},\"name\":\"setAttributes\"},{\"start\":[3,0],\"name\":\"splitParagraph\"},{\"start\":[3],\"name\":\"mergeParagraph\"},{\"start\":[2],\"name\":\"mergeParagraph\"},{\"start\":[2,8],\"name\":\"splitParagraph\"},{\"text\":\"s\",\"start\":[3,0],\"name\":\"insertText\"},{\"start\":[3,1],\"name\":\"splitParagraph\"},{\"text\":\"v\",\"start\":[4,0],\"name\":\"insertText\"}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    public void loadingTest() {
        final String SOURCE_FILE_NAME_TRUNC = "5cmtabstop";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            //				+ "{\"to\":[2,0],\"start\":[1,0],\"name\":\"move\",\"end\":[1,0]}"
            //				+ ",{\"start\":[2,0],\"attrs\":{\"drawing\":{\"anchorVertOffset\":2763,\"anchorHorBase\":\"column\",\"anchorHorOffset\":4710,\"anchorHorAlign\":\"offset\",\"anchorVertAlign\":\"offset\",\"anchorVertBase\":\"paragraph\"}},\"name\":\"setAttributes\"},{\"start\":[2,0],\"attrs\":{\"drawing\":{\"anchorVertOffset\":529,\"anchorHorBase\":\"column\",\"anchorHorOffset\":4763,\"anchorHorAlign\":\"offset\",\"anchorVertAlign\":\"offset\",\"anchorVertBase\":\"paragraph\"}},\"name\":\"setAttributes\"},{\"start\":[2,0],\"attrs\":{\"drawing\":{\"anchorVertOffset\":2487,\"anchorHorBase\":\"column\",\"anchorHorOffset\":5372,\"anchorHorAlign\":\"offset\",\"anchorVertAlign\":\"offset\",\"anchorVertBase\":\"paragraph\"}},\"name\":\"setAttributes\"},{\"start\":[2,0],\"attrs\":{\"drawing\":{\"inline\":true}},\"name\":\"setAttributes\"},{\"start\":[2,0],\"attrs\":{\"drawing\":{\"inline\":true}},\"name\":\"setAttributes\"},{\"start\":[2,0],\"attrs\":{\"drawing\":{\"anchorHorOffset\":0,\"textWrapMode\":\"topAndBottom\",\"anchorHorBase\":\"column\",\"inline\":false,\"anchorHorAlign\":\"center\"}},\"name\":\"setAttributes\"},{\"start\":[2,0],\"name\":\"delete\",\"end\":[2,0]},{\"start\":[5,0],\"attrs\":{\"drawing\":{\"anchorHorOffset\":0,\"textWrapMode\":\"square\",\"anchorHorBase\":\"column\",\"inline\":false,\"anchorHorAlign\":\"left\",\"textWrapSide\":\"right\"}},\"name\":\"setAttributes\"},{\"start\":[5,0],\"attrs\":{\"drawing\":{\"anchorHorOffset\":0,\"textWrapMode\":\"square\",\"anchorHorBase\":\"column\",\"inline\":false,\"anchorHorAlign\":\"right\",\"textWrapSide\":\"left\"}},\"name\":\"setAttributes\"},{\"start\":[5,0],\"attrs\":{\"drawing\":{\"inline\":true}},\"name\":\"setAttributes\"}"
            //				+ "{\"start\":[0,21],\"attrs\":{\"drawing\":{\"marginBottom\":317,\"height\":3307,\"marginLeft\":317,\"marginTop\":317,\"imageUrl\":\"Pictures/uid102dced7ccfc.jpg\",\"marginRight\":317,\"width\":3307}},\"name\":\"insertDrawing\",\"type\":\"image\"}"
            //+ "{\"start\":[28,0],\"name\":\"delete\",\"end\":[28,79]},"
            //				+ "{\"start\":[27],\"name\":\"delete\"},"
            //				+ "{\"start\":[26],\"name\":\"delete\"},"
            //				+ "{\"start\":[25],\"name\":\"delete\"},{\"start\":[24],\"name\":\"delete\"},{\"start\":[23],\"name\":\"delete\"},{\"start\":[22],\"name\":\"delete\"},{\"start\":[21],\"name\":\"delete\"},{\"start\":[20],\"name\":\"delete\"},{\"start\":[19],\"name\":\"delete\"},{\"start\":[18],\"name\":\"delete\"},{\"start\":[17],\"name\":\"delete\"},{\"start\":[16],\"name\":\"delete\"},{\"start\":[15],\"name\":\"delete\"},{\"start\":[14],\"name\":\"delete\"},{\"start\":[13],\"name\":\"delete\"},{\"start\":[12],\"name\":\"delete\"},{\"start\":[11],\"name\":\"delete\"},{\"start\":[10],\"name\":\"delete\"},{\"start\":[9],\"name\":\"delete\"},{\"start\":[8],\"name\":\"delete\"},{\"start\":[7],\"name\":\"delete\"},{\"start\":[6],\"name\":\"delete\"},{\"start\":[5],\"name\":\"delete\"},{\"start\":[4],\"name\":\"delete\"},{\"start\":[3],\"name\":\"delete\"},{\"start\":[2],\"name\":\"delete\"},{\"start\":[1],\"name\":\"delete\"},{\"start\":[0,0],\"name\":\"delete\",\"end\":[0,72]},{\"start\":[0],\"name\":\"mergeParagraph\"}"
            + "]";

        editOperations.add(firstEditOperations);
//		super.roundtripOnlyToEmptyDocRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt");
        super.importOnlyRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt", getTestMethodName(), editOperations);
//.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    /**
     * Verified: https://bugs.open-xchange.com/show_bug.cgi?id=26437
     */
    public void nestedHyperlinksTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"text\":\"Empty document\",\"start\":[0,0],\"name\":\"insertText\"},"
            + "{\"styleName\":\"Hyperlink\",\"styleId\":\"Hyperlink\",\"attrs\":{\"character\":{\"color\":{\"value\":\"hyperlink\",\"fallbackValue\":\"0080C0\",\"type\":\"scheme\"},\"underline\":true}},\"name\":\"insertStyleSheet\",\"parent\":null,\"uiPriority\":99,\"type\":\"character\"},"
            + "{\"start\":[0,2],\"attrs\":{\"character\":{\"style\":\"Hyperlink\",\"url\":\"http://www.heise.de\"}},\"name\":\"setAttributes\",\"end\":[0,8]},"
            + "{\"start\":[0,1],\"attrs\":{\"character\":{\"style\":\"Hyperlink\",\"url\":\"http://www.mopo.de\"}},\"name\":\"setAttributes\",\"end\":[0,9]}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    public void listInsertionTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty_as_can_be";
        String firstEditOperations = "["
            + "{\"start\":[0],\"name\":\"insertParagraph\"},"
            + "{\"text\":\"1\",\"start\":[0,0],\"name\":\"insertText\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"●\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"●\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"●\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"●\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"●\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"●\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"●\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"●\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"●\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20000\"},"
            + "{\"styleId\":\"ListParagraph\",\"styleName\":\"List Paragraph\",\"attrs\":{\"paragraph\":{\"indentLeft\":1270,\"nextStyleId\":\"ListParagraph\",\"contextualSpacing\":true}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"uiPriority\":34,\"type\":\"paragraph\"},"
            + "{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20000\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"start\":[0,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"2\",\"start\":[1,0],\"name\":\"insertText\"},"
            + "{\"start\":[1,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"3\",\"start\":[2,0],\"name\":\"insertText\"},"
            + "{\"start\":[2,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"4\",\"start\":[3,0],\"name\":\"insertText\"},"
            + "{\"start\":[3,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"5\",\"start\":[4,0],\"name\":\"insertText\"},"
            + "{\"start\":[4,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"6\",\"start\":[5,0],\"name\":\"insertText\"},"
            + "{\"start\":[5,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"7\",\"start\":[6,0],\"name\":\"insertText\"},"
            + "{\"start\":[6,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"8\",\"start\":[7,0],\"name\":\"insertText\"},"
            + "{\"start\":[7,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"9\",\"start\":[8,0],\"name\":\"insertText\"},"
            + "{\"start\":[8,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"0\",\"start\":[9,0],\"name\":\"insertText\"},"
            + "{\"start\":[9,1],\"name\":\"splitParagraph\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"•\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"•\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"•\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"•\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"•\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"•\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"•\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"•\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"•\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20001\"},"
            + "{\"start\":[1],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20001\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"○\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"○\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"○\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"○\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"○\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"○\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"○\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"○\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"○\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20002\"},"
            + "{\"start\":[2],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20002\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◦\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◦\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◦\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◦\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◦\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◦\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◦\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◦\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◦\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20003\"},"
            + "{\"start\":[3],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20003\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"■\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"■\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"■\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"■\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"■\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"■\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"■\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"■\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"■\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20004\"},"
            + "{\"start\":[4],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20004\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▪\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▪\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▪\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▪\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▪\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▪\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▪\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▪\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▪\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20005\"},"
            + "{\"start\":[5],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20005\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"□\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"□\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"□\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"□\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"□\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"□\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"□\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"□\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"□\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20006\"},"
            + "{\"start\":[6],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20006\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▫\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▫\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▫\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▫\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▫\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▫\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▫\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▫\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"▫\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20007\"},"
            + "{\"start\":[7],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20007\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"♦\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"♦\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"♦\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"♦\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"♦\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"♦\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"♦\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"♦\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"♦\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20008\"},"
            + "{\"start\":[8],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20008\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◊\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◊\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◊\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◊\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◊\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◊\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◊\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◊\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"◊\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20009\"},"
            + "{\"start\":[9],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20009\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"text\":\"a\",\"start\":[10,0],\"name\":\"insertText\"},"
            + "{\"start\":[10,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"b\",\"start\":[11,0],\"name\":\"insertText\"},"
            + "{\"start\":[11,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"c\",\"start\":[12,0],\"name\":\"insertText\"},"
            + "{\"start\":[12,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"d\",\"start\":[13,0],\"name\":\"insertText\"},"
            + "{\"start\":[13,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"e\",\"start\":[14,0],\"name\":\"insertText\"},"
            + "{\"start\":[14,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"f\",\"start\":[15,0],\"name\":\"insertText\"},"
            + "{\"start\":[15,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"g\",\"start\":[16,0],\"name\":\"insertText\"},"
            + "{\"start\":[16,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"h\",\"start\":[17,0],\"name\":\"insertText\"},"
            + "{\"start\":[17,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"i\",\"start\":[18,0],\"name\":\"insertText\"},"
            + "{\"start\":[18,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"j\",\"start\":[19,0],\"name\":\"insertText\"},"
            + "{\"start\":[19,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"k\",\"start\":[20,0],\"name\":\"insertText\"},"
            + "{\"start\":[20,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"l\",\"start\":[21,0],\"name\":\"insertText\"},"
            + "{\"start\":[21,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"m\",\"start\":[22,0],\"name\":\"insertText\"},"
            + "{\"start\":[22,1],\"name\":\"splitParagraph\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"►\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"►\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"►\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"►\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"►\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"►\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"►\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"►\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"►\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20010\"},"
            + "{\"start\":[10],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20010\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\">\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\">\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\">\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\">\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\">\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\">\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\">\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\">\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\">\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20011\"},"
            + "{\"start\":[11],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20011\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"→\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"→\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"→\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"→\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"→\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"→\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"→\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"→\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"→\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20012\"},"
            + "{\"start\":[12],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20012\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"–\",\"indentLeft\":11430,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"–\",\"indentLeft\":8890,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"–\",\"indentLeft\":10160,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"–\",\"indentLeft\":7620,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"–\",\"indentLeft\":6350,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"–\",\"indentLeft\":5080,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"–\",\"indentLeft\":3810,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"–\",\"indentLeft\":2540,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"fontName\":\"Times New Roman\",\"levelText\":\"–\",\"indentLeft\":1270,\"numberFormat\":\"bullet\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L20013\"},"
            + "{\"start\":[13],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L20013\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9\",\"indentLeft\":11430,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7\",\"indentLeft\":8890,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8\",\"indentLeft\":10160,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5\",\"indentLeft\":6350,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4\",\"indentLeft\":5080,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3\",\"indentLeft\":3810,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2\",\"indentLeft\":2540,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30000\"},"
            + "{\"start\":[14],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30000\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30001\"},"
            + "{\"start\":[15],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30001\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9)\",\"indentLeft\":11430,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7)\",\"indentLeft\":8890,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8)\",\"indentLeft\":10160,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6)\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5)\",\"indentLeft\":6350,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4)\",\"indentLeft\":5080,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3)\",\"indentLeft\":3810,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2)\",\"indentLeft\":2540,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1)\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30002\"},"
            + "{\"start\":[16],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30002\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"(%9)\",\"indentLeft\":11430,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"(%7)\",\"indentLeft\":8890,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"(%8)\",\"indentLeft\":10160,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"(%6)\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"(%5)\",\"indentLeft\":6350,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"(%4)\",\"indentLeft\":5080,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"(%3)\",\"indentLeft\":3810,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"(%2)\",\"indentLeft\":2540,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"(%1)\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30003\"},"
            + "{\"start\":[17],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30003\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9\",\"indentLeft\":11430,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8\",\"indentLeft\":10160,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6\",\"indentLeft\":7620,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5\",\"indentLeft\":6350,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4\",\"indentLeft\":5080,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3\",\"indentLeft\":3810,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1\",\"indentLeft\":1270,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30010\"},"
            + "{\"start\":[18],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30010\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30011\"},"
            + "{\"start\":[19],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30011\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9)\",\"indentLeft\":11430,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7)\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8)\",\"indentLeft\":10160,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6)\",\"indentLeft\":7620,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5)\",\"indentLeft\":6350,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4)\",\"indentLeft\":5080,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3)\",\"indentLeft\":3810,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2)\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1)\",\"indentLeft\":1270,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30012\"},"
            + "{\"start\":[20],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30012\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"(%9)\",\"indentLeft\":11430,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"(%7)\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"(%8)\",\"indentLeft\":10160,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"(%6)\",\"indentLeft\":7620,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"(%5)\",\"indentLeft\":6350,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"(%4)\",\"indentLeft\":5080,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"(%3)\",\"indentLeft\":3810,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"(%2)\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"(%1)\",\"indentLeft\":1270,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30013\"},"
            + "{\"start\":[21],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30013\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"text\":\"n\",\"start\":[23,0],\"name\":\"insertText\"},"
            + "{\"start\":[23,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"o\",\"start\":[24,0],\"name\":\"insertText\"},"
            + "{\"start\":[24,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"p\",\"start\":[25,0],\"name\":\"insertText\"},"
            + "{\"start\":[25,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"q\",\"start\":[26,0],\"name\":\"insertText\"},"
            + "{\"start\":[26,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"r\",\"start\":[27,0],\"name\":\"insertText\"},"
            + "{\"start\":[27,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"s\",\"start\":[28,0],\"name\":\"insertText\"},"
            + "{\"start\":[28,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"t\",\"start\":[29,0],\"name\":\"insertText\"},"
            + "{\"start\":[29,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"u\",\"start\":[30,0],\"name\":\"insertText\"},"
            + "{\"start\":[30,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"v\",\"start\":[31,0],\"name\":\"insertText\"},"
            + "{\"start\":[31,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"w\",\"start\":[32,0],\"name\":\"insertText\"},"
            + "{\"start\":[32,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"x\",\"start\":[33,0],\"name\":\"insertText\"},"
            + "{\"start\":[33,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"y\",\"start\":[34,0],\"name\":\"insertText\"},"
            + "{\"start\":[34,1],\"name\":\"splitParagraph\"},"
            + "{\"text\":\"z\",\"start\":[35,0],\"name\":\"insertText\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9\",\"indentLeft\":11430,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7\",\"indentLeft\":8890,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8\",\"indentLeft\":10160,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6\",\"indentLeft\":7620,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5\",\"indentLeft\":6350,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4\",\"indentLeft\":5080,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3\",\"indentLeft\":3810,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2\",\"indentLeft\":2540,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1\",\"indentLeft\":1270,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30020\"},"
            + "{\"start\":[22],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30020\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"right\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"},\"defaultlist\":\"numbering\""
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"right\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"right\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"lowerLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"decimal\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L24\"},"
            + "{\"start\":[23],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L24\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30021\"},"
            + "{\"start\":[23],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30021\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9)\",\"indentLeft\":11430,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7)\",\"indentLeft\":8890,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8)\",\"indentLeft\":10160,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6)\",\"indentLeft\":7620,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5)\",\"indentLeft\":6350,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4)\",\"indentLeft\":5080,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3)\",\"indentLeft\":3810,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2)\",\"indentLeft\":2540,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1)\",\"indentLeft\":1270,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30022\"},"
            + "{\"start\":[24],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30022\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"(%9)\",\"indentLeft\":11430,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"(%7)\",\"indentLeft\":8890,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"(%8)\",\"indentLeft\":10160,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"(%6)\",\"indentLeft\":7620,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"(%5)\",\"indentLeft\":6350,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"(%4)\",\"indentLeft\":5080,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"(%3)\",\"indentLeft\":3810,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"(%2)\",\"indentLeft\":2540,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"(%1)\",\"indentLeft\":1270,\"numberFormat\":\"upperLetter\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30023\"},"
            + "{\"start\":[25],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30023\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9\",\"indentLeft\":11430,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7\",\"indentLeft\":8890,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8\",\"indentLeft\":10160,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6\",\"indentLeft\":7620,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5\",\"indentLeft\":6350,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4\",\"indentLeft\":5080,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3\",\"indentLeft\":3810,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2\",\"indentLeft\":2540,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1\",\"indentLeft\":1270,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30030\"},"
            + "{\"start\":[26],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30030\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30031\"},"
            + "{\"start\":[27],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30031\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9)\",\"indentLeft\":11430,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7)\",\"indentLeft\":8890,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8)\",\"indentLeft\":10160,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6)\",\"indentLeft\":7620,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5)\",\"indentLeft\":6350,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4)\",\"indentLeft\":5080,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3)\",\"indentLeft\":3810,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2)\",\"indentLeft\":2540,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1)\",\"indentLeft\":1270,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30032\"},"
            + "{\"start\":[28],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30032\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"(%9)\",\"indentLeft\":11430,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"(%7)\",\"indentLeft\":8890,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"(%8)\",\"indentLeft\":10160,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"(%6)\",\"indentLeft\":7620,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"(%5)\",\"indentLeft\":6350,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"(%4)\",\"indentLeft\":5080,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"(%3)\",\"indentLeft\":3810,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"(%2)\",\"indentLeft\":2540,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"(%1)\",\"indentLeft\":1270,\"numberFormat\":\"lowerRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30033\"},"
            + "{\"start\":[29],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30033\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9\",\"indentLeft\":11430,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7\",\"indentLeft\":8890,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8\",\"indentLeft\":10160,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6\",\"indentLeft\":7620,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5\",\"indentLeft\":6350,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4\",\"indentLeft\":5080,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3\",\"indentLeft\":3810,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2\",\"indentLeft\":2540,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1\",\"indentLeft\":1270,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30040\"},"
            + "{\"start\":[30],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30040\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9.\",\"indentLeft\":11430,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7.\",\"indentLeft\":8890,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8.\",\"indentLeft\":10160,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6.\",\"indentLeft\":7620,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5.\",\"indentLeft\":6350,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4.\",\"indentLeft\":5080,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3.\",\"indentLeft\":3810,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2.\",\"indentLeft\":2540,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1.\",\"indentLeft\":1270,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30041\"},"
            + "{\"start\":[30],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30041\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"start\":[30],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30040\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"start\":[31],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30041\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"%9)\",\"indentLeft\":11430,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"%7)\",\"indentLeft\":8890,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"%8)\",\"indentLeft\":10160,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"%6)\",\"indentLeft\":7620,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"%5)\",\"indentLeft\":6350,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"%4)\",\"indentLeft\":5080,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"%3)\",\"indentLeft\":3810,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"%2)\",\"indentLeft\":2540,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"%1)\",\"indentLeft\":1270,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30042\"},"
            + "{\"start\":[32],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30042\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"listDefinition\":{\"listLevel8\":{\"listStartValue\":1,\"levelText\":\"(%9)\",\"indentLeft\":11430,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel6\":{\"listStartValue\":1,\"levelText\":\"(%7)\",\"indentLeft\":8890,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel7\":{\"listStartValue\":1,\"levelText\":\"(%8)\",\"indentLeft\":10160,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel5\":{\"listStartValue\":1,\"levelText\":\"(%6)\",\"indentLeft\":7620,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel4\":{\"listStartValue\":1,\"levelText\":\"(%5)\",\"indentLeft\":6350,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel3\":{\"listStartValue\":1,\"levelText\":\"(%4)\",\"indentLeft\":5080,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel2\":{\"listStartValue\":1,\"levelText\":\"(%3)\",\"indentLeft\":3810,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel1\":{\"listStartValue\":1,\"levelText\":\"(%2)\",\"indentLeft\":2540,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}"
            + ",\"listLevel0\":{\"listStartValue\":1,\"levelText\":\"(%1)\",\"indentLeft\":1270,\"numberFormat\":\"upperRoman\",\"indentFirstLine\":-635,\"textAlign\":\"left\"}},\"name\":\"insertListStyle\",\"listStyleId\":\"L30043\"},"
            + "{\"start\":[33],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30043\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"start\":[34],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30000\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"start\":[35],\"attrs\":{\"paragraph\":{\"style\":\"ListParagraph\",\"listStyleId\":\"L30000\""
            + ",\"listLevel\":0}},\"name\":\"setAttributes\"},"
            + "{\"start\":[35],\"attrs\":{\"paragraph\":{\"listLevel\":1}},\"name\":\"setAttributes\"}"
            + "]";
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    //	@Test
//	/**
//	 * Extended: https://bugs.open-xchange.com/show_bug.cgi?id=25250
//	 */
//	public void columnWidthTest() {
//		final String SOURCE_FILE_NAME_TRUNC = "feature_attributes_tables";
//
//		List<String> editOperations = new ArrayList();
//		String firstEditOperations = "["
//				+ "{\"insertMode\":\"behind\",\"start\":[4],\"name\":\"insertColumn\",\"tableGrid\":[20,20,20,20,20],\"gridPosition\":2},"
//				+ "{\"start\":[4],\"attrs\":{\"table\":{\"tableGrid\":[20,20,20,20,20]}},\"name\":\"setAttributes\"},"
//				+ "{\"start\":[4,0,3,0],\"name\":\"insertParagraph\"},{\"text\":\"b\",\"start\":[4,0,3,0,0],\"name\":\"insertText\"},"
//				+ "{\"start\":[4,1,3,0],\"name\":\"insertParagraph\"},{\"text\":\"c\",\"start\":[4,1,3,0,0],\"name\":\"insertText\"},"
//				+ "{\"start\":[4,2,3,0],\"name\":\"insertParagraph\"},{\"text\":\"d\",\"start\":[4,2,3,0,0],\"name\":\"insertText\"},"
//				+ "{\"start\":[4,3,3,0],\"name\":\"insertParagraph\"},{\"text\":\"e\",\"start\":[4,3,3,0,0],\"name\":\"insertText\"},"
//				+ "{\"insertMode\":\"behind\",\"start\":[4],\"name\":\"insertColumn\",\"tableGrid\":[20,20,20,20,20],\"gridPosition\":2},"
//				+ "{\"start\":[4],\"attrs\":{\"table\":{\"tableGrid\":[20,20,20,20,20]}},\"name\":\"setAttributes\"},{\"start\":[4,0,3,0],\"name\":\"insertParagraph\"},"
//				+ "{\"text\":\"b\",\"start\":[4,0,3,0,0],\"name\":\"insertText\"},{\"insertMode\":\"behind\",\"start\":[4],\"name\":\"insertColumn\",\"tableGrid\":[17,17,17,17,17,17],\"gridPosition\":1},"
//				+ "{\"start\":[4],\"attrs\":{\"table\":{\"tableGrid\":[17,17,17,17,17,17]}},\"name\":\"setAttributes\"}"
//				+ "]";
//
//		editOperations.add(firstEditOperations);
////		super.roundtripOnlyToEmptyDocRegressionTest(SOURCE_FILE_NAME_TRUNC, ".odt");
//		super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
//	}
//	@Test
//
//	public void splitTest() {
//
//		final String SOURCE_FILE_NAME_TRUNC = "DUMMY";
//		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
//
//		List<String> editOperations = new ArrayList();
//		String firstEditOperations = "["
//				+ "]";
//		// {"start":[1,22],"name":"splitParagraph"},{"text":"Svante","start":[2,0],"name":"insertText"},{"start":[0,6],"attrs":{"character":{"color":{"value":"C00000","type":"rgb"}}},"name":"setAttributes","end":[0,22]},{"start":[1,0],"attrs":{"character":{"color":{"value":"C00000","type":"rgb"}}},"name":"setAttributes","end":[1,21]},{"start":[2,0],"attrs":{"character":{"color":{"value":"C00000","type":"rgb"}}},"name":"setAttributes","end":[2,4]},{"start":[2,0],"name":"delete","end":[2,3]},{"start":[1],"name":"delete"},{"start":[0,8],"name":"delete","end":[0,22]},{"start":[0],"name":"mergeParagraph"}
//		String secondEditOperations = "["
//				+ "{\"start\":[1,22],\"name\":\"splitParagraph\"},"
////				+ "{\"text\":\"svante\",\"start\":[2,0],\"name\":\"insertText\"},"
//				//+ "{\"start\":[0,6],\"attrs\":{\"character\":{\"color\":{\"value\":\"C00000\",\"type\":\"rgb\"}}},\"name\":\"setAttributes\",\"end\":[0,22]},"
////				+ "{\"start\":[1,0],\"attrs\":{\"character\":{\"color\":{\"value\":\"C00000\",\"type\":\"rgb\"}}},\"name\":\"setAttributes\",\"end\":[1,0]}"
////				+ "{\"start\":[2,0],\"attrs\":{\"character\":{\"color\":{\"value\":\"C00000\",\"type\":\"rgb\"}}},\"name\":\"setAttributes\",\"end\":[2,4]}"
////				+ ","
////				+ "{\"start\":[0,6],\"name\":\"delete\",\"end\":[0,21]}"
//				+ "]";
//		editOperations.add(firstEditOperations);
//		editOperations.add(secondEditOperations);
//		super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, SOURCE_FILE_NAME_SUFFIX, getTestMethodName(), editOperations);
//	}
    @Test
    @Ignore
    /**
     * FIXME: https://bugs.open-xchange.com/show_bug.cgi?id=25248
     */
    public void insertRowAtSecondPosition() {
        final String SOURCE_FILE_NAME_TRUNC = "feature_attributes_tables-backgroundTableOnly";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"count\":1,\"start\":[4,1],\"name\":\"insertRows\",\"insertDefaultCells\":false,\"referenceRow\":0}"
            //				+ "{\"insertMode\":\"behind\",\"start\":[4],\"name\":\"insertColumn\",\"tableGrid\":[20,20,20,20,20],\"gridPosition\":0},{\"start\":[4],\"attrs\":{\"table\":{\"tableGrid\":[20,20,20,20,20]}},\"name\":\"setAttributes\"},{\"start\":[4],\"attrs\":{\"table\":{\"tableGrid\":[25,25,25,25]}},\"name\":\"setAttributes\",\"end\":[4]},{\"start\":[4,0,1],\"name\":\"delete\",\"end\":[4,0,1]},{\"start\":[4,1,1],\"name\":\"delete\",\"end\":[4,1,1]},{\"start\":[4,2,1],\"name\":\"delete\",\"end\":[4,2,1]},{\"start\":[4,3,1],\"name\":\"delete\",\"end\":[4,3,1]},{\"count\":1,\"start\":[4,1],\"name\":\"insertRows\",\"insertDefaultCells\":false,\"referenceRow\":0},{\"start\":[4,1],\"name\":\"delete\"},{\"count\":1,\"start\":[4,1],\"name\":\"insertRows\",\"insertDefaultCells\":false,\"referenceRow\":0}"
            + "]";

        String changeOps = "["
            + //				"{\"startGrid\":0,\"start\":[4],\"name\":\"deleteColumns\",\"endGrid\":0},{\"start\":[4],\"attrs\":{\"table\":{\"tableGrid\":[25,25,25]}},\"name\":\"setAttributes\"}" +
            "]";

        editOperations.add(firstEditOperations);
        editOperations.add(changeOps);

        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    public void tableBackgroundTest() {
        final String SOURCE_FILE_NAME_TRUNC = "empty_as_can_be";
        final String SOURCE_FILE_NAME_SUFFIX = ".odt";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            + "{\"styleId\":\"default_paragraph_style\",\"default\":true,\"hidden\":true,\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontName\":\"Times New Roman\",\"fontNameComplex\":\"Lucida Sans\",\"language\":\"de-DE\",\"fontSize\":12,\"fontNameAsian\":\"SimSun\"}},\"name\":\"insertStyleSheet\",\"type\":\"paragraph\"},{\"styleId\":\"Standard\",\"attrs\":{},\"name\":\"insertStyleSheet\",\"parent\":\"default_paragraph_style\",\"type\":\"paragraph\"},{\"styleName\":\"Text body\",\"styleId\":\"Text_20_body\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":0}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"Caption\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":212},\"character\":{\"fontSizeAsian\":12,\"italicComplex\":true,\"fontNameComplex\":\"Lucida Sans1\",\"italicAsian\":true,\"italic\":true,\"fontSize\":12}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"Index\",\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontNameComplex\":\"Lucida Sans1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"Heading\",\"attrs\":{\"paragraph\":{\"marginBottom\":212,\"marginTop\":423},\"character\":{\"fontSizeAsian\":14,\"fontNameComplex\":\"Lucida Sans\",\"fontName\":\"Arial\",\"fontSize\":14,\"fontNameAsian\":\"SimSun\"}},\"next\":\"Text_20_body\",\"name\":\"insertStyleSheet\",\"parent\":\"Standard\",\"type\":\"paragraph\"},{\"styleId\":\"List\",\"attrs\":{\"character\":{\"fontSizeAsian\":12,\"fontNameComplex\":\"Lucida Sans1\"}},\"name\":\"insertStyleSheet\",\"parent\":\"Text_20_body\",\"type\":\"paragraph\"},{\"attrs\":{\"page\":{\"printOrientation\":\"portrait\",\"marginBottom\":2000,\"indentRight\":2000,\"height\":29700,\"indentLeft\":2000,\"marginTop\":2000,\"marginLeft\":2000,\"numberFormat\":\"1\",\"width\":21001,\"marginRight\":2000}},\"name\":\"setDocumentAttributes\"},{\"fontName\":\"Lucida Sans1\",\"attrs\":{\"family\":\"'Lucida Sans'\",\"familyGeneric\":\"swiss\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Times New Roman\",\"attrs\":{\"family\":\"'Times New Roman'\",\"familyGeneric\":\"roman\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Arial\",\"attrs\":{\"family\":\"Arial\",\"familyGeneric\":\"swiss\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"Lucida Sans\",\"attrs\":{\"family\":\"'Lucida Sans'\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"fontName\":\"SimSun\",\"attrs\":{\"family\":\"SimSun\",\"familyGeneric\":\"system\",\"pitch\":\"variable\"},\"name\":\"insertFontDescription\"},{\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}},\"name\":\"insertParagraph\"},{\"styleName\":\"Table Grid\",\"styleId\":\"TableGrid\",\"attrs\":{\"wholeTable\":{}},\"next\":\"null\",\"name\":\"insertStyleSheet\",\"parent\":\"default_table_style\",\"type\":\"table\"},{\"start\":[1],\"attrs\":{\"table\":{\"fillColor\":{\"value\":\"#4f81bd\",\"type\":\"rgb\"},\"style\":\"a6831c1\",\"tableGrid\":[1000,1000,1000,1000]}},\"name\":\"insertTable\"},{\"start\":[1,0],\"name\":\"insertRows\"},{\"start\":[1,0,0],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,0,1],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,0,2],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,0,3],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,1],\"name\":\"insertRows\"},{\"start\":[1,1,0],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,1,1],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,1,2],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,1,3],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,2],\"name\":\"insertRows\"},{\"start\":[1,2,0],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,2,1],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,2,2],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,2,3],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,3],\"name\":\"insertRows\"},{\"start\":[1,3,0],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,3,1],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,3,2],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,3,3],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,4],\"name\":\"insertRows\"},{\"start\":[1,4,0],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,4,1],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,4,2],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,4,3],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,5],\"name\":\"insertRows\"},{\"start\":[1,5,0],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,5,1],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,5,2],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"},{\"start\":[1,5,3],\"attrs\":{\"cell\":{\"borderTop\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderBottom\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderRight\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2},\"borderLeft\":{\"style\":\"single\",\"color\":{\"value\":\"000000\",\"type\":\"rgb\"},\"width\":2}}},\"name\":\"insertCells\"}"
            + "]";

        String secondEditOperations = "["
            + "{\"start\":[1],\"attrs\":{\"table\":{\"fillColor\":{\"value\":\"text2\",\"fallbackValue\":\"#1f497d\",\"type\":\"scheme\"}}},\"name\":\"setAttributes\"}"
            + "]";
        editOperations.add(firstEditOperations);
        editOperations.add(secondEditOperations);
        super.roundtripRegressionTest(SOURCE_FILE_NAME_TRUNC, SOURCE_FILE_NAME_SUFFIX, getTestMethodName(), editOperations);
    }

//	@Test
//	public void loadBigTest() {
//		final String SOURCE_FILE_NAME_TRUNC = "excelfileformat";
//		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
//
//		List<String> editOperations = new ArrayList();
//		String firstEditOperations = "["
//				//+ ""
//				+ "]";
//		editOperations.add(firstEditOperations);
//		super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, SOURCE_FILE_NAME_SUFFIX, getTestMethodName(), editOperations);
//	}
//	@Test
//	public void notAllCenteredTest() {
//		final String SOURCE_FILE_NAME_TRUNC = "feature_attributes_paragraph_MSO2013";
//		final String SOURCE_FILE_NAME_SUFFIX = ".odt";
//
//		List<String> editOperations = new ArrayList();
//		String firstEditOperations = "["
//				+ "{\"start\":[6,453],\"name\":\"splitParagraph\"},"
//				+ "{\"text\":\"Zwei flinke Boxer jagen die quirlige Eva und ihren Mops durch Sylt. Franz jagt im komplett verwahrlosten Taxi quer durch Bayern. Zwölf Boxkämpfer jagen Viktor quer über den großen Sylter Deich.\",\"start\":[7,0],\"name\":\"insertText\"},"
//				+ "{\"start\":[7,193],\"name\":\"splitParagraph\"},"
//				+ "{\"start\":[8],\"attrs\":{\"paragraph\":{\"style\":\"default_paragraph_style\"}},\"name\":\"setAttributes\"},"
//				+ "{\"text\":\"Vogel Quax zwickt Johnys Pferd Bim. Sylvia wagt quick den Jux bei Pforzheim. Polyfon zwitschernd aßen Mäxchens Vögel Rüben, Joghurt und Quark. \\\"Fix, Schwyz!\",\"start\":[8,0],\"name\":\"insertText\"},"
//				+ "{\"start\":[8,156],\"name\":\"splitParagraph\"},"
//				+ "{\"start\":[9],\"attrs\":{\"paragraph\":{\"style\":\"default_paragraph_style\"}},\"name\":\"setAttributes\"},"
//				+ "{\"text\":\"\\\" quäkt Jürgen blöd vom Paß. Victor jagt zwölf Boxkämpfer quer über den großen Sylter Deich. Falsches Üben von Xylophonmusik quält jeden größeren Zwerg. Heizölrückstoßabdämpfung. Zwei flinke Boxer jagen die quirlige Eva und ihren Mops durch Sylt. Franz jagt im komplett verwahrlosten Taxi quer durch Bayern.\",\"start\":[9,0],\"name\":\"insertText\"}"
//				+ "]";
//		editOperations.add(firstEditOperations);
//		super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, SOURCE_FILE_NAME_SUFFIX, getTestMethodName(), editOperations);
//	}
    @Test
    @Ignore
    public void crazy() {
        final String SOURCE_FILE_NAME_TRUNC = "images";
//		final String SOURCE_FILE_NAME_TRUNC = "WhitespaceTest"; // _SMALL
//		final String SOURCE_FILE_NAME_TRUNC = "DUMMY"; // _SMALL
//		 final String SOURCE_FILE_NAME_TRUNC = "test1"; // problem with whitespace, index start higher than end

        //final String SOURCE_FILE_NAME_TRUNC = "empty_as_can_be";
        //final String SOURCE_FILE_NAME_TRUNC = "a4-hoch-und-quer-SMALL"; //-SMALL
        //final String SOURCE_FILE_NAME_TRUNC = "Tabelle1"; // Probleme mit verrutschten Spans beim Roundtrip!
        //final String SOURCE_FILE_NAME_TRUNC = "FruitDepot-SeasonalFruits4";
        //final String SOURCE_FILE_NAME_TRUNC = "WhitespaceTest";
//		final String SOURCE_FILE_NAME_TRUNC = "TestStyleSelection";
        //finnal String SOURCE_FILE_NAME_TRUNC = "feature_attributes_tables";
        String firstEditOperations = "["
            + //				"{\"startGrid\":0,\"start\":[4],\"name\":\"deleteColumns\",\"endGrid\":0},{\"start\":[4],\"attrs\":{\"table\":{\"tableGrid\":[25,25,25]}},\"name\":\"setAttributes\"}" +
            //"{\"name\":\"insertParagraph\",\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"Default_20_Text\"},\"character\":{\"fontSizeAsian\":18,\"fontSize\":18}}},\n" +
            //"{\"text\":\"Effect  Effect  Effect Effect \",\"start\":[0,0],\"name\":\"insertText\"},\n" +
            ////"{\"name\":\"setAttributes\",\"start\":[0,0],\"end\":[0,7],\"attrs\":{\"character\":{\"italicComplex\":false,\"boldComplex\":false,\"italic\":false,\"boldAsian\":false,\"bold\":false,\"italicAsian\":false}}},\n" +
            ////"{\"name\":\"setAttributes\",\"start\":[0,8],\"end\":[0,13],\"attrs\":{\"character\":{\"italicComplex\":true,\"boldComplex\":false,\"italic\":true,\"boldAsian\":false,\"bold\":false,\"italicAsian\":true}}},\n" +
            //"{\"name\":\"setAttributes\",\"start\":[0,15],\"end\":[0,15],\"attrs\":{\"character\":{\"italicComplex\":false,\"boldComplex\":false,\"italic\":false,\"boldAsian\":false,\"bold\":false,\"italicAsian\":false}}},\n" +
            //"{\"name\":\"setAttributes\",\"start\":[0,16],\"end\":[0,21],\"attrs\":{\"character\":{\"italicComplex\":false,\"boldComplex\":true,\"italic\":false,\"boldAsian\":true,\"bold\":true,\"italicAsian\":false}}},\n" +
            //"{\"name\":\"setAttributes\",\"start\":[0,23],\"end\":[0,28],\"attrs\":{\"character\":{\"italicComplex\":true,\"boldComplex\":true,\"italic\":true,\"boldAsian\":true,\"bold\":true,\"italicAsian\":true}}}," +
            //				"{\"name\":\"insertDrawing\",\"type\":\"image\",\"start\":[0],\"attrs\":{\"drawing\":{\"marginTop\":0,\"marginBottom\":0,\"style\":\"Graphics\",\"width\":5078,\"height\":1083,\"name\":\"fruitdepot\",\"anchorHorBase\":\"page\",\"anchorVertBase\":\"page\",\"imageUrl\":\"Pictures/100002010000012C00000040F176124D.png\"}}},\n" +
            //"{\"attrs\":{\"page\":{\"height\":27940,\"numberFormat\":\"1\",\"marginLeft\":2540,\"indentLeft\":2540,\"marginTop\":2540,\"marginRight\":2540,\"indentRight\":2540,\"marginBottom\":2540,\"printOrientation\":\"portrait\",\"width\":21590}},\"name\":\"setDocumentAttributes\"},\n" +
            //"{\"name\":\"insertParagraph\",\"start\":[1],\"attrs\":{\"paragraph\":{\"style\":\"Title\"},\"character\":{\"fontName\":\"Arial1\"}}},\n" +
            //"{\"text\":\"Se\",\"start\":[1,0],\"name\":\"insertText\"}," +
            //				"{\"text\":\"X\",\"start\":[0,7],\"name\":\"insertText\"},\n" +
            //				+ "{\"name\":\"insertParagraph\",\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}},\n"
            //				+ "{\"text\":\" 0 2  5 \",\"start\":[0,0],\"name\":\"insertText\"},\n"
            //				+ "{\"name\":\"insertHardBreak\",\"start\":[0,7]},\n"
            //+ "{\"text\":\"8 \",\"start\":[0,8],\"name\":\"insertText\"}"
            //+				"{\"name\":\"insertParagraph\",\"start\":[0],\"attrs\":{\"paragraph\":{\"style\":\"Standard\"}}},{\"text\":\"New   \\n\\t\\t\\t\\t\",\"start\":[0,0],\"name\":\"insertText\"},\n" +
            //"{\"text\":\"\\n\\t\\t\\t\\t\\t\\n\\t\\t\\t\\t\\t\\t\",\"start\":[0,11],\"name\":\"insertText\"},\n" +
            //"{\"name\":\"insertParagraph\",\"start\":[0,24],\"attrs\":{\"paragraph\":{}}},\n" +
            //"{\"text\":\"FRAME  \\n\\t\\t\\t\\t\\t\\t\",\"start\":[0,24,0],\"name\":\"insertText\"},\n" +
            //"{\"text\":\"\\n\\t\\t\\t\\t\\t\\n\\t\\t\\t\\t\",\"start\":[0,25],\"name\":\"insertText\"}," +
            //				"{\"styleId\":\"TableGrid\",\"styleName\":\"Table Grid\",\"attrs\":{\"wholeTable\":{\"paragraph\":{\"lineHeight\":{\"value\":100,\"type\":\"percent\"}},\"table\":{\"borderInsideVert\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderTop\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderInsideHor\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderBottom\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderLeft\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17},\"borderRight\":{\"style\":\"single\",\"color\":{\"type\":\"auto\"},\"width\":17}}},\"next\":null},\"name\":\"insertStyleSheet\",\"uiPriority\":59,\"type\":\"table\"},"+
            //				"{\"start\":[0],\"attrs\":{\"table\":{\"style\":\"TableGrid\",\"tableGrid\":[1000,1000,1000],\"width\":\"auto\",\"exclude\":[\"lastRow\",\"lastCol\",\"bandsVert\"]}},\"name\":\"insertTable\"},"+
            //				"{\"count\":2,\"start\":[0,0],\"name\":\"insertRows\",\"insertDefaultCells\":true}" +
            "]";

        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, "", firstEditOperations);
    }

    @Test
    @Ignore
    public void markStyle() {
        final String SOURCE_FILE_NAME_TRUNC = "empty_as_can_be";

        String firstEditOperations = "["
            + "{\"name\":\"insertParagraph\",\"start\":[0],\"attrs\":{\"paragraph\":{}}},"
            + "{\"text\":\"1\",\"start\":[0,0],\"name\":\"insertText\"},"
            + "{\"text\":\"2\",\"start\":[0,1],\"name\":\"insertText\"},"
            + "{\"name\":\"insertHardBreak\",\"start\":[0,2]},"
            + "{\"text\":\"3\",\"start\":[0,3],\"name\":\"insertText\"},"
            + "{\"text\":\"4\",\"start\":[0,4],\"name\":\"insertText\"},"
            + "{\"name\":\"setAttributes\",\"start\":[0,1],\"end\":[0,3],\"attrs\":{\"character\":{\"fontSize\":16,\"fontNameComplex\":\"Cumberland\",\"fontName\":\"Cumberland\",\"fontNameAsian\":\"Cumberland\"}}}"
            + "]";

        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    public void edit() {
        //final String SOURCE_FILE_NAME_TRUNC = "a4-hoch-und-quer-SMALL";
        //final String SOURCE_FILE_NAME_TRUNC = "imageReplacements";
        //final String SOURCE_FILE_NAME_TRUNC = "frame";
        // final String SOURCE_FILE_NAME_TRUNC = "emptySpan";
        final String SOURCE_FILE_NAME_TRUNC = "textLineBreakText";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            //				+ "{\"startGrid\":2,\"start\":[2],\"name\":\"deleteColumns\",\"endGrid\":2},"
            //				+ "{\"start\":[2],\"attrs\":{\"table\":{\"tableGrid\":[25,25,25]}},\"name\":\"setAttributes\"}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), editOperations);
    }

    @Test
    @Ignore
    // TestMe:
    public void missingImageList() {
        final String SOURCE_FILE_NAME_TRUNC = "feature_bullets_numbering";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            //				+ "{\"startGrid\":2,\"start\":[2],\"name\":\"deleteColumns\",\"endGrid\":2},"
            //				+ "{\"start\":[2],\"attrs\":{\"table\":{\"tableGrid\":[25,25,25]}},\"name\":\"setAttributes\"}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }

    @Test
    @Ignore
    // TestMe:
    public void repeatedColumnAndRow() {
        final String SOURCE_FILE_NAME_TRUNC = "OOStyledTable";

        List<String> editOperations = new ArrayList();
        String firstEditOperations = "["
            //				+ "{\"startGrid\":2,\"start\":[2],\"name\":\"deleteColumns\",\"endGrid\":2},"
            //				+ "{\"start\":[2],\"attrs\":{\"table\":{\"tableGrid\":[25,25,25]}},\"name\":\"setAttributes\"}"
            + "]";

        editOperations.add(firstEditOperations);
        super.roundtripRegressionTextTest(SOURCE_FILE_NAME_TRUNC, getTestMethodName(), firstEditOperations);
    }
}
