/*
 * Copyright 2014 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.odftoolkit.odfdom.component;

import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.pkg.OdfElement;

/**
 *
 * @author svante.schubert AT gmail DOT com
 */
public interface TableChange {
	/** Effects the tableElement provided as first parameter, e.g. format, insert, delete
	 * @param tableChildElement - might be either a column, row or a cell.
	 * @param nextElement - the following element to be analyzed
	 * @param rowStartNo
	 * @param rowEndNo
	 * @param currentRowNo
	 * @param columnStartNo
	 * @param columnEndNo
	 * @param currentColumnNo
	 * @param change
	 * @param args the number and type of the arguments depends on the concrete implementation
	 * @return  the type of objects depends on the concrete implementation*/
	public Object execute(OdfStylableElement tableChildElement, OdfElement nextElement, int rowStartNo, int rowEndNo, int currentRowNo, int columnStartNo, int columnEndNo, int currentColumnNo, TableChange change, Object... args);
	/** An action should declare if XML column elements are effected.
	 * @return if changes effects one or more columns */
	public boolean effectsColumns();
	/** An action should declare if XML row elements are effected.
	 * @return if changes effects one or more rows */
	public boolean effectsRows();
	/** An action should declare if XML cell elements are effected.
	 * @return if changes effects one or more cells */
	public boolean effectsCells();

    /** An action should declare if columns are to be deleted */
    public boolean isColumnDeletion();

	/** Starts the change on the last position of the given table traversal */
	public void start();

    public void setColumnStart(int columnStartNo);

    public void setColumnEnd(int columnEndNo);

    public void setRowStart(int rowStartNo);

    public void setRowEnd(int rowEndNo);
}
