/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the Open-Xchange, Inc. group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2004-2012 Open-Xchange, Inc.
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.office.calcengine.client.impl;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openexchange.office.calcengine.client.CalcEngineClipBoardEvent;
import com.openexchange.office.calcengine.client.CalcEngineHandleGenerator;
import com.openexchange.office.calcengine.client.ECalcEngineError;
import com.openexchange.office.calcengine.client.ICalcEngineClient;
import com.openexchange.office.tools.logging.ELogLevel;
import com.openxchange.office_communication.jms.core.plain.EErrorCode;
import com.openxchange.office_communication.jms.core.plain.JMSClientBase;
import com.openxchange.office_communication.office.jms.messages.CalcEngineMessageBean;
import com.openxchange.office_communication.office.jms.messages.ECalcEngineMethod;

//=============================================================================
/** Run the calc engine in 'client JMS' mode.
 */
public class CalcEngineClientJMS extends    JMSClientBase
								 implements ICalcEngineClient
{
	//-------------------------------------------------------------------------
	private static final Logger LOG = LoggerFactory.getLogger(CalcEngineClientJMS.class);
	
	//-------------------------------------------------------------------------
	private CalcEngineClientJMS ()
	    throws Exception
	{}

	//-------------------------------------------------------------------------
	public synchronized static CalcEngineClientJMS create(final String sOutQueue)
	    throws Exception
	{
		CalcEngineClientJMS aInst = new CalcEngineClientJMS ();
	  	aInst.setFullQualifiedRequestQueue(sOutQueue);
	  	return aInst;
	}

	//-------------------------------------------------------------------------
	@Override
	public String createDocument()
		throws Exception
	{
    	LOG.debug ("create document ...");
    	
    	final String                sDocHandle = CalcEngineHandleGenerator.newHandle();
    	final CalcEngineMessageBean aRequest   = new CalcEngineMessageBean();
    	aRequest.setMethod   (ECalcEngineMethod.E_CREATE_DOCUMENT);
    	aRequest.setDocHandle(sDocHandle);
    	
    	final CalcEngineMessageBean aResponse = super.requestSynchronous(aRequest);
    	
    	final EErrorCode eResult = aResponse.getErrorCode();
    	if (eResult != EErrorCode.E_OK)
    		throw new Exception ("failed with result : "+eResult);
    	
    	LOG.debug ("... document with handle '"+sDocHandle+"' created.");
    	return sDocHandle;
	}

	//-------------------------------------------------------------------------
	@Override
	public void destroyDocument(final String sDocHandle)
		throws Exception
	{
    	LOG.debug ("destroy document ...");
    	
    	final CalcEngineMessageBean aRequest = new CalcEngineMessageBean();
    	aRequest.setMethod   (ECalcEngineMethod.E_DESTROY_DOCUMENT);
    	aRequest.setDocHandle(sDocHandle);
    	
    	final CalcEngineMessageBean aResponse = super.requestSynchronous(aRequest);
    	
    	final EErrorCode eResult = aResponse.getErrorCode();
    	if (eResult != EErrorCode.E_OK)
    		throw new Exception ("failed with result : "+eResult);
    	
    	LOG.debug ("... document with handle '"+sDocHandle+"' destroyed.");
	}

	//-------------------------------------------------------------------------
	@Override
	public ECalcEngineError executeOperation(final String       sDocHandle    ,
											 final String       sOperationJSON,
											 final StringBuffer sResultJSON   )
		throws Exception
	{
    	LOG.debug ("execute operation ...");
    	
    	final CalcEngineMessageBean aRequest = new CalcEngineMessageBean();
    	aRequest.setMethod   (ECalcEngineMethod.E_EXECUTE_OPERATION);
    	aRequest.setDocHandle(sDocHandle);
    	aRequest.setBody     (sOperationJSON);
    	
    	final CalcEngineMessageBean aResponse = super.requestSynchronous(aRequest);
    	
    	final EErrorCode eResult = aResponse.getErrorCode();
    	if (eResult != EErrorCode.E_OK)
    		throw new Exception ("failed with result : "+eResult);
    	
    	final String sResult = aResponse.getBody();
    	if (StringUtils.isEmpty(sResult))
    		throw new Exception ("no result JSON ?!");
    	sResultJSON.append (sResult);
    	
    	LOG.debug ("... operation executed at doc '"+sDocHandle+"'.");
    	return ECalcEngineError.E_NONE;
	}

	//-------------------------------------------------------------------------
	@Override
	public ECalcEngineError restoreDocument(final String    sDocHandle          ,
											final String... lPagedOperationJSONs)
		throws Exception
	{
		throw new UnsupportedOperationException("not implemented yet");
	}

	//-------------------------------------------------------------------------
	@Override
	public ECalcEngineError copy(final String                   sSourceDocHandle,
								 final CalcEngineClipBoardEvent aEvent          )
		throws Exception
	{
		throw new UnsupportedOperationException("not implemented yet");
	}

	//-------------------------------------------------------------------------
	@Override
	public ECalcEngineError paste(final String                   sTargetDocHandle,
								  final CalcEngineClipBoardEvent aEvent          )
		throws Exception
	{
		throw new UnsupportedOperationException("not implemented yet");
	}

	//-------------------------------------------------------------------------
	@Override
	public String getVersion()
		throws Exception
	{
		throw new UnsupportedOperationException("not implemented yet");
	}

	//-------------------------------------------------------------------------
	@Override
	public void setLogLevel(final ELogLevel eLevel)
		throws Exception
	{
		throw new UnsupportedOperationException("not implemented yet");
	}
}
