/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/spreadsheet/utils/config',
    ['io.ox/office/tk/utils',
     'io.ox/office/editframework/utils/editconfig',
     'settings!io.ox/office'
     ], function (Utils, EditConfig, settings) {

    'use strict';

    var // the configuration items of the spreadsheet module
        moduleConfig = settings.get('spreadsheet', {});

    // static class SpreadsheetConfig =========================================

    var SpreadsheetConfig = _.clone(EditConfig);

    /**
     * The configured maximum number of non-empty cells allowed to be contained
     * in a complete spreadsheet document.
     *
     * @constant
     */
    SpreadsheetConfig.MAX_CELL_COUNT = Utils.getIntegerOption(moduleConfig, 'maxCells', 500000);

    /**
     * The configured maximum number of sheets allowed to be contained in a
     * spreadsheet document.
     *
     * @constant
     */
    SpreadsheetConfig.MAX_SHEET_COUNT = Utils.getIntegerOption(moduleConfig, 'maxSheets', 256);

    // exports ================================================================

    return SpreadsheetConfig;

});
