/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/axistitlemodel',
    ['io.ox/office/editframework/model/attributedmodel'
    ], function (AttributedModel) {

    'use strict';

    // class AxisTitleModel ===================================================

    /**
     * visualization model for chart axes,
     * it defines colors and textual colors
     */
    function AxisTitleModel(chart) {

        // base constructor ---------------------------------------------------

        AttributedModel.call(this, chart.getApp(), {}, { additionalFamilies: ['text', 'character'] });

    } // class AxisTitleModel

    // exports ================================================================
    return AttributedModel.extend({ constructor: AxisTitleModel });

});
