/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

define('io.ox/office/portal/collection/documentcollection',
    ['io.ox/office/portal/model/documentmodel'],
    function (DocumentModel) {

    'use strict';

    var documentCollection = Backbone.Collection.extend({

        model : DocumentModel,

        setData: function (recentsArray) {

            var self = this;

            // populate the collection with recent documents
            _.each(recentsArray, function (recentDocument) {
                self.add(new DocumentModel(recentDocument), {merge: true});
            });

        }

    });

    return documentCollection;

});