/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/portal/action/toolbaractionsspreadsheet',
    ['gettext!io.ox/office/portal',
        'io.ox/core/folder/api',
        'io.ox/core/extensions',
        'io.ox/core/extPatterns/links',
        'io.ox/backbone/mini-views/dropdown',
        'io.ox/office/portal/portalutils',
        'io.ox/core/capabilities'
    ], function (gt, FolderAPI, Ext, Links, Dropdown, PortalUtils) {

        'use strict';

        /**
         * Creates all extensions points and bind actions for the portal toolbar.
         *
         * @constructor
         *
         */
        var ToolbarActionsSpreadsheet = function () {

            var // identifier for the spreadsheet toolbar
                toolbarPointId = 'io.ox/office/portal/toolbarspreadsheet',
                // the name of the application, used for filtering files in file picker
                appBaseName = 'spreadsheet';

            this.toolbarPoint = Ext.point(toolbarPointId);

            // create extension point for the 'new spreadsheet' link
            Ext.point(toolbarPointId + '/new').extend(new Links.Link({
                id: 'new_spreadsheet',
                index: 100,
                prio: 'hi',
                label: gt('New Spreadsheet'),
                cssClasses: 'new-document',
                ref: toolbarPointId + '/actions/new/spreadsheet'
            }));

            // add link to the toolbar point
            this.toolbarPoint.extend({
                id: 'new-spreadsheetdocument',
                index: 100,
                draw: function (baton) {
                    Ext.point(toolbarPointId + '/new').invoke('draw', this, baton);
                }
            });

            //add open document link to  the toolbar point
            this.toolbarPoint.extend(new Links.Link({
                id: 'open-spreadsheetdocument',
                index: 200,
                prio: 'hi',
                label: gt('Open Spreadsheet'),
                cssClasses: 'open-document',
                ref: 'io.ox/office/portal/openspreadsheet'
            }));

            // define action that will be fired on the 'new spreadsheet', 'new text' and 'open document' link
            new Links.Action(toolbarPointId + '/actions/new/spreadsheet', {
                capabilities: 'spreadsheet',
                action: function (baton) {
                    ox.launch('io.ox/office/spreadsheet/main', { action: 'new', folderId: baton.app.folder.get() });
                }
            });

            new Links.Action('io.ox/office/portal/openspreadsheet', {
                action: function () {
                    require(['io.ox/files/filepicker']).done(function (Picker) {
                        new Picker({
                            // prefix for custom ext. point
                            point: 'io.ox/office/portal/toolbar/open',
                            // filter files of disabled applications (capabilities)
                            filter: function (file) {
                                return appBaseName === PortalUtils.getAppBaseName(file.filename);
                            },
                            primaryButtonText: gt('Open'),
                            cancelButtonText: gt('Cancel'),
                            header: gt('Open document'),
                            multiselect: false,
                            tree: {
                                // filter deleted files folder
                                filter: function (parent, model) {
                                    if (FolderAPI.is('trash', model.toJSON())) { return false; }
                                }
                            }
                        })
                        .done(function (files) {
                            // get single file in array (multiselect false)
                            if (files && files[0]) {
                                var selectedFile = files[0],
                                    moduleName = PortalUtils.getModuleName(selectedFile.filename);
                                ox.launch(moduleName + '/main', { action: 'load', file: selectedFile });
                            }
                        });
                    });
                }
            });

        };

        return new ToolbarActionsSpreadsheet();

    });
