/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/editframework/utils/editconfig', ['io.ox/office/tk/config'], function (Config) {

    'use strict';

    // static class EditConfig ================================================

    var EditConfig = _.clone(Config);

    /**
     * A Boolean flag specifying whether the local browser storage will be used
     * for saving documents.
     *
     * @constant
     */
    EditConfig.USE_LOCAL_STORAGE = EditConfig.getFlag('useLocalStorage', true);

    /**
     * A Boolean flag specifying whether the current selection of remote users
     * will be displayed in all OX Documents edit applications.
     *
     * @constant
     */
    EditConfig.SHOW_REMOTE_SELECTIONS = EditConfig.getFlag('showRemoteSelections', true);

    /**
     * A Boolean flag specifying whether detailed performance data will be sent
     * to and logged at the server.
     *
     * @constant
     */
    EditConfig.LOG_PERFORMANCE_DATA = EditConfig.getFlag('logPerformanceData', false);

    /**
     * A Boolean flag specifying whether the error and other important data
     * for bug hunting will be sent to and logged by the server.
     *
     * @constant
     */
    EditConfig.LOG_ERROR_DATA = EditConfig.getFlag('logErrorData', false);

    // exports ================================================================

    return EditConfig;

});
