/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com
 *
 * @author Stefan Eckert <stefan.eckert@open-xchange.com>
 */

define('io.ox/office/spreadsheet/model/drawing/legendmodel',
    ['io.ox/office/drawinglayer/view/chartstyleutil',
     'io.ox/office/editframework/model/attributedmodel'
    ], function (ChartStyleUtil, AttributedModel) {

    'use strict';

    // class LegendModel ======================================================

    function LegendModel(chart, attrs, dataLegend) {
        var self = this;
        // base constructor ---------------------------------------------------

        AttributedModel.call(this, chart.getApp(), attrs, { additionalFamilies: ['legend', 'character'] });

        // methods ------------------------------------------------------------

        this.refreshInfo = function () {
            var att = self.getMergedAttributes();
            var legendPos = att.legend.pos;
            switch (legendPos) {
            case 'bottom':
            case 'top':
                dataLegend.verticalAlign = legendPos;
                dataLegend.horizontalAlign = 'center';
                break;
            case 'left':
            case 'right':
                dataLegend.verticalAlign = 'center';
                dataLegend.horizontalAlign = legendPos;
                break;
            case 'topRight':
                dataLegend.verticalAlign = 'top';
                dataLegend.horizontalAlign = 'right';
                break;
            }

            if (legendPos !== 'off') {
                ChartStyleUtil.handleCharacterProps(chart, att.character, dataLegend);
            }
        };


    } // class LegendModel

    // exports ================================================================
    return AttributedModel.extend({ constructor: LegendModel });

});
