/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2014 Open-Xchange Inc., Tarrytown, NY, USA. info@open-xchange.com
 *
 * @author Edy Haryono <edy.haryono@open-xchange.com>
 */

/**
 *  Defines extensions and actions of the recent documents pane
 */
define('io.ox/office/portal/action/recentsactions',
    ['io.ox/core/extensions',
     'io.ox/core/extPatterns/links',
     'io.ox/core/extPatterns/actions',
     'io.ox/office/portal/portalutils'],
function (Ext, Links, CoreActions, PortalUtils) {

    'use strict';


    var RecentsExtensions = function () {

        var recentDocumentExtension = 'io.ox/portal/office/recents/document';

        this.documentPoint = Ext.point(recentDocumentExtension);

        new Links.Action(recentDocumentExtension + '/open', {

            action: function (baton) {
                var appModuleName = PortalUtils.getModuleName(baton.data.filename);
                ox.launch(appModuleName + '/main', { action: 'load', file: baton.data });
            }

        });

        this.documentPoint.extend({

            id: 'recent_document',

            draw: function (baton) {

                var link = $('<a>').addClass('document-link row')
                    .attr({
                        'data-toggle': 'tooltip',
                        'data-placement': 'top',
                        'title': baton.data.filename,
                        'tabindex': 0
                    }),
                    metadata = $('<div>').addClass('document-metadata'),
                    name = $('<div>').addClass('document-name col-xs-8'),
                    date = $('<div>').addClass('document-date col-xs-4')
                        .text(PortalUtils.formatDate(baton.data.last_modified ? baton.data.last_modified : baton.data.last_opened));

                // enable Bootstrap tooltip except for touch devices, since it is buggy (see https://github.com/twbs/bootstrap/issues/6232)
                if (!Modernizr.touch) { link.tooltip(); }

                name.append(PortalUtils.createDocumentIcon(baton.data.filename), $('<div>').text(baton.data.filename));
                link.append(metadata.append(name, date));

                link.click(function () {
                    CoreActions.invoke(recentDocumentExtension + '/open', this, baton);
                });

                link.on('keydown', PortalUtils.keydownHandler);

                this.append(link);
            }

        });

    };

    return new RecentsExtensions();

});