Name:           open-xchange-documents-ui
BuildArch:      noarch
BuildRequires:  ant
BuildRequires:  ant-nodeps
BuildRequires:  java-devel >= 1.6.0
BuildRequires:  nodejs >= 0.10.0
Version:        7.6.1
%define         ox_release 9
Release:        %{ox_release}_<CI_CNT>.<B_CNT>
Group:          Applications/Productivity
Vendor:         Open-Xchange
URL:            http://www.open-xchange.com
Packager:       Daniel Rentz <daniel.rentz@open-xchange.com>
License:        CC-BY-NC-SA-3.0
Summary:        OX Documents
Source:         %{name}_%{version}.orig.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-root

Requires:       open-xchange-documents-ui-viewer
Requires:       open-xchange-documents-ui-editors

%description
Meta package for all Open-Xchange Documents web applications


%if 0%{?rhel_version} || 0%{?fedora_version}
%define docroot /var/www/html/
%else
%define docroot /srv/www/htdocs/
%endif

%package common
Group:          Applications/Productivity
Summary:        OX Viewer
Conflicts:      open-xchange-appsuite-manifest < 7.4.1
Conflicts:      open-xchange-appsuite-l10n-en-us < 7.4.1
Requires:       open-xchange-appsuite-manifest

%description common
Common code for all Open-Xchange Documents web applications


%package viewer
Group:          Applications/Productivity
Summary:        OX Viewer
Requires:       open-xchange-documents-ui-common

%description viewer
The Open-Xchange Viewer web application


%package editors
Group:          Applications/Productivity
Summary:        OX Documents editors
Requires:       open-xchange-documents-backend
Requires:       open-xchange-documents-ui-common

%description editors
The Open-Xchange Documents editor applications


%package static
Group:          Applications/Productivity
Summary:        OX Documents
Requires:       open-xchange-appsuite

%description static
The Open-Xchange Documents

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -Dhtdoc=%{docroot} -DkeepCache=true -f build/build.xml build

%clean
%{__rm} -rf %{buildroot}

%define update /opt/open-xchange/appsuite/share/update-themes.sh
%define touch /opt/open-xchange/sbin/touch-appsuite

%post common
if [ -x %{update} ]; then %{update}; fi

%postun common
if [ -x %{update} ]; then %{update}; fi

%post viewer
if [ -x %{update} ]; then %{update}; fi

%postun viewer
if [ -x %{update} ]; then %{update}; fi

%post editors
if [ -x %{update} ]; then %{update}; fi

%postun editors
if [ -x %{update} ]; then %{update}; fi

%files
%defattr(-,root,root)
%doc ui/README

%files common
%defattr(-,root,root)
%dir /opt/open-xchange
/opt/open-xchange/appsuite
%exclude /opt/open-xchange/appsuite/apps/io.ox/office/preview
%exclude /opt/open-xchange/appsuite/apps/io.ox/office/editframework
%exclude /opt/open-xchange/appsuite/apps/io.ox/office/drawinglayer
%exclude /opt/open-xchange/appsuite/apps/io.ox/office/text
%exclude /opt/open-xchange/appsuite/apps/io.ox/office/spreadsheet
%exclude /opt/open-xchange/appsuite/apps/io.ox/office/presentation
%exclude /opt/open-xchange/appsuite/manifests

%files viewer
%defattr(-,root,root)
/opt/open-xchange/appsuite/apps/io.ox/office/preview
%dir /opt/open-xchange/appsuite/manifests
/opt/open-xchange/appsuite/manifests/open-xchange-documents-ui-viewer.json

%files editors
%defattr(-,root,root)
/opt/open-xchange/appsuite/apps/io.ox/office/editframework
/opt/open-xchange/appsuite/apps/io.ox/office/drawinglayer
/opt/open-xchange/appsuite/apps/io.ox/office/text
/opt/open-xchange/appsuite/apps/io.ox/office/spreadsheet
/opt/open-xchange/appsuite/apps/io.ox/office/presentation
%dir /opt/open-xchange/appsuite/manifests
/opt/open-xchange/appsuite/manifests/open-xchange-documents-ui-editors.json

%files static
%defattr(-,root,root)
%dir %{docroot}/appsuite
%dir %{docroot}/appsuite/apps
%dir %{docroot}/appsuite/apps/io.ox
%{docroot}/appsuite/apps/io.ox/office
%dir %{docroot}/appsuite/apps/themes
%dir %{docroot}/appsuite/apps/themes/default
%dir %{docroot}/appsuite/apps/themes/default/io.ox
%{docroot}/appsuite/apps/themes/default/io.ox/office

%changelog
* Tue Nov 04 2014 Markus Wagner <markus.wagner@open-xchange.com>
Ninth candidate for 7.6.1 release
* Thu Oct 30 2014 Markus Wagner <markus.wagner@open-xchange.com>
Eighth candidate for 7.6.1 release
* Mon Oct 27 2014 Markus Wagner <markus.wagner@open-xchange.com>
Seventh candidate for 7.6.1 release
* Tue Oct 21 2014 Markus Wagner <markus.wagner@open-xchange.com>
Sixth candidate for 7.6.1 release
* Tue Oct 14 2014 Markus Wagner <markus.wagner@open-xchange.com>
Fifth candidate for 7.6.1 release
* Fri Oct 10 2014 Markus Wagner <markus.wagner@open-xchange.com>
Fourth candidate for 7.6.1 release
* Thu Oct 02 2014 Markus Wagner <markus.wagner@open-xchange.com>
Third candidate for 7.6.1 release
* Tue Sep 16 2014 Markus Wagner <markus.wagner@open-xchange.com>
Second candidate for 7.6.1 release
* Wed Sep 10 2014 Markus Wagner <markus.wagner@open-xchange.com>
First candidate for 7.6.1 release
* Mon Sep 08 2014 Markus Wagner <markus.wagner@open-xchange.com>
prepare for 7.6.1
* Mon Jun 23 2014 Markus Wagner <markus.wagner@open-xchange.com>
Seventh candidate for 7.6.0 release
* Fri Jun 20 2014 Markus Wagner <markus.wagner@open-xchange.com>
Sixth candidate for 7.6.0 release
* Fri Jun 13 2014 Markus Wagner <markus.wagner@open-xchange.com>
Fifth candidate for 7.6.0 release
* Fri May 30 2014 Markus Wagner <markus.wagner@open-xchange.com>
Fourth candidate for 7.6.0 release
* Fri May 16 2014 Markus Wagner <markus.wagner@open-xchange.com>
Third candidate for 7.6.0 release
* Mon May 05 2014 Markus Wagner <markus.wagner@open-xchange.com>
Second candidate for 7.6.0 release
* Fri Apr 25 2014 Markus Wagner <markus.wagner@open-xchange.com>
First candidate for 7.6.0 release
* Wed Feb 26 2014 Markus Wagner <markus.wagner@open-xchange.com>
First candidate for 7.4.2 spreadsheet release
* Wed Feb 12 2014 Markus Wagner <markus.wagner@open-xchange.com>
prepare for 7.6.0
* Fri Feb 07 2014 Markus Wagner <markus.wagner@open-xchange.com>
Sixth candidate for 7.4.2 release
* Thu Feb 06 2014 Markus Wagner <markus.wagner@open-xchange.com>
Fifth candidate for 7.4.2 release
* Tue Feb 04 2014 Markus Wagner <markus.wagner@open-xchange.com>
Fourth candidate for 7.4.2 release
* Tue Jan 28 2014 Markus Wagner <markus.wagner@open-xchange.com>
Build for patch 2014-01-30
* Thu Jan 23 2014 Markus Wagner <markus.wagner@open-xchange.com>
Third candidate for 7.4.2 release
* Fri Jan 10 2014 Markus Wagner <markus.wagner@open-xchange.com>
Second candidate for 7.4.2 release
* Mon Dec 23 2013 Markus Wagner <markus.wagner@open-xchange.com>
First candidate for 7.4.2 release
* Thu Dec 19 2013 Markus Wagner <markus.wagner@open-xchange.com>
prepare for 7.4.2
* Thu Dec 12 2013 Markus Wagner <markus.wagner@open-xchange.com>
Build for patch 2013-12-12
* Thu Dec 12 2013 Markus Wagner <markus.wagner@open-xchange.com>
Build for patch 2013-12-12
* Wed Nov 20 2013 Markus Wagner <markus.wagner@open-xchange.com>
Fifth candidate for 7.4.1 release
* Fri Nov 15 2013 Markus Wagner <markus.wagner@open-xchange.com>
Fourth candidate for 7.4.1 release
* Thu Nov 07 2013 Markus Wagner <markus.wagner@open-xchange.com>
Third candidate for 7.4.1 release
* Wed Oct 23 2013 Markus Wagner <markus.wagner@open-xchange.com>
Second candidate for 7.4.1 release
* Thu Oct 10 2013 Markus Wagner <markus.wagner@open-xchange.com>
First sprint increment for 7.4.1 release
* Tue Sep 24 2013 Markus Wagner <markus.wagner@open-xchange.com>
Eleventh candidate for 7.4.0 release
* Fri Sep 20 2013 Markus Wagner <markus.wagner@open-xchange.com>
prepare for 7.4.1 release
* Fri Sep 20 2013 Markus Wagner <markus.wagner@open-xchange.com>
Tenth candidate for 7.4.0 release
* Thu Sep 12 2013 Markus Wagner <markus.wagner@open-xchange.com>
Ninhth candidate for 7.4.0 release
* Sun Sep 01 2013 Markus Wagner <markus.wagner@open-xchange.com>
Eighth candidate for 7.4.0 release
* Tue Aug 27 2013 Markus Wagner <markus.wagner@open-xchange.com>
Seventh candidate for 7.4.0 release
* Fri Aug 23 2013 Markus Wagner <markus.wagner@open-xchange.com>
Sixth candidate for 7.4.0 release
* Mon Aug 19 2013 Markus Wagner <markus.wagner@open-xchange.com>
Fifth candidate for 7.4.0 release
* Tue Aug 13 2013 Markus Wagner <markus.wagner@open-xchange.com>
Fourth candidate for 7.4.0 release
* Tue Aug 06 2013 Markus Wagner <markus.wagner@open-xchange.com>
Third release candidate for 7.4.0
* Fri Aug 02 2013 Markus Wagner <markus.wagner@open-xchange.com>
Second release candidate for 7.4.0
* Wed Jul 17 2013 Markus Wagner <markus.wagner@open-xchange.com>
First candidate for 7.4.0 release
* Tue Jul 16 2013 Markus Wagner <markus.wagner@open-xchange.com>
prepare for 7.4.0
* Mon Jul 01 2013 Markus Wagner <markus.wagner@open-xchange.com>
Third candidate for 7.2.2 release
* Fri Jun 28 2013 Markus Wagner <markus.wagner@open-xchange.com>
Second candidate for 7.2.2 release
* Wed Jun 26 2013 Markus Wagner <markus.wagner@open-xchange.com>
Release candidate for 7.2.2 release
* Fri Jun 21 2013 Markus Wagner <markus.wagner@open-xchange.com>
Second feature freeze for 7.2.2 release
* Mon Jun 17 2013 Markus Wagner <markus.wagner@open-xchange.com>
Feature freeze for 7.2.2 release
* Mon Jun 03 2013 Markus Wagner <markus.wagner@open-xchange.com>
First sprint increment for 7.2.2 release
* Wed May 29 2013 Markus Wagner <markus.wagner@open-xchange.com>
First candidate for 7.2.2 release
* Mon May 27 2013 Markus Wagner <markus.wagner@open-xchange.com>
prepare for 7.2.2
* Fri May 17 2013 Markus Wagner <markus.wagner@open-xchange.com>
Third candidate for 7.2.1 release
* Wed May 15 2013 Markus Wagner <markus.wagner@open-xchange.com>
Second candidate for 7.2.1 release
* Mon Apr 22 2013 Markus Wagner <markus.wagner@open-xchange.com>
First candidate for 7.2.1 release
* Mon Apr 15 2013 Markus Wagner <markus.wagner@open-xchange.com>
prepare for 7.4.0
* Mon Apr 15 2013 Markus Wagner <markus.wagner@open-xchange.com>
prepare for 7.2.1
* Wed Apr 10 2013 Markus Wagner <markus.wagner@open-xchange.com>
Fourth candidate for 7.2.0 release
* Mon Apr 08 2013 Markus Wagner <markus.wagner@open-xchange.com>
Third candidate for 7.2.0 release
* Tue Apr 02 2013 Markus Wagner <markus.wagner@open-xchange.com>
Second candidate for 7.2.0 release
* Tue Mar 26 2013 Markus Wagner <markus.wagner@open-xchange.com>
First release candidate for 7.2.0
* Fri Mar 15 2013 Markus Wagner <markus.wagner@open-xchange.com>
prepare for 7.2.0
* Mon Dec 10 2012 Daniel Rentz <daniel.rentz@open-xchange.com>
Initial Release.
