/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/oxguard_core', ['io.ox/core/extensions', 'io.ox/core/notifications',
                                'io.ox/core/tk/dialogs', 'gettext!oxguard/oxguard_core'],
                                function (ext, notify, dialogs, gt) {
    'use strict';
    
    // Add lock to the message detail view and menu options
    
    // Prompt for creating master keys for this user if not yet created.
    function createKeys(errors, view) {
        var dialog = new dialogs.CreateDialog({ width: 450, center: true});
        dialog.header($('<h4>').text(gt('Create Guard Security Keys')));
        var explain = $('<div><p>' + gt('This appears to be the first time you have used Encryption') + '</p><p>' + gt('Please enter a password to protect your new encrypted items') + '</p>');
        
        var passdiv = $('<div>').addClass('row-fluid');
        var table = $('<table class="og_password_prompt"/>')
        .append('<tr><td><em>' + gt('Password') + ':</em></td><td><input name="newogpassword" type="password"/></td></tr>')
        .append('<tr><td><em>' + gt('Confirm') + ':</em></td><td><input name="newogpassword2" type="password"/></td></tr>');
        passdiv.append(table);
        dialog.getBody().append(explain).append(passdiv);
        if (errors !== undefined) {
            dialog.getBody().append('<div><span style="color: red;">' + errors + '</span></div>');
        }
        dialog
        .addPrimaryButton('ok', gt('OK'), 'ok')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('cancel', function () {

        })
        .on('ok', function () {
            var pass1 = $('input[name="newogpassword"]').val();
            var pass2 = $('input[name="newogpassword2"]').val();
            if (pass1 !== pass2) {
                createKeys(gt('Passwords not equal'), view);
                return;
            }
            var userdata = {
                    user_id : ox.user_id,
                    password : pass1,
                    sessionID : ox.session,
                    language : ox.language,
                    cid : ox.context_id
                };
            var waitdiv = $('<div class="og_wait" id="keygen"></div');
            waitdiv.append('<i class="fa-key icon-key fa-spin icon-spin"/><span>' + gt('Generating key, Please wait') + '</span>');
            $('.window-container-center').append(waitdiv);
            waitdiv.show();
            $.post(ox.apiRoot + '/oxguard/login?action=create&session=' + ox.session, JSON.stringify(userdata), function (data) {
                $('.og_wait').hide();
                if (data.indexOf('ok') > 0) {
                    window.oxguarddata.passcode = null;
                } else {
                    $('.og_wait').hide();
                    notify.yell('error', gt('Problems creating keys, please try again later'));
                }
                
            })
            .fail(function () {
                $('.og_wait').hide();
                notify.yell('error', gt('Problems creating keys, please try again later'));
            });
            
        })
        .show(function () { $('input[name="ogname"]').focus(); });
    }

    return {
        
            // Send authorization to the oxguard server
        auth: function authorize(userid, password, extra)
            {
            var def = $.Deferred();
            var userdata = {
                    user_id : userid,
                    ox_password : password,
                    encr_password : '',
                    sessionID : ox.session,
                    lang: ox.language,
                    cid : ox.context_id,
                    extrapass : extra ? extra : ''
                };
            $.post(ox.apiRoot + '/oxguard/login?action=login&session=' + ox.session + '&time=' + new Date().getTime(), JSON.stringify(userdata), function (data) {
                def.resolve(data);
            })
            .fail(function () {
                def.reject();
            });
            return def;
            
        },
        
        createKeys : createKeys
    
    };
});
    

    