define('oxguard/mail/saveattach',
    ['io.ox/mail/api', 'io.ox/core/http',
     'io.ox/core/notifications', 'settings!io.ox/core',
     'io.ox/core/tk/dialogs',
     'io.ox/core/tk/folderviews',
     'io.ox/core/api/folder',
     'settings!io.ox/files', // yep, files not mail!
     'settings!io.ox/core',
     'gettext!oxguard/mail/saveattach'], function (api, http, notifications, coreConfig, dialogs, views, folderAPI, settings, settingsCore, gt) {

    'use strict';

    function commit(list, target) {

        function saveAttachments(list, target) {
            // be robust
            target = target || coreConfig.get('folder/infostore');
            // support for multiple attachments
            list = _.isArray(list) ? list : [list];
            var def = $.Deferred();
            // loop
            _(list).each(function (data) {
                var params = {
                        action: 'attachment',
                        id: data.mail.id,
                        encrextrapass: data.extrapass,
                        filename: data.filename,
                        folder: data.mail.folder_id,
                        dest_folder: target,
                        attachment: data.id,
                        folder_id: target,
                        session_id: ox.session,
                        userid: ox.user_id,
                        cid: ox.context_id,
                        epassword: data.epass,
                        auth: window.oxguarddata.passcode,
                        cc: data.cc,
                        description: 'Saved mail attachment'
                    };
                $.ajax({
                    type: 'PUT',
                    url: ox.apiRoot + '/oxguard/mail?action=saveattachment',
                    data: JSON.stringify(params),
                    success: function () {
                        def.resolve('success');
                    }
                })
                .fail(function (data) {
                    def.reject(data.responseText);
                });
            });
            return (def);
        }
        
        notifications.yell('busy',
            gt.ngettext('Saving attachment to Drive', 'Saving attachments to Drive', list.length) + ' ...'
        );
        saveAttachments(list, target).done(function () {
            notifications.yell('success',
                    gt.ngettext('Attachment has been saved', 'Attachments have been saved', list.length)
                );
            folderAPI.reload(target, list);
        }).fail(function (data) {
            if (data == 'Failed to decode') {  // Translate known error messages
                data = gt('Failed to decode'); 
            }
            if (data == 'Failed to save') { // Generic error, no additional lines needed
                data = '';
            }
            notifications.yell('error', gt('Failed to save attachments') + '\r\n' + data);
        });
    }
    


    return {

        multiple: function (list) {

            var dialog = new dialogs.ModalDialog()
                .header($('<h4>').text('Save attachment'))
                .addPrimaryButton('ok', gt('Save'), 'ok', {tabIndex: '1'})
                .addButton('cancel', gt('Cancel'), 'cancel', {tabIndex: '1'});

            dialog.getBody().css({ height: '250px' });

            var folderId = settingsCore.get('folder/infostore'),
                id = settings.get('folderpopup/last') || folderId,
                tree = new views.FolderTree(dialog.getBody(), {
                    type: 'infostore',
                    rootFolderId: '9',
                    open: settings.get('folderpopup/open', []),
                    tabindex: 0,
                    toggle: function (open) {
                        settings.set('folderpopup/open', open).save();
                    },
                    select: function (id) {
                        settings.set('folderpopup/last', id).save();
                    }
                });

            dialog.show(function () {
                tree.paint().done(function () {
                    tree.select(id).done(function () {
                        dialog.getBody().focus();
                    });
                });
            })
            .done(function (action) {
                if (action === 'ok') {
                    var target = _(tree.selection.get()).first();
                    if (target) commit(list, target);
                }
                tree.destroy().done(function () {
                    tree = dialog = null;
                });
            });
        }
    };
});