/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/mail/register_mail', ['io.ox/core/extensions', 'oxguard/mail/oxguard_mail', 'io.ox/mail/view-detail',
                           'oxguard/mail/oxguard_mail_write_core', 'gettext!oxguard/mail/register_mail',
                           'io.ox/core/notifications', 'io.ox/core/extPatterns/links',
                           'io.ox/core/tk/dialogs', 'io.ox/core/api/account',
                           'css!oxguard/style.css'],
                           function (ext, oxmail, mail, core, gt, notifications, links, dialogs, account) {
    'use strict';
    
    var popupBlockCount = 0;
    var draftWarningCount = 0;
    
    ///////////////////  Email points
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGSave',
        index: 202,
        label: gt('Save Encrypted'),
        ref: 'io.ox/mail/actions/save-OGattachment'
    }));
    
    ////////  Reply or Reply all actions from top command bar
    
    // If secure Reply, we need to update the reply email with the decrypted text, and format
    ext.point('io.ox/mail/write/initializers/before').extend({
        modify: function (baton) {
            if (window.oxguarddata.action === 'secureReply') {
                if (baton.mail.format === 'text') {
                    baton.mail.data.attachments[0].content = prepareTextReply($.extend({}, window.oxguarddata.temp));
                    baton.mail.data.attachments[0].content_type = 'text/plain'; 
                } else {
                    baton.mail.data.attachments[0].content = prepareReply($.extend({}, window.oxguarddata.temp));
                    baton.mail.data.attachments[0].content_type = 'text/html'; 
                }
       
            }
            if (window.oxguarddata.actionType === 'replyAll') {
                addTo(baton);
            }
            window.oxguarddata.action = '';// reset action
            window.oxguarddata.actionType = '';
        }
    });
    
    
    // For replyAll, we need to add back all the recipients from decoded email
    function addTo (baton) {
        var to = window.oxguarddata.temp.to;
        var newto = [];
        var user = baton.app.getView().form.find('.sender-dropdown').val();// Get current users email
        for (var i = 0; i < to.length; i++) {
            if (user.indexOf(to[i][1]) < 0) { // dont add the user to recip list
                newto.push(to[i]);
            }
        }
        baton.app.setTo(newto);
        baton.app.setCC(window.oxguarddata.temp.cc);
    }

    // When hitting reply, see if was a secured email.  If so, set temp vars for updating reply email
    ext.point('io.ox/mail/actions/reply').extend({
        index: 1,
        id: 'securedreply',
        action: function () {
            if (window.oxguarddata.temp === null) return;
            if (window.oxguarddata.temp.og === true) {
                window.oxguarddata.action = 'secureReply';
                window.oxguarddata.actionType = 'reply';
            }
        }
    });
    
    ext.point('io.ox/mail/actions/forward').replace({
        id: 'forward',
        requires: function (e) {
            try {
                var data = e.baton.isThread ? e.baton.first() : e.baton.data;
                if (data === undefined) return e.collection.has('toplevel', 'some');
                if (data.headers !== undefined) { // Email selected
                    if (data.headers['X-OxGuard'] !== undefined) { // Will not be defined if sent from other client
                        if (data.headers['X-OxGuard'].toLowerCase() === 'true')  // Will be defined but false from UI
                            return false;
                    }
                }
            } catch (e) {
                console.log('catch in forward require');
                console.log(e);
            }
            return e.collection.has('toplevel', 'some');
        },
        action: function (baton) {

            var data = baton.isThread ? baton.first() : baton.data;

            require(['io.ox/mail/write/main'], function (m) {
                if (m.reuse('forward', data)) return;
                m.getApp().launch().done(function () {
                    this.forward(data);
                });
            });
        }
    });
    
    // Popup to warn that drafts are not encrypted
    // Fires ony if Guard selected
    ext.point('io.ox/mail/write/actions/draft').extend({
        index: 1,
        id: 'savedraft',
        action: function (baton) {
            if (draftWarningCount > 0) return;  // only warn once
            draftWarningCount++;
            if (baton.app.getView().form.find('#OxGuardOn:checked').length > 0) {
                var dialog = new dialogs.ModalDialog({ width: 450, center: true, enter : 'ok'});
                //#. Header to message box alerting the user that draft emails are not saved encrypted
                dialog.header($('<h4>').text(gt('Draft Email Alert')));
                var explain = $('<div><p>' + gt('Please be aware that emails are only encrypted upon sending.  Draft emails are stored in plain text.') + '</p></div>');
                dialog.getBody().append(explain);
                dialog
                .addPrimaryButton('okpass', gt('OK'), 'ok')
                .show();
            }
        }
    });
    
    // Check if secured email.  
    ext.point('io.ox/mail/actions/reply-all').extend({
        index: 1,
        id: 'securedreplyall',
        action: function () {
            if (window.oxguarddata.temp === null) return;
            if (window.oxguarddata.temp.og === true) {
                window.oxguarddata.action = 'secureReply';
                window.oxguarddata.actionType = 'replyAll';
            }
        }
    });

    
    /////////  Extension points reader / inbox
    
    
    // Action to open OxGuard attachment
    new links.Action('io.ox/mail/actions/open-OGattachment', {
        id: 'openOG',
        requires: 'some',
        multiple: function (list) {
            _(list).each(function (data) {
                var params = '&emailid=' + data.mail.id +
                '&attach=' + data.id +
                '&session=' + ox.session +
                '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                '&userid=' + ox.user_id +
                '&cid=' + ox.context_id +
                '&epassword=' + encodeURIComponent(data.epass) +
                '&folder=' + data.mail.folder_id +
                '&encrextrapass=' + encodeURIComponent(data.extrapass) +
                '&cc=' + data.cc +
                '&attname=' + encodeURIComponent(data.filename);
                var link = ox.apiRoot + '/oxguard/mail/' + encodeURIComponent(data.filename) + '?action=getattach' + params;
                var popup = window.open(link);
                if (popup === null || popup === undefined) {
                    // If popup blocked, give one try to see if user notices, otherwise alert message regarding blocking
                    if (popupBlockCount === 1) {
                      //#. Error message when trying to open a file with popup blocker on browser blocking
                        alert(gt('popup blocked'));
                      //  window.location.href = link;
                    }
                    popupBlockCount++;
                }
            });
        }
    });
    
    // Download encrypted attachment
    new links.Action('io.ox/mail/actions/download-OGattachment', {
        id: 'DownloadOG',
        requires: 'some',
        multiple: function (list) {
            _(list).each(function (data) {
                var params = '&emailid=' + data.mail.id +
                '&attach=' + data.id +
                '&session=' + ox.session +
                '&auth=' + encodeURIComponent(window.oxguarddata.passcode) +
                '&userid=' + ox.user_id +
                '&cid=' + ox.context_id +
                '&epassword=' + encodeURIComponent(data.epass) +
                '&folder=' + data.mail.folder_id +
                '&encrextrapass=' + encodeURIComponent(data.extrapass) +
                '&cc=' + data.cc +
                '&download=true' +
                '&attname=' + encodeURIComponent(data.filename);
                var link = ox.apiRoot + '/oxguard/mail?action=getattach' + params;
                $('#tmp').append(
                        $('<iframe>', { src: link, 'class': 'hidden download-frame', id: 'download' + data.id })
                    );
            });
        }
    });
    
    // Save encrypted attachment.  Need to add the .oxg suffix
    new links.Action('io.ox/mail/actions/save-OGattachment', {
        id: 'SaveOG',
        requires: 'some',
        multiple: function (list) {
            for (var n = 0; n < list.length; n++) {
                var filename = list[n].filename;
                list[n].save_as = filename + '.grd';                
            }
            require(['io.ox/mail/actions/attachmentSave'], function (action) {
                action.multiple(list);
            });
        }
    });
    
    // Save decoded attachment.  Need to add the .oxg suffix
    new links.Action('io.ox/mail/actions/save-OGdecoded', {
        id: 'SaveOG',
        requires: 'some',
        multiple: function (list) {
            require(['oxguard/mail/saveattach'], function (action) {
                action.multiple(list);
            });
        }
    });
    
    // Attachment links for encrypted emails
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGopen',
        index: 200,
        label: gt('Open in browser'),
        ref: 'io.ox/mail/actions/open-OGattachment'
    }));
    
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGdownload',
        index: 201,
        label: gt('Download'),
        ref: 'io.ox/mail/actions/download-OGattachment'
    }));
    
    ext.point('io.ox/mail/attachment/links').extend(new links.Link({
        id: 'OGsaveDecoded',
        index: 203,
        label: gt('Save Decoded'),
        ref: 'io.ox/mail/actions/save-OGdecoded'
    }));
    

    
    
    
    // For attachments, need to change links to decoding through oxguard if encrypted.
    ext.point('io.ox/mail/detail/header').extend({
        index: 1,
        id: 'ogattachlinks',
        draw: function (baton) {
            setAttachments(baton);
        }
    });
    
    function setAttachments(baton) {
        regAttach();    // Default is to just display the regular links
        if (baton.data.headers === undefined) return;   // Usually not defined unless decoded email
        if (baton.data.attachments === undefined) return;
        if ((baton.data.headers['X-OxGuard'] === 'True') || baton.data.og) {
            if (ox.serverConfig.version.indexOf('7.6.0') !== 0) ext.point('io.ox/mail/detail/attachments').disable('attachment-list');
            // We are going to search the attachments, and not display the main email attachment if present
            try {
                if (baton.data.attachment) {
                    ogAttach();
                } else {// If no attachments to show, hide the attachment div
                    baton.view.$el.find('.attachments').remove();
                }
                
            } catch (e) {
                
            }
        } else {
            ext.point('io.ox/mail/detail/attachments').enable('attachment-list');
        }
    }
    
    function ogAttach() {
        // Set the right links in the attachment dropdown
        ext.point('io.ox/mail/attachment/links').disable('preview');
        ext.point('io.ox/mail/attachment/links').disable('download');
        ext.point('io.ox/mail/attachment/links').disable('save');
        ext.point('io.ox/mail/attachment/links').disable('open');
        ext.point('io.ox/mail/attachment/links').disable('vcard');
        ext.point('io.ox/mail/attachment/links').disable('ical');
        ext.point('io.ox/mail/attachment/links').disable('slideshow');
        ext.point('io.ox/mail/attachment/links').enable('OGopen');
        ext.point('io.ox/mail/attachment/links').enable('OGdownload');
        ext.point('io.ox/mail/attachment/links').enable('OGSave');
        ext.point('io.ox/mail/attachment/links').enable('OGsaveDecoded');
    }
    
    function regAttach() {
        ext.point('io.ox/mail/detail/attachments').enable('attachment-list');
        ext.point('io.ox/mail/attachment/links').enable('preview');
        ext.point('io.ox/mail/attachment/links').enable('download');
        ext.point('io.ox/mail/attachment/links').enable('save');
        ext.point('io.ox/mail/attachment/links').enable('open');
        ext.point('io.ox/mail/attachment/links').enable('vcard');
        ext.point('io.ox/mail/attachment/links').enable('ical');
        ext.point('io.ox/mail/attachment/links').enable('slideshow');
        ext.point('io.ox/mail/attachment/links').disable('OGopen');
        ext.point('io.ox/mail/attachment/links').disable('OGdownload');
        ext.point('io.ox/mail/attachment/links').disable('OGSave');
        ext.point('io.ox/mail/attachment/links').disable('OGsaveDecoded');
    }
    
    // Add lock to header
    ext.point('io.ox/mail/detail/header').extend({
        index: 230,
        id: 'ogMailLock',
        draw: function (baton) {
            ogMailLockExt.call(this, baton);
        }
    });
    

    ext.point('io.ox/mail/mobile/detail/header').extend({
        index: 230,
        id: 'ogMailLock',
        draw: function (baton) {
            ogMailLockExt.call(this, baton);
            setAttachments(baton);
        }
    });

    
    function ogMailLockExt(baton) {
        var headers = baton.view.model.get('headers');
        if (headers === undefined) {
            baton.view.listenTo(baton.view.model, 'change:headers', function () {
                headers = baton.view.model.get('headers');
                if (headers['X-OxGuard-ID'] !== undefined) {
                    window.setTimeout(function () {
                        baton.view.redraw();
                    }, 5);

                }
            });
            return;
        }
        if (headers['X-OxGuard-ID'] !== undefined) {
            // Add lock symbol to header
            var lockdiv = $('<div style="float:left; padding-right:5px;" id="lockdiv" title="' + gt('This Email was sent encrypted. It has been decoded with your private key') + '"></div>');
            lockdiv.append($('<i class="icon-lock icon-large fa fa-lock oxguard_lock">'));
            if (_.contains(account.getFoldersByType('sent'), baton.data.folder_id)) {
                lockdiv.click(function () {
                    status(baton);       
                });
            }
            var exp = baton.model.get('exp');
            if (exp !== undefined) {
                if (exp > 0) {
                    var expdate = new Date(exp).toLocaleString();
                    //#. Expires: date/time.  This is on header of email labeling when an email will expire
                    var expd = $('<span class="og_exp">' + gt('Expires: ') + expdate + '</span><br/>');
                    $(this).prepend(expd);
                }
            }
            $(this).prepend(lockdiv);
        }
        baton.view.$el.find('.subject').html(baton.data.subject);
    }
    
    // Handle viewing the emails
    var point = ext.point('io.ox/mail/detail');

    point.extend({
        id: 'OGHider',
        index: 1,
        draw: function (baton) {
            if (baton.data.og) {
                baton.view.$el.hide();
                $('.thread-view-list').append('<div style="text-align:center; background-color:white;" id="loading"><i class="fa fa-spinner fa-spin" id="busygif"></i></div>');
            }
        }
    });
    point.extend({
        id: 'OGdecoder',
        index: 2000,
        draw: function (baton) {
            detailExt(baton);
        }
    });
    

    ext.point('io.ox/mail/mobile/detail').extend({
        id: 'OGdecoder',
        index: 2000,
        draw: function (baton) {
            detailExt(baton);

        }
    });

    // Extension for watching for changes, then checking if OG data or not.
    function detailExt(baton) {
        // Depreciated.  No longer chaning the subject on outgoing emails.
     //   baton.view.model.on('change:subject', function () {
      //      var subject = baton.data.subject;
     //       if (subject !== null) {
      //          subject = subject.replace('OXGrd::', '').replace('OXGrd:', '');
      //          baton.data.subject = subject;
       //         baton.model.set('subject', subject);
       //     }
      //  });
        checkOG.call(this, baton);
    }
    
    // Check if OxGuard email, and if so, send to decode or prompt password
    function checkOG(baton) {
        if (baton.view.model === null) {
            return;
        }
        // Check if alreay done...
        if ((baton.decoded === true) || (baton.data.decoded === true)) {
            // Check to see if they are members, and if not, display upsell
            try {
                $('#loading').remove();
                baton.view.$el.show();
                baton.view.$el.find('.attachment-preview').hide();
                if (window.oxguarddata.settings.oxguard === false) {
                    var location = baton.view.$el.find('.detail-view-header');
                    upsell(location);
                }
            } catch (e) {
                
            }
            return;// if this is an already decoded email, then return
        }
        window.oxguarddata.temp = null;
        var headers = baton.view.model.get('headers');
        if (headers === undefined) {// not yet loaded
            return;
        }
        // Init
        if (baton.data.headers === undefined) { // If email wasn't fully loaded into baton, do so now.
            baton.data = baton.view.model.toJSON();
        }
        
        if (window.oxguarddata.settings === undefined) {// If OG settings not yet loaded, store baton for finish load
            window.oxguarddata.baton = baton;
        }
        
        if (headers['X-OxGuard-Guest'] !== undefined) { // Although it's an OG email, guest from other system, so stop and show.
            $('#loading').remove();
            baton.view.$el.show();
            return;
        }
        
      //If header states an oxguard email, then start
        if (headers['X-OxGuard-ID'] !== undefined) {
            baton.view.$el.find('.alert.external-images').hide();
            
            baton.model.trigger('change', baton.model, this); //trigger   redraw inbox list icon
            baton.data.og = true;
            var location = this;
            baton.view.expand();
            $('#loading').remove();
            // Check to see if we should be requesting passwords
            if ((window.oxguarddata.passcode === null) || ((headers['X-OxGuard-ExtraPass'] !== undefined) && (headers['X-OxGuard-ExtraPass'] !== ''))) {
                baton.view.listenTo(baton.view.model, 'change:attachments', function () {
                    checkOG(baton);
                    if (baton.view.$el === null) return;
                    baton.view.$el.find('#oxgrpass').focus();
                });
                window.setTimeout(function () {// Diplay password prompt
                    if (baton.view.$el === null) return;
                    baton.view.$el.find('.content').replaceWith(oxmail.passwordPrompt(baton, false, location));
                    baton.view.$el.find('#oxgrpass').focus();
                    baton.view.$el.show();
                    baton.view.$el.find('.attachments').remove();
                    baton.view.$el.find('.subject').html(baton.data.subject.replace('OXGrd::', '').replace('OXGrd:', ''));
                    baton.view.expand();
                }, 10);
            } else {
                
                if (window.oxguarddata.passcode.indexOf('Password Needed') > -1) {// If no password for user has been defined, open dialog
                    createOxGuardPasswordPrompt(baton, '');
                    return;
                }
                if (window.oxguarddata.passcode.indexOf('No Key') > -1) {// If received a first encrypted email while already logged in, will still have 'no key' in passcode
                    createOxGuardPasswordPrompt(baton, '');
                    return;
                }
                if ((window.oxguarddata.passcode === 'NoPrivate') || (window.oxguarddata.passcode === 'No Key')) {// No key would really only occur in a demo reset
                    window.setTimeout(function () {// Diplay password prompt
                        baton.view.$el.show();
                        baton.view.$el.find('.content').replaceWith(oxmail.passwordPrompt(baton, false, location));
                        $('#oxgrpass').focus();
                        baton.view.$el.find('.attachments').remove();
                    }, 100);
                    return;
                }
                $('#loading').remove();
                oxmail.getMail(baton, window.oxguarddata.passcode, '', '', location)
                .done(function () {
                    baton.view.$el.show();
                    baton.view.$el.find('section').show();
                    baton.view.$el.find('.attachment-preview').hide();
                    baton.model.on('change:attachments', function () {// Attachments occasionally reloaded after decoded
                        if (baton.decodedData !== undefined) {// If already decoded, redraw decoded data
                            if (baton.view.model !== null) {
                                if (baton.view.model.get('attachments').length !== baton.decodedData.attachments.length) {
                                    baton.view.model = new Backbone.Model(baton.decodedData);
                                    baton.view.redraw();
                                    baton.view.expand();
                                }
                            }
                        }
                        
                    });
                })
                .fail(function () {
                    console.log('fail og load');
                    baton.model.on('change:attachments', function () {
                        window.oxguarddata.passcode = null;
                        checkOG(baton);
                    });
                });

            }
          //  baton.view.loaded = true;
        } else {
            $('#loading').remove();
            baton.view.$el.show();  // Not OG email, show contents
        }
    }
    
    function upsell(location) {
        var params = '&cid=' + ox.context_id + '&id=' + ox.user_id + '&lang=' + ox.language;
        $.get(ox.apiRoot + '/oxguard/mail?action=upsell' + params, function (data) {
            location.after(data);
        });
    }
    
    ///////////////  Write / Send
    
    // Set the action for send.
    var sendpoint = ext.point('io.ox/mail/write/actions/send');
    sendpoint.replace({
        id: 'default',
      //  index: 'default',
        action: function (baton) {
            var view = baton.app.getView().form;
            if (view.find('#OxGuardOn').is(':checked')) {
                if (window.oxguarddata.passcode === 'No Key') {
                    core.createKeys('', view);
                    return;// Do not send until the master key is created
                }
                oxmail.sendMail(baton, window.oxguarddata.passcode);
            } else {
                baton.app.send();
            }
            
        }
    });
    

 
    
    // Email writing
    
    // Add the oxguard button to write toolbar
    
    
    ext.point('io.ox/mail/write/filelist/filePicker/customizer').extend({
        id: 'oxguard',
        customize: function (file) {
            if (file.filename.indexOf('.grd') > 0) {
              //  var newfilename = file.filename.replace('.grd2', '').replace('.grd', '');
                var icon = '<i class = "fa fa-lock oxguard_lock_p"/>';
                $(this).find('.name').text(file.filename).prepend(icon);
            }
        }
    });

    
    var newpoint = ext.point('io.ox/mail/write/toolbar');
    newpoint.extend({
        id: 'locksend',
        index: 100,
        draw: function (baton) {
            // Create Security Link
            try {
                if ($('.btn-primary:visible').length === 0) return;// if page not yet created
                if ($('.btn-primary:visible').prev().is('[name="Page"]')) {//We've already updated this
                    return;
                }
                var view = baton.app.getView().form;
                if (view === undefined) return;//View not yet loaded
                if (view.find('#OxGuardOn').length > 0) return;//Already created
                core.createOptions(view);
                addBlur('#writer_field_to', view);
                addBlur('#writer_field_cc', view);
                addBlur('#writer_field_bcc', view);
                
            } catch (e) {
                console.log(e.toString());
            }
            
        }
        
    });
    
    function addBlur(id, view) {
        $(id).blur(function () {
            if (view.find('#OxGuardOn').is(':checked')) {
                window.setTimeout(function () {
                    core.checkRecip(view);
                }, 200);
            }
        }).keypress(function(e) {
            if (e.which === 13) {
                if (view.find('#OxGuardOn').is(':checked')) {
                    window.setTimeout(function () {
                        core.checkRecip(view);
                    }, 200);
                }
            }
        });
    }
    
    ext.point('io.ox/mail/write/filelist/file/customizer').extend({
        id: 'oxguardfilelist',
        customize: function () {
            var icon = '<i class = "fa fa-lock oxguard_lock_p"/>';
            $(this).find('.row-1').each(function (e, v) {
                var te = $(v);
                if (te.text().indexOf('.grd') > 0) {
                //    te.html(icon + te.text().replace('.grd2', '').replace('.grd', ''));
                    te.html(icon + te.text());
                    $('#statuslock.icon-unlock:visible').click();// Enable encryption if not set
                }
            });
        }
    });
    
    
    // Format an email for reply
    function prepareReply(tmp) {
        try {
            if (tmp === null) return ('');
            if (tmp.replytext === undefined) return ('');
            var sentDate = new Date(tmp.received_date);
            var from = ' ' + tmp.replyfrom[0][0] + ' ';
            //#. Used for top of reply email, %1 is date, %2 is name
            //#. Would appear like - On 4/5/14 12:30 Greg sent:
            var line = ' ' + gt('On %1$s %2$s sent:', sentDate.toLocaleString(), from);
            if (tmp.replytype === undefined) tmp.replytype = '';
            var header = '';
            if (tmp.replytype.indexOf('html') > 0) {
                header = '<br/><blockquote type="cite"><span>' + line + '</span><br/>' + tmp.replytext + '</blockquote>';
              //  header = '<br/><div style="border-left: 1px solid blue; padding-left:10px;"><span>' + line + '</span><br/>' + tmp.replytext + '</div>';
            } else {
                header = '\r\n\r\n---------------------------------------\r\n' + line + '\r\n' + tmp.replytext;
            }
            return (header);
        } catch (e) {
            console.log(e);
            return (header);
        }
    }

    // Generate Plaintext email reply
    function prepareTextReply (tmp) {
        try {
            if (tmp === null) return ('');
            if (tmp.replytext === undefined) return ('');
            var sentDate = new Date(tmp.received_date);
            var from = ' ' + tmp.replyfrom[0][0] + ' ';
            var line = ' ' + gt('On %1$s %2$s sent:', sentDate.toLocaleString(), from);
            if (tmp.replytype === undefined) tmp.replytype = '';
            tmp.replytext = convertHTML(tmp.replytext);
            var header = '\n>' + line + '\n' + tmp.replytext + '\n';
            return (header);
        } catch (e) {
            console.log(e);
            return (header);
        }
    }
    
    // Convert HTML email to plaintext
    function convert (html, start) {
        try {
            if (start === undefined)
                start = 0;
            var i = html.indexOf('<blockquote', start);
            if (i > -1) {
                i = html.indexOf('>', i) + 1;
                html = convert(html, i);
            }
            var j = html.indexOf('</blockquote');
            var substring = html.substring(start);
            if (j > -1) {
                substring = html.substring(start, j);
            } 
            var newstring = '> ' + substring.replace(/\n/g, '\n> ').replace(/<br[\/]*>/gi, '\n> ')
                    .replace(/<p[\/]*>/gi, '\n> ').replace(/<blockquote[^>]*>/,'\n> ').replace(/<(?:.|\s)*?>/g, '') + '\n> ';
            html = html.replace(substring, newstring);
            return (html);
        } catch (e) {
            console.log(e);
            return (html);
        }
    }
    
    function convertHTML(html) {
        return (convert(html, 0).replace(/<blockquote[^>]*>/,'\n> ').replace(/<(?:.|\s)*?>/g, ''));
    }

    ///////////  First time OG users
    
    // If the user has received encrypted objects, but hadn't since logged in, the need to assign a password to protect their keys
    function createOxGuardPasswordPrompt(baton, errors, oldpass)
    {
        var dialog = new dialogs.ModalDialog({ width: 450, center: true, enter : 'okpass'});
        dialog.header($('<h4>').text(gt('First Guard Security Password Use')));
        var explain = $('<div><p>' + gt('Please change the initial temporary Guard security password that was sent to you in a seperate email.') + '</p></div>');
        
        var passdiv = $('<div>').addClass('row-fluid');
        var table = $('<table class="og_password_prompt"/>')
        .append('<tr><td><em>' + gt('Initial Password') + ':</em></td><td><input name="oldogpassword" type="password"/></td></tr>')
        .append('<tr><td><em>' + gt('New Password') + ':</em></td><td><input name="newogpassword" type="password"/></td></tr>')
        //#. Confirm new password
        .append('<tr><td><em>' + gt('Confirm New') + ':</em></td><td><input name="newogpassword2" type="password"/></td></tr>');
        passdiv.append(table);
        dialog.getBody().append(explain).append(passdiv);
        var rule = $('<hr style="padding:10px;"/>');
        var recovery = $('<p>' + gt('Please enter a secondary email address in case you need to reset your password' + '</p>'));
        var email = $('<input name="recoveryemail" style="margin: 10px;"/>');
        dialog.getBody().append(rule).append(recovery.append(email));
        if (errors !== undefined) {
            dialog.getBody().append('<div><span style="color: red;">' + errors + '</span></div>');
        }
        dialog
        .addPrimaryButton('okpass', gt('OK'), 'okpass')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('okpass', function () {
            var oldpass = $('input[name="oldogpassword"]').val();
            var pass1 = $('input[name="newogpassword"]').val();
            var pass2 = $('input[name="newogpassword2"]').val();
            var emailaddr = $('input[name="recoveryemail"]').val();
            if (pass1 !== pass2) {
                $('input[name="newogpassword2"]').css('background-color', 'salmon');
                createOxGuardPasswordPrompt(baton, gt('Passwords not equal'), oldpass);
                return;
            }
            var userdata = {
                    newpass : pass1,
                    oldpass : oldpass,
                    email: emailaddr,
                    user_id : ox.user_id,
                    sessionID : ox.session,
                    cid : ox.context_id
                };
            if (validateEmail(emailaddr)) userdata.email = emailaddr;
            $.post(ox.apiRoot + '/oxguard/login?action=changepass&session=' + ox.session, JSON.stringify(userdata), function (data) {
                if (typeof data === 'string') data = $.parseJSON(data);
                if (data.auth.length > 20) {
                    $('#grdsettingerror').text(gt('Success'));
                    $('input[name="newogpassword"]').val('');
                    $('input[name="newogpassword2"]').val('');
                    window.oxguarddata.passcode = data.auth;
                    oxmail.getMail(baton, window.oxguarddata.passcode, '', '');
                    notifications.yell('success', gt('Password changed successfully'));
                } else {
                    if (data.auth === 'Bad new password') {
                        notifications.yell('error', gt('New password must be at least %s characters long', data.minlength));
                        return;
                    }
                    if (data.auth === 'Bad password') {
                        //#. Bad, incorrect password
                        notifications.yell('error', gt('Bad password'));
                        return;
                    }
                    if (data.auth === 'Key not found') {
                        notifications.yell('error', gt('Encryption key not found'));
                        return;
                    }
                    notifications.yell('error', gt('Failed to change password'));
                }
            
            })
            .fail(function () {
                notifications.yell('error', gt('Failed to change password'));
            });
        })
        .show(function () {
            if (oldpass !== undefined) {
                $('input[name="oldogpassword"]').val(oldpass);
                $('input[name="newogpassword"]').focus();
            } else
                $('input[name="oldogpassword"]').focus();
        });
    }
    
    function validateEmail(email) {
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }
    
    
    ////////////////  Status in sent folder
    
    // Get the status of email action
    new links.Action('io.ox/mail/actions/status', {
        id: 'statusaction',
        requires: function (e) {
            if (!(_.contains(account.getFoldersByType('sent'), e.context.folder_id))) return(false);
            try {
                return(e.baton.data.headers['X-OxGuard'].toLowerCase() === 'true');
            } catch (ex) {
                console.log(ex);
                return (false);
            }
        },
        action: function (baton) {
            status(baton);
        }
    });
    
    ext.point('io.ox/mail/links/inline').extend(new links.Link({
        index: 100,
        prio: 'lo',
        id: 'statuslink',
        label: gt('Retract'),
        ref: 'io.ox/mail/actions/status'
    }));
    
    // Get the status of emails
    function status(baton) {
        var dialog = new dialogs.ModalDialog({ width: 300, center: true, enter : 'ok'});
        dialog.header($('<h4>').text(gt('Email status')));
        var busy = $('<i id="busystatus" class="fa fa-spinner fa-spin"></i>');
        dialog.getBody().append(busy);
        var item = baton.data.headers['X-OxGuard-ID'];
        dialog
        .addPrimaryButton('ok', gt('Cancel'), 'ok')
        //#. Retract all access, retracts an email from being read by all recipients
        .addButton('retract', gt('Retract all access'), 'retract')
        .on('ok', function () {
            
        })
        .on('retract', function () {
            setTimeout(function () {
                retract(item);
            }, 500);
        })
        .show(function () {
            
        });

        var params = '&item=' + item + '&userid=' + ox.user_id + '&cid=' + ox.context_id;
        $.get(ox.apiRoot + '/oxguard/mail?action=count&session=' + ox.session + params, function (data) {
            $('#busystatus').remove();
            var readstatus = $.parseJSON(data);
            var html = '<table class="status_table">';
            for (var i in readstatus) {
                //var img = '<img src="apps/oxguard/images/mail-unread.png" />';
                var img = '<i class="icon-envelope-alt fa-envelope-o icon-2x fa fa-2x og_status" title="' + gt('Email has not been opened.') + '"/>';
                if (readstatus[i].count > 0) {
                    //img = '<img src="apps/oxguard/images/mail-read.png" />';
                    img = '<i class="icon-folder-open-alt fa-folder-open-o icon-2x fa fa-2x og_status" title="' + gt('Email has been opened.') + '"/>';
                }
                if (readstatus[i].count < 0) {
                    img = '<i class="icon-ban-circle fa-ban icon-2x fa fa-2x og_status" title="' + gt('Email has been retracted.') + '"/>';
                }
                html += '<tr><td>' + readstatus[i].email + '</td><td>' + img + '</td></tr>';
            }
            html += '</table>';
            var datatable = $(html);
            dialog.getBody().append(datatable);
        })
        .fail(function () {
            notifications.yell ('error', gt('Unable to get email status, please try again later'));
        });
    }
    
    // Retract selected email
    function retract(item) {
        var dialog = new dialogs.ModalDialog({ width: 450, center: true, enter : 'ok'});
        dialog.header($('<h4>').text(gt('Retract Email')));
        var verify = $('<p>' + gt('This will retract the email for all recipients. Click OK to confirm.') + '</p>');
        dialog.getBody().append(verify);
        dialog
        .addPrimaryButton('ok', gt('OK'), 'ok')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('ok', function () {
            var params = '&item=' + item + '&userid=' + ox.user_id + '&cid=' + ox.context_id;
            $.get(ox.apiRoot + '/oxguard/mail?action=retract&session=' + ox.session + params, function (data) {
                if (data.trim() === 'OK') {
                    notifications.yell('success', gt('Item was retracted'));
                } else notifications.yell('error', gt('Not all items retracted'));
            })
            .fail(function () {
                notifications.yell('error', gt('Failed to retract'));
            });
        })
        .show(function () {
            
        });
    }

    return {
        status : status,
        checkOG : checkOG
    };
    
});
