/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/mail/oxguard_mail_write_core', ['io.ox/core/extensions', 'io.ox/mail/write/main',
                                'io.ox/core/notifications',
                                'io.ox/core/tk/dialogs', 'gettext!oxguard/oxguard_core'],
                                function (ext, mailmain, notify, dialogs, gt) {
    'use strict';
    
    // Add lock to the message detail view and menu options
    var lockclass = 'icon-lock icon-2x fa fa-lock fa-2x oxguard_lock';
    var unlockclass = 'icon-unlock icon-2x fa fa-unlock fa-2x oxguard_lock';
    
    
    // Save encryption settings to header
    function saveToHeader(view) {
        try {
            var emailheader = view.find('[name="headers"]');
            var headerstring = emailheader.val();
            var header = {};
            if (headerstring !== '') header = JSON.parse(headerstring);
            header['X-OxGuard'] = (view.find('#OxGuardOn:checked').length > 0) ? 'True' : 'False';
            header['X-OxGuard-Expiration'] = getExpDate(view);
            header['X-OxGuard-ExtraPass'] = getPassword(view);
            if ((window.oxguarddata.temp !== null) && (window.oxguarddata.temp !== undefined)) {
                if (window.oxguarddata.temp.ogId !== undefined) {
                    header['X-OxGuard-ReplyId'] = window.oxguarddata.temp.ogId;
                }
            }
            emailheader.val(JSON.stringify(header));
        } catch (e) {
            console.log(e);
        }

        return;
    }
    
    // Retrieve oxguard settings from header and repopulate
    function retrieveOxGuard(view)
    {
        var headerstring = view.find('[name="headers"]').val();
        // Make sure header string exists and populated
        if (typeof headerstring !== 'undefined') {
            if (headerstring.length > 1) {
                var header = JSON.parse(headerstring);
                // Set oxguard on
                if (typeof header['X-OxGuard'] !== 'undefined') {
                    if (header['X-OxGuard'] === 'True') {
                        view.find('#OxGuardOn').prop('checked', true);
                        view.find('#statuslock').attr('class', lockclass);
                        view.find('#statuslock').attr('title', 'Click to disable encryption');
                        view.find('.btn-primary').html('Send Secure');
                        window.setTimeout(function () {
                            checkrecipient(view);
                        }, 500);
                    }
                    // Expiration Date
                    view.find('#expdatepicker').val(header['X-OxGuard-Expiration']);
                    // Get access restrictions
                }
                if (typeof header['X-OxGuard-ExtraPass'] !== 'undefined') {
                    view.find('#passbox').val(header['X-OxGuard-ExtraPass']);
                    if (header['X-OxGuard-ExtraPass'].trim() !== '') {
                        view.find('#reqpassword').prop('checked', 'true');
                        view.find('#passbox').parent().show();
                    }
                }
            }
            
        }

    }

    
    // Create the options div for oxguard
 

    // Get the expiration date
    function getExpDate(view)
    {
        return (view.find('#expdatepicker').val());
    }
      

    // Get the password assigned
    function getPassword(view)
    {
        var password = '';//If blank, use oxtest
        if (view.find('#reqpassword').is(':checked')) {
            password = view.find('#passbox').val();
        }
        return (password);
    }
    
   

    
    // Check location of the security or advanced div and see if we need to scroll down to make visible
    function checkscroll(num)
    {
        // Set timeout to happen after animated open/slidedown
        window.setTimeout(function () {
            var bottom = $('#oxguarddiv' + num).offset().top +
            $('#oxguarddiv').outerHeight();
            var offset = bottom - window.innerHeight;
            if ((bottom - window.innerHeight) > 0) {
                $('.leftside.io-ox-mail-write-sidepanel').animate({scrollTop: $('.leftside.io-ox-mail-write-sidepanel').scrollTop() + offset}, 250);
            }
        }, 250);
        
        
    }
    
    // Check if email has a public key that we can use
    function checkrecip(email, from, view) {
        if (email.val().indexOf('<') < 0) return;// make sure has email address
        var id = hash(email.val());
        if (view.find('#recip_' + id).length === 1) {
            return;// If we have already processed, return
        }
        var tag = $('<span class="oxguard_key icon-stack fa-stack" id="recip_' + id + '"></span>');
        email.before(tag);// Tag this recipient
        var params = '&email=' + email.val() + '&cid=' + ox.context_id + '&from=' + encodeURIComponent(from);
        $.get(ox.apiRoot + '/oxguard/mail?action=getkey' + params, function (data) {//Get the key
            try {
                if (data.publicKey === undefined) {
                   // tag.append('<img src="apps/oxguard/images/nokey.png" title="' + gt('Unable to get key for encryption') + '"/>');
                    tag.append('<i class="icon-ban-circle icon-stack-base fa fa-ban fa-stack-2x" style="color:red;"/><i class="icon-key fa fa-key fa-stack-1x" title="' + gt('Unable to get key for encryption') + '"/>');
                    return;
                }
                if (data.publicKey.length > 20) {
                    if (data.guest === 'false') {
                        tag.append('<i class="icon-key fa fa-key oxguard_lock" title="' + gt('Recipient has Guard') + '"/>');
                      //  tag.append('<img src="apps/oxguard/images/key32.png" title="' + gt('Recipient has Guard') + '"/>');
                    } else {
                       // tag.append('<img src="apps/oxguard/images/key32-out.png" title="' + gt('Using a Guest account for Guard') + '"/>');
                        //#. Displayed over icon in name to symbolize that a guest account is created for the recipient
                        tag.append('<i class="icon-male icon-stack-base fa fa-male fa-stack-2x" style="color:#cfc;"/><i class="icon-key fa fa-key fa-stack-1x oxguard_lock" title="' + gt('Using a guest account for email') + '"/>');
                    }
                    
                } else {
                   // tag.append('<img src="apps/oxguard/images/nokey.png" title="' + gt('Unable to get key for encryption') + '"/>');
                    if (data.guest === 'true') {
                        tag.append('<i id="newguest" class="icon-male icon-stack-base fa fa-male fa-stack-2x" style="color:#fcc;"/><i class="icon-key fa fa-key fa-stack-1x oxguard_lock" title="' + gt('Will create new guest account for Guard') + '"/>');
                        
                    } else {
                        tag.append('<i class="icon-ban-circle icon-stack-base fa fa-ban fa-stack-2x" style="color:red;"/><i class="icon-key fa fa-key fa-stack-1x" title="' + gt('Unable to create Guard account, please try again later') + '"/>');
                    }
                    
                }
            } catch (e) {
                console.log(e);
            }
        });
        
    }
    
    // Return a has of string
    function hash(str) {
        var hashed = 0;
        if (str.length === 0) return hashed;
        for (var i = 0; i < str.length; i++) {
            hashed = (31 * hashed + str.charCodeAt(i)) << 0;
        }
        return hashed;
    }
    
    function validateEmail(email) {
        var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }
    
    // Prompt for creating master keys for this user if not yet created.
    function createKeys(errors, view) {
        var dialog = new dialogs.CreateDialog({ width: 450, center: true, enter : 'ok'});
        dialog.header($('<h4>').text(gt('Create Guard Account')));
        var explain = $('<div><p>' + gt('This appears to be the first time you have used Guard') + '</p><p>' + gt('Please enter a password to protect your Guard account') + '</p>');
        
        var passdiv = $('<div>').addClass('row-fluid');
        // Create password prompt table
        var table = $('<table class="og_password_prompt"/>');
        var row = $('<tr/>');
        row.append('<td style="width: 100px;"><em>' + gt('Password') + ':</em></td>');
        var col = $('<td/>');
        var new1 = $('<input name="newogpassword" type="password"/>');
        row.append(col.append(new1));
        var row2 = $('<tr/>');
        row2.append('<td><em>' + gt('Confirm') + ':</em></td>');
        var col2 = $('<td/>');
        var new2 = $('<input name="newogpassword2" type="password"/>');
        row2.append(col2.append(new2));
        table.append(row).append(row2);
        passdiv.append(table);
        // Routine to check if passwords equal, highlight if not
        new2.keyup(function () {
            if (new1.val() !== new2.val()) {
                new2.css('background-color', 'salmon');
                $('button[data-action="okx"]').prop('disabled', true);
            } else {
                new2.css('background-color', 'white');
                $('button[data-action="okx"]').prop('disabled', false);
            }
        });
        dialog.getBody().append(explain).append(passdiv);
        var resetpass = $('<div style="margin-top:10px;"><p>' + gt('Please enter a secondary email address in case you need to reset your password.  A new password would be sent to this email.') +
                '</p></div>');
        var resetEmail = $('<table class="og_password_prompt"><tr><td style="width: 100px;"><em>' + gt('Email:') + '</em></td><td><input name="resetemail"/></td></tr></table>');
        dialog.getBody().append(resetpass).append(resetEmail);
        if (errors !== undefined) {
            dialog.getBody().append('<div><span style="color: red;">' + errors + '</span></div>');
        }
        dialog
        .addPrimaryButton('ok', gt('OK'), 'ok')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('cancel', function () {
            unlock(view);
        })
        .on('ok', function () {
            var pass1 = $('input[name="newogpassword"]').val();
            var pass2 = $('input[name="newogpassword2"]').val();
            if (pass1 !== pass2) {
                createKeys(gt('Passwords not equal'), view);
                return;
            }
            var remail = $('input[name="resetemail"]').val();
            var userdata = {
                    user_id : ox.user_id,
                    password : pass1,
                    sessionID : ox.session,
                    language : ox.language,
                    cid : ox.context_id
                };
            if (validateEmail(remail)) userdata.email = remail;
            var waitdiv = $('<div class="og_wait" id="keygen"></div');
            waitdiv.append('<i class="fa-key icon-key fa fa-spin icon-spin"/><span>' + gt('Initializing Guard, please wait') + '</span>');
            $('.window-container-center').append(waitdiv);
            waitdiv.show();
            $.post(ox.apiRoot + '/oxguard/login?action=create&session=' + ox.session, JSON.stringify(userdata), function (data) {
                $('.og_wait').hide();
                if (data.indexOf('ok') > 0) {
                    window.oxguarddata.passcode = null;
                    checkrecipient(view);
                } else {
                    $('.og_wait').hide();
                    notify.yell('error', gt('Problems creating keys, please try again later'));
                    unlock(view);
                }
                
            })
            .fail(function () {
                $('.og_wait').hide();
                notify.yell('error', gt('Problems creating keys, please try again later'));
                unlock(view);
            });
            
        })
        .show(function () { $('input[name="ogname"]').focus(); });
    }
    
    
    function checkrecipient(view) {
        if (window.oxguarddata.passcode === 'No Key') {
            createKeys('', view);
            return;// Do not check recipients until the master key is created (in case mailing to self)
        }
        var from = view.find('.sender-dropdown').val();
        view.find('input[name="to"]').each(function () {
            checkrecip($(this), from, view);
        });
        view.find('input[name="cc"]').each(function () {
            checkrecip($(this), from, view);
        });
        view.find('input[name="bcc"]').each(function () {
            checkrecip($(this), from, view);
        });

    }
    
    function unlock(view) {
        view.find('#statuslock').attr('class', unlockclass);
        view.find('#statuslock').attr('title', gt('Click to enable encryption'));
        view.find('.btn-primary:visible').html(gt('Send'));
        view.find('#OxGuardOn').prop('checked', false);
        saveToHeader(view);
        view.find('.oxguard_key').hide();
    }
    
    function lock(view) {
        view.find('#statuslock').attr('class', lockclass);
        view.find('#statuslock').attr('title', gt('Click to disable encryption'));
        view.find('.btn-primary:visible').html(gt('Send Secure'));
        view.find('#OxGuardOn').prop('checked', true);
        checkrecipient(view);
        view.find('.oxguard_key').show();
        saveToHeader(view);
    }
    
    
    function createExtraPasswordPrompt(view) {
        var dialog = new dialogs.CreateDialog({ width: 450, height: 300, center: true});
        dialog.header($('<h4>').text(gt('Extra Password')));
        var passdiv = $('<div>').addClass('row-fluid');
        passdiv.append('<p>' + gt('This allows you to set an extra password that will be required for reading this item.') + '</p><p>' + gt('Please enter it below') + '</p>');
        var table = $('<table>');
        var row1 = $('<tr>');
        row1.append('<td><span>' + gt('Password') + ':</span></td>');
        var password1 = $('<input id="extrapassword1" type="password" class="oxguard_extrapass"/>');
        var pstd = $('<td>').append(password1);
        row1.append(pstd);
        var row2 = $('<tr>');
        
        row2.append('<td><span>' + gt('Confirm') + ': </span></td>');
        var password2 = $('<input id="extrapassword2" type="password" class="oxguard_extrapass" style="top:130px;"/>');
        var eptd = $('<td>').append(password2);
        row2.append(eptd);
        table.append(row1).append(row2);
        passdiv.append(table);
        password1.keyup(function () {
            if (password1.val() !== password2.val()) {
                $('button[data-action="okx"]').prop('disabled', true);// disable the ok button if not same
            } else {
                $('button[data-action="okx"]').prop('disabled', false);
            }
        });
        password2.keyup(function () {
            if (password1.val() !== password2.val()) {
                password2.css('background-color', 'salmon');
                $('button[data-action="okx"]').prop('disabled', true);
            } else {
                password2.css('background-color', 'white');
                $('button[data-action="okx"]').prop('disabled', false);
            }
        });
        dialog.getBody().append(passdiv);
        dialog
        .addPrimaryButton('ok', gt('OK'), 'okx')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('ok', function () {
            if ($('#extrapassword1').val() !== $('#extrapassword2').val()) {
                $('#reqpassword').attr('checked', false);
                view.find('#passbox').val('');
            } else {
                view.find('#passbox').val(password1.val());// Save the value to the password box
                if (password1.val() === '') {
                    $('#reqpassword').attr('checked', false);
                }
            }
            saveToHeader(view);
        })
        .on('cancel', function () {
            $('#reqpassword').attr('checked', false);
        })
        .show(function () {
            $('#extrapassword1').focus();
            password1.val(view.find('#passbox').val());
            password2.val(view.find('#passbox').val());
        });
    }
    
    function createlock(view) {
        
        var lockstatus = $('<div id="lockdiv" style="float:right;"><i id="statuslock" class="' + unlockclass + '" title="' + gt('Click to enable encryption') + '"></div>');
        var subjectline = view.find('.subject-wrapper');
        subjectline.after(lockstatus);
        lockstatus.click(function () {
            if (view.find('#OxGuardOn').is(':checked') === true) {
                view.find('#statuslock').attr('class', unlockclass);
                view.find('#statuslock').attr('title', gt('Click to enable Guard'));
                view.find('.oxguard_key').hide();
                view.find('#OxGuardOn').prop('checked', false);
                $('.btn-primary[data-action="send"]:visible').each(function () {
                    $(this).html(gt('Send'));
                });
                saveToHeader(view);
            } else {
                view.find('#statuslock').attr('class', lockclass);
                view.find('#statuslock').attr('title', gt('Click to disable Guard'));
                view.find('#OxGuardOn').prop('checked', true);
                view.find('.oxguard_key').show();
                $('.btn-primary[data-action="send"]:visible').each(function () {
                    $(this).html(gt('Send Secure'));
                });
                saveToHeader(view);
                checkrecipient(view);
            }
        });
    }


    return {
        
        checkRecip : function (view) {
            
            checkrecipient(view);
            
        },
        
        checkScroll : function check(num) {
            checkscroll(num);
        },

        updateheader : function updateHeader(view) {
            saveToHeader(view);
        },
        

        // Create the oxguard options box on the left of compose
        createOptions : function createOptions(view) {
            
            // Lets see if we should allow user to see OxGuard compose
            if ((window.oxguarddata.settings.oxguard === false) || (window.oxguarddata.settings.oxguard === undefined)) {
                if (window.oxguarddata.action !== 'secureReply') {// OK if secure reply, otherwise
                    var headerstring = view.find('[name="headers"]').val();// Check for OG header
                    // Make sure header string exists and populated
                    if (typeof headerstring !== 'undefined') {
                        if (headerstring.length > 1) {
                            var header = JSON.parse(headerstring);
                            // If oxguard didn't update header, then return
                            if (typeof header['X-OxGuard'] === 'undefined') {
                                return;
                            }
                        } else return;
                    } else return;
                }
            }
            if (window.oxguarddata.action === 'sendfile') {// If it is going to be sending already encrypted file, then don't add encryption options
                window.oxguarddata.action = null;
                return;
            }
            if (window.oxguarddata.sentfolder === undefined) {// Get sent folder data for sending
                require(['settings!io.ox/mail']).done(function (settings) {
                    window.oxguarddata.sentfolder = settings.get('folder/sent');
                });
            }
            view.find('.subject-wrapper').css('right', '40px');
            view.find('.priority-overlay').css('right', '53px');
            createlock(view);
            // div seperator for each item
            var sectiondiv = '<div class="section-item oxguard_options" style="padding-top: 0.1em; padding-bottom: 0.2em; line-height: 2em;">';
            // Enabled and disabled buttons
            var oxguard = $('<input type="checkbox" id="OxGuardOn" name="reqpassword" value="reqpass" style="margin-top: -5px;margin-right:5px;">');
            var guard = $('<span style="padding-right:5px;padding-bottom:15px;"></span>');
            guard.append(oxguard).append(gt('Enable Guard'));
            var onoff = $(sectiondiv + '</div>').append(guard);
            // Main options DIV

            var optionsdiv = $('<div class="section-item oxguard_options" id="oxguarddiv" style="display:none; margin-top:5px;"></div>');
            // Put it together
            //#. Retract email in selected time.  Next is dropdown box with options of time
            var selector = $(sectiondiv + '<span style="padding-right:5px;">' + gt('Retract in') + ': </span><select class="oxguard_option" id="expdatepicker" style="width:100px; left:7px;"><option value="0">' + 
                    //#. Never retract email (default setting)
                    gt('Never') + '</option>' +
                    //#. Time until email is retracted
            '<option value="24">' + gt('%s hours', '24') + '</option><option value = "48">' + gt('%s hours', '48') + '</option><option value="72">' + gt('%s hours', '72') + '</option><option value="168">' + gt('%s week', '1') + '</option><option value="336">' + gt('%s weeks', '2') + '</option>' +
            '</select></span></div>');
            var passoption = $(sectiondiv + '<span style="padding-right:5px;padding-top:15px;">' +
                    '<input type="checkbox" id="reqpassword" name="reqpassword" value="reqpass" style="margin-top: -5px;margin-right:5px;">' + gt('Require Additional Password') + '</span></div>');
        //    var passwordbox = $(sectiondiv + '<input class="oxguard_option" type="password" id="passbox" placeholder="Password" style="width:100px;"/></div>');
            var passwordbox = $('<input type="hidden" id="passbox"/>');
            optionsdiv.append(onoff);
            if (window.oxguarddata !== undefined) {
                if (window.oxguarddata.settings.extrapass !== 'false') {
                    optionsdiv.append(passoption).append(passwordbox);
                }
            }
            optionsdiv.append(selector);
            passwordbox.hide();

            passoption.click(function () {
                if (view.find('#reqpassword').is(':checked')) {
                    lock(view);
                    saveToHeader(view);
                    createExtraPasswordPrompt(view);
                } else {
                    saveToHeader(view);
                }
            });

            // Put the lock up if enabled
            oxguard.click(function () {
                saveToHeader(view);
                if (view.find('#islocked').length === 0) {
                    if (oxguard.is(':checked')) {
                        view.find('#statuslock').attr('class', lockclass);
                        view.find('#statuslock').attr('title', gt('Click to disable encryption'));
                        view.find('.btn-primary:visible').html(gt('Send Secure'));
                        checkrecipient(view);
                        view.find('.oxguard_key').show();
                    } else {
                        view.find('#statuslock').attr('class', unlockclass);
                        view.find('#statuslock').attr('title', gt('Click to enable encryption'));
                        view.find('.btn-primary:visible').html(gt('Send'));
                        saveToHeader(view);
                        view.find('.oxguard_key').hide();
                    }

                }
            });
            if (view === null) createExtraPasswordPrompt(view);
            var securelink = $('<div class="section-link"></div>');
            var secureoptions = $('<a href="#" id="oxguardlink" data-section-link="security">' + gt('Security Options') + '</a>');
            securelink.append(secureoptions);
            securelink.append(optionsdiv);
            view.find('[data-section-link="options"]').parent().before(securelink);
            secureoptions.click(function (ev) {
                if (optionsdiv.is(':visible')) {
                    optionsdiv.slideUp();
                    ev.preventDefault();
                    return;
                }
                // If already created, just slide down
                if (optionsdiv.length > 0) {
                    optionsdiv.slideDown();
                    ev.preventDefault();
                    return;
                }
            });
            $('#expdatepicker').on('change', function () {
                if ($('#expdatepicker').val() !== '0') {
                    lock(view);
                }
            });
            // If this is a secure reply, then disable all of the options to make it plain text
            if ((window.oxguarddata.action === 'secureReply') || (window.oxguarddata.action === 'fileAttach')) {
                view.find('#statuslock')
                 //   .attr("src", "apps/oxguard/images/lock32.png")
                    .attr('class', lockclass)
                    .click(false)
                    .attr('title', gt('Reply must be encrypted'));
                view.find('.btn-primary:visible').html(gt('Send Secure'));
                view.find('#OxGuardOn').prop('checked', true).prop('enabled', false).prop('disabled', true);
                if ((window.oxguarddata.action === 'secureReply') && (window.oxguarddata.settings.oxguard === false)) {
                    // If secure reply, and does not have OG, only allow reply to orig 
                    $('#writer_field_to').remove();
                    $('#writer_field_cc').remove();
                    $('#writer_field_bcc').remove();
                }

                window.setTimeout(function () {
                    saveToHeader(view);
                    checkrecipient(view);
                }, 5000);
            }

            // Handlers for updating header for storage
            $(document).ready(function () {
                view.find('.oxguard.radio').click(function () {
                    saveToHeader(view);
                });
                view.find('#expdatepicker').change(function () {
                    saveToHeader(view);
                });
                view.find('#passbox').on('input', function () {
                    saveToHeader(view);
                });
                window.setTimeout(function () {
                    retrieveOxGuard(view);
                    saveToHeader(view);
                }, 500);
            });

            return;
        },
        
        createKeys : createKeys,
        saveToHeader : saveToHeader
        
    
    };
});
    

    