/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/mail/oxguard_mail', ['io.ox/core/extensions', 'io.ox/mail/write/main', 'io.ox/mail/main',
                                     'io.ox/core/tk/dialogs', 'oxguard/oxguard_core', 'oxguard/mail/oxguard_mail_write_core',
                              'io.ox/core/http', 'gettext!oxguard/mail/oxguard_mail', 'io.ox/core/notifications'],
                              function (ext, mailmain, mail, dialogs, oxguard, write_core, http, gt, notifications) {
    'use strict';
    
    var encrPrivKey = '';
    var timer = null;
    ////////////   SENDING
    
    // Get files for upload
    function getFiles(baton, mail, authorization, guestdata, pass) {
        var view = baton.app.getView();

        var secure_reply = getReturnId(view.form);
        
        if (window.FormData === undefined) {
            var form = view.form.find('.oldschool');
            return upload({
                auth: authorization,
                data: mail,
                form: form,
                field: 'json_0'
            }, guestdata, pass);
        } else {
            var def = $.Deferred();

            var formData = new FormData();
            formData.append('json_0', JSON.stringify(mail));
            if (guestdata !== null) {
                formData.append('guest_message', guestdata.message);
            }

            for (var l = 0; l < mail.files.length; l++) {
                formData.append('file' + l, mail.files[l]);
            }
            var xhr = new XMLHttpRequest();
            var url = ox.apiRoot + '/oxguard/mail?action=emailform' +
            '&session=' + ox.session + '&userid=' + ox.user_id + '&cid=' + ox.context_id +
            '&sentfolder=' + encodeURIComponent(window.oxguarddata.sentfolder) +
            '&lang=' + ox.language + (guestdata === null ? '' : '&guestlanguage=' + guestdata.language) +
            ((secure_reply === undefined) ? '' : ('&sr=' + secure_reply)) +
            ((pass === undefined) ? '' : ('&password=' + encodeURIComponent(pass.password) + ((pass.extrapass === '') ? '' : '&extrapass=' + encodeURIComponent(pass.extrapass))));
            xhr.open('POST', url);
            
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4) {
                    if (xhr.status !== 200) {
                        def.reject(xhr.responseText);
                    } else {
                        def.resolve('success');
                    }
                }
            };
            xhr.send(formData);
            return (def);
        }
        
    }
    
    // Upload data to server
    function upload(options, guestdata, pass) {

        options = _.extend({
            module: 'mail',
            action: 'emailform',
            params: {},
            form: $(),
            field: 'json'
        }, options);

        var name = 'formpost_' + _.now(),
            def = $.Deferred(),
            data = JSON.stringify(options.data),
            url = ox.apiRoot + '/oxguard/' + options.module + '?action=' + options.action +
            '&session=' + ox.session + '&userid=' + ox.user_id + '&cid=' + ox.context_id +
            '&sentfolder=' + encodeURIComponent(window.oxguarddata.sentfolder) +
            '&lang=' + ox.language + (guestdata === null ? '' : '&guestlanguage=' + guestdata.language) +
            ((pass === undefined) ? '' : ('&password=' + encodeURIComponent(pass.password) + ((pass.extrapass === '') ? '' : '&extrapass=' + encodeURIComponent(pass.extrapass)))),
            form = options.form;

        var uploadframe = $('<iframe>', { name: name, id: name, height: 1, width: 1, src: ox.base + '/blank.html' });
        $('#tmp').append(uploadframe);
        uploadframe.load(function () {
            var result = uploadframe.contents()[0].children[0].innerText;
            if (result === 'OK') {
                def.resolve('success');
            } else {
                def.reject(result);
            }
        });
        
        if (form.find('input[name="' + options.field + '"]').length) {
            form.find('input[name="' + options.field + '"]').val(data);
        } else {
            form.append(
                $('<input type="hidden" name="' + options.field + '">').val(data)
            );
        }

        form.prop({
            method: 'post',
            enctype: 'multipart/form-data',
            encoding: 'multipart/form-data',
            action: url + '&' + _.serialize(options.params),
            target: name
        });

        form.submit();

        return def;
    }
    
    // Main send function
    function send(baton, auth, guestdata, pass)
    {
        var view = baton.app.getView().form;
        write_core.saveToHeader(view);  // Make sure headers updated
        
        var mail = baton.app.getMail(); // Get the email
        
        if (($('#newguest').length > 0) && (guestdata === null)) {
            guestOptions(baton, auth);
            return;
        }
        if (pass === undefined) {
            var encrAttach = checkPasswordNeeded(mail);
            if (encrAttach > 0) {
                getPassword(baton, auth, guestdata, encrAttach);
                return;
            }
        }
        spinRefresh();
        getFiles(baton, mail, auth, guestdata, pass)
        .done(function () {
            stopSpinRefresh();
        })
        .fail(function () {
            stopSpinRefresh();
            notifications.yell('error', gt('An error occurred during sending the encrypted email.'));
        });
        baton.app.dirty(false);
        baton.app.quit();
    }
    
    function spinRefresh() {
        var spinner = $('#io-ox-refresh-icon').find('i');
        timer = window.setInterval(function () {
            if (spinner.hasClass('fa-spin-paused')) {
                spinner.removeClass('fa-spin-paused').addClass('fa-spin');
            }
        }, 2000);
        spinner.removeClass('fa-spin-paused').addClass('fa-spin');
    }
    
    function stopSpinRefresh() {
        window.clearInterval(timer);
        $('#io-ox-refresh-icon').find('i').removeClass('fa-spin').addClass('fa-spin-paused');
    }
    
    function getReturnId(view) {
        try {
            var headers = JSON.parse(view.find('input[name="headers"]').val());
            return (headers['X-OxGuard-ReplyId']);
        } catch (ex) {
            console.log('OG: error parsing headers');
            console.log(ex);
            return (undefined);
        }
    }
    
    // Display options for guest account header (introduction)
    function guestOptions(baton, auth) {
        var dialog = new dialogs.CreateDialog({ width: 490, center: true,  enter : 'ok'});
        dialog.header($('<h4>').text(gt('Recipient Options')));
        var help = $('<p>' + gt('At least one of your recipients uses a different webmail system.  They will receive an email with a link for them to read this message.  If you like, you can add a personalized message that will appear at the top of this message.  This will help identify the message as coming from you.') + '</p>');
        var messageLabel = $('<label>' + gt('Message:') + '</label>');
        var message = $('<textarea type="text" id="message" class="og_guest_message"></textarea>');
        var languageLabel = $('<br/><label>' + gt('Automated Email Language') + '</label>');
        var langselect = $('<select class="og_language"></select>');
        // Populate language selector with languages avail
        var languages = window.oxguarddata.lang;
        $.each(languages, function (c, n) {
            langselect.append('<option value="' + c + '">' + n + '</option>');
        });
        dialog.getBody().append(help).append(messageLabel).append(message).append(languageLabel.append(langselect));
        dialog.addPrimaryButton('ok', gt('OK'), 'ok')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('ok', function () {
            var data = {
                    message : message.val(),
                    language: langselect.val()
                };
            send(baton, auth, data);
        });
        dialog.show(function () {
            var urlLang = ox.language;
            if ($('.og_language option[value="' + urlLang + '"]').length > 0) {
                langselect.val(urlLang);
            } else {
                langselect.val(urlLang.substring(0, 2));
            }
        });
    }
    
    function checkPasswordNeeded(mail) {
        for (var i = 0; i < mail.data.infostore_ids.length; i++) {
            if (mail.data.infostore_ids[i].filename.indexOf('.grd') > 0) {
                if (mail.data.infostore_ids[i].filename.indexOf('.grd2') > 0) return (2);
                return (1);
            }
        }
        for (var j = 0; j < mail.files.length; j++) {
            if (mail.files[j].name.indexOf('.grd') > 0) {
                if (mail.files[j].name.indexOf('.grd2') > 0) return (2);
                return (1);
            }
        }
        return (0);
    }
    
    function getPassword(baton, auth, data, level) {
        var dialog = new dialogs.CreateDialog({ width: 490, center: true,  enter : 'ok'});
        dialog.header($('<h4>').text(gt('Password Needed')));
        var help = $('<p>' + gt('At least one of your attachments are encrypted.  Please provide your Guard Security Password to decode before sending') + '</p>');
        var pass = $('<input name="password" id="password" type="password"/>');
        dialog.getBody().append(help).append(pass);
        if (level > 1) {
            var extrapasshelp = $('<p>' + gt('Extra Password') + '</p>');
            var extra = $('<input name="extrapass" id="atextrapass" type="password"/>');
            dialog.getBody().append(extrapasshelp).append(extra);
        }
        dialog.addPrimaryButton('ok', gt('OK'), 'ok')
        .on('ok', function () {
            var extrap = $('#atextrapass').val();
            var pass = {
                    password : $('#password').val(),
                    extrapass : (extrap === undefined) ? '' : extrap,
                };
            send(baton, auth, data, pass);
            
        });
        dialog.show(function () {
            pass.focus();
        });
    }
    
    
    ////////////////////////   RECEIVE / READ
    
    // Get the extra password if not previously provided
    function promptExtraPass(baton, auth, password) {
        var dialog = new dialogs.CreateDialog({ width: 450, center: true, enter : 'ok'});
        dialog.header($('<h4>').text(gt('Extra Password')));
        var passdiv = $('<div>').addClass('row-fluid');
        passdiv.append('<p>' + gt('The sender added an extra password encryption.') + '</p><p>' + gt('Please enter it below') + '</p>');
        passdiv.append('<input name="extrapassword" type="password"/>');
        dialog.getBody().append(passdiv);
        dialog
        .addPrimaryButton('ok', gt('OK'), 'ok')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('ok', function () {
            getMail(baton, auth, password, $('input[name="extrapassword"]').val());
            
        })
        .show(function () { $('input[name="extrapassword"]').focus(); });
    }
    
    // Retrieve decoded email and replace template
    function getMail(baton, auth, password, extrapass, location, cc) {
        var deferred = $.Deferred();
        var attachid = 0;// Find the attachment that contains the data, an get number
        if (baton.data.attachments === undefined) return;
        for (var j = 0; j < baton.data.attachments.length; j++) {// Find the attachment ID
            if (baton.data.attachments[j].filename === baton.data.headers['X-OxGuard-ID'] + '.grd') {
                attachid = baton.data.attachments[j].id;
                baton.model.set('attachid', attachid);
            }
        }
        if (attachid === 0) {// Already resolved, or no attachment
            if (baton.data.og) {
                if (baton.data.attachid !== undefined) {
                    attachid = baton.data.attachid;
                } else return (deferred);
            }
        }
        if (baton.data.headers['X-OxGuard-ExtraPass'] === 'true') {
            if (extrapass.length < 2) {
                promptExtraPass(baton, auth, password);
                return;
            }
        }
        var eid = getId(baton);
        window.setTimeout(function () {// Diplay wait symbol
            //#. Decoding an email, shown in wait dialog
            baton.view.$el.find('.content').replaceWith('<div class="content" id="content' + eid + '" style="padding-top:20px;width:100px;margin-left:auto;margin-right:auto;">' + gt('Decoding') + '<i class="fa fa-spinner fa-spin" style="margin-left:10px;"></i></div><div class="error" id="error' + eid + '"/>');
            baton.view.$el.show();
            baton.view.$el.find('.attachments').hide();
           // $('.attachments').hide();
        }, 20);
        var id = baton.data.headers['X-OxGuard-ID'];
        var params = '&auth=' + encodeURIComponent(auth) + '&time=' + new Date().getTime() + '&session=' + ox.session;
        var json = {
                itemid : id,
                folder : getFolder(baton),
                userid : ox.user_id,
                cid : ox.context_id,
                password : password,
                session : ox.session,
                attach : attachid,
                emailid : eid,
                extrapass : extrapass,
                cc : cc ? cc : ''
        };
        // Send the request to the oxguard server
        $.post(ox.apiRoot + '/oxguard/mail?action=getmail' + params, JSON.stringify(json), function (data) {
            try {
                var data2 = JSON.parse(data);
                if (data2.Exceeded !== undefined) {
                    notifications.yell ('error', gt('You have exceeded bad password attempts.  Please wait %s minutes', data2.Exceeded));
                    baton.view.$el.find('.content').replaceWith(gt('You have exceeded bad password attempts.  Please wait %s minutes', data2.Exceeded));
                    deferred.reject('Exceeded');
                    return (deferred);
                }
                var newattachments = [];
                baton.data.attachment = false;
                for (var i = 0; i < baton.data.attachments.length; i++) {
                    // Search for attchments, and add necessary link data, copy decoded
                    baton.data.attachments[i].decoded = true;
                    if (baton.data.attachments[i].disp === 'attachment') {
                        if (baton.data.attachments[i].filename.indexOf('.grd') > 0) {
                            baton.data.attachments[i].epass = data2.epass;
                            baton.data.attachments[i].extrapass = data2.extrapass;
                            baton.data.attachments[i].cc = cc;// Store content key for the attachment if any
                            baton.data.attachments[i].title = baton.data.attachments[i].title.replace('.grd2', '').replace('.grd', '');
                            baton.data.attachments[i].filename = baton.data.attachments[i].filename.replace('.grd2', '').replace('.grd', '');
                            if (baton.data.attachments[i].id !== attachid) {// If not the encrypted body
                                newattachments.push(baton.data.attachments[i]);
                                baton.data.attachment = true;
                                baton.data.attachments[i].ogAttach = true;
                            }
                        }
                        else { // After 1 or 2 calls, the ui copies the view data over to baton, so already decoded.  Just add it
                            if (baton.data.attachments[i].ogAttach) {
                                newattachments.push(baton.data.attachments[i]);
                                baton.data.attachment = true;
                            }
                        }

                    }
                }
                for (j = 0; j < data2.attachments.length; j++) {
                    if (data2.attachments[j].disp === 'inline') {
                        var type = data2.attachments[j].content_type;
                        if ((type.indexOf('text') > -1) || (type.indexOf('alternative') > -1)) {// add text attachments
                            if (type === 'alternative') {
                                type = 'text/html';
                                data2.attachments[j].content_type = type;
                            }
                            newattachments.push(data2.attachments[j]);
                            baton.data.replytext = data2.attachments[j].content;
                            baton.data.replytype = type;
                        }
                        
                    }
                }
                baton.data.attachments = newattachments;
  // Update headers and subject
                baton.data.headers = data2.headers;
                baton.data.ogId = id;
                baton.model.set('exp', data2.exp);
                baton.decoded = true;
                // copy the model to a new temporary for display
                var mdata = _.copy(baton.view.model.toJSON(), true);
                mdata.to = data2.to;
                baton.data.to = data2.to;
                baton.data.cc = data2.cc;
                mdata.cc = data2.cc;
                mdata.from = data2.from;
                baton.data.replyfrom = data2.from;
                mdata.attachments = newattachments;
                mdata.attachment = baton.data.attachment;
                mdata.subject = data2.subject;
                baton.model.set('subject', data2.subject);  // Perm set subject
                mdata.headers = data2.headers;
                mdata.headers['X-OxGuard-ID'] = id;
                mdata.headers['X-Oxguard-Done'] = 'True';
                mdata.decoded = true;
                baton.decodedData = mdata;
                baton.view.model = new Backbone.Model(mdata);
                baton.view.loaded = true;
                baton.view.$el.empty();// Clear out the old template email data
                baton.view.redraw();
                baton.view.expand();                
                baton.view.$el.find('.attachment-preview').hide();
                window.oxguarddata.temp = JSON.parse(JSON.stringify(baton.data));

                if (ox.serverConfig.version.indexOf('7.6.0') === 0) {
                    if (!baton.data.attachments) baton.view.$el.find('.attachments').remove();

                } else {
                    if (baton.data.attachment) {
                        window.setTimeout(function () {
                            var baton2 = ext.Baton({ data: data, attachments: newattachments });
                            var node = baton.view.$el.find('section.attachments').empty();
                            ext.point('io.ox/mail/detail/attachments').enable('attachment-list');
                            ext.point('io.ox/mail/detail/attachments').invoke('draw', node, baton2);
                        }, 0);
                    } else {
                        baton.view.$el.find('.attachments').remove();
                    }
                }
                baton.view.$el.find('.alert.external-images').hide();
                deferred.resolve('OK');
            } catch (e) {
                var cont = '#content' + eid;
                if (data.indexOf('expired') >= 0) {
                    baton.view.$el.find(cont).replaceWith('<br>' + gt('This email has expired and can no longer be accessed.  Contact the sender for more information.') + '</hr>');
                    deferred.reject('expired');
                    return;
                }
                if (data.indexOf('retracted') >= 0) {
                    baton.view.$el.find(cont).replaceWith('<br>' + gt('This Email has been retracted by the sender and can no longer be accessed.  Contact the sender for more information.') + '</hr>');
                    deferred.reject('retracted');
                    return;
                }
                if (baton.view.$el !== null) baton.view.$el.find(cont).replaceWith(gt('Unable to decrypt Email.'));
                console.log(e);
                deferred.reject('error');
            }
            
        })
        .fail(function (data) {
            baton.view.loaded = true;
            window.oxguarddata.priv = undefined;
            baton.view.$el.find('#content' + eid).replaceWith(passwordPrompt(baton, true));
            if (data.status == 503) {
                baton.view.$el.find('#error' + eid).replaceWith('<div class="error" id="error' + eid + '"><br>' + gt('Unable to connect to the encryption server.') + '</hr></div>');
            } else {
                baton.view.$el.find('#error' + eid).replaceWith('<div class="error" id="error' + eid + '"><br>' + gt('Unable to decrypt Email, incorrect password.') + '</hr></div>');
            }
            baton.view.$el.find('.body').show();
            try {// blank out auth if present
                if (window.oxguarddata.passcode.length > 20) window.oxguarddata.passcode = null;
            } catch (ex) {
                
            }
            deferred.reject('error');
        });
        return (deferred);
    
    }
    
    function loadKeyClick(evt) {
        var file = evt.target.files[0];
        var reader = new FileReader();

        reader.onload = function (event) {
            encrPrivKey = event.target.result;
            $('#privKeyButton').html(gt('Loaded'));
        };
        reader.readAsText(file);
    }
    
    
    function localDecode(baton, auth, password, extrapass, location) {

        require(['oxguard/crypto/encr', 'oxguard/crypto/jsencrypt'], function (encr, JS) {
            var privkey = window.oxguarddata.priv;
            if (privkey === undefined) privkey = encr.decodeKey(encrPrivKey, password);// Decode the private key
            encrPrivKey = null; // null out the global var
            if (privkey === undefined) {
                //#. User selected wrong or corrupt private key to decode email (Not yet implemented)
                notifications.yell('error', gt('Bad private key'));
                $('#busygif').hide();
                
            } else {
                var id = baton.data.headers['X-OxGuard-ID'];
                var params = '&itemid=' + id + '&userid=' + ox.user_id + '&cid=' + ox.context_id +
                '&session=' + ox.session;
                // Send the request to the oxguard server for the encrypted content key to decode
                $.get(ox.apiRoot + '/oxguard/keys?action=getCKey' + params, function (data) {
                    try {
                        var decrypt = new JS.JSEncrypt();
                        decrypt.setPrivateKey(privkey);
                        var eid = getId(baton);
                        var decodedKey = decrypt.decrypt(data.trim());// Decode the content key
                        if ($('input[name="rememberpass' + eid + '"]').is(':checked')) {
                            window.oxguarddata.priv = privkey;
                            var time = $('#duration' + eid) * 1000 * 60;
                            window.setTimeout(function () {
                                window.oxguarddata.priv = undefined;
                            }, time);
                        }
                        getMail(baton, '', '', extrapass, location, decodedKey);// Get the mail
                    } catch (e)
                    {
                        console.log(e);
                    }
                })
                .fail(function () {
                    //#. Unable to decode the email
                    notifications.yell('error', gt('Failed to decode'));
                });
            }
        });

    }
    
    // Unified inbox combines folder and email ID, returns email id
    function getId(baton) {
        var id = decodeURIComponent(baton.data.id);
        try {
            id = id.substring(id.lastIndexOf('/') + 1);
        } catch (e)
            {
            }
        return (id);
    }
    
    // Returns actual folder in unifided inbox for email retrieval
    function getFolder(baton) {
        var id = decodeURIComponent(baton.data.id);
        if (id.indexOf('/') < 0) return (baton.data.folder_id);
        var folder = id.substring(0, id.lastIndexOf('/'));
        return(folder);
    }
    
    function passwordPrompt(baton, badpass, location)
    {
        var id = getId(baton);
        var grdPasswordPrompt = $('<div class="alert" style="width:80%;"/>');
        var mainpassprompt = $('<span style="font-weight:bold;">' + gt('Secure Email, enter your Guard security password') + '</span><div style="height:10px;"/>');
        var passwordbox = $('<input type="password" id="oxgrpass' + id + '" style="margin-bottom:10px;margin-top:7px;"/>');
        var passButton = $('<button class="btn btn-primary oxguard_passbutton" type="button">' + gt('OK') + '</button><br/>');
        var placeholder = $('<span></span><br/>');
        //#. 'Keep me logged into guard' is followed by dropdown box specifying number of minutes or indefinite
        var rememberpass = $('<div><input type="checkbox" name="rememberpass' + id + '" value="true" style="margin-top:-3px;"/><span>&nbsp ' + gt('Keep me logged into Guard') + '</span><br/></div>');
        var duration = $('<select id="duration' + id + '" class="og_duration"><option value="10">' + gt('10 minutes') + '</option>' +
                '<option value="20">' + gt('20 minutes') + '</option>' +
                '<option value="30">' + gt('30 minutes') + '</option>' +
                '<option value="60">' + gt('1 hour') + '</option>' +
                '<option value="120">' + gt('2 hours') + '</option>' +
                '<option value="99999">' + gt('Session') + '</option' +
                '</select>')
                .on('change', function () {
                    $('input[name="rememberpass' + id + '"]').prop('checked', true);
                });
        rememberpass.append(duration);
        //#. Extra passwords can be added to emails for added security.  This is the prompt for it
        var extrapass = $('<span><p style="padding-top:10px;">' + gt('This email was sent with an extra password.') + '<br/>' + 
                //#. Please enter the extra password in the box below
                gt('Please enter below') + ':</p> </span>');
        var extrapassbox = $('<input type="password" id="extrapass' + id + '"/>');
        var cont = $('<br/><div class="error" id = "error' + id + '" style="display:none;"><i class="fa fa-spinner fa-spin" id="busygif"></i></div>');
        if (window.oxguarddata.passcode === 'NoPrivate') {
            if ((window.oxguarddata.priv !== undefined) && (baton.data.headers['X-OxGuard-ExtraPass'] === undefined)) {// If our private key is remembered, just go ahead and decode
                localDecode(baton, '', '', '', rememberpass, location);
                return;
            }
            var btn = $('<button class="btn og_getkey" id="privKeyButton' + id + '">' + gt('Select Key Location') + '</button>');

            var input = $('<input type="file" id="files' + id + '" name="files[] style="padding:10px;visibility:hidden;position:absolute;top-50px;left:-50px;"/>');
            btn.click(function () {
                input.click();
            });
            input.change(function (evt) {
                loadKeyClick(evt);
            });
            placeholder.append(btn.after(input));
        }
        passButton.click(go);
        passwordbox.keypress(function (e) {
            if (e.which === 13) {
               // passButton.click();
                go();
            }
        });
        extrapassbox.keypress(function (e) {
            if (e.which === 13) {
                go();
               // passButton.click();
            }
        });
        var mainprompt = (window.oxguarddata.passcode === null) || badpass || (window.oxguarddata.passcode === 'NoPrivate');
        var extraprompt = (baton.data.headers['X-OxGuard-ExtraPass'] === 'true');
        //$('<div class="content"/>').append(grdPasswordPrompt.append(passButton).append(rememberpass).append(cont));
        if (extraprompt && mainprompt) {
            grdPasswordPrompt.append(mainpassprompt).append(passwordbox).append(placeholder).append(rememberpass).append(extrapass).append(extrapassbox).append(passButton).append(cont);
            window.setTimeout(function () {
                passwordbox.focus();
            }, 100);
        }
        if (!extraprompt && mainprompt) {
            grdPasswordPrompt.append(mainpassprompt).append(passwordbox).append(passButton).append(placeholder).append(rememberpass).append(cont);
            window.setTimeout(function () {
                passwordbox.focus();
            }, 100);
        }
        if (extraprompt && !mainprompt) {
            grdPasswordPrompt.append(extrapass).append(extrapassbox).append(passButton).append(placeholder).append(cont);
            window.setTimeout(function () {
                extrapassbox.focus();
            }, 100);
        }
        function go() {
            $('#error' + id).show();
            var password = ($('#oxgrpass' + id).val() === undefined) ? '' : $('#oxgrpass' + id).val();
            var extrapass = ($('#extrapass' + id).val() === undefined) ? '' : $('#extrapass' + id).val();
            var auth = window.oxguarddata.passcode;
            if (auth === 'NoPrivate') {
                localDecode(baton, auth, password, extrapass, location);
                return;
            }
            if (auth === null) {// if no main password, send for auth/temp check
                if ($('input[name="rememberpass' + id + '"]').is(':checked')) {
                    oxguard.auth(ox.user_id, $('#oxgrpass' + id).val())
                    .done(function (data) {
                        if (data.auth.length > 20) {
                            $('.og_signout').show();
                            window.oxguarddata.passcode = data.auth;
                            getMail(baton, window.oxguarddata.passcode, '', extrapass, location);
                            var time = $('#duration' + id).val() * 1000 * 60;
                            window.setTimeout(function () {
                                window.oxguarddata.passcode = null;
                                $('.og_signout').hide();
                            }, time);
                        } else {
                            //#. Bad, incorrect password
                            $('#busygif').hide();
                            if (data.auth.indexOf('Lockout') > -1) {
                                notifications.yell('error', gt('Temporary Lockout'));
                            } else
                                notifications.yell('error', gt('Bad password'));
                        }
                    });
                } else {
                    getMail(baton, auth, password, extrapass, location);
                }
            } else {
                getMail(baton, auth, password, extrapass, location);
            }
        }
        
        var contdiv = $('<div class="content" id = "content' + id + '"/>').append(grdPasswordPrompt);
        return (contdiv);
    }
    
   
    
    return {
        sendMail: function sendmail(baton, auth) {
            send(baton, auth, null);
        },
        //Retrieve an encrypted email from OxGuard server
        getMail: getMail,
        passwordPrompt : passwordPrompt
            
    };
    
    
    
});
