define('oxguard/mail/maillist', ['io.ox/mail/common-extensions', 'io.ox/core/extensions'],
       function (extensions, ext) {
    'use strict';
    
    var lockclass = 'icon-lock icon-2x fa fa-lock fa-2x oxguard_icon_fa';
   
    
    // Disable default paper clip, as all oxguard emails have attachments.  Will call manually.
    ext.point('io.ox/mail/listview/item/default/row2').disable('paper-clip');
    ext.point('io.ox/mail/listview/item/small/col4').disable('paper-clip');
    
    
    ext.point('io.ox/mail/listview/item/default/row2').extend({
        id: 'OGpaper-clip',
        index: 300,
        draw: function (baton) {
            addLock.call(this, baton);
        }
    });
    // Extension point for List view, change in 7.6.1   
    if (ox.serverConfig.version.indexOf('7.6.0') === 0) {
        console.log('7.6.0 version loaded');
        ext.point('io.ox/mail/listview/item/small/col4').extend({
            id: 'OGpaper-clipSm',
            index: 300,
            draw: function (baton) {
                addLock.call(this, baton);
            }
        });
    } else {
        ext.point('io.ox/mail/listview/item/small/col5').disable('paper-clip');
        ext.point('io.ox/mail/listview/item/small/col5').extend({
            id: 'OGpaper-clipSm',
            index: 300,
            draw: function (baton) {
                addLock.call(this, baton);
            }
        });
    }


    
    // Check if OxGuard email, and if so, add lock icon.  Add paperclip if applicable
    function addLock(baton) {
        try {
            if (baton.data.attachment === undefined) {
                return;
            }
            if (baton.model === undefined) {
                extensions.paperClip.call(this, baton);
                return;
            }
            var headers = baton.model.get('headers');
            if (headers === undefined) {
                extensions.paperClip.call(this, baton);
                return;
            }
            if (headers['X-OxGuard-ID'] !== undefined) {
                baton.data.og = true;
                baton.model.set('og', true);
                this.append($('<i class="' + lockclass + '" aria-hidden="true">'));
                var attachments = baton.model.get('attachments');
                if (attachments === undefined) {
                    return;
                }
                var hasattach = false;
                for (var i = 0; i < attachments.length; i++) {// check for attachments
                    if (attachments[i].disp !== 'inline') {
                        if (attachments[i].filename.indexOf(headers['X-OxGuard-ID']) < 0) {
                            if ((attachments[i].ogAttach === true) || (attachments[i].filename.indexOf('.grd') > 0)) // Screen for generated part attachments
                                hasattach = true; // if not main body encr attachment
                        }
                    }
                }
                if (hasattach) {// If we have attachment, add icon
                    extensions.paperClip.call(this, baton);
                }
            } else extensions.paperClip.call(this, baton);
        } catch (ex) {
            console.log('Problem checking list for OG email');
            console.log(ex);
        }

    }
    
    
    ext.point('io.ox/mail/detail/header').extend({
        id: 'OGHpaper-clip',
        after: 'flag-picker',
        draw: function (baton) {
            if (baton.data.decoded === true) {
       //         var lockicon = $('<i class="' + lockclass + '" aria-hidden="true" title="' + gt('This Email was secured with Guard and has been decrypted.') + '"/>');
       //         lockicon.click(function () {
       //             require(['oxguard/mail/register_mail', 'io.ox/core/api/account'], function (mail, account) {
        //                if (_.contains(account.getFoldersByType('sent'), baton.data.folder_id)) {
         //                   mail.status(baton);
         //               }
         //           });
         //       });
         //       this.append(lockicon);
                if (baton.data.attachments === undefined) return;
                if (baton.data.attachments.length > 1) {// If we do have more than one attachment, add icon
                    extensions.paperClip.call(this, baton);
                }
            } else extensions.paperClip.call(this, baton);
        }
    });
    
    ext.point('io.ox/mail/detail/header').disable('paper-clip');
 

});
