define('oxguard/file/uploader', ['io.ox/core/extensions', 'io.ox/files/api', 'io.ox/core/http', 'io.ox/core/tk/attachments',
                                 'settings!io.ox/core', 'gettext!oxguard/file/uploader'],
                                 function (ext, api, http, attachments, coreConfig, gt) {
    'use strict';
    

    function ieform(options) {

        options = _.extend({
            module: 'oxguard/files',
            action: 'new',
            data: {},
            params: {},
            form: $(),
            field: 'json'
        }, options);

        var name = 'formpost_' + _.now(),
            callback = 'callback_' + options.action,
            callback_old = 'callback_' + options.module,
            def = $.Deferred(),
            data = JSON.stringify(options.data),
            url = ox.apiRoot + '/' + options.module + '?action=' + options.action + '&session=' + ox.session +
                '&userid=' + ox.user_id + '&cid=' + ox.context_id,
            form = options.form;

        $('#tmp').append(
            $('<iframe>', { name: name, id: name, height: 1, width: 1, src: ox.base + '/blank.html' })
        );
        window[callback] = function (response) {
            // skip warnings
            if (_.isArray(response.data)) {
                // Skip Warnings (category: 13)
                response.data = _(response.data).map(function (o) {
                    if (o.category !== 13) {
                        return o;
                    }
                });
            }
            def[(response && response.error ? 'reject' : 'resolve')](response);
            window[callback] = data = form = def = null;
            $('#' + name).remove();
        };
        // fallback for some old modules (e.g. import)
        window[callback_old] = window[callback];

        if (form.find('input[name="' + options.field + '"]').length) {
            form.find('input[name="' + options.field + '"]').val(data);
        } else {
            form.append(
                $('<input type="hidden" name="' + options.field + '">').val(data)
            );
        }

        form.prop({
            method: 'post',
            enctype: 'multipart/form-data',
            encoding: 'multipart/form-data',
            action: url + '&' + _.serialize(options.params),
            target: name
        });
        form.submit();

        return def;
    }

    var failedUpload = function (e) {
        e.data = e.data || {};
        //customized error messages
        if (e && e.code && (e.code === 'UPL-0005' || e.code === 'IFO-1700')) {
            e.data.custom = {
                type: 'error',
                text: gt('%s %s %s', e.error, e.error_params[0], e.error_params[1])
            };
        } else if (e && e.code && e.code === 'IFO-0100' && e.problematic && e.problematic[0] && e.problematic[0].id === 700) {
            e.data.custom = {
                type: 'error',
                text: gt('The provided filename exceeds the allowed length.')
            };
        } else if (e && e.code && e.code === 'FLS-0024') {
            e.data.custom = {
                type: 'error',
                text: gt('The allowed quota is reached.')
            };
        } else {
            e.data.custom = {
                type: 'error',
                text: gt('This file has not been added') + '\n' + e.error
            };
        }
        return e;
    };
    
    function setNotEncrypted() {
        api.encrypted = false;
    }
    
    function multipleEncrypted() {
        api.multi = true;
    }
    
    function endMulti() {
        api.multi = false;
        api.encrypted = false;
    }
    
    function setEncrypted() {
        api.encrypted = true;
        
        //// Taken from io.ox/files/api.  Rewrites to  allow for encrypted upload
        
        api.uploadFile = function (options) {
            // alright, let's simulate a multipart formdata form
            options = $.extend({
                folder: coreConfig.get('folder/infostore')
            }, options || {});
            function fixOptions() {
                if (options.json && !$.isEmptyObject(options.json)) {
                    if (!options.json.folder_id) {
                        options.json.folder_id = options.folder;
                    }
                } else {
                    options.json = { folder_id: options.folder };
                }
            }
    
            function success(data) {
                // clear folder cache
                var fid = String(options.json.folder_id);
                return api.propagate('new', { folder_id: fid }, true).pipe(function () {
                    api.trigger('create.file');
                    return { folder_id: fid, id: parseInt(data.data, 10) };
                });
            }
    
            if ('FormData' in window) {
                var formData = new FormData();
                if ('filename' in options) {
                    formData.append('file', options.file, options.filename);
                } else {
                    formData.append('file', options.file);
                }
    
                fixOptions();
                formData.append('json', JSON.stringify(options.json));
                if (api.encrypted) {
                    if (!api.multi) api.encrypted = false;// reset to not encrypted
                    return http.UPLOAD({
                        module: 'oxguard/files',
                        params: { action: 'new', filename: options.filename, userid: ox.user_id, cid: ox.context_id },
                        data: formData,
                        fixPost: true
                    })
                    .pipe(success, failedUpload);
                } else {
                    return http.UPLOAD({
                        module: 'files',
                        params: { action: 'new', filename: options.filename },
                        data: formData,
                        fixPost: true
                    })
                    .pipe(success, failedUpload);
                }

    
            } else {
    
                // good old form post
                fixOptions();
                if (options.form) {
                    options.form.off('submit');
                }
                if (api.encrypted) {
                    if (!api.multi) api.encrypted = false;
                    return ieform({
                        form: options.form,
                        data: options.json
                    }).pipe(success, failedUpload);
                    
                } else {
                    return http.FORM({
                        form: options.form,
                        data: options.json
                    }).pipe(success, failedUpload);
                }

            }
        };
    }
    
    function modifyUploadVersion() {
        // Upload Field
        ext.point('io.ox/files/details').extend({
            id: 'uploadOGVersion',
            index: 600,
            draw: function (baton) {
                if (baton.openedBy === 'io.ox/mail/write') return;//no uploads in mail preview
                var file = baton.data;

                var $node,
                $commentArea,
                $comment,
                $uploadButton,
                $input = attachments.fileUploadWidget({
                    displayLabel: true,
                    displayButton: false,
                    displayLabelText: gt('Upload a new encrypted version')
                });

                $node = $('<form>').append(
                    $('<div>').addClass('row-fluid').append(
                        $('<div class="pull-left">').append(
                            $input
                        ),
                        $uploadButton = $('<button type="button" data-action="upload" tabindex="1">')
                            .addClass('uploadbutton btn btn-primary pull-right').text(gt('Upload file')),
                        $('<div>').addClass('comment').append(
                            $comment = $('<div class="row-fluid">').append(
                                $('<label>').text(gt('Version Comment')),
                                $commentArea = $('<textarea rows="5" tabindex="1"></textarea>')
                            ).hide()
                        )
                    )
                ).appendTo(this);

                var resetCommentArea = function () {
                    if ($input.find('[data-dismiss="fileupload"]').is(':visible')) {
                        $uploadButton.show().text(gt('Upload new encrypted version'));
                        $commentArea.removeClass('disabled').val('');
                        $comment.hide();
                        $uploadButton.hide();
                        //general upload error
                        $uploadButton.removeClass('disabled');
                        $input.closest('form').get(0).reset();
                    }
                };

                var uploadFailed = function (e) {
                    require(['io.ox/core/notifications']).pipe(function (notifications) {
                        if (e && e.data && e.data.custom) {
                            notifications.yell(e.data.custom.type, e.data.custom.text);
                        }
                    });
                    resetCommentArea();
                };

                $uploadButton.on('click', function (e) {
                    e.preventDefault();
                    $(this).addClass('disabled').text(gt('Uploading...'));
                    $commentArea.addClass('disabled');

                    if (_.browser.IE !== 9) {
                        var files = $input.find('input[type="file"]')[0].files || [];

                        uploadNewVersion({
                            file: _(files).first(),
                            id: file.id,
                            version: file.version,
                            folder: file.folder_id,
                            timestamp: _.now(),
                            json: {version_comment: $commentArea.val()}
                        }).done(resetCommentArea)
                        .fail(uploadFailed);
                    } else {
                        $input.find('input[type="file"]').attr('name', 'file');
                        alert('IE9 no longer supported');
                   //     filesAPI.uploadNewVersionOldSchool({
                    //        form: $node,
                    //        id: file.id,
                    //        folder: file.folder_id,
                    //        timestamp: _.now(),
                     //       json: {version_comment: $commentArea.val()}
                    //    }).done(resetCommentArea);
                    }
                    return false;
                });

                $input.on('change', function () {
                    if ($input.find('[data-dismiss="fileupload"]').is(':visible')) {
                        $uploadButton.show();
                        $comment.show();
                        $commentArea.focus();
                    }
                }).find('[data-dismiss="fileupload"]').on('click', function (e) {
                    e.preventDefault();
                    resetCommentArea(e);
                });

            }
        });
    }
    
    /**
     * upload a new version of a file
     * @param  {object} options
     *         'folder' - The folder ID to upload the file to. This is optional and defaults to the standard files folder
     *         'json' - The complete file object. This is optional and defaults to an empty object with just the folder_id set.
     *         'file' - the file object to upload
     * @fires  api#create.file
     * @return {deferred}
     */
    function uploadNewVersion(options) {
        // Alright, let's simulate a multipart formdata form
        options = $.extend({
            folder: coreConfig.get('folder/infostore')
        }, options || {});

        var formData = new FormData();
        if ('filename' in options) {
            formData.append('file', options.file, options.filename);
        } else {
            formData.append('file', options.file);
        }

        if (options.json && !$.isEmptyObject(options.json)) {
            if (!options.json.folder_id) {
                options.json.folder_id = options.folder;
            }
        } else {
            options.json = { folder_id: options.folder };
        }
        formData.append('json', JSON.stringify(options.json));

        return http.UPLOAD({
                module: 'oxguard/files',
                params: { action: 'update', timestamp: _.now(), id: options.id,
                    filename: options.filename, userid: ox.user_id,
                    cid: ox.context_id, version: options.version,
                    folder: options.folder, auth: window.oxguarddata.passcode},
                data: formData,
                fixPost: true // TODO: temp. backend fix
            })
            .pipe(function () {
                var id = options.json.id || options.id,
                    folder_id = String(options.json.folder_id),
                    obj = { folder_id: folder_id, id: id };
                return api.propagate('change', obj, options.silent);
            }, failedUpload);
    }

    
    return {
        setEncrypted : setEncrypted,
        setNotEncryped : setNotEncrypted,
        modifyUploadVersion : modifyUploadVersion,
        multipleEncrypted : multipleEncrypted,
        endMulti : endMulti
    };
});