/* All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) Open-Xchange Inc., 2006-2011
 */
define('oxguard/file/share', ['io.ox/core/extensions', 'io.ox/core/api/autocomplete', 'io.ox/mail/util', 'io.ox/contacts/util',
                              'io.ox/core/tk/dialogs', 'io.ox/core/notifications', 'gettext!oxguard/file/share'],
        function (ext, AutocompleteAPI, mailUtil, contactsUtil, dialogs, notifications, gt) {
    'use strict';
    
    var autocompleteAPI = new AutocompleteAPI({ id: 'mailwrite', contacts: true, msisdn: true });

    // Create autocomplete field for sharing input
    function createShareInput(fileid) {
        var node = this;
        var addButton = $('<button type="submit" class="btn og_action_button" id="sendbutton" style="margin-left:30px;">' + gt('Add') + '</button>')
        .click(function () {
            $('#share_field_share').trigger($.Event('keydown', {which: 13}));
        });
        return $('<div class="fieldset fs_fieldset">').append(
                $('<label>' + gt('Add:') + ' </label>', { 'for' : 'share_field_share'})
                .addClass('wrapping-label')
                .append(
                    $('<input type="text" class="discreet" data-ime="inactive">')
                    .attr({
                        tabindex: '7',
                        id: 'share_field_share',
                        'data-type': 'share' // not name=id!
                    })
                    .autocomplete({
                        api: autocompleteAPI,
                        reduce: function (data) {
                            var hash = {},
                                list;
                            // remove duplicates
                            node.find('input[name="share"]').map(function () {
                                var rcpt = mailUtil.parseRecipient($(this).val())[1];
                                hash[rcpt] = true;
                            });
                            list = _(data).filter(function (o) {
                                if (o.data.folder_id !== 6) return(false);
                                return o.email !== '' ? hash[o.email] === undefined : hash[mailUtil.cleanupPhone(o.phone)] === undefined;
                            });

                            //return number of query hits and the filtered list
                            return { list: list, hits: data.length };
                        },
                        stringify: function (data) {
                            var name = contactsUtil.getMailFullName(data),
                                address = data.email || data.phone || '';
                            return name ? '"' + name + '" <' + address + '>' : address;
                        },
                        draw: function (data) {
                            ext.point('io.ox/mail/write/autoCompleteItem').invoke('draw', this, ext.Baton({ data: data }));
                        },
                        click: function (e) {
                            var data = {
                                    display_name : e.data.display_name,
                                    email : e.data.email
                                };
                            console.log(fileid);
                            if (window.oxguarddata.passcode === null) {
                                getPassword(data, node, fileid, true);
                            } else {
                                addshare(data, node, fileid, '');
                            }
                            $(this).val('');
                          //  copyRecipients.call(self, id, $(this), e);
                        },
                        blur: function () {
                          //  copyRecipients.call(self, id, $(this), e);
                        }
                    })
                    .on({
                        // IME support (e.g. for Japanese)
                        compositionstart: function () {
                            $(this).attr('data-ime', 'active');
                        },
                        compositionend: function () {
                            $(this).attr('data-ime', 'inactive');
                        },
                        keydown: function (e) {
                            if (e.which === 13 && $(this).attr('data-ime') !== 'active') {
                                if (e.target.value.length < 3) return;
                                var data = e.target.value;
                                if (window.oxguarddata.passcode === null) {
                                    getPassword(data, node, fileid, false);
                                } else manualShare(data, node, fileid, '');
                            }
                        },

                    })
                )
            ).append(addButton);
    }
    
    // Share is not one from address book or contacts, assume an email
    function manualShare(data, loc, fileid, password) {

        var name = null;
        var email = data;
        if (data.indexOf('<') > 0) {
            name = data.substring(0, data.indexOf('<'));
            email = data.substring(data.indexOf('<') + 1).replace('>', '');
        }
        if (email.indexOf('@') < 0) {
            return;
        }
        var data = {
                display_name : (name === null) ? '' : name,
                email : email
            };
        addshare(data, loc, fileid, password);
        $('#share_field_share').val('');
    }
    
    // Try to add the share.  Send to OG backend.  If OK, add the line to the table
    function addshare(e, loc, fileid, password) {
        var params = '&cid=' + ox.context_id + '&userid=' + ox.user_id + '&id=' + fileid +
            '&auth=' + encodeURIComponent(window.oxguarddata.passcode);
        var data = {
                password : password,
                email : e.email,
                name : e.display_name         
        };
        var user = e;
        loc.find('.og_sharetable').html('<div class="io-ox-busy"/>');
        $.ajax({
            url: ox.apiRoot + '/oxguard/file?action=share' + params,
            type: 'PUT',
            data: JSON.stringify(data),
            success: function (d) {
                var sharedata = JSON.parse(d);
                var data = (user.display_name === '') ? user.email : (user.display_name + '&lt' + user.email + '&gt');
                var line = $('<tr class="og_share-name"><td><input type="checkbox" id="sharebox" value="' + d + '"/></td><td>' + data + '</td></tr>');
                line.append(createTrash(user.email, fileid));
         //       var hidden = $('<input type="hidden" name="share" value = "' + user.email + '" user="' + sharedata.i + '" cid="' + sharedata.c + '" remote="' + sharedata.r + '" />');
                buildshare(fileid);
                if (sharedata.c.toString() === ox.context_id) $('#linkbutton').show();
            }
        }).fail(function (resp) {
            require(['io.ox/core/notifications'], function (notify) {
                if (resp.responseText.trim() === 'Not same context') {
                    notify.yell('error', gt('Must be in the same global address book'));
                    return;
                }
                if (resp.responseText.trim() === 'Bad Password') {
                    notify.yell('error', gt('Bad Password'));
                } else {
                    notify.yell('error', gt('Unable to add'));
                }
            });
        });
    }
    
    
    // Build the table of shares from OG backend
    function buildshare(id) {

        var params = '&userid=' + ox.user_id + '&cid=' + ox.context_id + '&id=' + id;
        $('.og_sharetable').html('<tr><td><i class="fa fa-spinner fa-spin" id="busygif"></td></tr>');
        $.get(ox.apiRoot + '/oxguard/file?action=getshare' + params, function (data) {//Get the key
            var users = JSON.parse(data);
            var table = $('<table class="og_sharetable"/>');
            if (users.length > 0) {
                var row = $('<tr>');
                var th1 = $('<th>' + gt('Select') + '</th>');
                var th2 = $('<th>' + gt('User') + '</th>');
                var th3 = $('<th>' + gt('Retract') + '</th>');
                table.append(row.append(th1).append(th2).append(th3));
                $('#sendbutton').show();
            }

            var showlink = false;
            for (var j = 0; j < users.length; j++) {
                var name = (users[j].n === undefined) ? users[j].e : (users[j].n + ' &lt' + users[j].e + '&gt');
                var line = $('<tr class="og_share-name" value="' + users[j].e + '"><td><input type="checkbox" id="sharebox" value="' + JSON.stringify(users[j]).replace(/\"/g, '&quot') + '" data-cid="' + users[j].c + '"/></td><td>' + name + '</td></tr>');
                var hidden = $('<input type="hidden" name="share" value = "' + users[j].e + '" user="' + users[j].i + '" cid="' + users[j].c + '" remote="' + users[j].r + '"/>');
                if (users[j].c.toString() === ox.context_id) showlink = true;
                line.append(createTrash(users[j].e, id));
                table.append(line).append(hidden);
            }
            
            if (showlink === true) $('#linkbutton').show();
            $('#og_file_share' + id).html(table);
        })
        .fail(function () {
            $('#og_file_share' + id).html('<tr><td>' + gt('Unable to share') + '</td></tr>');
            $('.fs_fieldset').hide();
        });
    }
    
    // Create trashcan icon and action
    function createTrash(email, id)
    {
        var trash = $('<td style="width: 30px;"><a href="#" class="remove" title="' + gt('Remove from share list') + '"><i class = "fa fa-trash-o"/></a></td>');
        trash.click(function (e) {
            var params = '&cid=' + ox.context_id + '&userid=' + ox.user_id + '&id=' + id +
            '&email=' + encodeURIComponent(email) + '&session=' + ox.session;
            $.ajax({
                url: ox.apiRoot + '/oxguard/file?action=remshare' + params,
                type: 'DELETE',
                data: '',
                success: function () {
                    $('.og_share-name[value="' + email + '"]').remove();
                }
            }).fail(function () {
                notifications.yell('error', gt('Failed to remove the share'));
            });
            e.preventDefault();
        });
        return (trash);
    }
    
    // Prompt for the password required to add share
    function getPassword(data, node, fileid, addressBook) {
        var dialog = new dialogs.CreateDialog({ width: 490, center: true,  enter : 'ok'});
        dialog.header($('<h4>').text(gt('Password Needed')));
        var help = $('<p>' + gt('Please provide your Guard Security Password to share this file') + '</p>');
        var pass = $('<input name="password" id="password" type="password"/>');
        dialog.getBody().append(help).append(pass);
//        if (level > 1) {
  //          var extrapasshelp = $('<p>' + gt('Extra Password') + '</p>');
  //          var extra = $('<input name="extrapass" id="atextrapass" type="password"/>');
  //          dialog.getBody().append(extrapasshelp).append(extra);
  //      }
        dialog.addPrimaryButton('ok', gt('OK'), 'ok')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('ok', function () {
            var extrap = $('#atextrapass').val();
            var pass = {
                    password : $('#password').val(),
                    extrapass : (extrap === undefined) ? '' : extrap,
                };
            if (addressBook) {
                addshare(data, node, fileid, pass.password);
            } else manualShare(data, node, fileid, pass.password);
            
        });
        dialog.show(function () {
            pass.focus();
        });
    }
    
    function sharelink(baton) {
        var tolist = [];
        $('#sharebox:checked').each(function (e, v) {
            var data = v.value;
            data = data.replace(/&quot/g, '\"');
            var user = JSON.parse(data);
            if (parseInt(user.c, 10) === parseInt(ox.context_id, 10)) {
                if (user.r !== 'Y')// Make sure not remote client
                    tolist.push(user);
            }
        });
        if (tolist.length < 1) {
            notifications.yell('error', gt('No users in same context'));
            return;
        }
        var params = '&id=' + baton.data.folder_id + '&session=' + ox.session;
        $.get(ox.apiRoot + '/oxguard/file?action=getfolder' + params, function (data) {//Get the key
            var folderdata = JSON.parse(data);
            var permissions = folderdata.data.permissions;
            var notfound = checkpermissions(tolist, permissions);
            if (notfound.length > 0) {
                promptAddPermissions(tolist, notfound, baton);
            } else {
                sendsharelink(tolist, baton);
                // Send link
            }
        });
    }
    
    function sendsharelink(tolist, baton) {
        var url = window.ox.abs + window.ox.root +
        '/#!&app=io.ox/files' +
        '&folder=' + encodeURIComponent(baton.data.folder_id) +
        '&id=' + encodeURIComponent(baton.data.folder_id) + '.' + encodeURIComponent(baton.data.id);
        var to = [];
        for (var i = 0; i < tolist.length; i++) {
            if (tolist[i].n === undefined) {
                to.push(['', tolist[i].e]);
            } else {
                to.push([tolist[i].n, tolist[i].e]);
            }
        }
        require(['io.ox/mail/write/main'], function (m) {
            m.getApp().launch().done(function () {
                var attachment = {
                        content : '<br/><br/>' + gt('The following link will take you to the shared file') + '<br/><a href="' + url + '">' + url + '</a>',
                        content_type : 'text/html',
                    };
                //#. Subject line for email with file link of shared file
                this.compose({ to: to, subject: gt('Shared file link'), attachments: [attachment] });
            });
        });
    }
    
    function sendEncrAttachment(baton) {
        var to = [];
        $('#sharebox:checked').each(function (e, v) {
            var data = v.value;
            data = data.replace(/&quot/g, '\"');
            var user = JSON.parse(data);
            if (user.n === undefined) {
                to.push(['', user.e]);
            } else {
                to.push([user.n, user.e]);
            }
        });
        var attachment = {
                content : '<br/><br/>' + gt('Attached encrypted file') + '<br/>',
                content_type : 'text/html',
            };
        require(['io.ox/mail/write/main'], function (m) {
            m.getApp().launch().done(function () {
                window.oxguarddata.action = 'sendfile';
                //#. Subject line for email with shared file in attachment
                this.compose({ to: to, subject: gt('Shared file'), attachments: [attachment], infostore_ids: [baton.data] });
            });
        });
    }
    
    function checkpermissions(users, permissions) {
        var notfound = [];
        for (var i = 0; i < users.length; i++) {
            var found = false;
            for (var j = 0; j < permissions.length; j++) {
                if (parseInt(users[i].i, 10) === parseInt(permissions[j].entity, 10)) {
                    var perm = permissions[j].bits;
                    var folderperm = perm & 127;// Get folder permissions
                    perm = perm >> 7; // Read permissions are 7 bits up
                    perm = perm & 67; // Filter
                    if ((perm === 2) || (perm === 64)) {// Must have read perm
                        if (folderperm > 0) {// And folder perm
                            found = true;
                        }
                    }
                }
            }
            if (!found) notfound.push(users[i]);
        }
        return (notfound);
    }
    
    function promptAddPermissions(tolist, notfound, baton) {
        var dialog = new dialogs.CreateDialog({ width: 490, center: true,  enter : 'ok'});
        dialog.header($('<h4>').text(gt('Add Permissions')));
        var help = $('<p>' + gt('The following users do not have permission to view objects in this folder.') + '</p>');
        var nfspan = $('<span>');
        var users = '';
        for (var i = 0; i < notfound.length; i++) {
            nfspan.append('<p>' + notfound[i].e + '</p>');
            if (users === '') {
                users = notfound[i].i;
            } else {
                users = ',' + notfound[i].i;
            }
        }
        var help2 = $('<p>' + gt('Do you wish to add read permissions to this folder for these users?') + '</p>');
        dialog.getBody().append(help).append(nfspan).append(help2);
        dialog.addPrimaryButton('ok', gt('OK'), 'ok')
        .addButton('cancel', gt('Cancel'), 'cancel')
        .on('ok', function () {
            var params = '&id=' + baton.data.folder_id + '&users=' + users + '&session=' + ox.session;
            $.ajax({
                url: ox.apiRoot + '/oxguard/file?action=folderperm' + params,
                type: 'PUT',
                data: '',
                success: function () {
                    sendsharelink(tolist, baton);
                }
            })
            .fail(function () {
                notifications.yell('error', gt('Failed to add folder sharing permissions'));
            });
        });
        dialog.show();
    }
    
    return {
        createShareInput : createShareInput,
        buildshare : buildshare,
        sharelink : sharelink,
        sendEncrAttachment : sendEncrAttachment
    };
    
    
});