﻿/// <reference path="jquery-1.7.1.js" />

var userid;
var cid;
var sessionID;
var root = getRoot();

$(document).ready(function () {
    view('login');
});


// Provides login to oxguard backend.  Authentication key is returned and stored
function login() {
    var username = $('#Username').val();
    var password = $('#Password').val().trim();
    $('#authorizing').show();
    $.post(root + "oxguard/login?action=guest&username=" + username + "&password=" + password, '', function (data) {
        console.log(data);
        if (data.auth === "Password Needed") {
            $('#login').hide();
            $('#NewPassword').show();
            userid = data.userid;
            cid = data.cid;
            sessionID = data.sessionID;
            return;
        }
        if (data.auth === "No Key") {
            $('#ErrorBox').append('Bad username / Password');
            $('#Username').focus();
        }
        if (data.auth.length > 20) {
            userid = data.userid;
            cid = data.cid;
            sessionID = data.sessionID;
            var extrapass = getURLParameter("extrapass");
            if (extrapass !== null) extrapass = extrapass.trim();
            if (extrapass === 'true') {
            	getExtraPass(data.auth);
            } else {
            	openreader(data.auth, "");
            }
        }

    })
    .fail(function () {
        alert('fail');
    });
}

function showChangepass() {
	view('NewPassword');
}

// Change the oxguard password
function changePass() {
    var pass1 = $('#new1').val();
    if (pass1 !== $('#new2').val()) {
        $('#new1').focus();
        $('#ChangeError').append('Passwords do not match');
        return;
    }
    var userdata = {
        newpass: pass1,
        oldpass: $('#old').val(),
        user_id: userid,
        sessionID: sessionID,
        cid: cid
    };
    $.post(root + 'oxguard/login?action=changepass&session=' + sessionID, JSON.stringify(userdata), function (data) {
        console.log('success ' + data);
        if (data.auth.length > 20) {
            $('#new1').val('');
            $('#new2').val('');
            $('#ChangeError').append('Password Changed!');

        }

    })
    .fail(function () {
        alert('Failed to change password');
    });
}

// Extra password is required
function getExtraPass (auth) {
	view("ExtraPassDiv");
	$('#ExtraPassButton').click(function () {
		var extra = $('#extrapass').val();
		openreader(auth, extra);
	});
}

// Open the email for reading.  Populate with decoded data
function openreader(auth, extra) {
    view();
    $('#Reader').show();
    $('#decoding').show();
    var itemid = getURLParameter("email");
    var url = root + 'oxguard/guest?action=getmail&session=' + sessionID + '&cid=' + cid + '&auth=' + auth + '&item=' + itemid;
    if (extra !== undefined) {
    	if (extra !== "") {
    		url = url + '&extrapass=' + extra;
    	}
    }
    $.get(url, function (data) {
        console.log(data);
        var toList = getTo(data),
            ccList = getCC(data);

        if (toList) {
            $('#tolist').append(toList).show();
        }

        if (ccList) {
            $('#cclist').append(ccList).show();
        }

        $('#fromlist').append(getFrom(data));
        $('#subject').append(getSubject(data));
        $('#reader').contents().find('html').html(getContent(data));
        $('#header').after(getAttachments(data, itemid, auth));
        $('#decoding').hide();
        $('#reply').click(function() {
        	reply(data);
        });
        $('#replyall').click(function() {
        	replyall(data);
        });

    })
    .fail(function () {
        console.log('fail');
    });

}

// Get base url
function getURLParameter(name) {
    return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search)||[,""])[1].replace(/\+/g, '%20'))||null
}

// Add surrounding <> for emails
function surround(d) {
    return (' &lt;' + d + '&gt;');
}

// Get the to recipients
function getTo(data) {
    var recips = data.to;
    var list = '';
    for (var i = 0; i < recips.length; i++) {
        if (i > 0) list += ', ';
        list += recips[i][0] + surround(recips[i][1]);
    }
    console.log(list);
    return (list);
}

function getCC(data) {
    var recips = data.CC;
    var list = '';
    if (recips === undefined) return (list);
    for (var i = 0; i < recips.length; i++) {
        if (i > 0) list += ', ';
        list += recips[i][0] + surround(recips[i][1]);
    }
    console.log(list);
    return (list);
}

function getFrom(data) {
    return (data.from[0][0] + surround(data.from[0][1]));
}

function getSubject(data) {
    return (data.subject);
}

function getContent(data) {
    var attachments = data.attachments;
    var othertext = '';
    for (var i = 0; i < attachments.length; i++) {
        if (attachments[i].disp === 'inline') {
            if (attachments[i].content_type === 'text/html') {
                return (attachments[i].content);
            } else {
                othertext = attachments[i].content;
            }
        }
    }
    return (othertext);
}

// Generate attachments.
function getAttachments(data, item, auth) {
    var attachmentdiv = $('<div/>');
    var attachments = data.attachments;
    var attcount = 0;
    for (var z = 0; z < attachments.length; z++) {
        var attach = attachments[z];
        if (attach.disp === 'attachment') {//If it is an attachment, we are going to display
            if (attcount === 0) {
                attachmentdiv.append('<span class="io-ox-label">Attachment&nbsp&nbsp</span>');
            }
            attcount++;
            // Create the link for that attachment
            var params = '&email=' + item +
            '&session=' + sessionID +
            "&auth=" + auth +
            "&userid=" + userid +
            "&cid=" + cid +
            '&extrapass=' + $('#extrapass').val() +
            '&attname=' + attach.filename;
            var link = root + 'oxguard/guest?action=getattach' + params;
            var atlink = $('<a/>', {
                "href": link,
                "target": "_blank",
                "class": "attachment-link",
                text: attach.filename

            }).css({
                'padding-right': '7px'
            });
            attachmentdiv.append(atlink);
        }
    }
    return (attachmentdiv);
}

// Send the reply
function sendreply(data, all) {
	var to = data.from;
	if (all) {
		to = data.from + data.to;
	}
	console.log(to);
	var from = ["", $('#Username').val()];
	var subject = data.subject;
	var content = tinyMCE.activeEditor.getContent();

	var mail = createJson (to, from, subject, content);
	var formData = new FormData();
    formData.append('json_0', JSON.stringify(mail));
    var xhr = new XMLHttpRequest();
    var url = root + '/oxguard/mail?action=emailform' +
    '&session=' + sessionID + '&userid=' + userid + '&cid=' + cid + "&guest=true";
    xhr.open("POST", url);
    $('#sending').show();
    xhr.onreadystatechange = function () {
        if (xhr.readyState === 4) {
            if (xhr.status !== 200) {
            	view("results");
            	$('#sendresult').append("Problem sending email");
            } else {
            	view("results");
            	$('#sendresult').append("Sent OK");
            }
        }
    };
    xhr.send(formData);

}

function reply(data) {
	console.log(data.from);
	$('#to').append(getFrom(data));
	$('#rsubject').append(data.subject);
	view('replydiv');
	$('#SendReply').click(function() {
		sendreply(data, false);
	});
}

function replyall(data) {
	$('#to').append(getTo(data) + ", " + getFrom(data));
	$('#rsubject').append(data.subject);
	view('replydiv');
	$('#SendReply').click(function() {
		sendreply(data, true);
	});
}


// Create the json required from the ox backend
function createJson(to, from, subject, content) {
	var attachments = {
			content : content,
			content_type : "text/html",
	};
	var data = {
			from : [from],
			to : to,
			cc : [],
			bcc : [],
			headers : {"X-OxGuard-Expiration" : 0, "X-OxGuard-ExtraPass" : ""},
			reply_to : from,
			subject : subject,
			priority : 3,
			vcard : 0,
			attachments : [attachments],
			nested_msgs : [],
			sendtype: 0,
			contact_ids: [],
			infostore_ids: [],
	};
	var json = {
			data : data,
			files : [],
			format : "html",
			mode : "compose",
			signature: "",
	};
	return (json);

}

function view (element) {
    $('.view').hide();
    if (element !== undefined)
    	$('#' + element).show();

}


